/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLinkHandler;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.fulfil.ExtHyperLink;
import com.kingdee.bos.ctrl.ext.fulfil.IShowLinkage;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.exec.ChartHyperLinkExec;
import com.kingdee.bos.ctrl.kds.impl.IUpdateStatusBar;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.SimpleToolBarLayout;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.base.execution.InvokeFunctionUtil;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.EXTREPORTLicenseChecker;
import com.kingdee.eas.rpts.base.license.ILicenseChecker;
import com.kingdee.eas.rpts.cloud.http.CloudRptCenterHttpFetcher;
import com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerFacade;
import com.kingdee.eas.rpts.cloud.service.ICloudRptCenterController;
import com.kingdee.eas.rpts.cloud.ui.CloudRptAgreementDialog;
import com.kingdee.eas.rpts.cloud.ui.CloudRptCenterDisabledDialog;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditUtil;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractExtReportRunUI;
import com.kingdee.eas.rpts.ctrlreport.client.ExportCompleteRepoertAction;
import com.kingdee.eas.rpts.ctrlreport.client.LinkageHyperLink;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.DataSetBaseFactory;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ProcessingBoxPanel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.rpts.statistics.client.StatisticsInfoClientCollector;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExtReportRunUI
extends AbstractExtReportRunUI {
    private static final long serialVersionUID = 3995638840997219481L;
    private static final Logger logger = LogUtil.getPackageLogger(ExtReportRunUI.class);
    protected SpreadContext _context = null;
    protected String report_id;
    protected boolean isInitToolBar = true;
    protected boolean isLimitRecord = false;
    protected boolean isEntryFromMenu = true;
    private boolean _checkPermission;
    protected Map filterMap = null;
    protected ProcessingBoxPanel processingBoxPanel;
    protected DataSetBaseFactory[] DataSetFactorys = new DataSetBaseFactory[5];
    protected DefineReportInfo info = null;
    private GetDataThread dataThread;
    protected ILicenseChecker _licenseChecker;

    public ExtReportRunUI() throws Exception {
        ExtContextUtils.setContext(null);
        this.addPropertyChangeListener("closeTab", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExtReportRunUI.this.menuItemExitCurrent.doClick();
            }
        });
    }

    public void onLoad() throws Exception {
        if (null != this.getUIContext().get("UIClassParam")) {
            this.report_id = (String)this.getUIContext().get("UIClassParam");
        } else {
            Object obj = this.getUIContext().get("DefineReportInfo");
            if (null != obj) {
                this.info = (DefineReportInfo)obj;
                this.report_id = this.info.getId().toString();
            }
        }
        this._licenseChecker = new EXTREPORTLicenseChecker(null);
        this.doCheck();
        super.onLoad();
        Object title = this.getUIContext().get("MainMenuName");
        if (title == null) {
            InvokeFunctionUtil.doUISetting(this, this.report_id);
        } else {
            this.setUITitle(String.valueOf(title));
        }
        this.hideBizData();
        this.openGetDataThread();
        CloudRptCenterHttpFetcher.reportCloudRptUsage(this.report_id);
    }

    public boolean destroyWindow() {
        CtrlReportUtil.releaseCtrl(this, this.report_id);
        this.dataThread.destroy();
        this.dataThread = null;
        return super.destroyWindow();
    }

    protected void doCheck() throws Exception {
        String isLimitRecord;
        try {
            if (this.report_id != null && this.info == null) {
                this.info = DefineReportBO.getReportInfo(null, this.report_id);
            }
            if (this.info == null) {
                MessageUtil.showInfo("label327", true);
                this.abort();
            }
        }
        catch (BOSException e) {
            MessageUtil.showDetailAndOKFromResource(null, "label17", (Exception)((Object)e));
            this.abort();
        }
        Book book = null;
        try {
            book = BookIOUtil.unpack((byte[])this.info.getContent());
        }
        catch (Exception e) {
            MiscUtil.handleFileCheckingException((Exception)e, null);
            if (MiscUtil.shouldLog()) {
                MiscUtil.log((Throwable)e);
            }
            this.abort();
        }
        String canExcute = CtrlReportUtil.getObjectString(this.getUIContext().get("canExcute"));
        this._checkPermission = canExcute.equals("true");
        String isEntryFromMenu = CtrlReportUtil.getObjectString(this.getUIContext().get("isEntryFromMenu"));
        if (isEntryFromMenu.equals("false")) {
            this.isEntryFromMenu = false;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String userId = userInfo.getId().toString();
        boolean isCloudRpt = book.getCloudRptUuid() != null;
        boolean hasDemoAuth = false;
        if (isCloudRpt) {
            if (this.isEntryFromMenu) {
                if (!CloudRptCenterControllerFacade.isCloudRptCenterEnable(null)) {
                    if (!this._checkPermission) {
                        MessageUtil.showInfo("\u62a5\u8868\u7ba1\u7406\u5458\u5df2\u7981\u7528\u4e91\u62a5\u8868\u4e2d\u5fc3\u3002\n\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7684\u62a5\u8868\u7ba1\u7406\u5458\uff0c\u542f\u7528\u4e91\u62a5\u8868\u4e2d\u5fc3\u3002\u5982\u679c\u7531\u4e8e\u4f01\u4e1a\u7684\u4fe1\u606f\u5b89\u5168\u7b56\u7565\u800c\u7981\u7528\u4e91\u62a5\u8868\u4e2d\u5fc3\u7684\uff0c\u4e91\u62a5\u8868\u5c06\u65e0\u6cd5\u4f7f\u7528\u3002", false);
                    } else {
                        CloudRptCenterDisabledDialog.showMessage((Component)((Object)this));
                    }
                    this.abort();
                }
                if (!CloudRptCenterHttpFetcher.isUserAgreementSigned(SysContext.getSysContext().getCurrentUserInfo().getNumber()) && !CloudRptAgreementDialog.showCloudRptAgreementBox()) {
                    this.abort();
                }
            }
            ICloudRptCenterController controller = CloudRptCenterControllerFacade.getRemoteInst();
            if (book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null) {
                hasDemoAuth = controller.hasDemoAuth(userId, book.getCloudRptUuid());
                boolean bl = this._checkPermission = !hasDemoAuth && this._checkPermission;
            }
        }
        if (!canExcute.equals("true")) {
            this.checkDeploy();
            this.checkFunctionPermission();
        }
        if ((isLimitRecord = CtrlReportUtil.getObjectString(this.getUIContext().get("isLimitRecord"))).equals("true")) {
            this.isLimitRecord = true;
        }
        if (this.getUIContext().get("filterMap") != null) {
            this.filterMap = (Map)this.getUIContext().get("filterMap");
        }
    }

    protected void checkDeploy() {
        try {
            String deployPath;
            if (null == this.info) {
                MessageUtil.showInfo("label327", true);
                this.abort();
            }
            if ((deployPath = CtrlReportUtil.getObjectString(this.info.getDeployPath())).equals("")) {
                MessageUtil.showInfo("label20", true);
                this.abort();
                return;
            }
            byte[] bContent = this.info.getContent();
            int stdProduct = this.info.getIsStdProduct();
            if (stdProduct == 1) {
                boolean isStdProduct = BookIOUtil.hasValidCoupon((byte[])bContent, (boolean)true);
                if (!isStdProduct) {
                    MessageUtil.showInfo("label229", true);
                    this.abort();
                }
            } else {
                try {
                    this._licenseChecker.checkLicense();
                }
                catch (EXTLicenseException e) {
                    MessageUtil.showInfo("label230", true);
                    this.abort();
                }
            }
        }
        catch (AbortException ae) {
            this.abort();
        }
        catch (Exception e) {
            MessageUtil.showDetailAndOKFromResource(null, "label17", e);
            this.abort();
        }
    }

    protected void checkFunctionPermission() {
        String message = null;
        boolean flag = false;
        try {
            boolean bl = flag = !this._checkPermission || PermissionBO.hasDataPermission(this.report_id, PermissionKind.VIEW);
            if (!flag) {
                message = MessageUtil.getMsgInfo("label19");
            }
        }
        catch (Exception e1) {
            message = MessageUtil.getMsgInfo("label17") + e1.getMessage();
        }
        if (!flag) {
            MessageUtil.showInfo(message, false);
            this.abort();
        }
    }

    protected void openGetDataThread() {
        this.dataThread = new GetDataThread();
        this.dataThread.start();
    }

    public void showBizData(final ExtGuiExecutor re) {
        if (this._context != null) {
            this.add((Component)this._context);
        }
        this.remove((Component)((Object)this.processingBoxPanel));
        this.validate();
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtReportRunUI.this.initToolBar(re);
            }
        });
    }

    public void hideBizData() {
        if (this._context != null) {
            this.remove((Component)this._context);
        }
        if (this.processingBoxPanel == null) {
            this.processingBoxPanel = new ProcessingBoxPanel();
        }
        this.add((Component)((Object)this.processingBoxPanel), "Center");
        this.repaint();
    }

    protected void initToolBar(ExtGuiExecutor re) {
        if (this.isInitToolBar) {
            Container c;
            KDToolBar toolBar = this.getUIToolBar();
            Component quit = null;
            if (toolBar.getToolBarComponentCount() >= 2) {
                quit = toolBar.getComponent(2);
                toolBar.removeAllToolBarComponents();
            }
            Action[] acs = null;
            acs = !this.isLimitRecord && this.isEntryFromMenu ? re.getContextualActions(0) : re.getContextualActions(5);
            ExportCompleteRepoertAction exportAction = new ExportCompleteRepoertAction(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label451"), (Component)((Object)this));
            exportAction.setPK(this.report_id);
            exportAction.setBook(this._context.getBook());
            for (int i = 0; i < acs.length; ++i) {
                toolBar.add(acs[i], i + 1);
            }
            toolBar.add((Action)exportAction);
            if (quit != null) {
                toolBar.add(quit);
            }
            if ((c = toolBar.getParent()) != null) {
                c.validate();
                c.repaint();
            }
            if (re.getSpreadContext().getBook().getCloudRptUuid() != null) {
                KDWorkButton btn = new KDWorkButton((Action)new ExtGuiExecutor.CloudRptCommentAction(re.getDataProvider()));
                toolBar.add((Component)btn);
                LayoutManager layout = toolBar.getLayout();
                if (layout instanceof SimpleToolBarLayout) {
                    ((SimpleToolBarLayout)layout).setHorizontalAlwayShownAtLastComponent((JComponent)btn);
                }
            }
            this.isInitToolBar = false;
        }
    }

    @Override
    protected void miExtConsole_actionPerformed(ActionEvent e) throws Exception {
        MiscUtil.showConsole(null);
    }

    public static void setShowLinkage(SpreadContext context, Object owner) {
        LinkageHyperLink linkage = new LinkageHyperLink(owner);
        HyperLinkHandler handler = context.getHyperLinkHandler();
        ExtReportRunUI.setShowLinkage(handler, linkage);
        Book book = context.getBook();
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            EmbedhLayer layer = sheet.getEmbedments(false);
            if (layer == null || layer.size() == 0) continue;
            EmbedhLayer.EmbedIterator iter = layer.getIterator(true);
            while (iter.hasNext()) {
                EmbedObject eObject = iter.next();
                if (!(eObject instanceof SubReportEmbed)) continue;
                SubReportEmbed rptEmbed = (SubReportEmbed)eObject;
                SpreadContext subContext = (SpreadContext)rptEmbed.getPhysicalUI();
                handler = subContext.getHyperLinkHandler();
                ExtReportRunUI.setShowLinkage(handler, linkage);
            }
        }
    }

    private static void setShowLinkage(HyperLinkHandler handler, LinkageHyperLink linkage) {
        ChartHyperLinkExec chartHyperLink = (ChartHyperLinkExec)handler.getLinkExec("fsChart:");
        ExtHyperLink hyperLink = (ExtHyperLink)handler.getLinkExec("user:");
        hyperLink.setShowLinkage((IShowLinkage)linkage);
        chartHyperLink.setShowLinkage((IShowLinkage)linkage);
    }

    static {
        StatisticsInfoClientCollector.collect();
    }

    class GetDataThread
    extends Thread {
        boolean isShow = true;
        ExtGuiExecutor re = null;

        @Override
        public void run() {
            try {
                ExtReportRunUI.this.hideBizData();
                this.initBook();
                if (this.isShow) {
                    ExtReportRunUI.this.showBizData(this.re);
                }
                if (ExtReportRunUI.this._context != null) {
                    ExtReportRunUI.this._context.register(new IUpdateStatusBar(){

                        public void updateStatusBar(String msg) {
                            ExtReportRunUI.this.getMainStatusBar().setPerTitle(msg);
                        }
                    });
                }
            }
            catch (Exception e) {
                MessageUtil.showDetailAndOK(null, EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label151"), e);
                logger.error((Object)"\u8fd0\u884c\u62a5\u8868:", (Throwable)e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtReportRunUI.this.getUIWindow().close();
                    }
                });
            }
        }

        protected void initBook() throws Exception {
            ExtCallbackImpl callbackImpl = new ExtCallbackImpl(ExtReportRunUI.this.info, ExtReportRunUI.this.isLimitRecord, ExtReportRunUI.this.isEntryFromMenu);
            callbackImpl.setUIContext(ExtReportRunUI.this.getUIContext());
            this.re = new ExtGuiExecutor(ExtReportRunUI.this.info.getContent(), (IExtRuntimeDataProvider)callbackImpl, ExtReportRunUI.this.isLimitRecord);
            boolean isOk = false;
            isOk = null == ExtReportRunUI.this.filterMap ? this.re.execute() : this.re.execute(ExtReportRunUI.this.filterMap);
            if (!isOk) {
                if (ExtReportRunUI.this.isInitToolBar) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExtReportRunUI.this.getUIWindow().close();
                        }
                    });
                    this.isShow = false;
                    return;
                }
            } else {
                long execTime = System.currentTimeMillis() - this.re.getRptRunStatt();
                if (ReportAuditUtil.isDeployReport(ExtReportRunUI.this.info)) {
                    Map map = ExtReportRunUI.this.getUIContext();
                    int pathType = ReportAuditUtil.getPathType(map);
                    ReportAuditUtil.updateAuditTable(null, ExtReportRunUI.this.info, execTime, pathType);
                }
                ExtReportRunUI.this._context = this.re.getSpreadContext();
                Object owner = ExtReportRunUI.this.getUIContext().get("Owner");
                ExtReportRunUI.setShowLinkage(ExtReportRunUI.this._context, owner);
            }
        }

        public void destroy() {
            if (this.re != null && this.re.getBook() != null) {
                this.re.getBook().getDeps().setUserInterrupted(true);
            }
        }
    }
}

