/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InputDialog
extends TypicalDialog {
    private static final Logger log = LogUtil.getPackageLogger(InputDialog.class);
    private Dimension _customSize;
    protected KDTextField _txtName;
    private String _oldName;
    private IChecker _checker;

    public static InputDialog create(Component parentCtrl, String title) {
        Window win = SwingUtilities.getWindowAncestor(parentCtrl);
        if (win instanceof Frame) {
            return new InputDialog((Frame)win, title);
        }
        if (win instanceof Dialog) {
            return new InputDialog((Dialog)win, title);
        }
        return new InputDialog(title);
    }

    public InputDialog(String title) {
        this.setTitle(title);
    }

    public InputDialog(Dialog owner, String title) {
        super(owner);
        this.setTitle(title);
    }

    public InputDialog(Frame owner, String title) {
        super(owner);
        this.setTitle(title);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        if (this._customSize == null) {
            this._customSize = new Dimension(320, 115);
        }
        super.setSize(this._customSize);
        KDLabelContainer lbc = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)"\u540d\u79f0", (int)80);
        parent.add((Component)lbc, thisCell);
        this.btnOk.setEnabled(false);
        this._txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String name = InputDialog.this.getNewName();
                InputDialog.this.btnOk.setEnabled(!"".equals(name) && !name.equals(InputDialog.this._oldName));
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    protected void todoInit() {
        this._txtName = new KDTextField();
    }

    public String getNewName() {
        return this._txtName.getText().trim();
    }

    public void setOldName(String text) {
        this._oldName = text;
        this._txtName.setText(text);
    }

    public void setChecker(IChecker checker) {
        this._checker = checker;
    }

    protected boolean verify() {
        if (this._checker != null) {
            try {
                return !this._checker.isNameExist(this._txtName.getText(), (Component)((Object)this));
            }
            catch (Exception e) {
                log.error((Object)"check floder node exist error", (Throwable)e);
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u68c0\u67e5\u540d\u79f0\u662f\u5426\u5b58\u5728\u51fa\u9519\uff0c\u68c0\u67e5\u65e5\u5fd7\u3002");
                return false;
            }
        }
        return true;
    }

    public Dimension getCustomSize() {
        return this._customSize;
    }

    public void setCustomSize(Dimension customSize) {
        this._customSize = customSize;
    }

    public static interface IChecker {
        public boolean isNameExist(String var1, Component var2) throws Exception;
    }
}

