/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractLinkReportUI;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LinkReportUI
extends AbstractLinkReportUI {
    private static final long serialVersionUID = 1L;
    private boolean isCanceled = false;
    private HashMap mapExpanded = new HashMap();
    ReportProperties reportFullName = null;
    DefaultKingdeeTreeNode nodeRoot;

    public LinkReportUI() throws Exception {
        this.initTree();
    }

    private void initTree() {
        this.nodeRoot = CommonTreeModel.getPackageTreeModel(null);
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.nodeRoot));
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(true);
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        this.kDTree1.setAutoscrolls(true);
    }

    @Override
    protected void kDTree1_treeExpanded(TreeExpansionEvent e) throws Exception {
        TreePath treePath = e.getPath();
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
        if (!selectedNode.isRoot()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)selectedNode.getUserObject();
            String fsystemid = bvNode.getFullName();
            if (this.mapExpanded.containsKey(fsystemid)) {
                return;
            }
            ArrayList lst = DefineReportBO.getReportListByOrgID(fsystemid);
            if (!lst.isEmpty()) {
                for (HashMap map : lst) {
                    DefaultKingdeeTreeNode dktNode = new DefaultKingdeeTreeNode();
                    dktNode.setText(String.valueOf(map.get("fname")));
                    dktNode.setAllowsChildren(false);
                    dktNode.setUserObject((Object)map);
                    ((DefaultTreeModel)this.kDTree1.getModel()).insertNodeInto((MutableTreeNode)dktNode, (MutableTreeNode)selectedNode, selectedNode.getChildCount());
                }
            }
            this.mapExpanded.put(fsystemid, null);
        }
    }

    @Override
    protected void kDTree1_mouseClicked(MouseEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode;
        Object userObject;
        Object object;
        if (e.getClickCount() == 2 && (object = this.kDTree1.getLastSelectedPathComponent()) != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf() && (userObject = (selectedNode = (DefaultKingdeeTreeNode)object).getUserObject()) instanceof HashMap) {
            this.kDButtonOk_actionPerformed(null);
        }
    }

    @Override
    protected void kDTree1_valueChanged(TreeSelectionEvent e) throws Exception {
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)object;
            Object userObject = selectedNode.getUserObject();
            if (userObject instanceof HashMap) {
                int len;
                HashMap map = (HashMap)userObject;
                String fid = map.get("fid").toString();
                String fname = CtrlReportUtil.getObjectString(map.get("fname"));
                String systemID = CtrlReportUtil.getObjectString(map.get("fsystemid"));
                String systemName = RunReportParam.getSystemFullLabel(this.nodeRoot, systemID);
                if (null == systemName) {
                    systemName = systemID;
                }
                if ((len = systemName.indexOf("\\")) != -1) {
                    systemName = systemName.substring(len + 1);
                }
                systemName = systemName + "\\" + fname;
                this.reportFullName = new ReportProperties(fid, fname, systemID);
                this.reportFullName.setDomain(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                this.reportFullName.setPathAlias(systemName);
            }
        } else {
            this.reportFullName = null;
        }
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.closeWin();
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.reportFullName == null) {
            MessageUtil.showInfo("label188", true);
            return;
        }
        this.isCanceled = false;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public ReportProperties getReportFullName() {
        return this.reportFullName;
    }
}

