/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.cloud.model.RptCategoryVO;
import com.kingdee.eas.rpts.ctrlreport.DefineReportFactory;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.IDefineReport;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.mobile.model.MobileType;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class MoveToNode {
    public static final String EXT_REPORT = "extReport";
    public static final String MOBILE_REPORT = "mobileReport";
    private static final String COLUMN_FID = "fid";
    private static final String COLUMN_FNAME = "fname";
    private static final String SYSTEMID = "fsystemid";
    private MoveToNodeTreeUI moveToNodeTreeUI;
    private TypicalDialog _dlg;
    private ArrayList<HashMap<String, Object>> selectRows;
    private String reportType;
    private StringBuffer sbErrMsg;
    private int successCount;
    private int errorCount;
    private boolean isRefreshParent;

    public MoveToNode(ArrayList<HashMap<String, Object>> selectRows, String reportType) {
        this.selectRows = selectRows;
        this.reportType = reportType;
        this.isRefreshParent = false;
    }

    public boolean isRefreshParent() {
        return this.isRefreshParent;
    }

    private void initDialog() {
        this._dlg = new TypicalDialog(){
            private static final long serialVersionUID = 1L;

            protected void todoInit() {
                this.enableBtn(false);
                MoveToNode.this.moveToNodeTreeUI.moveToTree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        Object object = MoveToNode.this.moveToNodeTreeUI.moveToTree.getLastSelectedPathComponent();
                        if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
                            this.enableBtn(true);
                        } else {
                            this.enableBtn(false);
                        }
                    }
                });
                MoveToNode.this.moveToNodeTreeUI.moveToTree.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Object object;
                        if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (object = MoveToNode.this.moveToNodeTreeUI.moveToTree.getLastSelectedPathComponent()) != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
                            this.onOk();
                        }
                    }
                });
            }

            protected void todoAddControls(Container parent, Cell thisCell) {
                parent.add((Component)MoveToNode.this.moveToNodeTreeUI.moveToTreeView, thisCell);
            }

            private void enableBtn(boolean btnOK) {
                this.btnOk.setEnabled(btnOK);
            }
        };
        this._dlg.setTitle("\u79fb\u52a8\u5230");
        this._dlg.setSize(400, 600);
        this._dlg.setMinimumSize(new Dimension(300, 400));
        this._dlg.setResizable(true);
        ImageIcon icon = (ImageIcon)UIManager.getIcon("Frame.Icon");
        if (icon != null) {
            this._dlg.setIconImage(icon.getImage());
        } else {
            this._dlg.setIconImage(null);
        }
    }

    public void showDialog() {
        DefaultKingdeeTreeNode treeNode = MoveToNode.createTreeNode(this.reportType);
        if (treeNode == null) {
            return;
        }
        this.moveToNodeTreeUI = new MoveToNodeTreeUI(treeNode);
        this.initDialog();
        if (this._dlg.showDialog()) {
            this.successCount = 0;
            this.errorCount = 0;
            this.sbErrMsg = new StringBuffer();
            ProgressUI progressUi = ProgressUI.create((Component)((Object)this.moveToNodeTreeUI));
            progressUi.setIndeterminate(true);
            progressUi.setText("\u6b63\u5728\u79fb\u52a8\uff0c\u8bf7\u7a0d\u5019...");
            Progress progress = new Progress(progressUi){

                @Override
                protected void work() throws Exception {
                    MoveToNode.this.modifyReport(MoveToNode.this.selectRows);
                }
            };
            progress.startAndShowUi("doMoveTo");
            if (!progress.isOk()) {
                this.handleException(progress.getException(), "\u79fb\u52a8\u5931\u8d25");
            }
            this.showResultMessage();
        }
    }

    private void showResultMessage() {
        StringBuffer showMessage = new StringBuffer();
        if (this.successCount > 0 && this.errorCount > 0) {
            showMessage.append("\u79fb\u52a8\u90e8\u5206\u6210\u529f\uff0c\u6709\u9519\u8bef\u4fe1\u606f\r\n");
        } else if (this.successCount == 0 && this.errorCount > 0) {
            showMessage.append("\u79fb\u52a8\u5931\u8d25\uff0c\u6709\u9519\u8bef\u4fe1\u606f\r\n");
        } else if (this.successCount > 0 && this.errorCount == 0) {
            showMessage.append("\u79fb\u52a8\u6210\u529f\r\n");
        } else if (this.successCount == 0 && this.errorCount == 0 && this.sbErrMsg.length() > 0) {
            showMessage.append("\u79fb\u52a8\u5931\u8d25\uff0c\u6709\u9519\u8bef\u4fe1\u606f\r\n");
        }
        if (this.sbErrMsg.length() > 0) {
            MessageUtil.msgboxWarning(null, (String)showMessage.toString(), (String)this.sbErrMsg.toString());
            this.isRefreshParent = true;
        } else if (showMessage.length() > 0) {
            MessageUtil.msgboxInfo(null, (String)showMessage.toString());
            this.isRefreshParent = true;
        } else {
            this.isRefreshParent = false;
        }
    }

    private void handleException(Exception e, String message) {
        this.sbErrMsg.append(message).append("\r\n").append(e.getMessage());
        Throwable t = e.getCause();
        if (null != t) {
            this.sbErrMsg.append("\r\n").append(t.getMessage());
        }
    }

    private void modifyReport(ArrayList<HashMap<String, Object>> list) {
        Object object = this.moveToNodeTreeUI.moveToTree.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)object;
        String newSystemID = MoveToNode.getSystemID(selectedNode, this.reportType);
        IDefineReport report = null;
        String ofgid = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        StringBuffer newName = new StringBuffer();
        try {
            report = DefineReportFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e), "\u521b\u5efa\u8fdc\u7a0b\u5bf9\u8c61\u5931\u8d25");
            return;
        }
        for (HashMap<String, Object> map : list) {
            ObjectUuidPK reportPK;
            DefineReportInfo info;
            String name;
            block8: {
                String fid = CtrlReportUtil.getObjectString(map.get(COLUMN_FID));
                name = CtrlReportUtil.getObjectString(map.get(COLUMN_FNAME));
                String systemID = CtrlReportUtil.getObjectString(map.get(SYSTEMID));
                if (!StringUtil.isEmptyString((String)systemID) && systemID.equals(newSystemID)) continue;
                info = new DefineReportInfo();
                BOSUuid bid = BOSUuid.read((String)fid);
                reportPK = new ObjectUuidPK("id", bid);
                info.setId(bid);
                info.setSystemID(newSystemID);
                DefineReportInfo reportInfo = null;
                try {
                    reportInfo = DefineReportBO.getReportInfo(null, newSystemID, name.toString(), ofgid, null);
                    if (reportInfo == null) break block8;
                    int count = 1;
                    while (reportInfo != null) {
                        newName.setLength(0);
                        newName.append(name).append("(").append(count++).append(")");
                        reportInfo = DefineReportBO.getReportInfo(null, newSystemID, newName.toString(), ofgid, null);
                    }
                    info.setName(newName.toString());
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e), "\u68c0\u67e5\u6269\u5c55\u62a5\u8868\u540d\u79f0\u91cd\u590d\u5931\u8d25");
                    ++this.errorCount;
                    continue;
                }
            }
            try {
                report.update((IObjectPK)reportPK, info);
                ++this.successCount;
            }
            catch (Exception e) {
                this.handleException(e, "\u62a5\u8868" + name + "\u79fb\u52a8\u5931\u8d25");
                ++this.errorCount;
            }
        }
    }

    public static DefaultKingdeeTreeNode createTreeNode(String reportType) {
        DefaultKingdeeTreeNode treeNode = null;
        if (EXT_REPORT.equals(reportType)) {
            treeNode = CommonTreeModel.getPackageTreeModel(null);
        } else if (MOBILE_REPORT.equals(reportType) && (treeNode = CommonTreeModel.getMobileTreeModel()).getChildCount() == 0) {
            MessageUtil.msgboxInfo(null, (String)"\u6ca1\u6709\u79fb\u52a8\u62a5\u8868\u516c\u4f17\u53f7\uff0c\u8bf7\u5148\u5efa\u7acb\u516c\u4f17\u53f7\uff01");
            return null;
        }
        MoveToNode.setReptsNode(treeNode);
        return treeNode;
    }

    private static void setReptsNode(DefaultKingdeeTreeNode treeNode) {
        if (treeNode.isLeaf()) {
            MoveToNode.addExtNode(treeNode);
        } else {
            Enumeration enume = treeNode.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                MoveToNode.setReptsNode(repNode);
            }
            if (!treeNode.isRoot()) {
                MoveToNode.addExtNode(treeNode);
            }
        }
    }

    private static void addExtNode(DefaultKingdeeTreeNode treeNode) {
        DefaultKingdeeTreeNode DKTreeNode = new DefaultKingdeeTreeNode();
        DKTreeNode.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.ReportsResource", (String)"defineReport"));
        DKTreeNode.setCustomIcon((Icon)ResourceManager.getIcon(ExtReportManageUI.class, (String)"tbtn_ext.gif"));
        DKTreeNode.setUserObject((Object)"1");
        treeNode.add((MutableTreeNode)DKTreeNode);
    }

    public static String getSystemID(DefaultKingdeeTreeNode selectedNode, String reportType) {
        String systemID = null;
        Object userObject = ((DefaultKingdeeTreeNode)selectedNode.getParent()).getUserObject();
        if (EXT_REPORT.equals(reportType)) {
            if (userObject == null) {
                RptCategoryVO bvNode = (RptCategoryVO)selectedNode.getUserObject();
                systemID = bvNode.getId();
            } else if (userObject instanceof IBriefViewTreeNode) {
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)userObject;
                systemID = bvNode.getFullName();
            }
        } else if (MOBILE_REPORT.equals(reportType)) {
            if (userObject == null) {
                MobileType bvNode = (MobileType)selectedNode.getUserObject();
                systemID = bvNode.getId();
            } else if (userObject instanceof PubAcctsDAO.PubAcct) {
                PubAcctsDAO.PubAcct bvNode = (PubAcctsDAO.PubAcct)userObject;
                systemID = bvNode.fid;
            }
        }
        return systemID;
    }

    private class MoveToNodeTreeUI
    extends KDPanel {
        private static final long serialVersionUID = 1L;
        private KDTree moveToTree;
        private KDTreeView moveToTreeView;
        private DefaultKingdeeTreeNode treeNode;

        public MoveToNodeTreeUI(DefaultKingdeeTreeNode treeNode) {
            this.treeNode = treeNode;
            this.initTree();
        }

        private void initTree() {
            this.moveToTree = new KDTree();
            this.moveToTreeView = new KDTreeView();
            this.moveToTreeView.setMinimumSize(new Dimension(0, 0));
            this.moveToTreeView.setName("moveToTreeView");
            this.moveToTree.setName("moveToTreeView");
            this.moveToTreeView.setTree(this.moveToTree);
            this.moveToTree.getSelectionModel().setSelectionMode(1);
            this.moveToTree.setAutoscrolls(true);
            this.moveToTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.treeNode));
        }
    }
}

