/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractOutDBCenterListUI;
import com.kingdee.eas.rpts.ctrlreport.client.OutDBCenterEditUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OutDBCenterListUI
extends AbstractOutDBCenterListUI {
    private static final Logger logger = CoreUIObject.getLogger(OutDBCenterListUI.class);
    private static final long serialVersionUID = 1L;
    private HashMap mapData = new HashMap();

    public OutDBCenterListUI() throws Exception {
        this.tblMain.checkParsed();
        this.initLayout();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                OutDBCenterListUI.this.tblMain_tableClicked(e);
            }
        });
    }

    public void onLoad() throws Exception {
        this.tblMain.getSelectManager().setSelectMode(2);
        this.setUITitle(String.valueOf(this.getUIContext().get("MainMenuName")));
        this.refresh();
    }

    private void refresh() throws BOSException, SQLException {
        this.mapData.clear();
        this.tblMain.removeRows();
        ArrayList lst = ExtReportOutDBBO.getDBList(null);
        for (HashMap map : lst) {
            IRow irow = this.tblMain.addRow();
            irow.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map.get("fdbcentername")));
            int dbtype = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("fdbtype")));
            irow.getCell(1).setValue((Object)DataCenterDBType.getDBType((int)dbtype));
            irow.getCell(2).setValue((Object)(CtrlReportUtil.getObjectString(map.get("fdbaddress")) + ":" + CtrlReportUtil.getObjectString(map.get("fdbport"))));
            irow.getCell(3).setValue((Object)CtrlReportUtil.getObjectString(map.get("fdbname")));
            irow.getCell(4).setValue((Object)CtrlReportUtil.getObjectString(map.get("fuser")));
            irow.setUserObject((Object)map);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) {
        try {
            int bottom;
            int top;
            KDTSelectBlock block;
            ArrayList blocks;
            if (e.getClickCount() == 1 && e.getType() == 1 && !(blocks = this.tblMain.getSelectManager().getBlocks()).isEmpty()) {
                block = (KDTSelectBlock)blocks.get(0);
                top = block.getTop();
                bottom = block.getBottom();
                if (bottom - top == 0) {
                    this.mapData = (HashMap)this.tblMain.getRow(top).getUserObject();
                }
            }
            if (e.getClickCount() == 2 && e.getType() == 1) {
                blocks = this.tblMain.getSelectManager().getBlocks();
                if (!blocks.isEmpty()) {
                    block = (KDTSelectBlock)blocks.get(0);
                    top = block.getTop();
                    bottom = block.getBottom();
                    if (bottom - top == 0) {
                        this.mapData = (HashMap)this.tblMain.getRow(top).getUserObject();
                    }
                }
                this.btnEdit_actionPerformed(null);
            }
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label17"), ex);
        }
    }

    @Override
    protected void btnNew_actionPerformed(ActionEvent e) throws Exception {
        OutDBCenterEditUI editUI = new OutDBCenterEditUI(new HashMap());
        ReportDialog.showDialog((CoreUIObject)editUI, MessageUtil.getMsgInfo("label211"), true);
        if (editUI.isOk) {
            this.refresh();
        }
    }

    @Override
    protected void btnEdit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        int size = blocks.size();
        if (size == 0) {
            MessageUtil.showInfo(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label8"), false);
            return;
        }
        KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
        int top = block.getTop();
        int bottom = block.getBottom();
        if (bottom - top == 0) {
            this.mapData = (HashMap)this.tblMain.getRow(top).getUserObject();
        }
        logger.error((Object)("mapData = " + this.mapData.toString()));
        OutDBCenterEditUI editUI = new OutDBCenterEditUI((HashMap)this.mapData.clone());
        ReportDialog.showDialog((CoreUIObject)editUI, MessageUtil.getMsgInfo("label212") + CtrlReportUtil.getObjectString(this.mapData.get("fdbcentername")), true);
        if (editUI.isOk) {
            this.refresh();
        }
    }

    @Override
    protected void btnTestLink_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        int size = blocks.size();
        if (size == 0) {
            MessageUtil.showInfo(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label8"), false);
            return;
        }
        KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
        int top = block.getTop();
        int bottom = block.getBottom();
        if (bottom - top == 0) {
            this.mapData = (HashMap)this.tblMain.getRow(top).getUserObject();
        }
        logger.error((Object)("TestLink mapData = " + this.mapData.toString()));
        String dbaddress = CtrlReportUtil.getObjectString(this.mapData.get("fdbaddress"));
        DataCenterInfo vo = new DataCenterInfo();
        vo.setDbCenterName(CtrlReportUtil.getObjectString(this.mapData.get("fdbcentername")));
        vo.setDbAddress(dbaddress);
        vo.setDbPort(Integer.parseInt(CtrlReportUtil.getObjectString(this.mapData.get("fdbport"))));
        vo.setDbType(Integer.parseInt(CtrlReportUtil.getObjectString(this.mapData.get("fdbtype"))));
        vo.setDbName(CtrlReportUtil.getObjectString(this.mapData.get("fdbname")));
        vo.setUser(CtrlReportUtil.getObjectString(this.mapData.get("fuser")));
        vo.setPwd(CtrlReportUtil.getObjectString(this.mapData.get("fpwd")));
        OutDBCenterEditUI.testLinkConn(vo);
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        int size = blocks.size();
        if (size == 0) {
            MessageUtil.showInfo(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label8"), false);
            return;
        }
        boolean confirm = MessageUtil.showConfirm(null, MessageUtil.getMsgInfo("label9"));
        if (!confirm) {
            return;
        }
        ExtReportOutDBBO.del(CtrlReportUtil.getObjectString(this.mapData.get("fdbcentername")));
        this.refresh();
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnPageSetup);
        this.toolBar.add((Component)this.btnNew);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnDel);
        this.toolBar.add((Component)this.btnTestLink);
        this.toolBar.add((Component)this.separator1);
    }
}

