/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.rpts.ctrlreport.IQueryFilterUI;
import com.kingdee.eas.rpts.ctrlreport.QueryFilterUIFactory;
import com.kingdee.eas.rpts.ctrlreport.QueryFilterUIInfo;
import com.kingdee.eas.rpts.ctrlreport.client.AddQueryFilterUI;
import com.kingdee.eas.rpts.ctrlreport.client.PopupQueryFilterUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignFinal;
import com.kingdee.eas.util.client.ComponentUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PopupF7FilterTree
extends KDDialog
implements KDPromptSelector {
    private static final long serialVersionUID = -5620967014380320318L;
    private static final Logger log = LogUtil.getLogger(PopupF7FilterTree.class);
    private FilterUI filterUI;
    protected KDSeparator kDSeparator2;
    protected KDButton btnOk;
    protected KDButton btnCancel;
    private boolean isOk = false;
    private boolean isInit = true;
    String fullName;
    String firstPath = "";

    private PopupF7FilterTree() {
    }

    private PopupF7FilterTree(Frame owner) {
        super(owner, true);
        this.initDialog();
    }

    private PopupF7FilterTree(Dialog owner) {
        super(owner, true);
        this.initDialog();
    }

    public static PopupF7FilterTree getInstance() {
        Window owner = ComponentUtil.getCurrentActiveWindow();
        if (owner instanceof Dialog) {
            return new PopupF7FilterTree((Dialog)owner);
        }
        if (owner instanceof Frame || owner == null) {
            return new PopupF7FilterTree((Frame)owner);
        }
        return new PopupF7FilterTree((Frame)owner);
    }

    private void initDialog() {
        this.filterUI = new FilterUI();
        this.kDSeparator2 = new KDSeparator();
        this.kDSeparator2.setName("kDSeparator2");
        this.btnOk = new KDButton();
        this.btnOk.setName("kDButton1");
        this.btnOk.setText("\u786e\u5b9a");
        this.btnCancel = new KDButton();
        this.btnCancel.setName("kDButton2");
        this.btnCancel.setText("\u53d6\u6d88");
        KDPanel panTemp = new KDPanel();
        this.initUIContentLayout(panTemp);
        this.installListener();
        this.setSize(panTemp.getWidth(), panTemp.getHeight());
        this.setLocationRelativeTo(null);
        this.setTitle("\u7ed1\u5b9aquery\u8fc7\u6ee4\u754c\u9762");
    }

    private void initUIContentLayout(KDPanel panTemp) {
        panTemp.setBounds(new Rectangle(10, 10, 800, 600));
        panTemp.setLayout((LayoutManager)new KDLayout());
        panTemp.setOpaque(false);
        panTemp.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 800, 600));
        this.filterUI.setBounds(new Rectangle(4, 4, 788, 553));
        panTemp.add((Component)((Object)this.filterUI), (Object)new KDLayout.Constraints(4, 4, 788, 553, 418));
        this.kDSeparator2.setBounds(new Rectangle(0, 564, 807, 10));
        panTemp.add((Component)this.kDSeparator2, (Object)new KDLayout.Constraints(0, 564, 807, 10, 14));
        this.btnOk.setBounds(new Rectangle(638, 570, 73, 21));
        panTemp.add((Component)this.btnOk, (Object)new KDLayout.Constraints(638, 570, 73, 21, 10));
        this.btnCancel.setBounds(new Rectangle(718, 570, 73, 21));
        panTemp.add((Component)this.btnCancel, (Object)new KDLayout.Constraints(718, 570, 73, 21, 10));
        this.getContentPane().add((Component)panTemp, "Center");
    }

    private void installListener() {
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupF7FilterTree.this.btnOk_actionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupF7FilterTree.this.btnCancel_actionPerformed();
            }
        });
    }

    private void btnOk_actionPerformed() {
        KDList list = this.filterUI.getSelectedList();
        int count = list.getElementCount();
        try {
            IQueryFilterUI iQueryFilterUI = QueryFilterUIFactory.getRemoteInstance();
            CoreBaseCollection collection = new CoreBaseCollection();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("queryFullName", (Object)this.fullName, CompareType.EQUALS));
            iQueryFilterUI.delete(filterInfo);
            if (count > 0) {
                for (int n = 0; n < count; ++n) {
                    Table table = (Table)list.getElement(n);
                    QueryFilterUIInfo info = new QueryFilterUIInfo();
                    info.setName(table.getName());
                    info.setAlias(table.getAlias());
                    info.setFullName(table.getExpr());
                    info.setQueryFullName(this.fullName);
                    collection.addObject((IObjectValue)info);
                }
                iQueryFilterUI.addnew(collection);
            }
            this.closeWin(true);
        }
        catch (BOSException e) {
            log.error((Object)e);
            this.closeWin(false);
        }
        catch (EASBizException e) {
            log.error((Object)e);
            this.closeWin(false);
        }
    }

    private void btnCancel_actionPerformed() {
        this.closeWin(false);
    }

    private void closeWin(boolean flag) {
        this.isOk = flag;
        this.dispose();
    }

    public void show() {
        if (this.isInit) {
            this.filterUI.initTree();
            this.filterUI.expandFirst(this.firstPath);
            this.isInit = false;
        }
        this.filterUI.getSelectedList().removeAllElements();
        IQueryFilterUI iQueryFilterUI = null;
        try {
            iQueryFilterUI = QueryFilterUIFactory.getRemoteInstance();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("queryFullName", (Object)this.fullName, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection collection = iQueryFilterUI.getCollection(entityViewInfo);
            QueryFilterUIInfo[] infos = new QueryFilterUIInfo[collection.size()];
            for (int i = 0; i < infos.length; ++i) {
                infos[i] = (QueryFilterUIInfo)collection.get(i);
                Table table = new Table();
                table.setName(infos[i].getName());
                table.setAlias(infos[i].getAlias());
                table.setExpr(infos[i].getFullName());
                this.filterUI.addNodeToList(table);
            }
        }
        catch (BOSException e) {
            log.error((Object)e);
        }
        super.show();
    }

    public Object getData() {
        if (this.filterUI.getSelectedList().getElementCount() == 0) {
            return "";
        }
        return "\u5df2\u7ed1\u5b9a";
    }

    public boolean isCanceled() {
        return !this.isOk;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setFirstPath(String firstPath) {
        this.firstPath = firstPath;
    }

    private static class FilterNode {
        String name;
        String alias;
        boolean filter;
        private static final FilterNode instance = new FilterNode();

        private FilterNode() {
        }

        public static final FilterNode getInstance() {
            return instance;
        }

        public void setCondition(HashMap mapFilter) {
            this.name = CtrlReportUtil.getObjectString(mapFilter.get("name")).toLowerCase();
            this.alias = CtrlReportUtil.getObjectString(mapFilter.get("alias")).toLowerCase();
            this.filter = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get("filter")));
        }

        public boolean isHiden(IBriefViewTreeNode bvNode) {
            String nodeName = CtrlReportUtil.getObjectString(bvNode.getName()).toLowerCase();
            String nodeAlias = CtrlReportUtil.getObjectString(bvNode.getAlias()).toLowerCase();
            if (this.name.length() > 0 && nodeName.indexOf(this.name) == -1) {
                return true;
            }
            if (this.alias.length() > 0 && nodeAlias.indexOf(this.alias) == -1) {
                return true;
            }
            return this.filter && nodeName.indexOf("filter") == -1 && nodeAlias.indexOf("filter") == -1 && nodeAlias.indexOf("\u8fc7\u6ee4") == -1;
        }
    }

    private class ActionAdd
    extends AbstractAction {
        private static final long serialVersionUID = -5327964800258950881L;

        public ActionAdd() {
            this.putValue("SmallIcon", Resource.ICON_INSERT);
            this.putValue("ShortDescription", "\u624b\u5de5\u65b0\u589eUI");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.addUI();
        }

        private void addUI() {
            try {
                AddQueryFilterUI addUI = new AddQueryFilterUI();
                ReportDialog.showDialog((CoreUIObject)addUI, "\u65b0\u589e\u8fc7\u6ee4UI", true);
                if (addUI.isOk()) {
                    HashMap mapAdd = addUI.getMapData();
                    String name = CtrlReportUtil.getObjectString(mapAdd.get("name"));
                    String alias = CtrlReportUtil.getObjectString(mapAdd.get("alias"));
                    if (alias.length() == 0) {
                        alias = name;
                    }
                    Table table = new Table();
                    table.setName(name);
                    table.setAlias(alias);
                    table.setExpr(CtrlReportUtil.getObjectString(mapAdd.get("fullName")));
                    PopupF7FilterTree.this.filterUI.addNodeToList(table);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private class FilterUI
    extends NormalSelector {
        private static final long serialVersionUID = 7578151235942529954L;
        private KDTreeView kDTreeView1;
        private KDTree kDTree1;
        private KDWorkButton wbFilter;
        private HashMap mapFilter;
        private DefaultKingdeeTreeNode newRootOriSelected = null;
        private ActionAdd actionAdd;

        public FilterUI() {
            this.initCtrl();
            this.installListener();
        }

        private void initCtrl() {
            this.actionAdd = new ActionAdd();
            this.getSelected().addButton((Action)this.actionAdd, "add");
            this.getSelected().syncBtn();
            this.enableSelect(false);
            this.enableSelectAll(false);
            this.kDTreeView1 = new KDTreeView();
            this.kDTreeView1.setMinimumSize(new Dimension(10, 10));
            this.kDTreeView1.setName("kDTreeView1");
            this.wbFilter = new KDWorkButton((Icon)Resource.ICON_FILTER);
            this.wbFilter.setToolTipText("\u8fc7\u6ee4");
            this.kDTreeView1.getControlPane().add((Component)this.wbFilter);
            this.kDTree1 = new KDTree();
            this.kDTree1.setName("kDTree1");
            this.kDTreeView1.setTree(this.kDTree1);
            this.setSupplyTitle("\u5907\u9009UI\uff1a");
            this.setSelectedTitle("\u5df2\u9009UI\uff1a");
            this.setSupplyCtrlNoScroll((JComponent)this.kDTreeView1);
            this.mapFilter = new HashMap();
            this.mapFilter.put("name", "");
            this.mapFilter.put("alias", "");
            this.mapFilter.put("filter", "true");
        }

        private void installListener() {
            this.kDTree1.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FilterUI.this.kDTree1_mouseClicked(e);
                }
            });
            this.kDTree1.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    FilterUI.this.setSelectBtn();
                }
            });
            this.getSelectedList().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Object obj = ((KDList)e.getSource()).getSelectedValue();
                    if (obj instanceof ITable) {
                        String expr = ((ITable)obj).getExpr();
                        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)FilterUI.this.kDTree1.getModel().getRoot();
                        FilterUI.this.expandSelected(root, expr);
                    }
                }
            });
            this.wbFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterUI.this.btnFilter_actionPerformed();
                }
            });
        }

        public void initTree() {
            DefaultKingdeeTreeNode nodeRoot = CtrlDesignFinal.getF7QueryFilterUIRoot();
            this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
            ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(true);
            this.kDTree1.getSelectionModel().setSelectionMode(4);
            this.kDTree1.setAutoscrolls(true);
            this.executeFilter();
        }

        private void executeFilter() {
            FilterNode filterNode = FilterNode.getInstance();
            filterNode.setCondition(this.mapFilter);
            DefaultKingdeeTreeNode oldRoot = CtrlDesignFinal.getF7QueryFilterUIRoot();
            DefaultKingdeeTreeNode newRoot = new DefaultKingdeeTreeNode();
            newRoot.setText(oldRoot.getText());
            newRoot.setCustomIcon(oldRoot.getCustomIcon());
            newRoot.setAllowsChildren(oldRoot.getAllowsChildren());
            newRoot.setUserObject(oldRoot.getUserObject());
            TreePath path = this.kDTree1.getSelectionPath();
            DefaultKingdeeTreeNode nodeOriSelected = null;
            String strOriSelected = null;
            if (path != null) {
                nodeOriSelected = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                IBriefViewTreeNode bvOriSelected = (IBriefViewTreeNode)nodeOriSelected.getUserObject();
                strOriSelected = bvOriSelected.getFullName();
            }
            this.newRootOriSelected = null;
            this.doFilter(oldRoot, newRoot, strOriSelected);
            ((DefaultTreeModel)this.kDTree1.getModel()).setRoot((TreeNode)newRoot);
            this.kDTree1.setSelectionNode(this.newRootOriSelected);
        }

        public void expandFirst(String selectedPath) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
            this.expandSelected(root, selectedPath);
        }

        private boolean expandSelected(DefaultKingdeeTreeNode nodeRoot, String selectedPath) {
            boolean flag = true;
            Enumeration enume = nodeRoot.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)repNode.getUserObject();
                if (bvNode.getFullName().equals(selectedPath)) {
                    Object[] pathtoRoot = repNode.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    this.kDTree1.expandPath(path);
                    this.kDTree1.setSelectionPath(path);
                    this.kDTree1.scrollPathToVisible(path);
                    flag = false;
                    break;
                }
                flag = this.expandSelected(repNode, selectedPath);
                if (flag) continue;
                break;
            }
            return flag;
        }

        private void kDTree1_mouseClicked(MouseEvent e) {
            Object object = this.kDTree1.getLastSelectedPathComponent();
            if (e.getClickCount() == 2 && object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
                try {
                    this.addNodeToList();
                }
                catch (BOSException be) {
                    log.error((Object)be);
                }
            }
        }

        private void setSelectBtn() {
            boolean flag = true;
            TreePath[] paths = this.kDTree1.getSelectionPaths();
            if (paths == null) {
                return;
            }
            for (int i = 0; i < paths.length; ++i) {
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)selectedNode.getUserObject();
                if (bvNode.isPackage()) {
                    flag = false;
                    break;
                }
                flag = true;
            }
            this.enableSelect(flag);
        }

        private void btnFilter_actionPerformed() {
            try {
                PopupQueryFilterUI typeUI = new PopupQueryFilterUI(this.mapFilter);
                ReportDialog.showDialog((CoreUIObject)typeUI, "\u8fc7\u6ee4", true, false);
                if (typeUI.isOk()) {
                    this.mapFilter = typeUI.getMapData();
                    this.executeFilter();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }

        private void doFilter(DefaultKingdeeTreeNode oldRoot, DefaultKingdeeTreeNode newRoot, String strOriSelected) {
            int nodeCount = oldRoot.getChildCount();
            for (int j = 0; j < nodeCount; ++j) {
                DefaultKingdeeTreeNode newNode;
                DefaultKingdeeTreeNode oldNode = (DefaultKingdeeTreeNode)oldRoot.getChildAt(j);
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)oldNode.getUserObject();
                if (bvNode.isPackage()) {
                    newNode = new DefaultKingdeeTreeNode();
                    newNode.setText(oldNode.getText());
                    newNode.setCustomIcon(oldNode.getCustomIcon());
                    newNode.setAllowsChildren(oldNode.getAllowsChildren());
                    newNode.setUserObject(oldNode.getUserObject());
                    newRoot.add((MutableTreeNode)newNode);
                    if (bvNode.getFullName().equals(strOriSelected)) {
                        this.newRootOriSelected = newNode;
                    }
                    this.doFilter(oldNode, newNode, strOriSelected);
                    continue;
                }
                if (FilterNode.getInstance().isHiden(bvNode)) continue;
                newNode = new DefaultKingdeeTreeNode();
                newNode.setText(oldNode.getText());
                newNode.setCustomIcon(oldNode.getCustomIcon());
                newNode.setAllowsChildren(oldNode.getAllowsChildren());
                newNode.setUserObject(oldNode.getUserObject());
                newRoot.add((MutableTreeNode)newNode);
                if (!bvNode.getFullName().equals(strOriSelected)) continue;
                this.newRootOriSelected = newNode;
            }
            if (newRoot.isLeaf() && !newRoot.isRoot()) {
                newRoot.removeFromParent();
            }
        }

        private void addNodeToList() throws BOSException {
            TreePath[] paths = this.kDTree1.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)selectedNode.getUserObject();
                if (bvNode.isPackage()) continue;
                this.enableSelect(true);
                Table table = new Table();
                table.setName(bvNode.getName());
                table.setAlias(bvNode.getAlias());
                table.setExpr(bvNode.getFullName());
                this.addNodeToList(table);
            }
        }

        private void addNodeToList(Table table) {
            if (!this.isExist(table.getExpr())) {
                this.addList(table);
            }
        }

        private boolean isExist(String fullName) {
            KDList list = this.getSelectedList();
            for (int n = 0; n < list.getElementCount(); ++n) {
                Table tableTmp = (Table)list.getElement(n);
                if (!tableTmp.getExpr().equals(fullName)) continue;
                return true;
            }
            return false;
        }

        private void addList(Table table) {
            this.getSelectedList().addElement((Object)table);
            this.getSelectedList().setSelectedValue((Object)table, true);
        }

        protected void onSelect() {
            try {
                this.addNodeToList();
            }
            catch (BOSException e) {
                log.error((Object)e);
            }
        }
    }
}

