/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractPreviewDbSourceUI;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtBizData;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.PreviewKSQLPanelUI;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.util.HashMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PreviewDbSourceUI
extends AbstractPreviewDbSourceUI {
    private static final long serialVersionUID = -884013313788912234L;
    private static final Logger logger = CoreUIObject.getLogger(PreviewDbSourceUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = false;
    String define;
    ExtBizData ebd;

    public PreviewDbSourceUI() throws Exception {
        this.tblContent.checkParsed();
        this.initLayout();
        this.spnTop.setModel((SpinnerModel)new SpinnerNumberModel(50, 1, 1000, 1));
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private int getTopNumber() {
        return this.spnTop.getIntegerVlaue();
    }

    public void execute(boolean isRefresh) {
        try {
            int rowCount = this.getTopNumber();
            if (rowCount == -1) {
                rowCount = Integer.MAX_VALUE;
            }
            this.tblContent.removeColumns();
            if (this.ebd == null) {
                this.ebd = new ExtBizData();
            }
            this.ebd.setRefresh(isRefresh);
            this.ebd.execute(this.define, 0, rowCount);
            this.isCancel = this.ebd.isCancel();
            if (this.isCancel) {
                try {
                    this.abort();
                }
                catch (Exception e) {
                    return;
                }
            }
            CtrlDesignQueryModel model = null;
            HashMap mapDefine = RunReportParam.splitDefineToMap(this.define);
            String dataSetType = CtrlReportUtil.getObjectString(mapDefine.get("DataSetType"));
            if (dataSetType.equals("sql_ksql")) {
                String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceID"));
                model = KSQLReportBO.initModel(dbsourceid);
            }
            ResultSet rs = this.ebd.getRs();
            PreviewKSQLPanelUI.addResultSet(this.tblContent, rs, model);
            try {
                rs.close();
            }
            catch (Exception e) {
                logger.debug((Object)"\u5173\u95edrs", (Throwable)e);
            }
        }
        catch (Exception e) {
            if (e instanceof CtrlReportException) {
                MessageUtil.showDetailAndOK(null, e.getMessage(), e);
            }
            logger.error((Object)"PreviewDbSourceUI.execute", (Throwable)e);
        }
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.execute(true);
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setDefine(String define) {
        this.define = define;
    }

    protected KDTable getTableForCommon() {
        return this.tblContent;
    }
}

