/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.InfoTipManager;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.sumreport.util.ControlDataLoadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;

public class QuotedReportUI
extends CoreUI {
    private KDContainer mainContainer;
    private KDTable rptTable;
    public static final int COL_REPORT_NAME = 0;
    public static final int COL_REPORT_ID = 1;
    public static final int COL_REPORT_PATH = 2;
    private KDSeparator kDSeparator;
    private KDButton btnCancel;
    private List rptList;
    private String dsID;
    private DefaultKingdeeTreeNode node;

    public QuotedReportUI(List rptList, String dsID, DefaultKingdeeTreeNode node) throws Exception {
        this.rptList = rptList;
        this.dsID = dsID;
        this.node = node;
        this.init();
    }

    private void init() {
        this.mainContainer = new KDContainer();
        this.mainContainer.setTitle("\u8be5\u6570\u636e\u96c6\u88ab\u5f15\u7528\u7684\u62a5\u8868\u5217\u8868");
        this.mainPanel = new KDPanel();
        this.rptTable = new KDTable();
        this.kDSeparator = new KDSeparator();
        this.btnCancel = new KDButton("\u53d6\u6d88");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    QuotedReportUI.this.kDButtonCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    QuotedReportUI.this.handUIException(exc);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this.setSize(960, 640);
        this.initTable();
        this.fillTable(this.rptList);
    }

    private void fillTable(List rptList) throws IOException, KDFException, KDFSAXException, Exception {
        for (HashMap map : rptList) {
            ExtDataSet[] datasets;
            byte[] byteData;
            Book book;
            String fid = CtrlReportUtil.getObjectString(map.get("fid"));
            String name = CtrlReportUtil.getObjectString(map.get("fname"));
            String systemid = CtrlReportUtil.getObjectString(map.get("fsystemid"));
            String fpubacctname = CtrlReportUtil.getObjectString(map.get("fpubacctname"));
            String fpath = RunReportParam.getSystemFullLabel(this.node, systemid);
            if (null == fpath) {
                fpath = "EAS\u79fb\u52a8\u62a5\u8868\\" + fpubacctname;
            }
            if (TableManager.isExistRowData(this.rptTable, "fid", fid) || null == (book = BookIOUtil.unpack((byte[])(byteData = (byte[])map.get("fcontent")))) || null == (datasets = MiscUtil.collectExtDataSets((Book)book)) || datasets.length <= 0) continue;
            for (int i = 0; i < datasets.length; ++i) {
                ExtDataSet ds = datasets[i];
                String define = ds.getDefine();
                String dsId = ExtDataSetManager.getDataSetIdByDefine((String)define);
                if (!this.dsID.equalsIgnoreCase(dsId)) continue;
                IRow irow = this.rptTable.addRow();
                irow.setUserObject((Object)map);
                irow.getCell(0).setValue((Object)name);
                irow.getCell(1).setValue((Object)fid);
                irow.getCell(2).setValue((Object)fpath);
            }
        }
    }

    private void initTable() {
        int[] columnWidth = new int[]{200, 150, 500};
        String[] columnNames = new String[]{"\u62a5\u8868\u540d\u79f0", "\u62a5\u8868ID", "\u62a5\u8868\u8def\u5f84"};
        ControlDataLoadUtil.initTableHeader(this.rptTable, 3, columnWidth, columnNames);
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 800, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 800, 600));
        this.mainContainer.setBounds(new Rectangle(10, 10, 780, 550));
        this.mainContainer.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.mainContainer, new KDLayout.Constraints(10, 10, 780, 550, 15));
        this.mainContainer.getContentPane().setLayout(new BorderLayout(0, 0));
        this.mainContainer.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.mainPanel.add((Component)this.rptTable, (Object)"Center");
        this.kDSeparator.setBounds(new Rectangle(0, 560, 800, 8));
        this.add((Component)this.kDSeparator, new KDLayout.Constraints(0, 560, 800, 8, 14));
        this.btnCancel.setBounds(new Rectangle(717, 570, 73, 21));
        this.add((Component)this.btnCancel, new KDLayout.Constraints(717, 570, 73, 21, 10));
        KDLabel tipLabel = InfoTipManager.getInstance().getTipLabel();
        tipLabel.setBounds(new Rectangle(240, 570, 200, 21));
        this.add((Component)tipLabel, new KDLayout.Constraints(290, 570, 200, 21, 386));
    }

    protected void kDButtonCancel_actionPerformed(ActionEvent e) {
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }
}

