/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.IRename;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractRenameUI;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;

public class RenameUI
extends AbstractRenameUI
implements IRename {
    private static final long serialVersionUID = 1509764070259573128L;
    private HashMap mapAlias = new HashMap();
    private HashMap mapInfo;
    private boolean isOk = false;

    public RenameUI() throws Exception {
    }

    public RenameUI(HashMap mapInfo) throws Exception {
        this();
        this.mapInfo = mapInfo;
        this.init();
    }

    private void init() {
        this.kDButtonGroup1.add((AbstractButton)this.rbCommon);
        this.kDButtonGroup1.add((AbstractButton)this.rbCustom);
        String name = CtrlReportUtil.getObjectString(this.mapInfo.get("fname"));
        this.setDefaultName(name);
        String defaultTypeString = CtrlReportUtil.getObjectString(this.mapInfo.get("forgtype"));
        this.setDefaultOrgType(defaultTypeString);
        String filterType = CtrlReportUtil.getObjectString(this.mapInfo.get("ffiltertype"));
        this.setDefaultParam(filterType);
        String fisstdproduct = CtrlReportUtil.getObjectString(this.mapInfo.get("fisstdproduct"));
        if (fisstdproduct.equals("1")) {
            this.kDBizMultiLangBox1.setEnabled(false);
        }
    }

    private void setDefaultName(String strName) {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        int z = this.kDBizMultiLangBox1.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)this.kDBizMultiLangBox1.getItemAt(i);
            String ls = mli.getLang().getLocale().toString();
            if (!strLocal.equals(ls)) continue;
            this.kDBizMultiLangBox1.setSelectedItem((Object)mli);
            this.kDBizMultiLangBox1.setSelectedItemData((Object)strName);
        }
    }

    private void setDefaultOrgType(String defaultTypeString) {
        Object[] cbArray = OrgType.getEnumList().toArray();
        DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>(cbArray);
        for (int i = 0; i < cbModel.getSize(); ++i) {
            OrgType orgType = (OrgType)cbModel.getElementAt(i);
            if (orgType.getValue() == 0) {
                cbModel.removeElementAt(i);
                --i;
                continue;
            }
            int ivalue = orgType.getValue();
            String orgTypeString = String.valueOf(ivalue);
            if (!orgTypeString.equals(defaultTypeString)) continue;
            cbModel.setSelectedItem(orgType);
        }
        this.cbOrgType.setModel(cbModel);
    }

    private void setDefaultParam(String filterType) {
        if (filterType.equals("2")) {
            this.rbCustom.setSelected(true);
        } else {
            this.rbCommon.setSelected(true);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isOk = false;
        this.closeWin();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.mapAlias = CtrlReportUtil.getEaslocaleFromKDMultiLangBox((KDMultiLangBox)this.kDBizMultiLangBox1);
        String strLocal = SysContext.getSysContext().getLocale().toString();
        Iterator it = this.mapAlias.keySet().iterator();
        while (it.hasNext()) {
            String strLocalTmp = it.next().toString();
            String curName = CtrlReportUtil.getObjectString(this.mapAlias.get(strLocalTmp));
            if (curName.indexOf(" ") != -1) {
                MessageUtil.showInfo("label202", true);
                this.kDBizMultiLangBox1.requestFocus();
                return;
            }
            if (curName.indexOf("/") != -1) {
                MessageUtil.showInfo("label203", true);
                this.kDBizMultiLangBox1.requestFocus();
                return;
            }
            String fisstdproduct = CtrlReportUtil.getObjectString(this.mapInfo.get("fisstdproduct"));
            if (!fisstdproduct.equals("1") && curName.startsWith("std_")) {
                MessageUtil.showInfo("label204", true);
                this.kDBizMultiLangBox1.requestFocus();
                return;
            }
            if (!curName.equals("") || !strLocalTmp.equals(strLocal)) continue;
            String msg1 = MessageUtil.getMsgInfo("label142");
            String msg2 = MessageUtil.getMsgInfo("label91");
            String msg = msg1 + "(" + CtrlReportUtil.bosToEasLang(strLocal) + ")" + msg2;
            MessageUtil.showInfo(msg, false);
            this.kDBizMultiLangBox1.requestFocus();
            return;
        }
        OrgType orgType = (OrgType)this.cbOrgType.getSelectedItem();
        int ivalue = orgType.getValue();
        String orgTypeString = String.valueOf(ivalue);
        this.mapInfo.put("forgtype", orgTypeString);
        if (this.rbCommon.isSelected()) {
            this.mapInfo.put("ffiltertype", "1");
        } else if (this.rbCustom.isSelected()) {
            this.mapInfo.put("ffiltertype", "2");
        }
        this.isOk = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    @Override
    public boolean isOk() {
        return this.isOk;
    }

    @Override
    public HashMap getMapAlias() {
        return this.mapAlias;
    }

    @Override
    public void clear() {
        this.mapAlias.clear();
    }

    @Override
    public HashMap getMapInfo() {
        return this.mapInfo;
    }
}

