/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UINewTabFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.rpts.ctrlreport.ReportAttemperInfo;
import com.kingdee.eas.rpts.ctrlreport.adapter.ExtReportFilterManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.IFilter;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.bo.MainMenuItemBO;
import com.kingdee.eas.rpts.ctrlreport.bo.ReportAttemperBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractReportAttemperListUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportAttemperSetupUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.client.SendMailListUI;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ReportAttemperListUI
extends AbstractReportAttemperListUI
implements IFilter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ReportAttemperListUI.class);
    KDTSortManager sm = null;
    int orderColIndex = 5;
    int orderSortType = 1;
    ArrayList selectedIDList = new ArrayList();
    ExtReportFilterManager efm;
    String refreshFlag = "Refresh_Node";

    public ReportAttemperListUI() throws Exception {
        this.tblMain.checkParsed();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.getDataList();
    }

    private void initTable() {
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.tblMain){

                public void sort(int colIndex, int sortType) {
                    super.sort(colIndex, sortType);
                    ReportAttemperListUI.this.orderColIndex = colIndex;
                    ReportAttemperListUI.this.orderSortType = sortType;
                    for (int i = 0; i < ReportAttemperListUI.this.tblMain.getRowCount(); ++i) {
                        IRow row = ReportAttemperListUI.this.tblMain.getRow(i);
                        HashMap map = (HashMap)row.getUserObject();
                        String fid = CtrlReportUtil.getObjectString(map.get("fid"));
                        if (!ReportAttemperListUI.this.selectedIDList.contains(fid)) continue;
                        ReportAttemperListUI.this.tblMain.getSelectManager().select(i, -1);
                        break;
                    }
                }
            };
            this.sm.setSortAuto(true);
        }
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
    }

    public void getDataList() {
        if (this.refreshFlag == "Refresh_Search") {
            this.efm.filte(true);
            return;
        }
        ArrayList lstData = new ArrayList();
        try {
            lstData = ReportAttemperBO.getReportAttemperList(null);
            this.fillData(lstData);
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label17") + "\r\n" + ex.getMessage(), ex);
        }
    }

    @Override
    public void fillData(ArrayList lst) throws Exception {
        this.tblMain.removeRows();
        for (HashMap map : lst) {
            IRow irow = this.tblMain.addRow();
            irow.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map.get("attempername")));
            irow.getCell(1).setValue((Object)CtrlReportUtil.getObjectString(map.get("reportname")));
            irow.getCell(2).setValue((Object)MainMenuItemBO.getDeployName(CtrlReportUtil.getObjectString(map.get("fdeploypath"))));
            irow.getCell(3).setValue((Object)CtrlReportUtil.getObjectString(map.get("ftitle")));
            irow.getCell(4).setValue((Object)CtrlReportUtil.getObjectString(map.get("user_name")));
            irow.getCell(5).setValue((Object)CtrlReportUtil.formatDateTimeHHmm(String.valueOf(map.get("flastupdatetime"))));
            irow.setUserObject((Object)map);
        }
        if (this.sm != null) {
            this.sm.sort(this.orderColIndex, this.orderSortType);
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        boolean isSearch;
        if (this.efm == null) {
            this.efm = new ExtReportFilterManager(this);
        }
        if (isSearch = this.efm.filte(false)) {
            this.refreshFlag = "Refresh_Search";
        }
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.getDataList();
    }

    @Override
    protected void btnNew_actionPerformed(ActionEvent e) throws Exception {
        ReportAttemperSetupUI ui = new ReportAttemperSetupUI(null);
        ReportDialog.showDialog((CoreUIObject)ui, MessageUtil.getMsgInfo("label384"), true, false);
        if (!ui.isCancel()) {
            String newID = ui.getNewID();
            this.selectedIDList.clear();
            this.selectedIDList.add(newID);
            this.getDataList();
        }
    }

    @Override
    protected void btnEdit_actionPerformed(ActionEvent e) throws Exception {
        HashMap mapData = this.getSelectedObj();
        if (mapData == null) {
            return;
        }
        String fid = CtrlReportUtil.getObjectString(mapData.get("fid"));
        ReportAttemperInfo infoDetail = ReportAttemperBO.getReportAttemperInfo(null, fid);
        ReportAttemperSetupUI ui = new ReportAttemperSetupUI(infoDetail);
        ReportDialog.showDialog((CoreUIObject)ui, MessageUtil.getMsgInfo("label384"), true, false);
        if (!ui.isCancel()) {
            this.getDataList();
        }
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tblMain);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        String confirmMsg = "\u786e\u5b9a\u5220\u9664\uff1f";
        for (int i = 0; i < lstSelected.size(); ++i) {
            String strRowIndex = lstSelected.get(i).toString();
            HashMap mapInfo = (HashMap)this.tblMain.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String fjobprocessdefid = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
            if (fjobprocessdefid.equals("")) continue;
            confirmMsg = "\u5b58\u5728\u5df2\u53d1\u5e03\u4e3a\u540e\u53f0\u4e8b\u52a1\u7684\u8c03\u5ea6\uff0c\u5982\u679c\u5220\u9664\uff0c\u540c\u65f6\u5220\u9664\u5bf9\u5e94\u7684\u540e\u53f0\u4e8b\u52a1\uff0c\u786e\u5b9a\u5220\u9664\uff1f";
        }
        boolean confirm = MessageUtil.showConfirm(null, confirmMsg);
        if (!confirm) {
            return;
        }
        ArrayList<Object> lstInfo = new ArrayList<Object>();
        for (int i = 0; i < lstSelected.size(); ++i) {
            String strRowIndex = lstSelected.get(i).toString();
            HashMap mapInfo = (HashMap)this.tblMain.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String fid = mapInfo.get("fid").toString();
            boolean isOtherCtrl = CtrlReportUtil.isOtherCtrl(this, "EDIT", fid);
            if (isOtherCtrl) {
                return;
            }
            CtrlReportUtil.releaseCtrl(this, fid);
            lstInfo.add(mapInfo.clone());
        }
        try {
            ReportAttemperBO.delete(lstInfo);
            MessageUtil.showInfo("\u5220\u9664\u6210\u529f", false);
            this.getDataList();
        }
        catch (Exception e1) {
            MessageUtil.showDetailAndOK(null, "\u5220\u9664\u5931\u8d25", e1);
        }
    }

    private HashMap getSelectedObj() {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.tblMain);
        if (lstIndex.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return null;
        }
        if (lstIndex.size() != 1) {
            MessageUtil.showInfo("label12", true);
            return null;
        }
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        HashMap mapData = (HashMap)this.tblMain.getRow(row).getUserObject();
        return mapData;
    }

    @Override
    protected void btnRelease_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tblMain);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        String[] arrID = new String[lstSelected.size()];
        for (int i = 0; i < lstSelected.size(); ++i) {
            String fid;
            String strRowIndex = lstSelected.get(i).toString();
            HashMap mapInfo = (HashMap)this.tblMain.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String fjobprocessdefid = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
            if (!fjobprocessdefid.equals("")) {
                MessageUtil.showInfo("\u9009\u62e9\u7684\u8bb0\u5f55\u5b58\u5728\u5df2\u7ecf\u53d1\u5e03\u7684\u8c03\u5ea6\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03\uff01", false);
                return;
            }
            arrID[i] = fid = mapInfo.get("fid").toString();
        }
        boolean confirm = MessageUtil.showConfirm(null, "\u786e\u5b9a\u53d1\u5e03\uff1f");
        if (!confirm) {
            return;
        }
        try {
            ReportAttemperBO.release(arrID);
            MessageUtil.showInfo("\u53d1\u5e03\u6210\u529f\uff0c\u8bf7\u5728\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\u8868\u4e2d\u7ef4\u62a4\u8c03\u5ea6\u5b9e\u4f8b", false);
            this.getDataList();
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, "\u53d1\u5e03\u8c03\u5ea6\u5931\u8d25", ex);
            logger.error((Object)ex);
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.btnEdit_actionPerformed(null);
            return;
        }
        if (e.getClickCount() == 1 && e.getType() == 1) {
            ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.tblMain);
            this.selectedIDList.clear();
            String strRowIndex = lstIndex.get(lstIndex.size() - 1).toString();
            HashMap mapInfo = (HashMap)this.tblMain.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String fid = mapInfo.get("fid").toString();
            this.selectedIDList.add(fid);
        }
    }

    @Override
    protected void miSendMail_actionPerformed(ActionEvent e) throws Exception {
        Frame mainFrame = UIFrameUtil.getCurrMainFrame((Component)((Object)this));
        UIContext uiContext = new UIContext((Object)mainFrame);
        uiContext.put("checkLicense", "true");
        uiContext.put("MainMenuName", MessageUtil.getMsgInfo("label441"));
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)UINewTabFactory.class.getName());
            IUIWindow uiWindow = uiFactory.create(SendMailListUI.class.getName(), (Map)uiContext, null, null);
            if (uiWindow != null) {
                uiWindow.show();
            }
        }
        catch (UIException ue) {
            MessageUtil.showDetailAndOK(null, "Open SendMailListUI error", (Exception)((Object)ue));
        }
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuFile.remove((JMenuItem)this.menuItemExitCurrent);
        this.menuFile.remove((Component)this.kDSeparator2);
        this.menuFile.add((Component)this.kDSeparator2);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnPageSetup);
        this.toolBar.add((Component)this.btnSearch);
        this.toolBar.add((Component)this.btnRefresh);
        this.toolBar.add((Component)this.btnNew);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnDel);
        this.toolBar.add((Component)this.btnRelease);
        this.toolBar.add((Component)this.separator1);
    }

    @Override
    public String getSystemID() {
        return null;
    }

    @Override
    public String getTableFlag() {
        return null;
    }

    @Override
    public void setStopChange(boolean isStopChange) {
    }

    @Override
    public void setSystemID(String systemID) {
    }
}

