/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.IUpdateStatusBar;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.SimpleToolBarLayout;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.rpts.base.execution.InvokeFunctionUtil;
import com.kingdee.eas.rpts.base.license.EXTLicenseService;
import com.kingdee.eas.rpts.cloud.http.CloudRptCenterHttpFetcher;
import com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerFacade;
import com.kingdee.eas.rpts.cloud.service.ICloudRptCenterController;
import com.kingdee.eas.rpts.cloud.ui.CloudRptAgreementDialog;
import com.kingdee.eas.rpts.cloud.ui.CloudRptCenterDisabledDialog;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditUtil;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.client.ExportCompleteRepoertAction;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportRunUI;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.rpts.ctrlreport.util.LicenseControllerUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ProcessingBoxPanel;
import com.kingdee.eas.rpts.statistics.client.StatisticsInfoClientCollector;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class ReportRunTimeUI
extends CoreUI {
    private String _reportID;
    private DefineReportInfo _entity;
    private ExtRunner _worker;
    private Map _associativeFilter;
    private boolean isEntryFromMenu;
    private boolean _checkPermission;
    public static final Object BACK_DOOR_PERMISSION = new Object();

    public ReportRunTimeUI() throws Exception {
        this.addPropertyChangeListener("closeTab", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReportRunTimeUI.this.menuItemExitCurrent.doClick();
            }
        });
    }

    public void onLoad() throws Exception {
        boolean isCloudRpt;
        Map uiCtx = this.getUIContext();
        this._reportID = (String)uiCtx.get("UIClassParam");
        this._checkPermission = uiCtx.get(BACK_DOOR_PERMISSION) == null;
        boolean bl = this.isEntryFromMenu = uiCtx.get(BACK_DOOR_PERMISSION) == null;
        if (StringUtil.isEmptyString((String)this._reportID)) {
            this._entity = (DefineReportInfo)uiCtx.get("DefineReportInfo");
            if (this._entity != null) {
                this._reportID = this._entity.getId().toString();
            }
            this._associativeFilter = (Map)uiCtx.get("filterMap");
        }
        this.preCheck();
        Book book = null;
        try {
            book = BookIOUtil.unpack((byte[])this._entity.getContent());
        }
        catch (Exception e) {
            MiscUtil.handleFileCheckingException((Exception)e, null);
            if (MiscUtil.shouldLog()) {
                MiscUtil.log((Throwable)e);
            }
            this.selfDestruction();
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String userId = userInfo.getId().toString();
        boolean bl2 = isCloudRpt = book.getCloudRptUuid() != null;
        if (isCloudRpt) {
            if (this.isEntryFromMenu) {
                if (!CloudRptCenterControllerFacade.isCloudRptCenterEnable(null)) {
                    if (this.isEntryFromMenu) {
                        MessageUtil.showInfo("\u62a5\u8868\u7ba1\u7406\u5458\u5df2\u7981\u7528\u4e91\u62a5\u8868\u4e2d\u5fc3\u3002\n\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7684\u62a5\u8868\u7ba1\u7406\u5458\uff0c\u542f\u7528\u4e91\u62a5\u8868\u4e2d\u5fc3\u3002\u5982\u679c\u7531\u4e8e\u4f01\u4e1a\u7684\u4fe1\u606f\u5b89\u5168\u7b56\u7565\u800c\u7981\u7528\u4e91\u62a5\u8868\u4e2d\u5fc3\u7684\uff0c\u4e91\u62a5\u8868\u5c06\u65e0\u6cd5\u4f7f\u7528\u3002", false);
                    } else {
                        CloudRptCenterDisabledDialog.showMessage((Component)((Object)this));
                    }
                    this.selfDestruction();
                }
                if (!CloudRptCenterHttpFetcher.isUserAgreementSigned(SysContext.getSysContext().getCurrentUserInfo().getNumber()) && !CloudRptAgreementDialog.showCloudRptAgreementBox()) {
                    this.selfDestruction();
                }
            }
            ICloudRptCenterController controller = CloudRptCenterControllerFacade.getRemoteInst();
            if (book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null) {
                boolean hasDemoAuth = controller.hasDemoAuth(userId, book.getCloudRptUuid());
                this._checkPermission = !hasDemoAuth && this._checkPermission;
            }
        }
        this.check();
        super.onLoad();
        Object title = this.getUIContext().get("MainMenuName");
        if (title == null) {
            InvokeFunctionUtil.doUISetting(this, this._reportID);
        } else {
            this.setUITitle(String.valueOf(title));
        }
        this.runEXT();
        CloudRptCenterHttpFetcher.reportCloudRptUsage(this._reportID);
    }

    private void preCheck() {
        EXTLicenseService licSrsv = new EXTLicenseService(null);
        try {
            if ((licSrsv.sysLicenseModuleType() & 2) == 0) {
                LicenseController lc = FrameWorkClientUtils.getLicenseController();
                String content = "\u6ca1\u6709\u5408\u6cd5\u7684\u8bb8\u53ef\u4e14\u5df2\u8fc7\u8bd5\u7528\u671f";
                StringBuffer detail = new StringBuffer();
                detail.append("\u7533\u8bf7License\u7684\u7c7b\u540d\u79f0\uff1a [");
                detail.append(((Object)((Object)this)).getClass().getName() + "]\n");
                String licenseMessage = LicenseControllerUtil.constructLicenseMessage(((Object)((Object)this)).getClass().getName());
                if (licenseMessage == null) {
                    detail.append("\u5bf9\u5e94\u7684\u6a21\u5757\u540d\u79f0\uff1a\u62a5\u8868\u8fd0\u884c\u5e73\u53f0[BOS_RPTC_RUNTIME]\n");
                    detail.append("\u5bf9\u5e94\u7684\u5b50\u7cfb\u7edf\u540d\u79f0\uff1a\u6269\u5c55\u62a5\u8868\u4e2d\u5fc3[BOS_RPTC_G]\n");
                } else {
                    detail.append(licenseMessage);
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)content, (String)detail.toString(), (int)0);
                this.selfDestruction();
            }
        }
        catch (Exception e) {
            MessageUtil.showDetailAndOK(null, "\u5931\u8d25", e);
            this.selfDestruction();
        }
        if (this._reportID != null && this._entity == null) {
            try {
                this._entity = DefineReportBO.getReportInfo(null, this._reportID);
                if (this._entity == null) {
                    MessageUtil.showInfo("\u62a5\u8868\u5df2\u7ecf\u5220\u9664", false);
                    this.selfDestruction();
                }
            }
            catch (BOSException e) {
                MessageUtil.showDetailAndOK(null, "\u5931\u8d25", (Exception)((Object)e));
                this.selfDestruction();
            }
        }
    }

    private void check() {
        if (PublishType.isPublished(this._entity)) {
            if (!this._checkPermission || PermissionBO.hasDataPermission(this._reportID, PermissionKind.VIEW)) {
                return;
            }
            MessageUtil.showInfo("\u6ca1\u6709\u67e5\u770b\u8be5\u62a5\u8868\u7684\u6743\u9650", false);
        } else {
            MessageUtil.showInfo("\u62a5\u8868\u672a\u53d1\u5e03\u6216\u5df2\u64a4\u9500\u53d1\u5e03", false);
        }
        this.selfDestruction();
    }

    private void selfDestruction() {
        this.abort();
    }

    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI");
    }

    private void runEXT() {
        this._worker = new ExtRunner();
        this._worker.start();
    }

    public boolean destroyWindow() {
        boolean destroy = super.destroyWindow();
        this._worker.destroy();
        this._worker = null;
        return destroy;
    }

    static {
        StatisticsInfoClientCollector.collect();
    }

    private class ExtRunner
    extends LongTaskWorker {
        private ExtGuiExecutor _executor;
        private ReportRunTimeUI ui;

        private ExtRunner() {
            this.ui = ReportRunTimeUI.this;
        }

        public Object construct() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtRunner.this.ui.setLayout(new BorderLayout());
                    ExtRunner.this.ui.add((Component)((Object)new ProcessingBoxPanel()), "Center");
                    ExtRunner.this.ui.revalidate();
                }
            });
            this.load();
            try {
                if (ReportRunTimeUI.this._associativeFilter == null ? !this._executor.execute() : !this._executor.execute(ReportRunTimeUI.this._associativeFilter)) {
                    this.ui.getUIWindow().close();
                    return null;
                }
                long execTime = System.currentTimeMillis() - this._executor.getRptRunStatt();
                if (ReportAuditUtil.isDeployReport(this.ui._entity)) {
                    Map map = this.ui.getUIContext();
                    int pathType = ReportAuditUtil.getPathType(map);
                    ReportAuditUtil.updateAuditTable(null, this.ui._entity, execTime, pathType);
                }
                return Boolean.TRUE;
            }
            catch (Exception e) {
                MessageUtil.showDetailAndOK(null, "\u6267\u884c\u62a5\u8868\u51fa\u9519", e);
                return null;
            }
        }

        private void load() {
            ExtCallbackImpl callbackImpl = new ExtCallbackImpl(this.ui._entity, false, ReportRunTimeUI.this.isEntryFromMenu);
            callbackImpl.setUIContext(this.ui.getUIContext());
            this._executor = new ExtGuiExecutor(this.ui._entity.getContent(), (IExtRuntimeDataProvider)callbackImpl, false);
        }

        public void destroy() {
            if (this._executor != null && this._executor.getBook() != null) {
                this._executor.getBook().getDeps().setUserInterrupted(true);
            }
        }

        public void finished() {
            Object obj = this.get();
            if (obj != null && obj == Boolean.TRUE) {
                this.displayReport();
            }
        }

        private void displayReport() {
            boolean back_door_permission = ReportRunTimeUI.this.getUIContext().get(BACK_DOOR_PERMISSION) == null && PermissionBO.hasDataPermission(ReportRunTimeUI.this._reportID, PermissionKind.VIEW);
            Action[] actions = back_door_permission ? this._executor.getContextualActions(0) : this._executor.getContextualActions(5);
            Window cr = SwingUtilities.getWindowAncestor((Component)((Object)this.ui));
            Book book = this._executor.getSpreadContext().getBook();
            ExportCompleteRepoertAction exportAction = new ExportCompleteRepoertAction("\u5bfc\u51fa\u5168\u4fe1\u606f\u62a5\u8868", (Component)((Object)this.ui));
            exportAction.setPK(ReportRunTimeUI.this._reportID);
            exportAction.setBook(book);
            if (null != cr) {
                for (int i = 0; i < actions.length; ++i) {
                    this.ui.toolBar.add(actions[i]);
                }
                this.ui.toolBar.add((Action)exportAction);
                if (book.getCloudRptUuid() != null) {
                    KDWorkButton btn = new KDWorkButton((Action)new ExtGuiExecutor.CloudRptCommentAction(this._executor.getDataProvider()));
                    this.ui.toolBar.add((Component)btn);
                    LayoutManager layout = ReportRunTimeUI.this.toolBar.getLayout();
                    if (layout instanceof SimpleToolBarLayout) {
                        ((SimpleToolBarLayout)layout).setHorizontalAlwayShownAtLastComponent((JComponent)btn);
                    }
                }
                this.ui.removeAll();
                SpreadContext context = this._executor.getSpreadContext();
                if (null != context) {
                    context.register(new IUpdateStatusBar(){

                        public void updateStatusBar(String msg) {
                            ReportRunTimeUI.this.getMainStatusBar().setPerTitle(msg);
                        }
                    });
                }
                this.ui.add((Component)context, "Center");
                Object owner = ReportRunTimeUI.this.getUIContext().get("Owner");
                ExtReportRunUI.setShowLinkage(context, owner);
                this.ui.toolBar.validate();
                cr.validate();
                cr.repaint();
            }
        }
    }
}

