/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.rpts.ctrlreport.ByteContentInfo;
import com.kingdee.eas.rpts.ctrlreport.ReportSnapInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.ReportSnapBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractExtReportRunUI;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ProcessingBoxPanel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReportSnapRunUI
extends AbstractExtReportRunUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogUtil.getPackageLogger(ReportSnapRunUI.class);
    private SpreadContext _context = null;
    String report_id;
    boolean isInitToolBar = true;
    boolean isLimitRecord = false;
    ProcessingBoxPanel processingBoxPanel;
    ReportSnapInfo snapInfo = null;
    ByteContentInfo byteInfo = null;

    public ReportSnapRunUI() throws Exception {
        ExtContextUtils.setContext(null);
    }

    public void onLoad() throws Exception {
        this.report_id = (String)this.getUIContext().get("UIClassParam");
        this.doCheck();
        super.onLoad();
        this.setUITitle(String.valueOf(this.getUIContext().get("MainMenuName")));
        this.hideBizData();
        this.openGetDataThread();
    }

    public boolean destroyWindow() {
        CtrlReportUtil.releaseCtrl(this, this.report_id);
        return super.destroyWindow();
    }

    private void doCheck() {
        try {
            this.snapInfo = ReportSnapBO.getReportSnapInfo(null, this.report_id);
            if (this.snapInfo == null) {
                MessageUtil.showInfo("label406", true);
                this.abort();
            }
            this.byteInfo = ReportSnapBO.getByteContentInfo(null, this.report_id);
            if (this.byteInfo == null) {
                MessageUtil.showInfo("label407", true);
                this.abort();
            }
        }
        catch (Exception e) {
            MessageUtil.showDetailAndOKFromResource(null, "label17", e);
            this.abort();
        }
    }

    private void openGetDataThread() {
        new GetDataThread().start();
    }

    public void showBizData(ExtGuiExecutor re) {
        if (this._context != null) {
            this.add((Component)this._context);
        }
        this.remove((Component)((Object)this.processingBoxPanel));
        this.validate();
        this.repaint();
        this.initToolBar(re);
    }

    public void hideBizData() {
        if (this._context != null) {
            this.remove((Component)this._context);
        }
        if (this.processingBoxPanel == null) {
            this.processingBoxPanel = new ProcessingBoxPanel();
        }
        this.add((Component)((Object)this.processingBoxPanel), "Center");
        this.repaint();
    }

    private void initToolBar(ExtGuiExecutor re) {
        if (this.isInitToolBar) {
            KDToolBar toolBar = this.getUIToolBar();
            Component quit = toolBar.getComponent(2);
            toolBar.removeAllToolBarComponents();
            Action[] acs = re.getContextualActions(4);
            for (int i = 0; i < acs.length; ++i) {
                toolBar.add(acs[i], i + 1);
            }
            toolBar.add(quit);
            Container c = toolBar.getParent();
            if (c != null) {
                c.validate();
                c.repaint();
            }
            this.isInitToolBar = false;
        }
    }

    @Override
    protected void miExtConsole_actionPerformed(ActionEvent e) throws Exception {
        MiscUtil.showConsole(null);
    }

    class GetDataThread
    extends Thread {
        boolean isShow = true;
        ExtGuiExecutor re = null;

        @Override
        public void run() {
            try {
                ReportSnapRunUI.this.hideBizData();
                this.initBook();
                if (this.isShow) {
                    ReportSnapRunUI.this.showBizData(this.re);
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u8fd0\u884c\u5feb\u7167:", (Throwable)e);
                MessageUtil.showDetailAndOK(null, EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label151"), e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReportSnapRunUI.this.getUIWindow().close();
                    }
                });
            }
        }

        private void initBook() throws Exception {
            this.re = new ExtGuiExecutor(ReportSnapRunUI.this.byteInfo.getContent());
            boolean isOk = this.re.execute();
            if (!isOk) {
                if (ReportSnapRunUI.this.isInitToolBar) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReportSnapRunUI.this.getUIWindow().close();
                        }
                    });
                    this.isShow = false;
                    return;
                }
            } else {
                ReportSnapRunUI.this._context = this.re.getSpreadContext();
            }
        }
    }
}

