/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.EXTLicenseService;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.ExtRptMacroManageActionFactory;
import com.kingdee.eas.rpts.ctrlreport.model.SQLCustomType;
import com.kingdee.eas.rpts.ctrlreport.util.LicenseControllerUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.sumreport.client.icon.UploadSumIcons;
import com.kingdee.eas.rpts.sumreport.debug.client.sumrange.DebugSumRangeListUI;
import com.kingdee.eas.rpts.sumreport.debug.client.task.DebugTaskDistributeListUI;
import com.kingdee.eas.rpts.sumreport.exceptions.DataSourceException;
import com.kingdee.eas.rpts.sumreport.use.model.SumReportModel;
import com.kingdee.eas.rpts.sumreport.use.service.DataSourceService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ReportStudioUI
extends ExtReportManageUI {
    private static final Logger _logger = CoreUIObject.getLogger(ReportStudioUI.class);

    public ReportStudioUI() throws Exception {
        this.setUITitle(MessageUtil.getReportsInfo("label35"));
    }

    @Override
    public void onLoad() throws Exception {
        this.licVerify();
        super.onLoad();
        this.addSumReportedMenu();
    }

    public void licVerify() {
        EXTLicenseService licSrsv = new EXTLicenseService(null);
        try {
            if (!licSrsv.sysLicenseContain("BOS_RPTC_STUDIO")) {
                String content = "\u6ca1\u6709\u5408\u6cd5\u7684\u8bb8\u53ef\u4e14\u5df2\u8fc7\u8bd5\u7528\u671f";
                StringBuffer detail = new StringBuffer();
                detail.append("\u7533\u8bf7License\u7684\u7c7b\u540d\u79f0\uff1a [");
                detail.append(this.getClass().getName() + "]\n");
                String licenseMessage = LicenseControllerUtil.constructLicenseMessage(this.getClass().getName());
                if (licenseMessage == null) {
                    detail.append("\u5bf9\u5e94\u7684\u6a21\u5757\u540d\u79f0\uff1a\u62a5\u8868\u5de5\u5177[BOS_RPTC_STUDIO]\n");
                    detail.append("\u5bf9\u5e94\u7684\u5b50\u7cfb\u7edf\u540d\u79f0\uff1a\u6269\u5c55\u62a5\u8868\u4e2d\u5fc3[BOS_RPTC_G]\n");
                } else {
                    detail.append(licenseMessage);
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)content, (String)detail.toString(), (int)0);
                this.selfDestruction();
            }
        }
        catch (EXTLicenseException e) {
            MessageUtil.showDetailAndOK(null, "\u5931\u8d25", e);
            this.selfDestruction();
        }
    }

    private void selfDestruction() {
        this.abort();
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.rpts.ctrlreport.client.ReportStudioUI");
    }

    private void addSumReportedMenu() {
        this.btnDebug.setVisible(true);
        this.btnDebug.setIcon((Icon)UploadSumIcons.createIcon("tbtn_debugmode.gif"));
        this.btnDebug.removeAllAssistButton();
        this.btnDebug.addAssistMenuItem((Action)new OpenTabAction(MessageUtil.getReportsInfo("label36"), DebugSumRangeListUI.class.getName(), new UIContext()));
        this.btnDebug.addAssistMenuItem((Action)new OpenTabAction(MessageUtil.getReportsInfo("label37"), DebugTaskDistributeListUI.class.getName(), new UIContext()));
    }

    @Override
    protected KDMenuItem[] getAddDataSourceMenu() {
        KDMenuItem itemSumReport = new KDMenuItem(MessageUtil.getReportsInfo("label38"));
        itemSumReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportStudioUI.this.customType = SQLCustomType.SUMMARY_REPORTED_SNAP;
                    ReportStudioUI.this.addSumReportedDS();
                }
                catch (Exception e1) {
                    _logger.error((Object)e1);
                }
            }
        });
        KDMenuItem itemSnap = new KDMenuItem(MessageUtil.getReportsInfo("label39"));
        itemSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportStudioUI.this.customType = SQLCustomType.DYNAMIC_SNAPSHOT;
                    ReportStudioUI.this.btnAdd_actionPerformed(null);
                }
                catch (Exception e1) {
                    _logger.error((Object)e1);
                }
            }
        });
        KDMenuItem itemStaticSnap = new KDMenuItem(MessageUtil.getReportsInfo("label40"));
        itemStaticSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportStudioUI.this.customType = SQLCustomType.STATIC_SNAPSHOT;
                    ReportStudioUI.this.btnAdd_actionPerformed(null);
                }
                catch (Exception e1) {
                    _logger.error((Object)e1);
                }
            }
        });
        return new KDMenuItem[]{itemSumReport, itemSnap, itemStaticSnap};
    }

    private void addSumReportedDS() {
        DataSourceService dsSrsv = new DataSourceService();
        try {
            if (!dsSrsv.isExistDS(this.getSystemID())) {
                try {
                    dsSrsv.persistDS(this.getSystemID(), SumReportModel.getModel().getCommonQuery());
                    this.getDataList();
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                ExtMsgBox.showInfo((Component)((Object)this), "\u5df2\u5b58\u5728\u6c47\u603b\u4e0a\u62a5\u6570\u636e\u96c6\uff01");
            }
        }
        catch (DataSourceException e) {
            this.handUIException(e);
        }
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.add((Component)new KDWorkButton(ExtRptMacroManageActionFactory.newManageAction((Component)((Object)this))));
    }

    private class OpenTabAction
    extends AbstractAction {
        private String _className;
        private UIContext _uiCtx;

        public OpenTabAction(String name, String className, UIContext uiCtx) {
            this.putValue("Name", name);
            this._className = className;
            this._uiCtx = uiCtx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EASUtil.showUIOnNewTab(this._className, (Map)this._uiCtx, ReportStudioUI.this);
        }
    }
}

