/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.base.ColorConst;
import com.kingdee.eas.rpts.ctrlreport.IPopupSelector;
import com.kingdee.eas.rpts.ctrlreport.adapter.ExtReportFilterManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.IFilter;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.TreeManager;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractSelectedReportSingleUI;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportAttemperSetupUI;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class SelectedReportSingleUI
extends AbstractSelectedReportSingleUI
implements IPopupSelector,
IFilter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SelectedReportSingleUI.class);
    private boolean isinitLayout = false;
    boolean isStopChange = false;
    private String systemID = null;
    private String tableFlag = "1";
    ArrayList lstSelected = new ArrayList();
    ExtReportFilterManager efm;
    SelectedReportSingleUI selectedReportSingleUI = this;
    String uiFlag;
    boolean isCanceled = true;
    boolean isMulteSelected = false;
    boolean isF7 = false;
    Object objectUI;
    String selectedTreeNode = "";
    private boolean isMobile = false;
    private DefaultKingdeeTreeNode nodeRoot;

    public SelectedReportSingleUI() throws Exception {
        this.tableReport.checkParsed();
        this.initLayout();
        this.putClientProperty("ShowToolBar", this.toolBar);
    }

    public SelectedReportSingleUI(String uiFlag) throws Exception {
        this();
        this.uiFlag = uiFlag;
    }

    public SelectedReportSingleUI(String uiFlag, boolean isF7) throws Exception {
        this(uiFlag);
        this.isF7 = isF7;
    }

    public SelectedReportSingleUI(Object objectUI, boolean isF7) throws Exception {
        this(objectUI.getClass().getName());
        this.objectUI = objectUI;
        this.isF7 = isF7;
    }

    public void onLoad() throws Exception {
        if (this.isF7) {
            return;
        }
        this.initCtrl();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void initCtrl() {
        if (this.isF7) {
            this.lstSelected.clear();
            this.tableReport.removeRows();
        }
        this.isCanceled = true;
        this.nodeRoot = this.isMobile ? CommonTreeModel.getMobileTreeModel() : CommonTreeModel.getPackageTreeModel(null);
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.nodeRoot));
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(false);
        this.kDTree1.setAutoscrolls(true);
        this.setReptsNode(this.nodeRoot);
        this.tableReport.getStyleAttributes().setLocked(true);
        if (this.isMulteSelected) {
            this.tableReport.getSelectManager().setSelectMode(10);
        } else {
            this.tableReport.getSelectManager().setSelectMode(2);
        }
        this.lstSelected.clear();
        TreeManager.treeSelected(this.kDTree1, this.nodeRoot, this.tableFlag, this.selectedTreeNode);
    }

    private void setReptsNode(DefaultKingdeeTreeNode nodeRoot) {
        if (nodeRoot.isLeaf()) {
            this.addExtNode(nodeRoot);
        } else {
            Enumeration enume = nodeRoot.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                this.setReptsNode(repNode);
            }
            if (!nodeRoot.isRoot()) {
                this.addExtNode(nodeRoot);
            }
        }
    }

    private void addExtNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode DKTreeNode1 = new DefaultKingdeeTreeNode();
        DKTreeNode1.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.ReportsResource", (String)"defineReport"));
        DKTreeNode1.setCustomIcon((Icon)ResourceManager.getIcon(ExtReportManageUI.class, (String)"tbtn_ext.gif"));
        DKTreeNode1.setUserObject((Object)"1");
        node.add((MutableTreeNode)DKTreeNode1);
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.tableFlag) {
            MessageUtil.showInfo("label332", true);
            return;
        }
        if (this.efm == null) {
            this.efm = new ExtReportFilterManager(this);
        }
        this.efm.filte(false);
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.closeWin();
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstIndex.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        if (lstIndex.size() != 1) {
            MessageUtil.showInfo("label12", true);
            return;
        }
        this.selectedTreeNode = this.getSystemID();
        for (int i = 0; i < lstIndex.size(); ++i) {
            int rowIndex = Integer.parseInt(String.valueOf(lstIndex.get(i)));
            Object obj = this.tableReport.getRow(rowIndex).getUserObject();
            this.lstSelected.add(obj);
        }
        this.isCanceled = false;
        this.closeWin();
    }

    public ReportProperties getLinkTargetReportProperties() {
        int len;
        ArrayList lstSelected = this.lstSelected;
        HashMap mapSelected = (HashMap)lstSelected.get(0);
        String fid = mapSelected.get("fid").toString();
        String fname = CtrlReportUtil.getObjectString(mapSelected.get("fname"));
        String systemID = CtrlReportUtil.getObjectString(mapSelected.get("fsystemid"));
        String systemName = RunReportParam.getSystemFullLabel(this.nodeRoot, systemID);
        String isstdproduct = CtrlReportUtil.getObjectString(mapSelected.get("fisstdproduct"));
        if (null == systemName) {
            systemName = systemID;
        }
        if ((len = systemName.indexOf("\\")) != -1) {
            systemName = systemName.substring(len + 1);
        }
        systemName = systemName + "\\" + fname;
        ReportProperties reportFullName = new ReportProperties(fid, fname, systemID);
        if (isstdproduct.equals("1")) {
            reportFullName.setDomain("qUvvbL4yQsyQYFIDSlvngID2+FI=");
            reportFullName.setStdProduct(true);
        } else {
            reportFullName.setDomain(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            reportFullName.setStdProduct(false);
        }
        reportFullName.setPathAlias(systemName);
        return reportFullName;
    }

    @Override
    protected void kDTree1_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.isStopChange) {
            this.isStopChange = false;
            return;
        }
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            PubAcctsDAO.PubAcct bvNode;
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)object;
            Object nodeObject = ((DefaultKingdeeTreeNode)selectedNode.getParent()).getUserObject();
            if (nodeObject instanceof PubAcctsDAO.PubAcct) {
                bvNode = (PubAcctsDAO.PubAcct)nodeObject;
                this.systemID = bvNode.fid;
            } else if (nodeObject instanceof IBriefViewTreeNode) {
                bvNode = (IBriefViewTreeNode)((DefaultKingdeeTreeNode)selectedNode.getParent()).getUserObject();
                this.systemID = bvNode.getFullName();
            }
            this.tableFlag = selectedNode.getUserObject().toString();
            ArrayList lst = DefineReportBO.getReportListBySystemID(this.systemID, this.uiFlag, false);
            this.fillData(lst);
        } else {
            this.systemID = "-1";
            this.tableReport.removeRows();
        }
    }

    @Override
    public void fillData(ArrayList lst) throws Exception {
        this.tableReport.removeRows();
        if (lst == null || lst.size() == 0) {
            return;
        }
        for (HashMap map : lst) {
            IRow irow = this.tableReport.addRow();
            String extreportLicenseType = String.valueOf(1);
            String fisstdproduct = CtrlReportUtil.getObjectString(map.get("fisstdproduct"));
            if (fisstdproduct.equals("1")) {
                irow.getStyleAttributes().setBackground(ColorConst.LIGHT_ORANGE);
            } else if (extreportLicenseType.equals(CtrlReportUtil.getObjectString(map.get("flicensestrategy")))) {
                irow.getStyleAttributes().setBackground(ColorConst.LIGHT_RED);
            }
            irow.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map.get("fname")));
            irow.setUserObject((Object)map);
        }
    }

    @Override
    protected void tableReport_tableClicked(KDTMouseEvent e) throws Exception {
        int row = this.tableReport.getSelectManager().getActiveRowIndex();
        if (row < 0) {
            return;
        }
        HashMap mapData = (HashMap)this.tableReport.getRow(row).getUserObject();
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.kDButtonOk_actionPerformed(null);
        } else {
            ArrayList blocks = this.tableReport.getSelectManager().getBlocks();
            if (!blocks.isEmpty()) {
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
                int top = block.getTop();
                int bottom = block.getBottom();
                if (bottom - top == 0) {
                    TreeManager ta = new TreeManager(this);
                    ta.expandExtTreeSelected(this.kDTree1, CtrlReportUtil.getObjectString(mapData.get("fsystemid")));
                }
            }
        }
    }

    protected KDTable getTableForCommon() {
        return this.tableReport;
    }

    protected void initHelper() {
        super.initHelper();
        this.tHelper.getDisabledTables().add(this.tableReport);
    }

    @Override
    public void showSelector() {
        this.initCtrl();
    }

    @Override
    public Component getComponentSelector() {
        return this;
    }

    @Override
    public Object getData() {
        int size = this.lstSelected.size();
        DefObj[] defs = new DefObj[this.lstSelected.size()];
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)this.lstSelected.get(i);
            DefObj def = new DefObj();
            def.setName(CtrlReportUtil.getObjectString(map.get("fid")));
            def.setAlias(CtrlReportUtil.getObjectString(map.get("fname")));
            def.setProperty("tableFlag", (Object)this.tableFlag);
            def.setProperty("systemID", (Object)CtrlReportUtil.getObjectString(map.get("fsystemid")));
            def.setProperty("orgID", (Object)CtrlReportUtil.getObjectString(map.get("forgid")));
            defs[i] = def;
        }
        if (this.objectUI instanceof ReportAttemperSetupUI) {
            ReportAttemperSetupUI ui = (ReportAttemperSetupUI)((Object)this.objectUI);
            ui.setScheduName(defs[0].getAlias());
        }
        return defs;
    }

    @Override
    public int getHeightSelector() {
        return this.getHeight();
    }

    @Override
    public int getWidthSelector() {
        return this.getWidth();
    }

    @Override
    public void initLayoutSelector() {
        this.initLayout();
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void onLoadSelector() throws Exception {
        this.onLoad();
    }

    @Override
    public void setParamMap(HashMap paramMap) {
    }

    @Override
    public KDToolBar getToolBarSelector() {
        return this.toolBar;
    }

    @Override
    public String getTableFlag() {
        return this.tableFlag;
    }

    @Override
    public String getSystemID() {
        return this.systemID;
    }

    @Override
    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    @Override
    public void setStopChange(boolean isStopChange) {
        this.isStopChange = isStopChange;
    }

    public String getUiFlag() {
        return this.uiFlag;
    }

    public void setUiFlag(String uiFlag) {
        this.uiFlag = uiFlag;
    }

    public void setSelectedTreeNode(String selectedTreeNode) {
        this.selectedTreeNode = selectedTreeNode;
    }

    public ArrayList getLstSelected() {
        return this.lstSelected;
    }

    public void setIsMobile(boolean isMobile) {
        this.isMobile = isMobile;
    }

    public boolean isMobile() {
        return this.isMobile;
    }
}

