/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.bo.SendMailBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractSendMailListUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.client.SendMailEditUI;
import com.kingdee.eas.rpts.ctrlreport.email.SendMailInfo;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class SendMailListUI
extends AbstractSendMailListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SendMailListUI.class);

    public SendMailListUI() throws Exception {
        this.tblMain.checkParsed();
        this.initLayout();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                SendMailListUI.this.tblMain_tableClicked(e);
            }
        });
    }

    public void onLoad() throws Exception {
        this.tblMain.getSelectManager().setSelectMode(10);
        this.setUITitle(String.valueOf(this.getUIContext().get("MainMenuName")));
        this.refresh();
    }

    private void refresh() throws BOSException, SQLException {
        this.tblMain.removeRows();
        ArrayList lst = SendMailBO.getSendMailListByCurUser(null, EASUtil.getCurrentUserID());
        for (HashMap map : lst) {
            IRow irow = this.tblMain.addRow();
            irow.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map.get("fmailaddress")));
            irow.getCell(1).setValue((Object)CtrlReportUtil.getObjectString(map.get("fmailhost")));
            irow.getCell(2).setValue((Object)CtrlReportUtil.getObjectString(map.get("fmailuser")));
            irow.setUserObject((Object)map);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            try {
                this.btnEdit_actionPerformed(null);
            }
            catch (Exception ex) {
                MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label17"), ex);
            }
        }
    }

    @Override
    protected void btnNew_actionPerformed(ActionEvent e) throws Exception {
        SendMailEditUI editUI = new SendMailEditUI(null);
        ReportDialog.showDialog((CoreUIObject)editUI, "\u65b0\u5efa\u5e10\u6237", true);
        if (editUI.isOk) {
            this.refresh();
        }
    }

    private SendMailInfo getSelectedObj() throws IOException {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.tblMain);
        if (lstIndex.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return null;
        }
        if (lstIndex.size() != 1) {
            MessageUtil.showInfo("label12", true);
            return null;
        }
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        HashMap mapData = (HashMap)this.tblMain.getRow(row).getUserObject();
        SendMailInfo info = new SendMailInfo();
        info.setId(CtrlReportUtil.getObjectString(mapData.get("fid")));
        info.setMailAddress(CtrlReportUtil.getObjectString(mapData.get("fmailaddress")));
        info.setMailHost(CtrlReportUtil.getObjectString(mapData.get("fmailhost")));
        info.setMailUser(CtrlReportUtil.getObjectString(mapData.get("fmailuser")));
        info.setCreatorId(CtrlReportUtil.getObjectString(mapData.get("fcreatorid")));
        info.setMailPassword(new String(new BASE64Decoder().decodeBuffer(CtrlReportUtil.getObjectString(mapData.get("fmailpassword")))));
        return info;
    }

    @Override
    protected void btnEdit_actionPerformed(ActionEvent e) throws Exception {
        SendMailInfo info = this.getSelectedObj();
        if (info == null) {
            return;
        }
        SendMailEditUI editUI = new SendMailEditUI(info);
        ReportDialog.showDialog((CoreUIObject)editUI, MessageUtil.getMsgInfo("label212") + info.getMailAddress(), true);
        if (editUI.isOk) {
            this.refresh();
        }
    }

    @Override
    protected void btnTestLink_actionPerformed(ActionEvent e) throws Exception {
        SendMailInfo info = this.getSelectedObj();
        if (info == null) {
            return;
        }
        SendMailBO.testLinkMail(null, info);
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tblMain);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        boolean confirm = MessageUtil.showConfirm(null, MessageUtil.getMsgInfo("label9"));
        if (!confirm) {
            return;
        }
        try {
            for (int i = 0; i < lstSelected.size(); ++i) {
                String strRowIndex = lstSelected.get(i).toString();
                HashMap mapInfo = (HashMap)this.tblMain.getRow(Integer.parseInt(strRowIndex)).getUserObject();
                SendMailInfo info = new SendMailInfo();
                info.setMailAddress(CtrlReportUtil.getObjectString(mapInfo.get("fmailaddress")));
                info.setId(CtrlReportUtil.getObjectString(mapInfo.get("fid")));
                SendMailBO.del(info);
            }
        }
        catch (Exception e1) {
            MessageUtil.showDetailAndOK(null, "\u5220\u9664\u5931\u8d25", e1);
        }
        MessageUtil.showInfo("\u5220\u9664\u6210\u529f", false);
        this.refresh();
        try {
            SendMailBO.refreshServerCache(null);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnPageSetup);
        this.toolBar.add((Component)this.btnNew);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnDel);
        this.toolBar.add((Component)this.btnTestLink);
        this.toolBar.add((Component)this.separator1);
    }
}

