/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.ext.immit.SavedSpan;
import com.kingdee.bos.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.bos.ctrl.ext.util.ShowcaseUtil;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jdom2.Element;

public class ShowcaseConstraintsPanel
extends KDPanel {
    private KDPanel constraintsPanel;
    private KDCheckBox editable;
    private KDCheckBox showFormula;
    private KDCheckBox rowCount;
    private KDCheckBox columnCount;
    private KDCheckBox hideEditable;
    private KDButtonGroup group;
    private KDRadioButton cellSelect;
    private KDRadioButton rowSelect;
    private ShowcaseConfig current;
    private SavedSpan[] rowSpan;
    private SavedSpan[] colSpan;
    private boolean isDesign;

    public ShowcaseConstraintsPanel(SavedSpan[] rowSpan, SavedSpan[] colSpan) {
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.initComponents();
    }

    private void initComponents() {
        this.editable = new KDCheckBox("\u7ed3\u679c\u53ef\u7f16\u8f91");
        this.showFormula = new KDCheckBox("\u663e\u793a\u516c\u5f0f");
        this.hideEditable = new KDCheckBox("\u9690\u85cf\u7684\u884c,\u5217\u53ef\u62d6\u52a8");
        this.rowCount = new KDCheckBox("\u4e0d\u663e\u793a\u884c\u53f7");
        this.rowCount.setBounds(50, 140, 100, 20);
        this.columnCount = new KDCheckBox("\u4e0d\u663e\u793a\u5217\u6807");
        this.columnCount.setBounds(50, 100, 100, 20);
        GridLayout layout = new GridLayout(2, 1);
        KDPanel panel = new KDPanel((LayoutManager)layout);
        KDPanel select = new KDPanel((LayoutManager)layout);
        this.rowSelect = new KDRadioButton("\u9009\u4e2d\u884c");
        this.rowSelect.setBounds(20, 60, 100, 20);
        this.cellSelect = new KDRadioButton("\u9009\u4e2d\u5355\u5143\u683c");
        this.cellSelect.setBounds(20, 30, 100, 20);
        panel.setBorder((Border)BorderFactory.createTitledBorder("\u6d4f\u89c8\u6a21\u5f0f"));
        panel.add((Component)this.cellSelect);
        panel.add((Component)this.rowSelect);
        this.group = new KDButtonGroup();
        this.group.add((AbstractButton)this.cellSelect);
        this.group.add((AbstractButton)this.rowSelect);
        this.constraintsPanel = new KDPanel((LayoutManager)layout);
        select.add((Component)this.rowCount);
        select.add((Component)this.columnCount);
        this.constraintsPanel.add((Component)select);
        this.constraintsPanel.add((Component)panel);
        this.constraintsPanel.setPreferredSize(new Dimension(400, 300));
        this.add((Component)this.constraintsPanel);
        if (this.current != null) {
            this.rowCount.setSelected(this.current.isRowCountVisible());
            this.columnCount.setSelected(this.current.isColCountVisible());
            this.group.setValue(this.current.isCellSelect() ? 0 : 1);
        } else {
            this.group.setValue(0);
        }
        this.constraintsPanel.setBorder((Border)BorderFactory.createTitledBorder("\u663e\u793a\u65b9\u6848\u8be6\u7ec6\u8bbe\u7f6e"));
        this.add((Component)this.constraintsPanel);
    }

    public String getUserSettings(boolean withHeight) {
        if (!withHeight) {
            if (this.current == null) {
                this.current = new ShowcaseConfig();
            }
            this.updateConfig(this.current);
            return ShowcaseUtil.toShowcaseConfig((Element)this.current.toElement());
        }
        return this.getUserSettings2();
    }

    private String getUserSettings2() {
        if (this.current != null) {
            boolean[] user = this.fetchUserSettings();
            this.current.setRowCountVisible(user[2]);
            this.current.setColCountVisible(user[3]);
            this.current.setCellSelect(user[5]);
        }
        if (this.current == null) {
            this.current = new ShowcaseConfig();
        }
        return ShowcaseUtil.toShowcaseConfig((Element)this.current.toElement());
    }

    public void setUserSettings(String showcaseConfig) {
        if (this.current == null) {
            this.current = ShowcaseUtil.toShowcaseConfig((String)showcaseConfig, (ShowcaseConfig)new ShowcaseConfig());
        } else if (!this.isDesign) {
            this.current = ShowcaseUtil.toShowcaseConfig((String)showcaseConfig, (ShowcaseConfig)new ShowcaseConfig());
        }
        this.setCheckBoxbySelection(this.current);
    }

    public boolean isDesign() {
        return this.isDesign;
    }

    public void setDesign(boolean isDesign) {
        this.isDesign = isDesign;
    }

    private void updateConfig(ShowcaseConfig config) {
        if (config != null) {
            boolean[] user = this.fetchUserSettings();
            config.setRowCountVisible(user[2]);
            config.setColCountVisible(user[3]);
            config.setCellSelect(user[5]);
            config.setRowSpans((Object[])this.rowSpan);
            config.setColSpans((Object[])this.colSpan);
        }
    }

    private boolean[] fetchUserSettings() {
        boolean editable = this.editable.isSelected();
        boolean showFormula = this.showFormula.isSelected();
        boolean rowCount = this.rowCount.isSelected();
        boolean columnCount = this.columnCount.isSelected();
        boolean hideEditable = this.hideEditable.isSelected();
        boolean cell = this.group.getValue() == 0;
        return new boolean[]{editable, showFormula, rowCount, columnCount, hideEditable, cell};
    }

    private void setCheckBoxbySelection(ShowcaseConfig config) {
        if (config != null) {
            this.editable.setSelected(config.isEditable());
            this.showFormula.setSelected(config.isShowFormula());
            this.hideEditable.setSelected(config.isHideEditable());
            this.rowCount.setSelected(config.isRowCountVisible());
            this.columnCount.setSelected(config.isColCountVisible());
            if (config.isCellSelect()) {
                this.group.setValue(0);
            } else {
                this.group.setValue(1);
            }
        }
    }
}

