/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.bo.MainMenuItemBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractStdImportUI;
import com.kingdee.eas.rpts.ctrlreport.client.ChoosedExtZipTreeUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MultiLangUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ExportSQLUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class StdImportUI
extends AbstractStdImportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(StdImportUI.class);
    public static final int COL_REPORT_NAME = 0;
    public static final int COL_DEPLOY_PATH = 1;
    public static final int COL_MENU_NAME = 2;
    private boolean isinitLayout = false;
    private boolean isCancel = true;
    KDBizMultiLangBox mlbMenu;
    DefaultKingdeeTreeNode nodeRoot;
    String fileAbsolutePath;

    public StdImportUI() throws Exception {
        this.initLayout();
        this.tableReport.checkParsed();
    }

    public void onLoad() throws Exception {
        this.txtMessage.setSelectAllOnFocus(false);
        this.initTable();
        this.setCreateEnable(false);
    }

    private void initTable() {
        this.tableReport.getColumn(0).getStyleAttributes().setLocked(true);
        this.tableReport.getColumn(0).getStyleAttributes().setFontColor(Color.GRAY);
        this.mlbMenu = new KDBizMultiLangBox();
        this.tableReport.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.mlbMenu));
        this.mlbMenu.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
    }

    private void setCreateEnable(boolean isEnable) {
        this.btnOk.setEnabled(isEnable);
        this.txtMessage.selectAll();
        Rectangle rect = this.txtMessage.getBounds();
        rect.setLocation(rect.x, rect.height);
        this.kDScrollPane1.getViewport().scrollRectToVisible(rect);
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    @Override
    protected void btnSelected_actionPerformed(ActionEvent e) throws Exception {
        try {
            ChoosedExtZipTreeUI ui = new ChoosedExtZipTreeUI();
            ReportDialog.showDialog((CoreUIObject)ui, "\u9009\u62e9\u6807\u51c6\u4ea7\u54c1\u5305", true, false);
            if (!ui.isCanceled()) {
                this.tableReport.removeRows();
                Map map = ui.getMapSelect();
                this.fileAbsolutePath = map.get("path").toString();
                int star = this.fileAbsolutePath.indexOf("extzip");
                String name = this.fileAbsolutePath.substring(star + 7);
                this.filePath.setText(name);
                this.setReportList();
                this.setCreateEnable(true);
            }
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, "\u6a21\u677f\u9519\u8bef", ex);
        }
    }

    private void setReportList() throws Exception {
        if (null == this.nodeRoot) {
            this.nodeRoot = CommonTreeModel.getPackageTreeModel(null);
        }
        ArrayList paramList = new ArrayList();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("path", this.fileAbsolutePath);
        paramList.add(paramMap);
        RptParams paramReturn = CtrlReportUtil.requestServiceMethod("com.kingdee.eas.rpts.ctrlsqldesign.model.ZipProvider", "unZipStdProduct", paramList);
        HashMap mapStd = (HashMap)paramReturn.getObject("object");
        ArrayList lstReadme = (ArrayList)mapStd.get("lstReadme");
        ArrayList lstReport = (ArrayList)mapStd.get("lstReport");
        for (HashMap mapEntry : lstReport) {
            int len;
            String name = CtrlReportUtil.getObjectString(mapEntry.get("name"));
            String systemID = CtrlReportUtil.getObjectString(mapEntry.get("systemID"));
            String deployPath = CtrlReportUtil.getObjectString(mapEntry.get("deployPath"));
            String fpath = RunReportParam.getSystemFullLabel(this.nodeRoot, systemID);
            if (null == fpath) {
                fpath = systemID;
            }
            if ((len = fpath.indexOf("\\")) != -1) {
                fpath = fpath.substring(len + 1);
            }
            IRow irow = this.tableReport.addRow();
            irow.setUserObject(null);
            irow.getCell(0).setValue((Object)(fpath + "\\" + name));
            irow.getCell(1).setValue((Object)MainMenuItemBO.getDeployName(deployPath));
            MultiLangUtil.setMultiLangItemListToCell(irow.getCell(2), name, this.mlbMenu);
        }
    }

    public static void setTxtMsg(KDScrollPane kDScrollPane1, KDTextArea txtMessage, String msg) {
        txtMessage.append(msg);
        txtMessage.setCaretPosition(txtMessage.getText().length());
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        this.tableReport.getEditManager().stopEditing();
        int length = this.tableReport.getRowCount();
        if (length <= 0) {
            MessageUtil.showInfo("label403", true);
            return;
        }
        this.txtMessage.setText("");
        StdImportUI.setTxtMsg(this.kDScrollPane1, this.txtMessage, "\u6b63\u5728\u6821\u9a8c\uff0c\u8bf7\u7a0d\u5019......\r\n");
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ExportSQLUI ui = new ExportSQLUI();
                    ui.btnImportStd(StdImportUI.this.fileAbsolutePath, StdImportUI.this.tableReport, StdImportUI.this.kDScrollPane1, StdImportUI.this.txtMessage);
                    MainMenuItemBO.refreshMenuCache();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    StringWriter sw = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(sw);
                    ex.printStackTrace(printWriter);
                    StdImportUI.setTxtMsg(StdImportUI.this.kDScrollPane1, StdImportUI.this.txtMessage, "\u5931\u8d25\uff1a\r\n" + sw.toString() + "\r\n");
                }
                finally {
                    StdImportUI.this.btnOk.setEnabled(true);
                    StdImportUI.this.btnCancel.setEnabled(true);
                }
            }
        });
        t.start();
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

