/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.ext.util.EncryptSpreadService;
import com.kingdee.bos.ctrl.ext.util.VerifyUserService;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.kds.KdsToBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.bo.ExtReportProductBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractStdMakeUI;
import com.kingdee.eas.rpts.ctrlreport.client.DeployEasSelector;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialogSelector;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class StdMakeUI
extends AbstractStdMakeUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(StdMakeUI.class);
    private static final int COL_REPORT_NAME = 0;
    private static final int COL_DEPLOY_PATH = 1;
    private boolean isinitLayout = false;
    private boolean isCancel = true;
    KDBizPromptBox easMenu;
    String selectFielPath;
    DefaultKingdeeTreeNode nodeRoot;
    String uri;
    DefObj defCopy;

    public StdMakeUI() throws Exception {
        this.initLayout();
        this.tableReport.checkParsed();
    }

    public void onLoad() throws Exception {
        this.txtMessage.setText("\u751f\u6210\u64cd\u4f5c\u524d\u8bf7\u786e\u4fdd\u6a21\u677f\u6587\u4ef6\u5df2\u653e\u5230root\u76ee\u5f55\u4e0b\r\n");
        this.txtMessage.setSelectAllOnFocus(false);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String curDate = sdf.format(new Date());
        String fileName = "STD" + curDate;
        this.extzipName.setText(fileName);
        this.initTable();
        this.setCreateEnable(false);
        this.txtIP.setSelectedIndex(0);
    }

    private void initTable() throws Exception {
        this.tableReport.getColumn(0).getStyleAttributes().setLocked(true);
        this.tableReport.getColumn(0).getStyleAttributes().setFontColor(Color.GRAY);
        this.easMenu = new KDBizPromptBox();
        this.easMenu.setSelector((KDPromptSelector)ReportDialogSelector.showDialog(new DeployEasSelector(), MessageUtil.getMsgInfo("label27"), true, false));
        this.easMenu.setEditable(false);
        KDTDefaultCellEditor ceEditor = new KDTDefaultCellEditor((IKDEditor)this.easMenu);
        this.tableReport.getColumn(1).setEditor((ICellEditor)ceEditor);
    }

    private void setCreateEnable(boolean isEnable) {
        this.btnOk.setEnabled(isEnable);
        this.txtMessage.selectAll();
        Rectangle rect = this.txtMessage.getBounds();
        rect.setLocation(rect.x, rect.height);
        this.kDScrollPane1.getViewport().scrollRectToVisible(rect);
    }

    private void setTxtMsg(String msg) {
        this.txtMessage.append(msg);
        this.txtMessage.setCaretPosition(this.txtMessage.getText().length());
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    @Override
    protected void btnVerify_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = false;
        boolean flagUser = false;
        try {
            String strIP = CtrlReportUtil.getObjectString(this.txtIP.getSelectedItem());
            this.uri = "http://" + strIP + ":" + this.txtPort.getText().trim() + "/encrypt/EncryptServlet";
            VerifyUserService.setServerUri((String)this.uri);
            flag = VerifyUserService.verifyUser((String)strIP, (String)this.txtPort.getText().trim());
            flagUser = ExtReportProductBO.verifyUser(this.userAccount.getText().trim(), new String(this.userPassword.getPassword()));
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, "\u7b7e\u5230\u5931\u8d25", ex);
            return;
        }
        if (flag && flagUser) {
            MessageUtil.showInfo("\u7b7e\u5230\u6210\u529f\uff0c\u670d\u52a1\u5668\u6b63\u5e38\uff01", false);
            this.txtIP.setEnabled(false);
            this.txtPort.setEnabled(false);
            this.btnVerify.setEnabled(false);
            this.btnSelected.setEnabled(true);
            this.btnCopy.setEnabled(true);
            this.btnPaste.setEnabled(true);
            this.extzipName.setEnabled(true);
            this.popedomFullname.setEnabled(true);
            this.txtMessage.setEnabled(true);
        } else if (!flag) {
            MessageUtil.showInfo("\u7b7e\u5230\u5931\u8d25\uff01", false);
        } else if (!flagUser) {
            MessageUtil.showInfo("\u7b7e\u5230\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01", false);
        }
    }

    @Override
    protected void btnCopy_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u590d\u5236\u53d1\u5e03\u8def\u5f84\u7684\u62a5\u8868", false);
            return;
        }
        if (lstSelected.size() > 1) {
            MessageUtil.showInfo("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", false);
            return;
        }
        this.defCopy = (DefObj)this.tableReport.getRow(Integer.parseInt(lstSelected.get(0).toString())).getCell(1).getValue();
        if (null == this.defCopy) {
            MessageUtil.showInfo("\u53d1\u5e03\u8def\u5f84\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u590d\u5236", false);
            return;
        }
    }

    @Override
    protected void btnPaste_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.defCopy) {
            MessageUtil.showInfo("\u8bf7\u5148\u590d\u5236\u53d1\u5e03\u8def\u5f84", false);
            return;
        }
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("\u8bf7\u9009\u62e9\u9700\u8981\u7c98\u8d34\u53d1\u5e03\u8def\u5f84\u7684\u62a5\u8868", false);
            return;
        }
        for (int i = 0; i < lstSelected.size(); ++i) {
            String strRowIndex = lstSelected.get(i).toString();
            IRow irow = this.tableReport.getRow(Integer.parseInt(strRowIndex));
            irow.getCell(1).setValue((Object)this.defCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void btnSelected_actionPerformed(ActionEvent e) throws Exception {
        block9: {
            try {
                FileInputStream in;
                block10: {
                    KDFileChooser chooser = new KDFileChooser(this.filePath.getText());
                    chooser.setDialogType(1);
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle("\u9009\u62e9\u6a21\u677f\u76ee\u5f55");
                    chooser.setApproveButtonText("\u786e\u5b9a");
                    FileFilter[] ff = chooser.getChoosableFileFilters();
                    for (int i = 0; i < ff.length; ++i) {
                        chooser.removeChoosableFileFilter(ff[i]);
                    }
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return "\u6240\u6709\u6587\u4ef6";
                        }
                    });
                    int r = chooser.showSaveDialog((Component)((Object)this));
                    if (r != 0) break block9;
                    this.tableReport.removeRows();
                    this.selectFielPath = chooser.getSelectedFile().getAbsolutePath().trim();
                    this.filePath.setText(this.selectFielPath);
                    if (this.selectFielPath.equals("")) {
                        return;
                    }
                    String rootPath = this.selectFielPath + File.separator + "root";
                    boolean existFlag = FileUtil.isExist((String)rootPath);
                    if (!existFlag) {
                        this.txtMessage.append("\u63d0\u793a\uff1a\u76ee\u5f55\u9519\u8bef\uff0c\u9009\u62e9\u7684\u76ee\u5f55\u5fc5\u987b\u6709root\u5b50\u76ee\u5f55\uff01\r\n");
                        this.setCreateEnable(false);
                        return;
                    }
                    String readmeFile = this.selectFielPath + File.separator + "readme.txt";
                    existFlag = FileUtil.isExist((String)readmeFile);
                    if (!existFlag) {
                        this.txtMessage.setText("\u63d0\u793a\uff1a\u76ee\u5f55\u9519\u8bef\uff0c\u9009\u62e9\u7684\u76ee\u5f55\u5fc5\u987b\u5b58\u5728readme.txt\u6587\u4ef6\u4e14\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01\r\n");
                        this.setCreateEnable(false);
                    }
                    in = null;
                    try {
                        in = new FileInputStream(readmeFile);
                        byte[] bom = new byte[3];
                        in.read(bom);
                        String md = StdMakeUI.byteToHexString(bom[0]) + StdMakeUI.byteToHexString(bom[1]) + StdMakeUI.byteToHexString(bom[2]);
                        if (md.toUpperCase(Locale.ENGLISH).equals("EFBBBF")) break block10;
                        this.txtMessage.setText("\u63d0\u793a\uff1a readme.txt\u6587\u4ef6\u683c\u5f0f\u9519\u8bef, \u4e0d\u662fUTF-8\u683c\u5f0f\uff0c\u8bf7\u7528\u8bb0\u4e8b\u672c\u91cd\u65b0\u4ee5UTF-8\u683c\u5f0f\u6765\u4fdd\u5b58\uff01\r\n");
                        this.setCreateEnable(false);
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    return;
                }
                CloseUtil.close((Closeable[])new Closeable[]{in});
                this.setCreateEnable(true);
                File file = new File(this.selectFielPath);
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    if (!f.getName().equals("root")) continue;
                    this.setReportList(f);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                StringWriter sw = new StringWriter();
                PrintWriter printWriter = new PrintWriter(sw);
                ex.printStackTrace(printWriter);
                this.txtMessage.setText("\u63d0\u793a\uff1a\u9009\u62e9\u76ee\u5f55\u9519\u8bef\r\n" + sw.toString() + "\r\n");
                this.btnOk.setEnabled(false);
            }
        }
    }

    private void setBtnEnable(boolean flag) {
        this.btnSelected.setEnabled(flag);
        this.btnCopy.setEnabled(flag);
        this.btnPaste.setEnabled(flag);
        this.btnOk.setEnabled(flag);
        this.btnCancel.setEnabled(flag);
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        this.txtMessage.setText("");
        this.tableReport.getEditManager().stopEditing();
        final int length = this.tableReport.getRowCount();
        final String strPopedomFullname = this.popedomFullname.getText().trim();
        final String userAccount = this.userAccount.getText().trim();
        final String easUser = SysContext.getSysContext().getCurrentUserInfo().getNumber();
        final String userIP = SysContext.getSysContext().getClientIP();
        final String sessionID = String.valueOf(CtrlReportUtil.getSystemTime());
        this.setBtnEnable(false);
        EncryptSpreadService.setServerUri((String)this.uri);
        this.setTxtMsg("\u6b63\u5728\u5236\u4f5c\uff0c\u8bf7\u7a0d\u5019......\r\n");
        for (int i = 0; i < length; ++i) {
            IRow row = this.tableReport.getRow(i);
            DefObj def = (DefObj)row.getCell(1).getValue();
            if (def != null) continue;
            this.setTxtMsg("\u53d1\u5e03\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\r\n");
            this.tableReport.getEditManager().editCellAt(i, 1);
            this.setBtnEnable(true);
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean isSuccess = true;
                for (int i = 0; i < length; ++i) {
                    IRow row = StdMakeUI.this.tableReport.getRow(i);
                    HashMap map = (HashMap)row.getUserObject();
                    String filePath = CtrlReportUtil.getObjectString(map.get("filePath"));
                    String reportfullName = row.getCell(0).getValue().toString();
                    DefObj def = (DefObj)row.getCell(1).getValue();
                    String longNumber = (String)def.getProperty("number");
                    String alias = def.getAlias();
                    if (longNumber.startsWith("/")) {
                        longNumber = longNumber.substring(1);
                    }
                    longNumber = ExtStringUtil.replace(longNumber, "/", "!");
                    longNumber = "/" + longNumber;
                    String deployPath = longNumber + "@@" + alias;
                    try {
                        File fileSource = new File(filePath);
                        String descFileString = null;
                        String extensionName = FileUtil.getExtension((File)fileSource);
                        if (!extensionName.equalsIgnoreCase("kds")) continue;
                        String fileName = fileSource.getName();
                        String fileNameLower = fileName.toLowerCase(Locale.ENGLISH);
                        if (!fileNameLower.startsWith("std_")) {
                            String stdFileName = "std_" + ExtStringUtil.replace(fileName, ".kds", "") + ".kdszip";
                            descFileString = ExtStringUtil.replace(filePath, fileName, stdFileName);
                        } else {
                            descFileString = ExtStringUtil.replace(filePath, ".kds", ".kdszip");
                        }
                        StdMakeUI.this.setTxtMsg("\u6b63\u5728\u52a0\u5bc6\uff1a" + reportfullName);
                        KdsToBook ktb = new KdsToBook();
                        Book bookSource = ktb.load(filePath);
                        bookSource.setReleaseDirector(deployPath);
                        bookSource.setUserObject("$MenuUiClassName$", (Object)strPopedomFullname);
                        byte[] classBytes = BookIOUtil.pack((Book)bookSource);
                        byte[] data = EncryptSpreadService.encrypt((byte[])classBytes);
                        FileUtil.writeFile((String)descFileString, (byte[])data);
                        StdMakeUI.this.setTxtMsg("\uff0c \u52a0\u5bc6\u5b8c\u6210\uff01\r\n");
                        try {
                            ExtReportProductBO.insert(userAccount, descFileString, easUser, userIP, sessionID);
                        }
                        catch (Exception exx) {
                            logger.error((Object)exx);
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        isSuccess = false;
                        logger.error((Object)ex);
                        StringWriter sw = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(sw);
                        ex.printStackTrace(printWriter);
                        StdMakeUI.this.setTxtMsg("\u63d0\u793a\uff1a\u51fa\u73b0\u9519\u8bef\r\n" + sw.toString() + "\r\n");
                        StdMakeUI.this.setBtnEnable(true);
                        break;
                    }
                }
                if (isSuccess) {
                    StdMakeUI.this.setBtnEnable(true);
                    try {
                        String descFileZipName = CtrlReportUtil.getObjectString(StdMakeUI.this.extzipName.getText());
                        if (descFileZipName.equals("")) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            String curDate = sdf.format(new Date());
                            descFileZipName = "\u6807\u51c6\u4ea7\u54c1\u62a5\u8868" + curDate;
                        }
                        if (!descFileZipName.toLowerCase(Locale.ENGLISH).endsWith(".extzip")) {
                            descFileZipName = descFileZipName + ".extzip";
                        }
                        String zipNew = StdMakeUI.this.filePath.getText().trim() + File.separator + descFileZipName;
                        StdMakeUI.zip(StdMakeUI.this.filePath.getText().trim(), zipNew, true);
                        StdMakeUI.this.setTxtMsg("\u63d0\u793a\uff1a\u6210\u529f\uff0c\u6a21\u677f\u5df2\u6253\u5305\u751f\u6210\u5230\u201c" + zipNew + "\u201c\r\n");
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                        StringWriter sw = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(sw);
                        ex.printStackTrace(printWriter);
                        StdMakeUI.this.setTxtMsg("\u63d0\u793a\uff1a\u6253\u5305\u51fa\u73b0\u9519\u8bef\r\n" + sw.toString() + "\r\n");
                        StdMakeUI.this.setBtnEnable(true);
                    }
                }
                File file = new File(StdMakeUI.this.selectFielPath);
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    if (!f.getName().equals("root")) continue;
                    StdMakeUI.this.deleteKdszip(f);
                }
            }
        });
        t.start();
    }

    private void setReportList(File file) throws Exception {
        if (null == this.nodeRoot) {
            this.nodeRoot = CommonTreeModel.getPackageTreeModel(null);
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int len;
            File f = files[i];
            if (f.isDirectory()) {
                this.setReportList(f);
                continue;
            }
            String extensionName = FileUtil.getExtension((File)f);
            if (!extensionName.equalsIgnoreCase("kds")) {
                throw new Exception("\u53d1\u73b0\u975e\u6cd5\u6587\u4ef6\uff1a" + f.getAbsolutePath());
            }
            String filePath = f.getAbsolutePath();
            String systemPathName = ExtStringUtil.replaceFirst(filePath, this.selectFielPath, "");
            String name = systemPathName.toLowerCase();
            int n = name.lastIndexOf("\\");
            if (n == -1) continue;
            String systemID = systemPathName.substring(0, n);
            systemID = ExtStringUtil.replace(systemID, "\\root\\", "com.kingdee.eas.");
            String fpath = RunReportParam.getSystemFullLabel(this.nodeRoot, systemID = ExtStringUtil.replace(systemID, "\\", "."));
            if (null == fpath) {
                fpath = systemID;
            }
            if ((len = fpath.indexOf("\\")) != -1) {
                fpath = fpath.substring(len + 1);
            }
            String reportName = systemPathName.substring(n + 1);
            reportName = extensionName.equalsIgnoreCase("kdszip") ? ExtStringUtil.replace(reportName, ".kdszip", "") : ExtStringUtil.replace(reportName, ".kds", "");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", reportName);
            map.put("systemid", systemID);
            map.put("filePath", filePath);
            IRow irow = this.tableReport.addRow();
            irow.setUserObject(map);
            irow.getCell(0).setValue((Object)(fpath + "\\" + reportName));
        }
    }

    private void deleteKdszip(File file) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                this.deleteKdszip(f);
                continue;
            }
            String extensionName = FileUtil.getExtension((File)f);
            if (!extensionName.equalsIgnoreCase("kdszip")) continue;
            FileUtil.deleteFile((File)f);
        }
    }

    private static String byteToHexString(byte b) {
        String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String sourceFilePath, String zipFilePath, boolean onlyContent) throws IOException {
        FileOutputStream fout = null;
        ZipOutputStream zipOutput = null;
        try {
            File file = new File(sourceFilePath);
            fout = new FileOutputStream(zipFilePath);
            zipOutput = new ZipOutputStream(fout);
            File[] files = new File[]{file};
            if (onlyContent) {
                files = file.listFiles();
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i].getName();
                    if (!fileName.equals("root") && !fileName.equals("readme.txt")) continue;
                    StdMakeUI.zip(fileName, files[i], zipOutput);
                }
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{zipOutput, fout});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{zipOutput, fout});
    }

    private static void zip(String name_string, File file, ZipOutputStream zipOutput) throws IOException {
        ZipEntry entry = new ZipEntry(name_string + (file.isDirectory() ? "/" : ""));
        if (file.isFile()) {
            String exten = FileUtil.getExtension((File)file);
            if (exten.equalsIgnoreCase("kdszip") || file.getName().equalsIgnoreCase("readme.txt")) {
                zipOutput.putNextEntry(entry);
                FileInputStream fin = new FileInputStream(file);
                byte[] data = CtrlUtil.Stream.readInputStream((InputStream)fin);
                ((InputStream)fin).close();
                zipOutput.write(data, 0, data.length);
                zipOutput.closeEntry();
            }
        } else {
            zipOutput.putNextEntry(entry);
            zipOutput.closeEntry();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    StdMakeUI.zip(name_string + "/" + files[i].getName(), files[i], zipOutput);
                }
            }
        }
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

