/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.datasetfactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.eas.rpts.ctrlreport.CommonCacheClear;
import com.kingdee.eas.rpts.ctrlreport.ICommonCacheClear;
import com.kingdee.util.StringUtils;

public class CommonCacheDataFactory {
    public static ICommonCacheClear getCommonCache() throws BOSException {
        ICommonCacheClear commonCacheClear = null;
        RPCServerView sv = RPCServerView.getLast();
        if (null == sv) {
            String rpcURL = ORMRPCServiceLocator.getCurrentServiceURL();
            commonCacheClear = CommonCacheDataFactory.createService(rpcURL);
            return commonCacheClear;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            IRPCServer s = ss[i];
            if (s.connectionFailed()) continue;
            String url = s.getUrl();
            commonCacheClear = StringUtils.isEmpty((String)url) || CommonCacheDataFactory.isLocal(url) ? new CommonCacheClear() : CommonCacheDataFactory.createService(url);
        }
        return commonCacheClear;
    }

    private static ICommonCacheClear createService(String rpcURL) throws BOSException {
        try {
            return (ICommonCacheClear)RPCEngine.createRemoteObject((String)rpcURL, (String)"com.kingdee.eas.rpts.ctrlreport.CommonCacheClear", ICommonCacheClear.class);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }
}

