/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.innerlink;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.immit.ExtHyperLinkAssembler;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.eas.rpts.ctrlreport.innerlink.InnerLinkException;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.ExtReportImpl;
import com.kingdee.eas.rpts.web.man.MobileReportImpl;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.model.LinkModel;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.util.EmbedObjectHelper;
import com.kingdee.eas.rpts.web.util.ReportBookHelper;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractInnerLinkWebExec {
    protected static Logger logger = LogUtil.getPackageLogger(AbstractInnerLinkWebExec.class);
    protected Book _book;
    protected Context _ctx;
    protected String _pageId;

    public AbstractInnerLinkWebExec(Book book, String pageId, Context ctx) {
        this._pageId = pageId;
        this._book = book;
        this._ctx = ctx;
    }

    public abstract LinkModel execute() throws InnerLinkException;

    protected Object execute(String targetType, String linkName, Map<String, IParameter> params) throws InnerLinkException {
        if ("fusionChart".equals(targetType)) {
            return this.executeChart(this._book, linkName, params);
        }
        return this.executeSubReport(this._book, linkName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeChart(Book book, String linkName, Map<String, IParameter> params) throws InnerLinkException {
        ChartRectEmbedment chart = ExtHyperLinkAssembler.getChartEmbedmentByName((Book)book, (String)linkName);
        if (chart != null) {
            FlashChartModel model = chart.getModel();
            model.getDataNode().setDirty(true);
            ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
            Map oldParams = ctx.getDataSetParameters();
            ctx.setDataSetParameters(params);
            String datasetName = chart.getModel().getDataNode().getFromDataset().getDatasetName();
            ExtDataSet dataset = book.getDataSetManager().getDataSetByName(datasetName);
            ArrayList allUnionParam = new ArrayList();
            try {
                RunReportParam.cacheDbSourceModel(this._ctx, new ExtDataSet[]{dataset}, allUnionParam, null);
            }
            catch (CtrlReportException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ReportBookHelper.executeParamsDefaultValue(this._ctx, params, allUnionParam, null);
            try {
                if (chart instanceof EChart) {
                    String string = Base64.encodeBytes((byte[])((EChart)chart).getLastExecutedScript().getBytes(StandardCharsets.UTF_8));
                    return string;
                }
                String string = EmbedObjectHelper.reBuildLinkProp(model.getXml(), chart.getName());
                return string;
            }
            finally {
                ctx.setDataSetParameters(oldParams);
            }
        }
        throw new InnerLinkException("\u672a\u627e\u5230\u8981\u8054\u52a8\u7684\u56fe\u8868[" + linkName + "]\uff01");
    }

    protected Object executeSubReport(Book book, String linkName, Map<String, IParameter> params) throws InnerLinkException {
        Cell cell;
        EmbedObject eObject;
        String[] arrName = linkName.split("!");
        if (arrName == null || arrName.length != 2) {
            return null;
        }
        String sheetName = arrName[0];
        Sheet sheet = book.getSheet(sheetName);
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer == null || layer.size() == 0) {
            return null;
        }
        SubReportEmbed rptEmbed = null;
        EmbedhLayer.EmbedIterator iter = layer.getIterator(true);
        while (!(!iter.hasNext() || (eObject = iter.next()) instanceof SubReportEmbed && (cell = (rptEmbed = (SubReportEmbed)eObject).getCell()).getName(false, true).equals(linkName))) {
        }
        if (rptEmbed != null) {
            byte[] bookData = rptEmbed.getSubReportInfo().getBookData();
            HashMap<String, IParameter> mapDesignParam = new HashMap<String, IParameter>();
            SubReportInfo subReportInfo = rptEmbed.getSubReportInfo();
            ReportProperties rptProps = subReportInfo.getReportProps();
            if (params != null) {
                ReportBookHelper.executeParamsDefaultValue(this._ctx, params, null, rptProps);
                mapDesignParam.putAll(params);
            }
            String systemId = rptProps.getPath();
            String name = rptProps.getName();
            String orgId = rptProps.getDomain();
            String rptId = rptProps.getId();
            RunReportParam.putServerDefalutListParamsMap(this._ctx, mapDesignParam);
            WebParamAdapter adapter = new WebParamAdapter(this._ctx, name, systemId, orgId, rptId);
            adapter.setLicenseChecked(true);
            Book subBook = null;
            try {
                subBook = adapter.executeSubReport(mapDesignParam, bookData);
            }
            catch (Exception e1) {
                logger.error((Object)"\u8054\u52a8\u5b50\u62a5\u8868\u5931\u8d25!", (Throwable)e1);
                throw new InnerLinkException("\u8054\u52a8\u5b50\u62a5\u8868\u5931\u8d25!", e1);
            }
            subReportInfo.setBook(subBook);
            ReportImpl subReportImpl = null;
            if (this._pageId != null) {
                ReportPage subPage = (ReportPage)PageManager.getPage((String)EmbedObjectHelper.reNameSubReportId(this._pageId, linkName));
                if (subPage == null) {
                    throw new InnerLinkException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
                }
                ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)subPage).getExtReport();
                subReportImpl = extReportImpl.getReport();
            } else {
                subReportImpl = MobileReportImpl.createTemplateImpl(this._ctx, rptId);
            }
            subReportImpl.setBook(subBook);
            subReportImpl.setCurrentSheetName(subBook.getSheet(0).getSheetName());
            BeanFactory.makeupReportModelBhv().behaviour(subReportImpl);
            ReportInfo reportInfo = BeanFactory.outputReportBhv().behaviour(subReportImpl);
            return reportInfo;
        }
        throw new InnerLinkException("\u672a\u627e\u5230\u8981\u8054\u52a8\u7684\u5b50\u62a5\u8868[" + linkName + "]\uff01");
    }

    protected final void buildErrorMsg(LinkModel linkModel, List<String> linkErrorNames) {
        if (!linkErrorNames.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer("\u4ee5\u4e0b\u5bf9\u8c61\u8054\u52a8\u5931\u8d25\uff1a[");
            for (String errorName : linkErrorNames) {
                errorMessage.append(errorName).append("]\u3001[");
            }
            linkModel.setErrorMessage(errorMessage.substring(0, errorMessage.length() - 2));
        }
    }
}

