/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.exec;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.FunctionMacroDataExecutor;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.SQLMacroDataExecutor;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.IExtRptMacro;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ext.MacroParameterImpl;
import com.kingdee.eas.rpts.ctrlreport.util.ExtRptContentChecker;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.industry.InnerParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.statistics.dynamic.DefaultExtStatisticsRunner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class ExtRptMacroExecuteFacade {
    private static Logger logger = CommonLogger.getLogger(ExtRptMacroExecuteFacade.class);

    public static MacroValue localExecute(Context easCtx, Map<String, MacroVO> innerMacroDefineMap, String macroName) throws MacroRuntimeException {
        IExtRptMacroController controller;
        try {
            controller = ExtRptMacroControllerFacade.getLocalInst(easCtx);
        }
        catch (BOSException e) {
            throw MacroRuntimeException.newStubFetchException(e);
        }
        MacroVO mVO = null;
        if (innerMacroDefineMap != null && innerMacroDefineMap != null && innerMacroDefineMap.containsKey(macroName.toUpperCase())) {
            IExtRptMacro macro = innerMacroDefineMap.get(macroName.toUpperCase()).getMacro();
            mVO = ExtRptMacroFactory.emptyMacro(macro.mType()).setVType(macro.vType()).setName(macro.name()).setDefine(macro.define());
        }
        if (mVO == null) {
            mVO = controller.r(macroName.toUpperCase());
        }
        if (mVO == null) {
            throw MacroRuntimeException.newNonExisitMacroException();
        }
        return ExtRptMacroExecuteFacade.localExecute(easCtx, innerMacroDefineMap, mVO);
    }

    public static MacroValue localExecute(Context easCtx, Map<String, MacroVO> innerMacroDefineMap, MacroVO mVO) throws MacroRuntimeException {
        try {
            return ExtRptMacroExecuteFacade.executeImpl(easCtx, ExtRptMacroControllerFacade.getLocalInst(easCtx), mVO);
        }
        catch (BOSException e) {
            throw MacroRuntimeException.newStubFetchException(e);
        }
    }

    public static MacroValue remoteExecute(Map<String, MacroVO> innerMacroDefineMap, String macroName) throws MacroRuntimeException {
        IExtRptMacroController controller;
        try {
            controller = ExtRptMacroControllerFacade.getRemoteInst();
        }
        catch (BOSException e) {
            throw MacroRuntimeException.newStubFetchException(e);
        }
        MacroVO mVO = null;
        if (innerMacroDefineMap != null && innerMacroDefineMap != null && innerMacroDefineMap.containsKey(macroName.toUpperCase())) {
            IExtRptMacro macro = innerMacroDefineMap.get(macroName.toUpperCase()).getMacro();
            mVO = ExtRptMacroFactory.emptyMacro(macro.mType()).setVType(macro.vType()).setName(macro.name()).setDefine(macro.define());
        }
        if (mVO == null) {
            mVO = controller.r(macroName.toUpperCase());
        }
        if (mVO == null) {
            throw MacroRuntimeException.newNonExisitMacroException();
        }
        return ExtRptMacroExecuteFacade.remoteExecute(innerMacroDefineMap, mVO);
    }

    public static MacroValue remoteExecute(Map<String, MacroVO> innerMacroDefineMap, MacroVO mVO) throws MacroRuntimeException {
        try {
            return ExtRptMacroExecuteFacade.executeImpl(null, ExtRptMacroControllerFacade.getRemoteInst(), mVO);
        }
        catch (BOSException e) {
            throw MacroRuntimeException.newStubFetchException(e);
        }
    }

    private static MacroValue executeImpl(Context easCtx, IExtRptMacroController controller, MacroVO mVO) throws MacroRuntimeException {
        MacroValue value;
        IExtRptMacro m = mVO.getMacro();
        switch (m.mType()) {
            case FUNCTION: {
                value = new FunctionMacroDataExecutor().execute(easCtx, m);
                break;
            }
            case SQL: {
                value = new SQLMacroDataExecutor().execute(easCtx, m);
                break;
            }
            default: {
                throw MacroRuntimeException.newUnkownMacroTypeException();
            }
        }
        ExtRptMacroType.VType vt = m.vType();
        if (vt != null) {
            switch (vt) {
                case MULTIPLE: {
                    break;
                }
                case SINGLE: {
                    Variant[][] values = new Variant[1][];
                    if (value.getValues() == null || value.getValues().length <= 0) break;
                    values[0] = value.getValues()[0];
                    value = new MacroValue(value.getColums(), values);
                    break;
                }
                default: {
                    throw MacroRuntimeException.newUnkownValueTypeException();
                }
            }
        }
        return value;
    }

    public static IParameter translate(DesignParameter param) {
        String value = param.getCurentValue();
        int dataType = param.getDesignDataType().intValue();
        ParameterImpl p = new ParameterImpl();
        p.setName(param.getName());
        p.setAlias(param.getAlias());
        p.setValue(RunReportParam.getVariant(value, dataType));
        p.setDataType(dataType);
        return p;
    }

    public static String evaluateMacro(Map<String, MacroVO> innerMacroDefineMap, String value) {
        return ExtRptMacroExecuteFacade.evaluateMacro(null, innerMacroDefineMap, value);
    }

    public static String evaluateMacro(Context easCtx, Map<String, MacroVO> innerMacroDefineMap, String value) {
        TreeSet<String> names = new TreeSet<String>();
        ExtRptContentChecker.analysisParamMacroUsage(names, value);
        if (!names.isEmpty()) {
            for (String macroName : names) {
                try {
                    MacroValue mv = easCtx == null ? ExtRptMacroExecuteFacade.remoteExecute(innerMacroDefineMap, macroName) : ExtRptMacroExecuteFacade.localExecute(easCtx, innerMacroDefineMap, value);
                    StringBuilder replacement = new StringBuilder(mv.getValues()[0][0].toString());
                    for (int i = 1; i < mv.getValues().length; ++i) {
                        replacement.append("0xx1xx");
                        replacement.append(mv.getValues()[i][0]);
                    }
                    while (value.indexOf("$" + macroName) > -1) {
                        value = value.replace("$" + macroName, replacement.toString().trim());
                    }
                }
                catch (MacroRuntimeException e) {
                    logger.error((Object)e);
                }
            }
        }
        return value;
    }

    public static HashMap<String, IParameter> fetchMacroParameters(Context easCtx, Book template) {
        return ExtRptMacroExecuteFacade.fetchMacroParameters(easCtx, template, new HashMap());
    }

    public static HashMap<String, IParameter> fetchMacroParameters(Context easCtx, Book template, HashMap mapDesignParams) {
        HashMap<String, IParameter> mapParameterImpl = new HashMap<String, IParameter>();
        try {
            IExtRptMacro[] list;
            HashSet<String> names = new HashSet<String>();
            ExtRptContentChecker.analysisMacroUsage(easCtx, names, mapDesignParams, template);
            if (!names.isEmpty() && (list = easCtx == null ? ExtRptMacroControllerFacade.getRemoteInst().l(names) : ExtRptMacroControllerFacade.getLocalInst(easCtx).l(names)) != null) {
                for (IExtRptMacro macro : list) {
                    MacroParameterImpl p = new MacroParameterImpl(easCtx, template.getDataSetManager().getExecutionContext());
                    String name = macro.name();
                    p.setName(name);
                    p.setAlias(name);
                    p.setDataType(0);
                    mapParameterImpl.put(name + "_temp_macro_param_suffix", (IParameter)p);
                }
            }
            for (Map.Entry<String, MacroVO> entry : DefaultExtStatisticsRunner.loadUsedMacros(template).entrySet()) {
                MacroParameterImpl p = new MacroParameterImpl(easCtx, template.getDataSetManager().getExecutionContext());
                p.setName(entry.getKey());
                p.setAlias(entry.getKey());
                p.setDataType(0);
                mapParameterImpl.put(entry.getKey() + "_temp_macro_param_suffix", (IParameter)p);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (MacroRuntimeException e) {
            logger.error((Object)e);
        }
        return mapParameterImpl;
    }

    static HashMap<String, IParameter> translate(HashMap<String, DesignParameter> sysParams) {
        HashMap<String, IParameter> params = new HashMap<String, IParameter>();
        for (Map.Entry<String, DesignParameter> entry : sysParams.entrySet()) {
            params.put(entry.getKey(), ExtRptMacroExecuteFacade.translate(entry.getValue()));
        }
        return params;
    }

    static HashMap<String, DesignParameter> loadSysParams(Context easCtx) {
        HashMap<String, DesignParameter> mapDesignParam = new HashMap<String, DesignParameter>();
        if (easCtx == null) {
            InnerParam.putClientDefalutListParamsMap(mapDesignParam);
        } else {
            RunReportParam.putServerDefalutListParamsMap(easCtx, mapDesignParam);
        }
        return mapDesignParam;
    }
}

