/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.IExtRptMacro;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class ExtRptMacroControllerBean
implements IExtRptMacroController {
    private Context easCtx;
    private static final int BinaryMaxLength = 1024;

    public ExtRptMacroControllerBean() {
        this.easCtx = ContextUtils.getContextFromSession();
    }

    public ExtRptMacroControllerBean(Context easCtx) {
        this.easCtx = easCtx;
    }

    public Context getContext() {
        return this.easCtx;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public BOSObjectType getType() {
        return new BOSObjectType("326B333E");
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }

    @Override
    public void c(MacroVO macro) throws MacroDesignException {
        byte[] description;
        byte[] define;
        StringBuilder insertSQL = new StringBuilder("INSERT INTO T_EXT_MACRO");
        insertSQL.append("(FID,FCREATOR,FCREATETIME,FLASTUPDATER,FLASTUPDATETIME,FMACRONAME,FMACROMT,FMACROVT)");
        insertSQL.append("VALUES(?,?,?,?,?,?,?,?)");
        ArrayList<Object> params = new ArrayList<Object>();
        Timestamp ts = new Timestamp(new Date().getTime());
        String userId = this.easCtx.getCaller().toString();
        String uuid = Uuid.randomUUID().toString();
        params.add(uuid);
        params.add(userId);
        params.add(ts);
        params.add(userId);
        params.add(ts);
        IExtRptMacro m = macro.getMacro();
        params.add(m.name().toUpperCase());
        params.add(m.mType().name());
        params.add(m.vType().name());
        try {
            define = m.define().getBytes("UTF-8");
            description = macro.getDescription().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw MacroDesignException.newFailed2CreateMacroException(e);
        }
        try {
            this.insertContent(define, uuid, ContentType.MacroDefine);
            this.insertContent(description, uuid, ContentType.MacroDescription);
            DbUtil.execute((Context)this.easCtx, (String)insertSQL.toString(), (Object[])params.toArray());
        }
        catch (BOSException e) {
            throw MacroDesignException.newFailed2CreateMacroException(e);
        }
    }

    @Override
    public void d(String[] mIdList) throws MacroDesignException {
        StringBuilder deleteSQL = new StringBuilder("DELETE T_EXT_MACRO");
        deleteSQL.append(" WHERE FID=?");
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < mIdList.length; ++i) {
            params.add(mIdList[i]);
            if (i == mIdList.length - 1) continue;
            deleteSQL.append(" OR FID=?");
        }
        try {
            DbUtil.execute((Context)this.easCtx, (String)deleteSQL.toString(), (Object[])params.toArray());
        }
        catch (BOSException e) {
            throw MacroDesignException.newFailed2DeleteMacroException(e);
        }
    }

    @Override
    public MacroVO[] l() throws MacroDesignException {
        StringBuilder selectSQL = new StringBuilder("SELECT ");
        selectSQL.append("M.FID,M.FCREATETIME,M.FLASTUPDATETIME,");
        selectSQL.append("M.FMACRONAME,M.FMACROMT,M.FMACROVT,");
        selectSQL.append("U2.FNAME_L2 AS FLASTUPDATER,U.FNAME_L2 AS FCREATOR ");
        selectSQL.append(" FROM T_EXT_MACRO M");
        selectSQL.append(" LEFT OUTER JOIN T_PM_USER U ON M.FCREATOR=U.FID");
        selectSQL.append(" LEFT OUTER JOIN T_PM_USER U2 ON M.FLASTUPDATER=U2.FID");
        selectSQL.append(" ORDER BY M.FLASTUPDATETIME DESC");
        ArrayList<MacroVO> mList = new ArrayList<MacroVO>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)selectSQL.toString());
            while (rs.next()) {
                mList.add(this.fillOne(rs));
            }
            return mList.toArray(new MacroVO[0]);
        }
        catch (BOSException e) {
            throw MacroDesignException.newFailed2QueryMacroException(e);
        }
        catch (SQLException e) {
            throw MacroDesignException.newFailed2QueryMacroException(e);
        }
        catch (IOException e) {
            throw MacroDesignException.newFailed2QueryMacroException(e);
        }
    }

    @Override
    public IExtRptMacro[] l(Set<String> names) throws MacroRuntimeException {
        if (names == null || names.isEmpty()) {
            return new IExtRptMacro[0];
        }
        StringBuilder selectSQL = new StringBuilder("SELECT ");
        selectSQL.append("M.FID,M.FMACRONAME,M.FMACROMT,M.FMACROVT");
        selectSQL.append(" FROM T_EXT_MACRO M WHERE M.FMACRONAME IN (?");
        for (int i = 1; i < names.size(); ++i) {
            selectSQL.append(",?");
        }
        selectSQL.append(")");
        ArrayList<IExtRptMacro> list = new ArrayList<IExtRptMacro>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)selectSQL.toString(), (Object[])names.toArray());
            while (rs.next()) {
                String uuid = rs.getString("FID");
                list.add(ExtRptMacroFactory.emptyMacro(ExtRptMacroType.MType.valueOf(rs.getString("FMACROMT"))).setName(rs.getString("FMACRONAME")).setVType(ExtRptMacroType.VType.valueOf(rs.getString("FMACROVT"))).setDefine(new String(this.findContent(uuid, ContentType.MacroDefine), "UTF-8")).getMacro());
            }
        }
        catch (BOSException e) {
            throw MacroRuntimeException.newRuntimeFailed2QueryMacroException(e);
        }
        catch (SQLException e) {
            throw MacroRuntimeException.newRuntimeFailed2QueryMacroException(e);
        }
        catch (IOException e) {
            throw MacroRuntimeException.newRuntimeFailed2QueryMacroException(e);
        }
        return list.toArray(new IExtRptMacro[0]);
    }

    @Override
    public boolean e(String name, String uuid) throws MacroDesignException {
        StringBuilder selectSQL = new StringBuilder("SELECT FID FROM T_EXT_MACRO WHERE FMACRONAME=?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)selectSQL.toString(), (Object[])new Object[]{name.toUpperCase()});
            return rs.next() && !StringUtil.equals((String)uuid, (String)rs.getString("FID"));
        }
        catch (BOSException e) {
            throw MacroDesignException.newFailed2QueryMacroException(e);
        }
        catch (SQLException e) {
            throw MacroDesignException.newFailed2QueryMacroException(e);
        }
    }

    @Override
    public MacroVO r(String name) throws MacroRuntimeException {
        StringBuilder selectSQL = new StringBuilder("SELECT ");
        selectSQL.append("FID,FCREATOR,FCREATETIME,FLASTUPDATER,FLASTUPDATETIME,FMACRONAME,FMACROMT,FMACROVT ");
        selectSQL.append(" FROM T_EXT_MACRO WHERE FMACRONAME=?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)selectSQL.toString(), (Object[])new Object[]{name});
            if (rs.next()) {
                return this.fillOne(rs);
            }
            throw MacroRuntimeException.newAccessNonExistMacroException();
        }
        catch (BOSException e) {
            throw MacroRuntimeException.newRuntimeFailed2QueryMacroException(e);
        }
        catch (SQLException e) {
            throw MacroRuntimeException.newRuntimeFailed2QueryMacroException(e);
        }
        catch (IOException e) {
            throw MacroRuntimeException.newRuntimeFailed2QueryMacroException(e);
        }
    }

    @Override
    public void u(MacroVO macro) throws MacroDesignException {
        byte[] description;
        byte[] define;
        StringBuilder updateSQL = new StringBuilder("UPDATE T_EXT_MACRO SET ");
        updateSQL.append("FLASTUPDATER=?,FLASTUPDATETIME=?,FMACROVT=?,FMACRONAME=? WHERE FID=?");
        IExtRptMacro m = macro.getMacro();
        String uuid = macro.getUuid();
        String name = m.name();
        if (uuid == null) {
            IRowSet rs;
            try {
                rs = DbUtil.executeQuery((Context)this.easCtx, (String)"SELECT FID FROM T_EXT_MACRO WHERE FMACRONAME=?", (Object[])new Object[]{name});
            }
            catch (BOSException e) {
                throw MacroDesignException.newFailed2UpdateMacroException(e);
            }
            try {
                if (!rs.next()) {
                    throw MacroDesignException.newFailed2UpdateMacroException(new RuntimeException("uuid is null and can not find by macro name"));
                }
                uuid = rs.getString("FID");
            }
            catch (SQLException e) {
                throw MacroDesignException.newFailed2UpdateMacroException(e);
            }
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.easCtx.getCaller().toString());
        params.add(new Timestamp(new Date().getTime()));
        params.add(m.vType().name());
        params.add(name);
        params.add(uuid);
        try {
            define = m.define().getBytes("UTF-8");
            description = macro.getDescription().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw MacroDesignException.newFailed2UpdateMacroException(e);
        }
        try {
            this.updateContent(define, uuid, ContentType.MacroDefine);
            this.updateContent(description, uuid, ContentType.MacroDescription);
            DbUtil.execute((Context)this.easCtx, (String)updateSQL.toString(), (Object[])params.toArray());
        }
        catch (BOSException e) {
            throw MacroDesignException.newFailed2UpdateMacroException(e);
        }
    }

    private void insertContent(byte[] datas, String uuid, ContentType ct) throws BOSException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        int index = 0;
        for (byte[] split : this.split(datas)) {
            paramsList.add(new Object[]{Uuid.randomUUID().toString(), uuid, ct.name(), index++, split});
        }
        DbUtil.executeBatch((Context)this.easCtx, (String)"INSERT INTO T_EXT_MACRO_CONTENT(FID,FMACROID,FTYPE,FINDEX,FCONTENT) VALUES(?,?,?,?,?)", paramsList);
    }

    private void updateContent(byte[] datas, String uuid, ContentType ct) throws BOSException {
        DbUtil.execute((Context)this.easCtx, (String)"DELETE T_EXT_MACRO_CONTENT WHERE FMACROID=? AND FTYPE=?", (Object[])new Object[]{uuid, ct.name()});
        this.insertContent(datas, uuid, ct);
    }

    private byte[][] split(byte[] datas) {
        int size = (1024 - datas.length % 1024 + datas.length) / 1024;
        byte[][] split = new byte[size][];
        for (int i = 0; i < size; ++i) {
            int len = datas.length - (i + 1) * 1024;
            len = len < 0 ? datas.length - i * 1024 : 1024;
            split[i] = new byte[len];
            System.arraycopy(datas, i * 1024, split[i], 0, len);
        }
        return split;
    }

    private MacroVO fillOne(IRowSet rs) throws BOSException, SQLException, IOException {
        String uuid = rs.getString("FID");
        return ExtRptMacroFactory.emptyMacro(ExtRptMacroType.MType.valueOf(rs.getString("FMACROMT"))).setUuid(uuid).setCreator(rs.getString("FCREATOR")).setCreateTime(rs.getTimestamp("FCREATETIME")).setLastUpdater(rs.getString("FLASTUPDATER")).setLastUpdateTime(rs.getTimestamp("FLASTUPDATETIME")).setDescription(new String(this.findContent(uuid, ContentType.MacroDescription), "UTF-8")).setName(rs.getString("FMACRONAME")).setVType(ExtRptMacroType.VType.valueOf(rs.getString("FMACROVT"))).setDefine(new String(this.findContent(uuid, ContentType.MacroDefine), "UTF-8"));
    }

    private byte[] findContent(String uuid, ContentType ct) throws BOSException, SQLException, IOException {
        IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)"SELECT FCONTENT FROM T_EXT_MACRO_CONTENT WHERE FMACROID=? AND FTYPE=? ORDER BY FINDEX ASC", (Object[])new Object[]{uuid, ct.name()});
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (rs.next()) {
            try {
                Blob blob = rs.getBlob("FCONTENT");
                if (blob == null) continue;
                buffer.write(this.readBlob(blob));
            }
            catch (SQLException e) {
                return rs.getBytes("FCONTENT");
            }
        }
        return buffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBlob(Blob blob) throws SQLException, IOException {
        byte[] byArray;
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            byte[] buffer = new byte[1024];
            int len = in.read(buffer);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while (len > 0) {
                bout.write(buffer, 0, len);
                len = in.read(buffer);
            }
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return byArray;
    }

    private static enum ContentType {
        MacroDefine,
        MacroDescription;

    }
}

