/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.designer;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.LimitedLengthDocument;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class PropertiesContentPanel {
    private static Pattern namePattern = Pattern.compile("^[a-zA-Z]{1}[a-zA-Z0-9_]{1,255}");
    private static Logger logger = CommonLogger.getLogger(PropertiesContentPanel.class);
    private KDPanel contentPane;
    private KDTextField nameField;
    private KDTextArea description;
    private KDComboBox comboBox;
    private MacroVO macroVO;
    private IExtRptMacroController controller;

    public PropertiesContentPanel(MacroVO macroVO, IExtRptMacroController controller) {
        this.macroVO = macroVO;
        this.controller = controller;
        this.buildContentPane();
    }

    public boolean verify() {
        String name = this.nameField.getText();
        boolean isOk = !StringUtil.isEmptyString((String)name);
        StringBuilder sb = new StringBuilder();
        sb.append(Resources.getResourceString("1.\u5b8f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
        sb.append("\n");
        sb.append(Resources.getResourceString("2.\u5b8f\u540d\u6700\u591a\u53ef\u4e3a255\u4e2a\u5b57\u7b26\u6700\u5c11\u4e3a2\u4e2a\u5b57\u7b26\uff0c\u5e76\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u59cb\uff0c\u5176\u4e2d\u53ef\u7528\u7684\u5b57\u7b26\u5305\u62ec\uff1a\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002"));
        sb.append("\n");
        sb.append(Resources.getResourceString("3.\u5b8f\u540d\u4e0d\u80fd\u8ddf\u62a5\u8868\u5355\u5143\u683c\u540d\u79f0\u51b2\u7a81(\u5217\uff1aA~CRXP\uff1b\u884c\uff1a1~1048576)\u3002"));
        if (!isOk) {
            MessageUtil.msgboxInfo(null, (String)sb.toString());
        } else {
            isOk = namePattern.matcher(name).matches();
            if (!isOk) {
                MessageUtil.msgboxInfo(null, (String)sb.toString());
            } else {
                Book book = Book.Manager.getNewBook();
                try {
                    Range.validateName((String)("$" + name), (Book)book, (Sheet)book.getSheet(0));
                    isOk = true;
                }
                catch (SyntaxErrorException e1) {
                    isOk = false;
                }
                if (!isOk) {
                    MessageUtil.msgboxInfo(null, (String)sb.toString());
                } else {
                    try {
                        isOk = !this.controller.e(name, this.macroVO.getUuid());
                    }
                    catch (MacroDesignException e) {
                        logger.error((Object)e);
                        MessageUtil.msgboxWarning((Component)this.contentPane, (String)Resources.getResourceString("\u67e5\u8be2\u5b8f\u5b9a\u4e49\u540d\u79f0\u5931\u8d25\u3002"), (String)e.getMessage());
                        return false;
                    }
                    if (!isOk) {
                        MessageUtil.msgboxInfo(null, (String)Resources.getResourceString("\u5b8f\u540d\u79f0\u5df2\u5b58\u5728"));
                    }
                }
            }
        }
        if (isOk) {
            this.macroVO.setName(name);
            this.macroVO.setDescription(this.description.getText());
            this.macroVO.setVType(this.comboBox.getSelectedIndex() == 0 ? ExtRptMacroType.VType.SINGLE : ExtRptMacroType.VType.MULTIPLE);
        }
        return isOk;
    }

    public KDPanel getContentPanel() {
        return this.contentPane;
    }

    private void buildContentPane() {
        this.contentPane = new KDPanel();
        this.contentPane.setLayout(null);
        this.nameField = new KDTextField((Document)new LimitedLengthDocument(){
            private static final long serialVersionUID = 1L;

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offs, str.toUpperCase(), a);
            }
        }, this.macroVO.getMacro().name(), 0);
        this.nameField.setRequired(true);
        this.comboBox = new KDComboBox((Object[])new String[]{Resources.getResourceString("\u5355\u503c"), Resources.getResourceString("\u591a\u503c")});
        this.comboBox.setSelectedIndex(ExtRptMacroType.VType.SINGLE.equals((Object)this.macroVO.getMacro().vType()) ? 0 : 1);
        this.comboBox.setRequired(true);
        this.description = new KDTextArea();
        this.description.setText(this.macroVO.getDescription());
        KDLabelContainer c = new KDLabelContainer(Resources.getResourceString("\u540d\u79f0"), (JComponent)this.nameField);
        c.setBoundLabelUnderline(true);
        c.setBoundLabelLength(100);
        c.setBounds(10, 10, 380, 20);
        this.contentPane.add((Component)c);
        c = new KDLabelContainer(Resources.getResourceString("\u7c7b\u578b"), (JComponent)this.comboBox);
        c.setBoundLabelUnderline(true);
        c.setBoundLabelLength(100);
        c.setBounds(10, 40, 380, 20);
        this.contentPane.add((Component)c);
        c = new KDLabelContainer(Resources.getResourceString("\u63cf\u8ff0"));
        c.setBoundLabelUnderline(true);
        c.setBoundLabelLength(100);
        c.setBounds(10, 70, 120, 60);
        this.contentPane.add((Component)c);
        KDScrollPane s = new KDScrollPane((Component)this.description);
        s.setBounds(108, 70, 284, 62);
        this.contentPane.add((Component)s);
        this.contentPane.setPreferredSize(new Dimension(400, 140));
    }
}

