/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.designer;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.AbstractMacroDesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutDBUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.SqlUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import org.jdom2.Element;

class SQLMacroDesignUI
extends AbstractMacroDesignUI {
    private static final long serialVersionUID = 1L;
    private CtrlDesignQueryModel model;
    private SqlUI sqlUI;

    SQLMacroDesignUI(MacroVO mVO, IExtRptMacroController controller) throws MacroDesignException {
        super(mVO, controller);
    }

    private void prepareModel() throws MacroDesignException {
        this.model = new CtrlDesignQueryModel();
        this.model.setObjectSelector(new KsqlObjectSelector());
        this.model.setQuery((IQuery)new CtrlDesignKsqlQuery(true));
        if (this.mVO.getUuid() != null) {
            try {
                CtrlDesignUtil.toObject(null, this.model, XmlUtil.loadXmlStream((InputStream)new ByteArrayInputStream(this.mVO.getMacro().define().getBytes("UTF-8"))));
            }
            catch (Exception e) {
                throw MacroDesignException.newFailed2LoadMacroModelException(e);
            }
        }
    }

    @Override
    protected void initUI() throws MacroDesignException {
        this.prepareModel();
        KDTabbedPane tab = new KDTabbedPane();
        this.sqlUI = SqlUI.getNewInstance(this.model);
        this.sqlUI.syncModel2Ui();
        this.sqlUI.config4MacroUI();
        KDPanel panel = new KDPanel((LayoutManager)new BorderLayout());
        panel.add((Component)new KDLabel("   "), (Object)"East");
        panel.add((Component)new KDLabel("   "), (Object)"West");
        panel.add((Component)this.sqlUI.getPanel());
        tab.addTab(Resources.getResourceString("\u67e5\u8be2"), (Component)panel);
        try {
            OutDBUI outDBUI = new OutDBUI(this.model);
            outDBUI.refreshTable();
            outDBUI.config4MacroUI();
            panel = new KDPanel((LayoutManager)new BorderLayout());
            panel.add((Component)new KDLabel("   "), (Object)"East");
            panel.add((Component)new KDLabel("   "), (Object)"West");
            panel.add((Component)new KDLabel("   "), (Object)"South");
            panel.add((Component)((Object)outDBUI));
            tab.addTab(Resources.getResourceString("\u5916\u90e8\u6570\u636e\u5e93"), (Component)panel);
        }
        catch (Exception e) {
            throw MacroDesignException.newFailed2InitOutDBUIException(e);
        }
        tab.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.add((Component)tab);
    }

    @Override
    protected void beforeSaveAction() throws MacroDesignException {
        this.sqlUI.syncUi2Model();
        try {
            this.mVO.setDefine(new String(XmlUtil.saveXmlBytes((Element)CtrlDesignUtil.toXml(this.model.getCommonQuery(), this.model.getQuery())), "UTF-8"));
        }
        catch (IOException e) {
            throw MacroDesignException.newFailed2TranslateMacroContentException(e);
        }
    }
}

