/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.mutex;

import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.util.Date;
import java.util.HashMap;

public class MacroMutexLockService {
    private static IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
    private static HashMap<String, Uuid> cache = new HashMap();

    public static boolean requestLock(String macroName, CoreUI coreUI) {
        SysContext sysCtx = SysContext.getSysContext();
        String dcName = sysCtx.getDcName();
        MutexParameter mutexParameter = new MutexParameter();
        String actionName = Resources.getResourceString("\u7f16\u8f91\u6269\u5c55\u62a5\u8868\u5b8f") + ":" + macroName;
        mutexParameter.setActionName(actionName);
        mutexParameter.setDcName(dcName);
        mutexParameter.setCreateTime(new Date());
        mutexParameter.setDescription(actionName);
        mutexParameter.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mutexParameter.setMutexName(actionName);
        mutexParameter.setOrgUnitID(sysCtx.getCurrentOrgUnit().getId());
        Uuid requestId = Uuid.create();
        mutexParameter.setRequestId(requestId);
        mutexParameter.setUserID(sysCtx.getCurrentUserInfo().getId());
        if (!mutexServiceControl.requestMutex(mutexParameter)) {
            if (coreUI != null) {
                coreUI.handUIException((Throwable)new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request"))));
            }
            return false;
        }
        cache.put(macroName, requestId);
        return true;
    }

    public static void releaseLock(String macroName) {
        if (cache.containsKey(macroName)) {
            mutexServiceControl.releaseMutex(cache.get(macroName));
        }
    }
}

