/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.client;

import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractChoosedTreePanel;
import com.kingdee.eas.rpts.ctrlreport.client.ExtMobileReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.client.InputDialog;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.mobile.client.PubAcctMapPanel;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.model.MobileReportInfo;
import com.kingdee.eas.rpts.ctrlreport.mobile.model.MobileType;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.sumreport.util.BaseUuid;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DeployMobileSelector
extends AbstractChoosedTreePanel {
    protected static final Logger logger = CoreUIObject.getLogger(DeployMobileSelector.class);
    private KDWorkButton mapSubjectBtn;
    private ImageIcon acctNodeIcon = ResourceManager.getImageIcon((String)"tree_acct.png");
    private boolean isMobileAppManage = false;
    private DeployMobileSelector deployMobileSelector;
    private boolean isSubjectNodeDirty;

    public DeployMobileSelector() throws Exception {
        this.deployMobileSelector = this;
    }

    public DeployMobileSelector(boolean mobileAppManage) throws Exception {
        this.isMobileAppManage = mobileAppManage;
        this.deployMobileSelector = this;
    }

    @Override
    public Object getData() {
        if (this.isCanceled) {
            return null;
        }
        DefaultKingdeeTreeNode selectNode = this.getSelectedTreeNode();
        if (selectNode == null) {
            return null;
        }
        Object userObject = selectNode.getUserObject();
        if (userObject == null || !(userObject instanceof MobileType)) {
            return null;
        }
        MobileType type = (MobileType)userObject;
        String path = "";
        TreeNode[] nodes = selectNode.getPath();
        for (int i = 1; i < nodes.length; ++i) {
            path = path + "/" + ((DefaultKingdeeTreeNode)nodes[i]).getText();
        }
        DefObj def = new DefObj();
        def.setName(type.getId());
        def.setAlias(path);
        def.setProperty("pubacctid", (Object)type.getPubAcctId());
        return def;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.toolBar.setBounds(0, 0, 300, 30);
        this.add((Component)this.toolBar);
        this.treeView.setBounds(new Rectangle(6, 35, 282, 349));
    }

    @Override
    public void onLoadSelector() throws Exception {
        this.mapSubjectBtn = new KDWorkButton("\u6620\u5c04");
        this.mapSubjectBtn.setToolTipText("\u4e91\u4e4b\u5bb6\u516c\u5171\u53f7\u6620\u5c04");
        this.mapSubjectBtn.setIcon(EASResource.getIcon((String)"imgTbtn_syncpurview"));
        this.toolBar.add((Component)this.mapSubjectBtn);
        this.treeView.getControlPane().removeAll();
        this.appendTreeOpbtn();
        this.treeMain.setRootVisible(false);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.getSelectionModel().setSelectionMode(1);
    }

    protected void initListener() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeployMobileSelector.this.isCanceled = true;
                DeployMobileSelector.this.isOk = false;
            }
        });
        this.tl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getSource() != null && !DeployMobileSelector.this.treeMain.isSelectionEmpty()) {
                    DefaultKingdeeTreeNode node = DeployMobileSelector.this.getSelectedTreeNode();
                    Object userObject = node.getUserObject();
                    if (userObject instanceof PubAcctsDAO.PubAcct) {
                        PubAcctsDAO.PubAcct temp = (PubAcctsDAO.PubAcct)userObject;
                        if ("718ea531-103a-467a-9cf5-7e07410373a5".equals(temp.fid)) {
                            DeployMobileSelector.this.setTreeBtnstate(false, false, false, DeployMobileSelector.this.isMobileAppManage, false, false);
                        } else {
                            DeployMobileSelector.this.setTreeBtnstate(true, true, true, DeployMobileSelector.this.isMobileAppManage, false, false);
                        }
                    } else if (node == DeployMobileSelector.this.getRootNode() || userObject instanceof MobileReportInfo) {
                        DeployMobileSelector.this.setTreeBtnstate(false, false, false, DeployMobileSelector.this.isMobileAppManage, true, true);
                    } else {
                        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
                        Object parentUserObject = parentNode.getUserObject();
                        if (parentUserObject instanceof PubAcctsDAO.PubAcct) {
                            PubAcctsDAO.PubAcct temp = (PubAcctsDAO.PubAcct)parentUserObject;
                            if ("718ea531-103a-467a-9cf5-7e07410373a5".equals(temp.fid)) {
                                DeployMobileSelector.this.setTreeBtnstate(false, false, false, true, true, true);
                            } else {
                                DeployMobileSelector.this.setTreeBtnstate(false, true, true, true, true, true);
                            }
                        } else {
                            DeployMobileSelector.this.setTreeBtnstate(false, true, true, true, true, true);
                        }
                    }
                } else {
                    DeployMobileSelector.this.setTreeBtnstate(false, false, false, DeployMobileSelector.this.isMobileAppManage, false, false);
                }
            }
        };
        this.treeMain.addTreeSelectionListener(this.tl);
        this.mapSubjectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployMobileSelector.this.beforeActionPerformed(e);
                try {
                    DeployMobileSelector.this.mapSubjectBtn_actionPerformed(e);
                }
                catch (Exception exc) {
                    DeployMobileSelector.this.handUIException(exc);
                }
                finally {
                    DeployMobileSelector.this.afterActionPerformed(e);
                }
            }
        });
    }

    @Override
    protected void appendTreeOpbtn() {
        this.appendTreeNodeSubject();
        super.appendTreeOpbtn();
        this.appendTreeNodeMoveBtn();
        this.addFolderBtn.setToolTipText("\u65b0\u5efa\u76ee\u5f55");
        this.updateFolderBtn.setToolTipText("\u4fee\u6539");
        this.delFolderBtn.setToolTipText("\u5220\u9664");
        this.upFolderBtn.setToolTipText("\u4e0a\u79fb\u76ee\u5f55");
        this.downFolderBtn.setToolTipText("\u4e0b\u79fb\u76ee\u5f55");
    }

    @Override
    protected void initTree() {
        DefaultKingdeeTreeNode rptNode;
        ArrayList<PubAcctsDAO.PubAcct> pubAcctList;
        RptParams params = new RptParams();
        params.setString("MethodName", "getMobileReportInfoList");
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.mobile.server.MobileTypeDAO");
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (Exception e) {
            String errInfo = "\u83b7\u53d6\u79fb\u52a8\u7c7b\u578b\u5931\u8d25\uff01";
            logger.error((Object)errInfo, (Throwable)e);
            Dialog parent = (Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this));
            MessageUtil.showDetailAndOK(parent, errInfo, e);
            this.treeView.setVisible(false);
            this.setVisible(false);
            return;
        }
        ArrayList typeList = (ArrayList)params.getObject("mobile_type_list");
        ArrayList rptInfoList = (ArrayList)params.getObject("mobile_rpt_list");
        try {
            pubAcctList = PubAcctsDAO.listPubAccts(null);
        }
        catch (ExtRptBizException e) {
            String errInfo = "\u83b7\u53d6\u79fb\u52a8\u62a5\u8868\u516c\u4f17\u53f7\u5931\u8d25\uff01";
            logger.error((Object)errInfo, (Throwable)e);
            Dialog parent = (Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this));
            MessageUtil.showDetailAndOK(parent, errInfo, e);
            this.treeView.setVisible(false);
            this.setVisible(false);
            return;
        }
        if (pubAcctList == null || pubAcctList.isEmpty()) {
            MessageUtil.showInfo("\u6ca1\u6709\u79fb\u52a8\u62a5\u8868\u516c\u4f17\u53f7\uff0c\u8bf7\u5148\u5efa\u7acb\u516c\u4f17\u53f7\uff01", false);
            return;
        }
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        rootNode.setText("\u79fb\u52a8\u62a5\u8868");
        DefaultKingdeeTreeNode defaultNode = null;
        for (PubAcctsDAO.PubAcct pubacct : pubAcctList) {
            DefaultKingdeeTreeNode pubAcctNode = new DefaultKingdeeTreeNode();
            pubAcctNode.setCustomIcon((Icon)this.acctNodeIcon);
            pubAcctNode.setText(pubacct.name);
            pubAcctNode.setUserObject((Object)pubacct);
            rootNode.add((MutableTreeNode)pubAcctNode);
            boolean hasChildren = false;
            ArrayList<MobileReportInfo> rptInfoRemoveList = new ArrayList<MobileReportInfo>();
            for (MobileType type : typeList) {
                if (!type.getPubAcctId().equals(pubacct.fid)) continue;
                DefaultKingdeeTreeNode typeNode = new DefaultKingdeeTreeNode();
                typeNode.setAllowsChildren(true);
                typeNode.setText(type.getName());
                typeNode.setUserObject((Object)type);
                pubAcctNode.add((MutableTreeNode)typeNode);
                if ("2cef69f7-ff2e-453b-b051-cc6840ebaefa".equals(type.getId())) {
                    defaultNode = typeNode;
                }
                hasChildren = false;
                for (MobileReportInfo rptInfo : rptInfoList) {
                    if (!type.getId().equals(rptInfo.getTypeId())) continue;
                    rptNode = new DefaultKingdeeTreeNode();
                    rptNode.setText(rptInfo.getPublishedName());
                    rptNode.setUserObject((Object)rptInfo);
                    hasChildren = true;
                    typeNode.add((MutableTreeNode)rptNode);
                    rptInfoRemoveList.add(rptInfo);
                }
                if (!hasChildren) {
                    typeNode.setCustomIcon(typeNode.getRenderIcon(false, false));
                }
                rptInfoList.removeAll(rptInfoRemoveList);
                rptInfoRemoveList.clear();
            }
        }
        if (defaultNode != null) {
            for (MobileReportInfo rptInfo : rptInfoList) {
                rptNode = new DefaultKingdeeTreeNode();
                rptNode.setText(rptInfo.getPublishedName());
                rptNode.setUserObject((Object)rptInfo);
                defaultNode.add((MutableTreeNode)rptNode);
            }
        }
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)rootNode));
        this.treeMain.expandOnLevel(3);
    }

    @Override
    protected void addFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode;
        InputDialog dialog = InputDialog.create((Component)((Object)this.deployMobileSelector), "\u65b0\u5efa\u76ee\u5f55");
        if (!dialog.showDialog()) {
            return;
        }
        String inputValue = dialog.getNewName();
        if (this.hasSameName(inputValue, selectedNode = this.getSelectedTreeNode())) {
            MessageUtil.showInfo("\u76ee\u5f55\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01", false);
            this.addFolderBtn_actionPerformed(e);
            return;
        }
        String pubAcctId = null;
        Object userObject = selectedNode.getUserObject();
        if (userObject instanceof PubAcctsDAO.PubAcct) {
            pubAcctId = ((PubAcctsDAO.PubAcct)userObject).fid;
        }
        int previousNumber = 0;
        if (selectedNode.getChildCount() > 0) {
            DefaultKingdeeTreeNode lastNode = (DefaultKingdeeTreeNode)selectedNode.getLastChild();
            previousNumber = ((MobileType)lastNode.getUserObject()).getOrderNumber();
        }
        MobileType type = new MobileType();
        type.setId(BaseUuid.create().toString());
        type.setName(inputValue);
        type.setOrderNumber(previousNumber + 1);
        type.setPubAcctId(pubAcctId);
        String typeName = type.getName();
        RptParams params = new RptParams();
        params.setString("MethodName", "insertMobileType");
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.mobile.server.MobileTypeDAO");
        params.setObject("MobileType", (Object)type);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (Exception e1) {
            String errInfo = "\u65b0\u589e'" + typeName + "'\u5931\u8d25\uff01";
            logger.error((Object)errInfo, (Throwable)e1);
            MessageUtil.showInfo(errInfo, false);
            return;
        }
        int resultType = params.getInt("resultType");
        if (resultType > 0) {
            MessageUtil.showInfo("\u65b0\u589e'" + typeName + "'\u6210\u529f\uff01", false);
            DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode();
            newNode.setCustomIcon(this.getRootNode().getRenderIcon(false, false));
            newNode.setText(typeName);
            newNode.setUserObject((Object)type);
            selectedNode.insert((MutableTreeNode)newNode, selectedNode.getChildCount());
            this.treeMain.updateUI();
        } else {
            MessageUtil.showInfo("\u65b0\u589e'" + typeName + "'\u5931\u8d25\uff01", false);
        }
    }

    @Override
    protected void updateFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode.getUserObject() instanceof PubAcctsDAO.PubAcct) {
            this.updateSubjectFolderAction();
            return;
        }
        MobileType type = (MobileType)selectedNode.getUserObject();
        String typeName = type.getName();
        InputDialog dialog = InputDialog.create((Component)((Object)this.deployMobileSelector), "\u4fee\u6539\u76ee\u5f55");
        dialog.setOldName(typeName);
        String inputValue = null;
        if (!dialog.showDialog()) {
            return;
        }
        inputValue = dialog.getNewName();
        if (this.hasSameName(inputValue, (DefaultKingdeeTreeNode)selectedNode.getParent())) {
            MessageUtil.showInfo("\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01", false);
            this.updateFolderBtn_actionPerformed(e);
            return;
        }
        type.setName(inputValue);
        typeName = inputValue;
        RptParams params = new RptParams();
        params.setString("MethodName", "updateMobileTypeById");
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.mobile.server.MobileTypeDAO");
        params.setObject("MobileType", (Object)type);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (Exception e1) {
            String errInfo = "\u4fee\u6539\u540d\u79f0\u5931\u8d25\uff01";
            logger.error((Object)errInfo, (Throwable)e1);
            MessageUtil.showInfo(errInfo, false);
            return;
        }
        int resultType = params.getInt("resultType");
        if (resultType > 0) {
            MessageUtil.showInfo("\u4fee\u6539\u540d\u79f0\u6210\u529f\uff01", false);
            selectedNode.setText(typeName);
            this.treeMain.updateUI();
        } else {
            MessageUtil.showInfo("\u4fee\u6539\u540d\u79f0\u5931\u8d25\uff01", false);
        }
    }

    @Override
    protected void delFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
        if (null == selectedNode.getParent()) {
            MessageUtil.showInfo("\u9876\u7ea7\u76ee\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\uff01", false);
            return;
        }
        if (selectedNode.getUserObject() instanceof PubAcctsDAO.PubAcct) {
            this.delSubjectFolderAction();
            return;
        }
        if (selectedNode.getChildCount() > 0) {
            MessageUtil.showInfo("\u6b64\u76ee\u5f55\u6709\u5df2\u53d1\u5e03\u7684\u62a5\u8868\uff0c\u8bf7\u5148\u53d6\u6d88\u53d1\u5e03\u62a5\u8868\u540e\u518d\u5220\u9664\uff01", false);
            return;
        }
        MobileType type = (MobileType)selectedNode.getUserObject();
        String typeName = type.getName();
        int inputValue = JOptionPane.showConfirmDialog((Component)((Object)this), "\u786e\u5b9a\u5220\u9664'" + typeName + "'\uff1f", "\u786e\u8ba4", 2);
        if (inputValue != 0) {
            return;
        }
        RptParams params = new RptParams();
        params.setString("MethodName", "deleteMobileTypeById");
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.mobile.server.MobileTypeDAO");
        params.setObject("MobileType", (Object)type);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (Exception e1) {
            String errInfo = "\u5220\u9664'" + typeName + "'\u5931\u8d25\uff01";
            logger.error((Object)errInfo, (Throwable)e1);
            MessageUtil.showInfo(errInfo, false);
            return;
        }
        int resultType = params.getInt("resultType");
        if (resultType > 0) {
            MessageUtil.showInfo("\u5220\u9664'" + typeName + "'\u6210\u529f\uff01", false);
            selectedNode.removeFromParent();
            this.treeMain.setSelectionNode(null);
            this.treeMain.updateUI();
        } else {
            MessageUtil.showInfo("\u5220\u9664'" + typeName + "'\u5931\u8d25\uff01", false);
        }
    }

    @Override
    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        this.upDownReportNode();
        this.upDownTypeNode();
        this.isOk = true;
        this.isCanceled = false;
        this.closeWin();
    }

    @Override
    protected void upFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
        if (null == selectedNode) {
            return;
        }
        DefaultMutableTreeNode previousNode = selectedNode.getPreviousSibling();
        if (previousNode == null) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getSelectedTreeNode().getParent();
        parentNode.insert((MutableTreeNode)selectedNode, parentNode.getIndex(previousNode));
        this.treeMain.updateUI();
    }

    @Override
    protected void downFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
        if (null == selectedNode) {
            return;
        }
        DefaultMutableTreeNode nextNode = selectedNode.getNextSibling();
        if (nextNode == null) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getSelectedTreeNode().getParent();
        parentNode.insert((MutableTreeNode)selectedNode, parentNode.getIndex(nextNode));
        this.treeMain.updateUI();
    }

    private void upDownReportNode() {
        DefaultKingdeeTreeNode rootNode = this.getRootNode();
        ArrayList<MobileReportInfo> updateNodes = new ArrayList<MobileReportInfo>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            for (int j = 0; j < rootNode.getChildAt(i).getChildCount(); ++j) {
                for (int k = 0; k < rootNode.getChildAt(i).getChildAt(j).getChildCount(); ++k) {
                    MobileReportInfo mobileRptInfo = (MobileReportInfo)((DefaultMutableTreeNode)rootNode.getChildAt(i).getChildAt(j).getChildAt(k)).getUserObject();
                    mobileRptInfo.setOrderNumber(k);
                    updateNodes.add(mobileRptInfo);
                }
            }
        }
        RptParams params = new RptParams();
        params.setString("MethodName", "moveReportPosition");
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.mobile.server.MobileTypeDAO");
        params.setBoolean("updateAll", false);
        params.setObject("MobileParams", updateNodes);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (Exception e1) {
            String errInfo = "\u79fb\u52a8\u5931\u8d25\uff01";
            logger.error((Object)errInfo, (Throwable)e1);
            MessageUtil.showInfo(errInfo, false);
        }
    }

    private void upDownTypeNode() {
        DefaultKingdeeTreeNode rootNode = this.getRootNode();
        ArrayList<MobileType> mobileType = new ArrayList<MobileType>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            for (int j = 0; j < rootNode.getChildAt(i).getChildCount(); ++j) {
                MobileType selectedType = (MobileType)((DefaultMutableTreeNode)rootNode.getChildAt(i).getChildAt(j)).getUserObject();
                mobileType.add(selectedType);
                selectedType.setOrderNumber(j);
            }
        }
        MobileType[] updateMobileType = new MobileType[mobileType.size()];
        updateMobileType = mobileType.toArray(updateMobileType);
        RptParams params = new RptParams();
        params.setString("MethodName", "moveTypePosition");
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.mobile.server.MobileTypeDAO");
        params.setObject("MobileParams", (Object)updateMobileType);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (Exception e1) {
            String errInfo = "\u79fb\u52a8\u5931\u8d25\uff01";
            logger.error((Object)errInfo, (Throwable)e1);
            MessageUtil.showInfo(errInfo, false);
        }
    }

    private void mapSubjectBtn_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<PubAcctsDAO.PubAcct> pubAcctList = new ArrayList<PubAcctsDAO.PubAcct>();
        DefaultKingdeeTreeNode rootNode = this.getRootNode();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            PubAcctsDAO.PubAcct pubAcct = (PubAcctsDAO.PubAcct)((DefaultKingdeeTreeNode)rootNode.getChildAt(i)).getUserObject();
            pubAcctList.add(pubAcct);
        }
        ReportDialog.showDialog(new PubAcctMapPanel(pubAcctList), "\u4e91\u4e4b\u5bb6\u516c\u5171\u53f7\u6620\u5c04", true, true);
    }

    private boolean hasSameName(String inputValue, DefaultKingdeeTreeNode parentNode) {
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode typeNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (!inputValue.equals(typeNode.getText())) continue;
            return true;
        }
        return false;
    }

    private DefaultKingdeeTreeNode getRootNode() {
        return (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
    }

    public static DeployMobileSelector createMobileAppManageUI() throws Exception {
        DeployMobileSelector thiz = new DeployMobileSelector(true);
        thiz.btnCancel.setText("\u53d6\u6d88");
        thiz.btnSelect.setText("\u786e\u5b9a");
        thiz.onLoadSelector();
        thiz.showSelector();
        thiz.setTreeBtnstate(false, false, false, true, false, false);
        return thiz;
    }

    private void appendTreeNodeSubject() {
        KDWorkButton addSubject = new KDWorkButton((Icon)ResourceManager.getImageIcon((String)"tree_acct_new.png"));
        addSubject.setToolTipText("\u65b0\u5efa\u4e3b\u9898");
        addSubject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployMobileSelector.this.beforeActionPerformed(e);
                try {
                    DefaultKingdeeTreeNode newNode = ExtMobileReportManageUI.addSubjectFolderAction((Component)((Object)DeployMobileSelector.this.deployMobileSelector), DeployMobileSelector.this.treeMain);
                    if (newNode != null) {
                        newNode.setCustomIcon((Icon)DeployMobileSelector.this.acctNodeIcon);
                        DeployMobileSelector.this.isSubjectNodeDirty = true;
                        DeployMobileSelector.this.treeMain.updateUI();
                    }
                }
                catch (Exception exc) {
                    DeployMobileSelector.this.handUIException(exc);
                }
                finally {
                    DeployMobileSelector.this.afterActionPerformed(e);
                }
            }
        });
        this.treeView.getControlPane().add((Component)addSubject);
    }

    private void delSubjectFolderAction() {
        if (ExtMobileReportManageUI.delSubjectFolderAction(this.treeMain)) {
            this.isSubjectNodeDirty = true;
        }
    }

    private void updateSubjectFolderAction() {
        if (ExtMobileReportManageUI.updateSubjectFolderAction((Component)((Object)this.deployMobileSelector), this.treeMain)) {
            this.isSubjectNodeDirty = true;
        }
    }

    public boolean isSubjectNodeDirty() {
        return this.isSubjectNodeDirty;
    }
}

