/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.client.card;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.border.Border;

public class MobileCardLayoutDialog
extends KDDialog {
    private KDPanel contentPanel;
    private KDPanel cardViewPanel;
    private KDPanel selectPanel;
    private KDPanel sheetContentPanel;
    private KDComboBox sheetsCombo;
    private KDComboBox embedsCombo;
    private KDRadioButton tbRb;
    private KDRadioButton ebRb;
    private KDWorkButton okBtn;
    private KDWorkButton cancelBtn;
    private KDLabel cardViewIcon;
    private KDLabel selectEmbed;
    private KDLabel selectContent;
    private KDTextArea tips;
    private Book book;
    private String[] sheetList;
    private String iconName;
    private boolean hasTable;
    private boolean hasEmbed;
    private EmbedObject[] embedName;

    public MobileCardLayoutDialog(KDExt ext, Book book) {
        super((Frame)ext);
        this.book = book;
        this.initSheetList();
        this.initSheetContent(this.sheetList[0]);
        this.init();
    }

    private void init() {
        this.initComponent();
        this.initSelectPanel();
        this.initListener();
        this.reLoadSelectPanel();
        this.loadData();
    }

    private void loadData() {
        UserObject userObject = this.book.getUserObject("SELECT_SHEET_NAME");
        if (userObject == null) {
            return;
        }
        String selectSheetName = (String)userObject.getValue();
        boolean isFind = false;
        for (String name : this.sheetList) {
            if (!name.equals(selectSheetName)) continue;
            isFind = true;
        }
        if (!isFind) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bbe\u7f6e\u7684\u5361\u7247\u5185\u5bb9\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
            return;
        }
        this.sheetsCombo.setSelectedItem((Object)selectSheetName, true);
        String showType = (String)this.book.getUserObject("SELECT_SHOW_TYPE").getValue();
        String selectEmbedName = (String)this.book.getUserObject("SELECT_EMBED_NAME").getValue();
        if ("TABLE".equals(showType)) {
            this.tbRb.setSelected(true, true);
        } else {
            this.ebRb.setSelected(true, true);
            int len = this.embedName.length;
            for (int i = 0; i < len; ++i) {
                if (!this.embedName[i].toString().equals(selectEmbedName)) continue;
                this.embedsCombo.setSelectedIndex(i, true);
                break;
            }
        }
    }

    private void initComponent() {
        this.setTitle("\u5361\u7247\u663e\u793a\u8bbe\u7f6e");
        this.setBounds(0, 0, 616, 428);
        this.setResizable(false);
        this.contentPanel = new KDPanel();
        this.contentPanel.setCustomInsets(new Insets(10, 10, 10, 10));
        this.contentPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 336, 338));
        this.contentPanel.setLayout((LayoutManager)new KDLayout());
        this.selectPanel = new KDPanel();
        this.selectPanel.setCustomInsets(new Insets(10, 10, 10, 10));
        this.selectPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 260, 300));
        this.selectPanel.setLayout((LayoutManager)new KDLayout());
        this.selectPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.cardViewPanel = new KDPanel();
        this.cardViewPanel.setCustomInsets(new Insets(10, 10, 10, 10));
        this.cardViewPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 320, 300));
        this.cardViewPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.cardViewPanel.setBackground(Color.WHITE);
        this.cardViewPanel.setLayout((LayoutManager)new KDLayout());
        this.cardViewIcon = new KDLabel();
        this.cardViewPanel.add((Component)this.cardViewIcon, (Object)new KDLayout.Constraints(1, 1, 316, 296, 0));
        this.okBtn = new KDWorkButton("\u786e\u5b9a");
        this.cancelBtn = new KDWorkButton("\u53d6\u6d88");
        KDLabel label1 = new KDLabel("\u5361\u7247\u5c55\u793a\u5185\u5bb9\u9009\u62e9\uff1a");
        KDLabel label2 = new KDLabel("\u5361\u7247\u6548\u679c\u5c55\u793a\uff1a");
        this.contentPanel.add((Component)label1, (Object)new KDLayout.Constraints(10, 10, 120, 19, 0));
        this.contentPanel.add((Component)label2, (Object)new KDLayout.Constraints(270, 10, 120, 19, 0));
        this.contentPanel.add((Component)this.selectPanel, (Object)new KDLayout.Constraints(10, 40, 260, 300, 0));
        this.contentPanel.add((Component)this.cardViewPanel, (Object)new KDLayout.Constraints(270, 40, 320, 300, 0));
        this.contentPanel.add((Component)this.okBtn, (Object)new KDLayout.Constraints(235, 360, 60, 22, 0));
        this.contentPanel.add((Component)this.cancelBtn, (Object)new KDLayout.Constraints(305, 360, 60, 22, 0));
        this.add((Component)this.contentPanel);
    }

    private void initSelectPanel() {
        KDLabel label = new KDLabel("\u9009\u62e9\u8868\u9875\uff1a");
        this.sheetsCombo = new KDComboBox((Object[])this.sheetList);
        this.sheetContentPanel = new KDPanel();
        this.sheetContentPanel.setCustomInsets(new Insets(10, 10, 10, 10));
        this.sheetContentPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 336, 338));
        this.sheetContentPanel.setLayout((LayoutManager)new KDLayout());
        this.selectContent = new KDLabel("\u9009\u62e9\u5185\u5bb9\uff1a");
        this.tbRb = new KDRadioButton("\u8868\u683c");
        this.ebRb = new KDRadioButton("\u56fe\u8868");
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.tbRb);
        group.add((AbstractButton)this.ebRb);
        this.sheetContentPanel.add((Component)this.selectContent, (Object)new KDLayout.Constraints(0, 10, 80, 19, 0));
        this.sheetContentPanel.add((Component)this.tbRb, (Object)new KDLayout.Constraints(90, 10, 50, 19, 0));
        this.sheetContentPanel.add((Component)this.ebRb, (Object)new KDLayout.Constraints(150, 10, 50, 19, 0));
        this.selectEmbed = new KDLabel("\u9009\u62e9\u56fe\u8868\uff1a");
        this.embedsCombo = new KDComboBox();
        this.sheetContentPanel.add((Component)this.selectEmbed, (Object)new KDLayout.Constraints(0, 40, 80, 19, 0));
        this.sheetContentPanel.add((Component)this.embedsCombo, (Object)new KDLayout.Constraints(90, 40, 120, 19, 0));
        this.tips = new KDTextArea("\u63d0\u793a\uff1a\u4e91\u4e4b\u5bb6\u5361\u7247\u5927\u5c0f\u4e3a320*300\u50cf\u7d20\uff0c\n\u8868\u683c\u6216\u8005\u56fe\u8868\u8d85\u8fc7\u90e8\u5206\u5c06\u65e0\u6cd5\u663e\u793a\u3002");
        this.tips.setEditable(false);
        this.tips.setBorder(null);
        this.selectPanel.add((Component)label, (Object)new KDLayout.Constraints(10, 10, 80, 19, 0));
        this.selectPanel.add((Component)this.sheetsCombo, (Object)new KDLayout.Constraints(100, 10, 120, 19, 0));
        this.selectPanel.add((Component)this.sheetContentPanel, (Object)new KDLayout.Constraints(10, 40, 240, 200, 0));
        this.selectPanel.add((Component)this.tips, (Object)new KDLayout.Constraints(10, 250, 240, 40, 0));
    }

    private void reLoadSelectPanel() {
        this.selectContent.setText("\u9009\u62e9\u5185\u5bb9\uff1a");
        this.sheetContentPanel.remove((Component)this.tbRb);
        this.sheetContentPanel.remove((Component)this.ebRb);
        if (!this.hasTable && !this.hasEmbed) {
            this.selectContent.setText("\u8868\u9875\u5185\u5bb9\u4e3a\u7a7a");
            this.tbRb.setVisible(false);
            this.ebRb.setVisible(false);
            this.tbRb.setSelected(false);
            this.ebRb.setSelected(false);
            this.selectEmbed.setVisible(false);
            this.embedsCombo.setVisible(false);
            this.cardViewIcon.setIcon(null);
        } else if (!this.hasTable && this.hasEmbed) {
            this.tbRb.setVisible(false);
            this.ebRb.setVisible(true);
            this.tbRb.setSelected(false);
            this.selectEmbed.setVisible(true);
            this.embedsCombo.setVisible(true);
            this.sheetContentPanel.add((Component)this.ebRb, (Object)new KDLayout.Constraints(90, 10, 50, 19, 0));
            this.embedsCombo.setModel(new DefaultComboBoxModel<EmbedObject>(this.embedName));
            this.embedsCombo.setSelectedIndex(0);
            this.ebRb.setSelected(true, true);
        } else if (!this.hasEmbed && this.hasTable) {
            this.tbRb.setVisible(true);
            this.ebRb.setSelected(false);
            this.ebRb.setVisible(false);
            this.selectEmbed.setVisible(false);
            this.embedsCombo.setVisible(false);
            this.sheetContentPanel.add((Component)this.tbRb, (Object)new KDLayout.Constraints(90, 10, 50, 19, 0));
            this.tbRb.setSelected(true, true);
        } else {
            this.tbRb.setVisible(true);
            this.ebRb.setVisible(true);
            this.sheetContentPanel.add((Component)this.tbRb, (Object)new KDLayout.Constraints(90, 10, 50, 19, 0));
            this.sheetContentPanel.add((Component)this.ebRb, (Object)new KDLayout.Constraints(150, 10, 50, 19, 0));
            this.embedsCombo.setModel(new DefaultComboBoxModel<EmbedObject>(this.embedName));
            this.embedsCombo.setSelectedIndex(0);
            this.tbRb.setSelected(true, true);
        }
    }

    private void initSheetContent(String sheetName) {
        Sheet sheet = null;
        try {
            sheet = this.book.getSheetByName(sheetName);
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
        this.hasTable = sheet.getRows().size() > 0;
        this.hasEmbed = false;
        EmbedhLayer embedments = sheet.getEmbedments(false);
        if (embedments != null) {
            this.hasEmbed = true;
            int len = embedments.size();
            this.embedName = new EmbedObject[len];
            for (int i = 0; i < len; ++i) {
                EmbedObject embed;
                this.embedName[i] = embed = embedments.getEmbed(i);
            }
        }
    }

    private void initListener() {
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileCardLayoutDialog.this.actionCancelBtn_actionPerformed();
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileCardLayoutDialog.this.actionOkBtn_actionPerformed();
            }
        });
        this.sheetsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MobileCardLayoutDialog.this.actionSheetsCombo_itemChanged(e);
            }
        });
        this.tbRb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MobileCardLayoutDialog.this.actionTableRadioBtn_itemChanged(e);
            }
        });
        this.tbRb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                e.getSource();
            }
        });
        this.ebRb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MobileCardLayoutDialog.this.actionEmbedRadioBtn_itemChanged(e);
            }
        });
        this.embedsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MobileCardLayoutDialog.this.actionEmbedsCombo_itemChanged(e);
            }
        });
    }

    private void actionTableRadioBtn_itemChanged(ItemEvent e) {
        KDRadioButton rb = (KDRadioButton)e.getSource();
        boolean selected = rb.isSelected();
        if (selected) {
            this.iconName = "table";
            this.initCardViewPanel();
        }
        if (this.hasEmbed) {
            this.selectEmbed.setVisible(!selected);
            this.embedsCombo.setVisible(!selected);
        } else {
            this.tbRb.setSelected(true, false);
        }
    }

    private void actionEmbedRadioBtn_itemChanged(ItemEvent e) {
        KDRadioButton rb = (KDRadioButton)e.getSource();
        boolean selected = rb.isSelected();
        if (selected) {
            this.initIconName((EmbedObject)this.embedsCombo.getSelectedItem());
            this.initCardViewPanel();
        }
        if (this.hasTable) {
            this.selectEmbed.setVisible(selected);
            this.embedsCombo.setVisible(selected);
        } else {
            this.ebRb.setSelected(true, false);
        }
    }

    private void actionEmbedsCombo_itemChanged(ItemEvent e) {
        EmbedObject eb = (EmbedObject)e.getItem();
        this.initIconName(eb);
        this.initCardViewPanel();
    }

    private void initIconName(EmbedObject eb) {
        if (eb instanceof FlashChart) {
            FlashChart fc = (FlashChart)eb;
            this.iconName = "./charts/" + fc.getModel().getChartType().getName();
        }
    }

    private void actionSheetsCombo_itemChanged(ItemEvent e) {
        this.initSheetContent(e.getItem().toString());
        this.reLoadSelectPanel();
    }

    private void actionOkBtn_actionPerformed() {
        String selectSheetName = this.sheetsCombo.getSelectedItem().toString();
        boolean isTable = this.tbRb.isSelected();
        if (isTable) {
            this.book.setUserObject("SELECT_SHOW_TYPE", (Object)"TABLE");
        } else {
            String embedName = this.embedsCombo.getSelectedItem().toString();
            this.book.setUserObject("SELECT_SHOW_TYPE", (Object)"CHART");
            this.book.setUserObject("SELECT_EMBED_NAME", (Object)embedName);
        }
        this.book.setUserObject("SELECT_SHEET_NAME", (Object)selectSheetName);
        MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        super.dispose();
    }

    private void actionCancelBtn_actionPerformed() {
        super.dispose();
    }

    private void initCardViewPanel() {
        this.cardViewIcon.removeAll();
        this.cardViewIcon.setIcon((Icon)ResourceManager.getImageIcon((String)(this.iconName + ".png")));
    }

    private void initSheetList() {
        ObjectArray sheets = this.book.getSheets();
        int len = sheets.size();
        this.sheetList = new String[len];
        for (int i = 0; i < len; ++i) {
            Sheet sheet = (Sheet)sheets.get(i);
            this.sheetList[i] = sheet.getSheetName();
        }
    }
}

