/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.client.param;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.eas.rpts.ctrlreport.mobile.client.param.MultiSplitterPanel;
import com.kingdee.eas.rpts.ctrlreport.mobile.client.param.img.ImageUtil;
import com.kingdee.eas.rpts.ctrlreport.mobile.util.LayoutParameterUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class MobileLayoutParamPanel
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private final Color COLOR_SELECTED = new Color(182, 219, 245);
    private final ImageIcon STARGRAY = new ImageIcon(MainMenuConstants.GRAY_STAR_IMAGE);
    private final ImageIcon STARBLUE = new ImageIcon(MainMenuConstants.BLUE_STAR_IMAGE);
    private KDWorkButton btnMoveUp;
    private KDWorkButton btnMoveDown;
    private KDLabel labelImg;
    private FilterLine filterLine;
    private FilterEmbedLine filterEmbedLine;
    private KDPanel allParamsPanel;
    private KDPanel currentParamPanel;
    private List<KDPanel> paramsPanelList = new ArrayList<KDPanel>();
    private MultiSplitterPanel splitterPanel;
    private List<DesignParameter> allParams;
    private boolean isDirty = false;
    private boolean isSrotChanged = false;
    private Book book;

    public MobileLayoutParamPanel(Book book) {
        this.book = book;
        this.allParams = LayoutParameterUtil.getAllUnionParam(book);
        this.allParamsPanel = new KDPanel();
        this.initComponents();
        this.initListeners();
        String allParamLayoutInfo = (String)book.getUserObjectValue("mobileparam_allparams_layoutinfo");
        this.initAllParamLayout(allParamLayoutInfo);
        this.initCommonParamLayout();
        this.resetImgAndLine(this.splitterPanel.getParamComponents());
    }

    public void reset() {
        this.allParams = LayoutParameterUtil.getAllUnionParam(this.book);
        if (this.isSrotChanged) {
            this.isDirty = true;
        }
        this.initAllParamLayout(null);
        this.allParamsPanel.revalidate();
        if (this.splitterPanel.getParamComponents() != null && !this.splitterPanel.getParamComponents().isEmpty()) {
            this.isDirty = true;
        }
        this.splitterPanel.setComponents(null);
        this.resetImgAndLine(this.splitterPanel.getParamComponents());
    }

    public String getAllParamLayout() {
        return LayoutParameterUtil.allParamsToXml(this.allParams);
    }

    public String getCommonParamLayout() {
        return LayoutParameterUtil.commonParamsToXml(this.splitterPanel.getParamPercentage());
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return this.isDirty;
        }
        return this.splitterPanel.isDirty();
    }

    private void initComponents() {
        this.setLayout(null);
        this.setBounds(400, 10, 300, 500);
        KDPanel paramPanel = this.createParamPanel();
        paramPanel.setBounds(405, 10, 376, 510);
        this.labelImg = new KDLabel();
        this.labelImg.setBounds(10, 10, 320, 510);
        this.filterLine = new FilterLine();
        this.filterLine.setBounds(332, 35, 75, 40);
        this.filterEmbedLine = new FilterEmbedLine();
        this.filterEmbedLine.setBounds(332, 80, 75, 365);
        this.add((Component)this.labelImg);
        this.add(this.filterLine);
        this.add(this.filterEmbedLine);
        this.add((Component)paramPanel);
    }

    private void resetImgAndLine(List<Component> commonComps) {
        this.filterLine.setVisible(false);
        this.filterEmbedLine.setVisible(false);
        if (this.allParams == null || this.allParams.isEmpty()) {
            this.labelImg.setIcon((Icon)ImageUtil.NONE_ICON);
        } else if (commonComps.isEmpty()) {
            this.labelImg.setIcon((Icon)ImageUtil.FILTER_ICON);
            this.filterLine.setVisible(true);
        } else if (this.allParams.size() == commonComps.size()) {
            this.labelImg.setIcon((Icon)ImageUtil.EMBED_INCON);
            this.filterEmbedLine.setVisible(true);
        } else {
            this.labelImg.setIcon((Icon)ImageUtil.EMBED_FILTER_ICON);
            this.filterLine.setVisible(true);
            this.filterEmbedLine.setVisible(true);
        }
    }

    private void initListeners() {
        this.btnMoveUp.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = MobileLayoutParamPanel.this.paramsPanelList.indexOf(MobileLayoutParamPanel.this.currentParamPanel);
                if (i <= 0) {
                    return;
                }
                KDPanel lastPanel = (KDPanel)MobileLayoutParamPanel.this.paramsPanelList.get(i - 1);
                MobileLayoutParamPanel.this.moveParamUp(i, MobileLayoutParamPanel.this.currentParamPanel, lastPanel);
            }
        });
        this.btnMoveDown.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = MobileLayoutParamPanel.this.paramsPanelList.indexOf(MobileLayoutParamPanel.this.currentParamPanel);
                if (++i >= MobileLayoutParamPanel.this.paramsPanelList.size()) {
                    return;
                }
                KDPanel nextPanel = (KDPanel)MobileLayoutParamPanel.this.paramsPanelList.get(i);
                MobileLayoutParamPanel.this.moveParamUp(i, nextPanel, MobileLayoutParamPanel.this.currentParamPanel);
            }
        });
    }

    private void moveParamUp(int index, KDPanel curPanel, KDPanel lastPanel) {
        Collections.swap(this.allParams, index, index - 1);
        this.paramsPanelList.remove(index);
        this.paramsPanelList.add(index - 1, curPanel);
        TableLayout2 layout = (TableLayout2)this.allParamsPanel.getLayout();
        layout.addLayoutComponent((Component)curPanel, (Object)TableLayout2.param((int)(index - 1), (int)0));
        layout.addLayoutComponent((Component)lastPanel, (Object)TableLayout2.param((int)index, (int)0));
        this.allParamsPanel.revalidate();
        this.isDirty = true;
        List<Component> paramComponents = this.splitterPanel.getParamComponents();
        this.orderSplitterPanel(paramComponents);
        Map<String, Double> paramPercentage = this.splitterPanel.getParamPercentage();
        this.splitterPanel.setComponents(paramComponents, paramPercentage);
    }

    private void orderSplitterPanel(List<Component> commonComps) {
        if (commonComps == null || commonComps.isEmpty()) {
            this.splitterPanel.setComponents(commonComps);
            return;
        }
        int index = 0;
        block0: for (int i = 0; i < this.allParams.size(); ++i) {
            DesignParameter designParameter = this.allParams.get(i);
            for (int j = 0; j < commonComps.size(); ++j) {
                Object userObject = ((KDLabel)commonComps.get(j)).getUserObject();
                if (!designParameter.equals(userObject)) continue;
                Collections.swap(commonComps, index++, j);
                if (index != commonComps.size()) continue block0;
                return;
            }
        }
    }

    private KDPanel createParamPanel() {
        KDPanel panel = new KDPanel();
        TableLayout2 layout = new TableLayout2(4, 3);
        layout.setFixedHeight(new int[]{0, 2}, 20);
        layout.setRatableHeight(1, 1);
        layout.setFixedHeight(3, 80);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(new int[]{1, 2}, 22);
        layout.setColSpacing(1, 5);
        layout.setRowsSpacing(new int[]{0, 2}, 5);
        layout.setRowSpacing(1, 10);
        panel.setLayout((LayoutManager)layout);
        KDLabel labelRpt = new KDLabel("\u6240\u6709\u53c2\u6570");
        KDLabel labelUsed = new KDLabel("\u5e38\u7528\u53c2\u6570");
        this.btnMoveDown = new KDWorkButton((Icon)ResourceManager.getImageIcon((String)"tbtn_movedown.gif"));
        this.btnMoveDown.setToolTipText("\u4e0b\u79fb");
        this.btnMoveUp = new KDWorkButton((Icon)ResourceManager.getImageIcon((String)"tbtn_moveup.gif"));
        this.btnMoveUp.setToolTipText("\u4e0a\u79fb");
        int cuontParam = this.allParams.size();
        this.allParamsPanel.setCustomInsets(new Insets(8, 8, 8, 8));
        TableLayout2 allParamLayout = new TableLayout2(cuontParam + 1, 1);
        this.allParamsPanel.setLayout((LayoutManager)allParamLayout);
        allParamLayout.setRatableHeight(cuontParam, 1);
        KDScrollPane scrollPanel = new KDScrollPane((Component)this.allParamsPanel);
        scrollPanel.setHorizontalScrollBarPolicy(31);
        scrollPanel.setBorder(BorderFactory.createLineBorder(new Color(160, 175, 188)));
        panel.add((Component)labelRpt, (Object)TableLayout2.param((int)0, (int)0));
        panel.add((Component)this.btnMoveUp, (Object)TableLayout2.param((int)0, (int)1));
        panel.add((Component)this.btnMoveDown, (Object)TableLayout2.param((int)0, (int)2));
        panel.add((Component)scrollPanel, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        panel.add((Component)labelUsed, (Object)TableLayout2.param((int)2, (int)0));
        panel.add((Component)this.createUsedParamsPanel(), (Object)TableLayout2.param((int)3, (int)0, (int)3, (int)2));
        panel.setAutoscrolls(false);
        return panel;
    }

    private void initAllParamLayout(String allParamLayoutInfo) {
        HashMap<String, Integer> allParamLayout = LayoutParameterUtil.allParamFromXml(allParamLayoutInfo);
        this.paramsPanelList.clear();
        this.allParamsPanel.removeAll();
        TableLayout2 layout = (TableLayout2)this.allParamsPanel.getLayout();
        int index = 0;
        int onePanelHeight = 38;
        this.isSrotChanged = LayoutParameterUtil.sortAllParams(this.allParams, allParamLayout);
        Integer selectedFlag = 0;
        ArrayList<DesignParameter> hiddenParam = new ArrayList<DesignParameter>();
        for (DesignParameter parameter : this.allParams) {
            if (parameter.getInputState() == InputState.HIDDEN) {
                hiddenParam.add(parameter);
                continue;
            }
            boolean isSelected = false;
            layout.setFixedHeight(index, onePanelHeight);
            if (allParamLayout != null) {
                selectedFlag = allParamLayout.get(parameter.getName() + "_isSelected");
            }
            if (allParamLayout != null && selectedFlag != null && selectedFlag == 1) {
                isSelected = true;
            }
            parameter.setProperty("isSelected", isSelected);
            OneParamPanel pp = new OneParamPanel(parameter, isSelected);
            pp.setUserObject((Object)parameter);
            this.allParamsPanel.add((Component)((Object)pp), (Object)TableLayout2.param((int)index, (int)0));
            this.paramsPanelList.add(pp);
            ++index;
        }
        this.allParams.removeAll(hiddenParam);
    }

    private void initCommonParamLayout() {
        String commonParamLayoutInfo = (String)this.book.getUserObjectValue("mobileparam_commonparam_layoutinfo");
        HashMap<String, Double> commonParamLayout = LayoutParameterUtil.commonParamFromXml(commonParamLayoutInfo);
        ArrayList<Component> commonParams = new ArrayList<Component>();
        if (commonParamLayout != null) {
            for (DesignParameter parameter : this.allParams) {
                if (commonParamLayout.get(parameter.getName()) == null) continue;
                KDLabel dpLabel = this.createUsedParamLabel(parameter.getAliasName(), parameter.getName());
                dpLabel.setUserObject((Object)parameter);
                commonParams.add((Component)dpLabel);
            }
            this.orderSplitterPanel(commonParams);
            this.splitterPanel.setComponents(commonParams, commonParamLayout);
        }
    }

    private void reSelect(KDPanel source) {
        if (this.currentParamPanel != null) {
            this.currentParamPanel.setBackground(null);
        }
        source.setBackground(this.COLOR_SELECTED);
        this.currentParamPanel = source;
    }

    private KDPanel createUsedParamsPanel() {
        JComponent panelSplitter = this.createSplitterPanel();
        ScalePanel panelScale = new ScalePanel();
        panelScale.setPreferredSize(new Dimension(100, 15));
        KDPanel panel = new KDPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(""));
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)panelScale, (Object)"North");
        panel.add((Component)panelSplitter, (Object)"Center");
        return panel;
    }

    private JComponent createSplitterPanel() {
        this.splitterPanel = new MultiSplitterPanel();
        this.splitterPanel.setBorder(BorderFactory.createTitledBorder(""));
        return this.splitterPanel;
    }

    private KDLabel createUsedParamLabel(String text, String name) {
        KDLabel label = new KDLabel(text);
        label.setName(name);
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        label.setHorizontalAlignment(0);
        return label;
    }

    private class ScalePanel
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private ScalePanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            int x = 0;
            int lineHeight = 0;
            int lineWidth = 1;
            int lineGap = this.getWidth() / 50;
            int lineCount = 0;
            for (int i = 0; i <= 10; ++i) {
                if (i == 0) {
                    x = 0;
                    lineHeight = 15;
                    lineCount = 6;
                } else {
                    x = lineGap * i + lineWidth;
                    lineCount = 5;
                    lineHeight = i == 5 ? 10 : 5;
                }
                for (int j = 0; j < lineCount; ++j) {
                    g.drawLine(x, this.getHeight() - lineHeight, x, this.getHeight());
                    x += lineGap * 10 + lineWidth;
                }
            }
        }
    }

    private class FilterEmbedLine
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private static final int LINESIZE = 5;

        private FilterEmbedLine() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Color.LIGHT_GRAY);
            int width = this.getWidth() / 2;
            g.fillRect(0, 0, width, 5);
            g.fillRect(width, 0, 5, this.getHeight());
            g.fillRect(width, this.getHeight() - 5, width - 1, 5);
        }
    }

    private class FilterLine
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private static final int LINESIZE = 5;

        private FilterLine() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, this.getWidth() - 1, 5);
        }
    }

    private class OneParamPanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;
        private KDLabel labelParam;
        private KDLabel labelStar;

        protected OneParamPanel(DesignParameter parameter, boolean isSelected) {
            this.initComponents(parameter, isSelected);
            this.initListener();
        }

        private void initComponents(DesignParameter parameter, boolean isSelected) {
            this.setBorder(BorderFactory.createTitledBorder(""));
            TableLayout2 layout = new TableLayout2(1, 3);
            layout.setFixedWidth(0, 170);
            layout.setFixedWidth(2, 25);
            layout.setRatableWidth(1, 1);
            this.setLayout((LayoutManager)layout);
            this.labelParam = new KDLabel(parameter.getAliasName());
            this.labelParam.setOpaque(true);
            this.labelParam.setBackground(Color.WHITE);
            this.labelParam.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.labelParam.setHorizontalAlignment(0);
            this.add((Component)this.labelParam, TableLayout2.param((int)0, (int)0));
            if (parameter.getInputType() != InputType.EMPTY && parameter.getInputType() != InputType.Separator) {
                this.labelStar = new KDLabel((Icon)(isSelected ? MobileLayoutParamPanel.this.STARBLUE : MobileLayoutParamPanel.this.STARGRAY));
                this.labelStar.setCursor(Cursor.getPredefinedCursor(12));
                HashMap<String, Boolean> mapLabelObject = new HashMap<String, Boolean>();
                mapLabelObject.put("isSelected", isSelected);
                this.labelStar.setUserObject(mapLabelObject);
                this.labelStar.setToolTipText("\u6dfb\u52a0\u5230\u5e38\u7528\u53c2\u6570");
                this.add((Component)this.labelStar, TableLayout2.param((int)0, (int)2));
            }
        }

        private void initListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    MobileLayoutParamPanel.this.reSelect((KDPanel)e.getSource());
                }
            });
            this.labelParam.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MobileLayoutParamPanel.this.reSelect((KDPanel)((KDLabel)e.getSource()).getParent());
                }
            });
            if (this.labelStar != null) {
                this.labelStar.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        KDLabel source = (KDLabel)e.getSource();
                        KDPanel parentPanel = (KDPanel)source.getParent();
                        Object userObject = source.getUserObject();
                        HashMap mapObject = (HashMap)userObject;
                        DesignParameter dp = (DesignParameter)((Object)parentPanel.getUserObject());
                        List<Component> allComps = MobileLayoutParamPanel.this.splitterPanel.getParamComponents();
                        if (((Boolean)mapObject.get("isSelected")).booleanValue()) {
                            mapObject.put("isSelected", false);
                            source.setIcon((Icon)MobileLayoutParamPanel.this.STARGRAY);
                            for (Component comp : allComps) {
                                Object odp = ((KDLabel)comp).getUserObject();
                                if (dp != odp) continue;
                                dp.setProperty("isSelected", false);
                                allComps.remove(comp);
                                break;
                            }
                        } else {
                            if (allComps.size() >= 10) {
                                MessageUtil.msgboxOkCancel((Component)((Object)MobileLayoutParamPanel.this), (String)"\u5e38\u7528\u53c2\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff01");
                                return;
                            }
                            mapObject.put("isSelected", true);
                            source.setIcon((Icon)MobileLayoutParamPanel.this.STARBLUE);
                            KDLabel dpLabel = MobileLayoutParamPanel.this.createUsedParamLabel(dp.getAliasName(), dp.getName());
                            dp.setProperty("isSelected", true);
                            dpLabel.setUserObject((Object)dp);
                            allComps.add((Component)dpLabel);
                        }
                        MobileLayoutParamPanel.this.resetImgAndLine(allComps);
                        MobileLayoutParamPanel.this.orderSplitterPanel(allComps);
                        MobileLayoutParamPanel.this.splitterPanel.setComponents(allComps);
                        MobileLayoutParamPanel.this.reSelect(parentPanel);
                        MobileLayoutParamPanel.this.isDirty = true;
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        KDLabel source = (KDLabel)e.getSource();
                        Object userObject = source.getUserObject();
                        HashMap mapObject = (HashMap)userObject;
                        if (((Boolean)mapObject.get("isSelected")).booleanValue()) {
                            OneParamPanel.this.labelStar.setToolTipText("\u4ece\u5e38\u7528\u53c2\u6570\u4e2d\u79fb\u9664");
                        } else {
                            OneParamPanel.this.labelStar.setToolTipText("\u6dfb\u52a0\u5230\u5e38\u7528\u53c2\u6570");
                        }
                    }
                });
            }
        }
    }
}

