/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.client.param;

import com.kingdee.bos.ctrl.swing.KDLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MultiSplitterPanel
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    private int orientation = 0;
    protected static final int DIVIDER_SIZE = 6;
    private static int COMPONENT_MIN_WIDTH = 14;
    private int xMove;
    private List<Component> components = new ArrayList<Component>();
    private Divider currentDraggedDivider;
    private List<Divider> dividers = new ArrayList<Divider>();
    private Map<Divider, Double> mapDividerInitLocation = new HashMap<Divider, Double>();
    private Map<String, Double> compsPercentage = new HashMap<String, Double>();
    private static final Color spliterColor1 = Color.decode("#c0c0c0");
    private static final Color spliterColor2 = Color.decode("#ffffff");
    private static final Color spliterColor3 = Color.decode("#e4e4e4");
    private static final Color spliterColor4 = Color.decode("#dfdfdf");
    private static final Color spliterColor5 = Color.decode("#dadada");
    private static final Color spliterColor6 = Color.decode("#cdcdcd");
    private static final Color spliterColor7 = Color.decode("#c0c0c0");
    private boolean isDirty = false;

    public MultiSplitterPanel() {
        this.setLayout(new PlaceholderLayout());
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public Map<String, Double> getParamPercentage() {
        return this.compsPercentage;
    }

    public void setComponents(List<Component> comps, Map<String, Double> compsPercentage) {
        this.compsPercentage = compsPercentage;
        this._setComponents(comps, compsPercentage);
    }

    public void setComponents(List<Component> comps) {
        this.compsPercentage.clear();
        this._setComponents(comps, null);
    }

    private void _setComponents(List<Component> comps, Map<String, Double> compsPercentage) {
        this.clearAll();
        if (comps == null || comps.isEmpty()) {
            this.components.clear();
            this.rerangeOffsprings();
            return;
        }
        this.addLabelPlaceholder(comps);
        Divider divider = null;
        this.components = comps;
        int countComps = this.components.size();
        Double percentage = 0.0;
        for (int i = 0; i < countComps; ++i) {
            this.add(this.components.get(i));
            divider = new Divider();
            this.dividers.add(divider);
            this.add(divider);
            if (compsPercentage != null && compsPercentage.size() != 0) {
                String compName = this.components.get(i).getName();
                percentage = percentage + compsPercentage.get(compName);
                this.mapDividerInitLocation.put(divider, percentage);
                continue;
            }
            if (i == 0) {
                this.mapDividerInitLocation.put(divider, 0.0);
                continue;
            }
            if (i == countComps - 2) {
                this.mapDividerInitLocation.put(divider, 1.0);
                continue;
            }
            this.mapDividerInitLocation.put(divider, (double)i / (double)(countComps - 2));
        }
        this.mapDividerInitLocation.remove(divider);
        this.dividers.remove(divider);
        this.remove(divider);
        this.rerangeOffsprings();
    }

    private void clearAll() {
        this.xMove = 0;
        this.removeAll();
        this.dividers.clear();
        this.mapDividerInitLocation.clear();
        this.currentDraggedDivider = null;
    }

    public List<Component> getParamComponents() {
        ArrayList<Component> params = new ArrayList<Component>();
        if (this.components == null || this.components.isEmpty()) {
            return params;
        }
        for (int i = 1; i < this.components.size() - 1; ++i) {
            params.add(this.components.get(i));
        }
        return params;
    }

    private void addLabelPlaceholder(List<Component> comps) {
        KDLabel btnFirst = new KDLabel("first_place_holder");
        btnFirst.setName("first_place_holder");
        btnFirst.setText("first_place_holder");
        btnFirst.setToolTipText(null);
        btnFirst.setVisible(false);
        KDLabel btnEnd = new KDLabel("end_place_holder");
        btnEnd.setName("end_place_holder");
        btnFirst.setText("end_place_holder");
        btnEnd.setToolTipText(null);
        btnEnd.setVisible(false);
        comps.add(0, (Component)btnFirst);
        comps.add(comps.size(), (Component)btnEnd);
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void rerangeOffsprings() {
        this.revalidate();
        this.repaint();
    }

    private class Divider
    extends JComponent {
        private static final long serialVersionUID = 1L;

        public Divider() {
            this.setCursor(Cursor.getPredefinedCursor(11));
            DividerResizer dividerResizer = new DividerResizer();
            this.addMouseListener(dividerResizer);
            this.addMouseMotionListener(dividerResizer);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color oldcolor = g.getColor();
            int width = this.getWidth();
            int height = this.getHeight();
            if (MultiSplitterPanel.this.orientation == 0) {
                g.setColor(spliterColor1);
                g.drawLine(0, 0, 0, height);
                g.setColor(spliterColor2);
                g.drawLine(1, 0, 1, height);
                g.setColor(spliterColor3);
                g.drawLine(2, 0, 2, height);
                g.setColor(spliterColor4);
                g.drawLine(3, 0, 3, height);
                g.setColor(spliterColor5);
                g.drawLine(4, 0, 4, height);
                g.setColor(spliterColor6);
                g.drawLine(5, 0, 5, height);
                g.setColor(spliterColor7);
                g.drawLine(6, 0, 6, height);
                g.setColor(Color.gray);
                g.drawLine(2, (int)((double)height * 0.4), 2, (int)((double)height * 0.6));
                g.drawLine(4, (int)((double)height * 0.4), 4, (int)((double)height * 0.6));
            } else {
                g.setColor(spliterColor1);
                g.drawLine(0, 0, width, 0);
                g.setColor(spliterColor2);
                g.drawLine(0, 1, width, 1);
                g.setColor(spliterColor3);
                g.drawLine(0, 2, width, 2);
                g.setColor(spliterColor4);
                g.drawLine(0, 3, width, 3);
                g.setColor(spliterColor5);
                g.drawLine(0, 4, width, 4);
                g.setColor(spliterColor6);
                g.drawLine(0, 5, width, 5);
                g.setColor(spliterColor7);
                g.drawLine(0, 6, width, 6);
            }
            g.setColor(oldcolor);
        }

        private class DividerResizer
        extends MouseAdapter
        implements MouseMotionListener {
            private Point pressFrom;

            private DividerResizer() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.pressFrom = SwingUtilities.convertPoint((Divider)e.getSource(), e.getPoint(), MultiSplitterPanel.this);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MultiSplitterPanel.this.xMove = 0;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MultiSplitterPanel.this.orientation == 0) {
                    int containerW = MultiSplitterPanel.this.getWidth();
                    if (containerW <= 0) {
                        return;
                    }
                    Point dragTo = SwingUtilities.convertPoint((Divider)e.getSource(), e.getPoint(), MultiSplitterPanel.this);
                    int drividerW = ((Divider)e.getSource()).getWidth();
                    int maxW = containerW - (drividerW - e.getX());
                    if (dragTo.x > maxW) {
                        dragTo.x = maxW;
                    }
                    MultiSplitterPanel.this.currentDraggedDivider = (Divider)e.getSource();
                    MultiSplitterPanel.this.xMove = dragTo.x - this.pressFrom.x;
                    int indexCurDivider = MultiSplitterPanel.this.dividers.indexOf(MultiSplitterPanel.this.currentDraggedDivider);
                    Component comp = (Component)MultiSplitterPanel.this.components.get(indexCurDivider);
                    if (MultiSplitterPanel.this.xMove < 0 && comp.getWidth() + MultiSplitterPanel.this.xMove < COMPONENT_MIN_WIDTH) {
                        if (indexCurDivider > 0) {
                            MultiSplitterPanel.this.xMove = -comp.getWidth() + COMPONENT_MIN_WIDTH;
                        } else {
                            MultiSplitterPanel.this.xMove = -comp.getWidth();
                        }
                    } else if (MultiSplitterPanel.this.xMove > 0 && (comp = (Component)MultiSplitterPanel.this.components.get(indexCurDivider + 1)).getWidth() <= COMPONENT_MIN_WIDTH) {
                        if (indexCurDivider == MultiSplitterPanel.this.dividers.size() - 1) {
                            MultiSplitterPanel.this.xMove = comp.getWidth();
                        } else {
                            MultiSplitterPanel.this.xMove = comp.getWidth() - COMPONENT_MIN_WIDTH;
                        }
                    }
                    this.pressFrom = dragTo;
                    MultiSplitterPanel.this.rerangeOffsprings();
                    MultiSplitterPanel.this.isDirty = true;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }
    }

    private class PlaceholderLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (MultiSplitterPanel.this.components == null || MultiSplitterPanel.this.components.isEmpty()) {
                return;
            }
            if (MultiSplitterPanel.this.orientation == 0) {
                if (MultiSplitterPanel.this.currentDraggedDivider != null) {
                    this.layoutDragged(parent);
                } else {
                    this.layoutInit(parent);
                }
            }
        }

        private void layoutDragged(Container parent) {
            int maxWidth = parent.getWidth() - 2;
            COMPONENT_MIN_WIDTH = (int)((double)maxWidth * 0.1) - 6;
            int countDivider = MultiSplitterPanel.this.dividers.size();
            int currentDividerIndex = 0;
            for (int i = 0; i < countDivider; ++i) {
                if (MultiSplitterPanel.this.currentDraggedDivider != MultiSplitterPanel.this.dividers.get(i)) continue;
                currentDividerIndex = i;
                break;
            }
            Component comp = (Component)MultiSplitterPanel.this.components.get(currentDividerIndex);
            comp.setBounds(comp.getX(), comp.getY(), comp.getWidth() + MultiSplitterPanel.this.xMove, comp.getHeight());
            MultiSplitterPanel.this.compsPercentage.put(comp.getName(), (double)(comp.getWidth() + 6 + MultiSplitterPanel.this.xMove) / (double)(maxWidth - 6));
            MultiSplitterPanel.this.currentDraggedDivider.setBounds(MultiSplitterPanel.this.currentDraggedDivider.getX() + MultiSplitterPanel.this.xMove, MultiSplitterPanel.this.currentDraggedDivider.getY(), 6, MultiSplitterPanel.this.currentDraggedDivider.getHeight());
            comp = (Component)MultiSplitterPanel.this.components.get(currentDividerIndex + 1);
            comp.setBounds(comp.getX() + MultiSplitterPanel.this.xMove, comp.getY(), comp.getWidth() - MultiSplitterPanel.this.xMove, comp.getHeight());
            MultiSplitterPanel.this.compsPercentage.put(comp.getName(), (double)(comp.getWidth() + 6 - MultiSplitterPanel.this.xMove) / (double)(maxWidth - 6));
        }

        private void layoutInit(Container parent) {
            int x = 0;
            int displacement = 0;
            int preDisplacement = 0;
            int height = parent.getHeight();
            int count = MultiSplitterPanel.this.dividers.size();
            int maxWidth = parent.getWidth() - 8;
            COMPONENT_MIN_WIDTH = (int)((double)maxWidth * 0.1) - 6;
            MultiSplitterPanel.this.compsPercentage.clear();
            for (int i = 0; i < count; ++i) {
                Divider divider = (Divider)MultiSplitterPanel.this.dividers.get(i);
                preDisplacement = (int)((double)maxWidth * (Double)MultiSplitterPanel.this.mapDividerInitLocation.get(divider));
                displacement = preDisplacement - displacement;
                displacement = displacement == 0 ? 0 : displacement - 6;
                ((Component)MultiSplitterPanel.this.components.get(i)).setBounds(x, 12, displacement, height - 24);
                double percentage = (double)(displacement == 0 ? 0 : displacement + 6) / (double)maxWidth;
                MultiSplitterPanel.this.compsPercentage.put(((Component)MultiSplitterPanel.this.components.get(i)).getName(), percentage);
                divider.setBounds(x += displacement, 1, 6, parent.getHeight() - 3);
                x += 6;
                displacement = preDisplacement;
            }
            if (MultiSplitterPanel.this.currentDraggedDivider == null) {
                ((Component)MultiSplitterPanel.this.components.get(MultiSplitterPanel.this.components.size() - 1)).setBounds(x, 12, parent.getWidth() - x, height - 24);
                MultiSplitterPanel.this.compsPercentage.put(((Component)MultiSplitterPanel.this.components.get(MultiSplitterPanel.this.components.size() - 1)).getName(), (double)(maxWidth + 6 - x) / (double)maxWidth);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

