/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.exception;

import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.InvalidCouponException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.NonExistRptException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.NonModuleLisenceException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.RptBinaryUnpackFailureException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.RptLisenceCheckException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.RptPermissionDeniedException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.UnDeployedRptVisitException;

public class ExtRptBizException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final int start = 10000;
    private int errorCode;
    private String errorMessage;

    private ExtRptBizException(Throwable cause, int errorCode, String errorMessage) {
        super(cause);
        if (cause instanceof ExtRptBizException) {
            ExtRptBizException source = (ExtRptBizException)cause;
            errorCode = source.errorCode - 10000;
            errorMessage = source.errorMessage;
        }
        this.init(errorCode, errorMessage);
    }

    private void init(int errorCode, String errorMessage) {
        this.errorCode = errorCode + 10000;
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return "source message: " + this.getMessage() + "\nbizMessage: " + this.errorMessage;
    }

    public static ExtRptBizException newLoginCtxException(Throwable cause) {
        return new ExtRptBizException(cause, 0, "failed to login");
    }

    public static ExtRptBizException newIllegalArgumentException(Throwable cause) {
        return new ExtRptBizException(cause, 1, "Illegal Argument Exception");
    }

    public static ExtRptBizException newUnknowException(Throwable cause) {
        return new ExtRptBizException(cause, 2, "unKnow exception");
    }

    public static ExtRptBizException newOrgListSQLExecuteException(Throwable cause) {
        return new ExtRptBizException(cause, 100, "can not fetch org list");
    }

    public static ExtRptBizException newRptListSQLExecuteException(Throwable cause) {
        return new ExtRptBizException(cause, 200, "can not fetch rpt list");
    }

    public static ExtRptBizException newOrgSwitchException(Throwable cause) {
        return new ExtRptBizException(cause, 300, "can not switch current org");
    }

    public static ExtRptBizException newRptVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 400, "can not create report page object");
    }

    public static ExtRptBizException newRptFilterVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 500, "can not load report's filter");
    }

    public static ExtRptBizException newRptExecuteException(Throwable cause) {
        return new ExtRptBizException(cause, 600, "can not execute report");
    }

    public static ExtRptBizException newSnapshotVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 700, "can not load snapshot data");
    }

    public static ExtRptBizException newSupplyValuesVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 800, "can not load supplyValues");
    }

    public static ExtRptBizException newParamJsonParseException(Throwable cause) {
        return ExtRptBizException.translateCause(cause, 9, "can not parse params from json");
    }

    public static ExtRptBizException newLicenseReleaseException(Throwable cause) {
        return new ExtRptBizException(cause, 1000, "can not release lisence");
    }

    public static ExtRptBizException newSnapshotFilterParseException(Throwable cause) {
        return new ExtRptBizException(cause, 1200, "can not parse filter values");
    }

    public static ExtRptBizException newSnapshotFilterVisitException(Throwable cause) {
        return ExtRptBizException.translateCause(cause, 13, "can not visit snapshot's filter");
    }

    public static ExtRptBizException newRptMessagesVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 1400, "can not visit rpt messages");
    }

    public static ExtRptBizException newRptKPIsVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 1500, "can not visit rpt messages");
    }

    public static ExtRptBizException newUserRptKPIsVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 1501, "can not visit user kpis");
    }

    public static ExtRptBizException newRptPicVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 1600, "can not visit message's pic data");
    }

    public static ExtRptBizException newRptSnapshotListVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 1700, "can not visit snapshot list");
    }

    public static ExtRptBizException newHyperlinkRptJsonException(Throwable cause) {
        return new ExtRptBizException(cause, 1900, "failed to anylysis report uuid");
    }

    public static ExtRptBizException newHyperlinkRptVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 1901, "\u627e\u4e0d\u5230\u76ee\u6807\u62a5\u8868");
    }

    public static ExtRptBizException newNoSnapshotCenterLisenceException() {
        return new ExtRptBizException(null, 2000, "no snapshot center lisence");
    }

    public static ExtRptBizException newCheckSnapshotCenterLisenceException(Throwable cause) {
        return new ExtRptBizException(cause, 2001, "failed to check snapshot center lisence");
    }

    public static ExtRptBizException newNonExistImgFileException() {
        return new ExtRptBizException(null, 2100, "img file not exist");
    }

    public static ExtRptBizException newFailed2LoadImgFileException(Throwable cause) {
        return new ExtRptBizException(cause, 2101, "failed to load img data");
    }

    public static ExtRptBizException newNoRptPermissionException() {
        return new ExtRptBizException(null, 2200, "\u62a5\u8868\u672a\u6388\u6743");
    }

    public static ExtRptBizException newFailed2LoadPubAcctsException(Throwable cause) {
        return new ExtRptBizException(cause, 2300, "failed to load pubAccts");
    }

    public static ExtRptBizException newPubAcctPicVisitException(Throwable cause) {
        return new ExtRptBizException(cause, 2400, "failed to load pubacct's pic");
    }

    public static ExtRptBizException newFailed2AccessWebkitPackageException(Throwable cause) {
        return new ExtRptBizException(cause, 2500, "failed to access webkit pacakge");
    }

    public static ExtRptBizException newFailed2LoadSettingPropertiesException(Throwable cause) {
        return new ExtRptBizException(cause, 2600, "failed to load setting.properties");
    }

    public static ExtRptBizException newFailed2TranslateDateFilterException(Throwable cause) {
        return new ExtRptBizException(cause, 2700, "failed to translate dateFilter json value");
    }

    public static ExtRptBizException newFailed2FetchManagerList(Throwable cause) {
        return new ExtRptBizException(cause, 2800, "failed to load mobile report manager list");
    }

    public static ExtRptBizException newFailed2CloudRptCenterEnable(Throwable cause) {
        return new ExtRptBizException(cause, 2900, "cloud report center is disable");
    }

    public static ExtRptBizException newFailed2LoadCloudRptCategorysException(Throwable cause) {
        return new ExtRptBizException(cause, 3100, "failed to load cloud report categorys");
    }

    public static ExtRptBizException newFailed2CheckCloudRptCategorysException(Throwable cause) {
        return new ExtRptBizException(cause, 3200, "failed to check cloud report categorys");
    }

    public static ExtRptBizException newFailed2LoadCloudRptsException(Throwable cause) {
        return new ExtRptBizException(cause, 4100, "failed to load cloud reports");
    }

    public static ExtRptBizException newFailed2SaveCloudRptsException(Throwable cause) {
        return new ExtRptBizException(cause, 4200, "failed to save cloud reports");
    }

    public static ExtRptBizException newCloudRptTempleException(String cloudRptNames) {
        return new ExtRptBizException(null, 4210, "cloud report temple '" + cloudRptNames + "' has structural exception");
    }

    public static ExtRptBizException newFailed2PublishCloudRptsException(Throwable cause) {
        return new ExtRptBizException(cause, 5300, "failed to publish cloud reports");
    }

    public static ExtRptBizException newFailed2PublishCloudRpts2GUIException(Throwable cause) {
        return new ExtRptBizException(cause, 5310, "failed to publish cloud report to GUI");
    }

    public static ExtRptBizException newFailed2PublishCloudRpts2PortalException(Throwable cause) {
        return new ExtRptBizException(cause, 5320, "failed to publish cloud report to Portal");
    }

    public static ExtRptBizException newFailed2PublishCloudRpts2BIException(Throwable cause) {
        return new ExtRptBizException(cause, 5330, "failed to publish cloud report to BI");
    }

    public static ExtRptBizException newFailed2PublishCloudRpts2MobileException(Throwable cause) {
        return new ExtRptBizException(cause, 5340, "failed to publish cloud report to Mobile");
    }

    public static ExtRptBizException newFailed2AuthCloudRptsException(Throwable cause) {
        return new ExtRptBizException(cause, 6400, "failed to auth cloud reports");
    }

    public static ExtRptBizException newFailed2LoadUserInfosException(Throwable cause) {
        return new ExtRptBizException(cause, 7000, "failed to load user infos");
    }

    public static ExtRptBizException newLisenceShortageException(Throwable cause) {
        return new ExtRptBizException(cause, 9999, "not enough lisence");
    }

    public static ExtRptBizException newLisenceCheckException(Throwable cause) {
        return new ExtRptBizException(cause, 9998, "checking lisence failed");
    }

    public static ExtRptBizException newFailed2DeleteCardContentExecute(Throwable cause) {
        return new ExtRptBizException(cause, 7990, "failed to delete Card Content");
    }

    public static ExtRptBizException newFailed2UpdateCardContent(Throwable cause) {
        return new ExtRptBizException(cause, 7991, "failed to update Card content");
    }

    public static ExtRptBizException newCardContentFailed2Execute(Throwable cause) {
        return new ExtRptBizException(cause, 7992, "failed to Execute");
    }

    public static ExtRptBizException newFailed2GetCardContent(Throwable cause) {
        return new ExtRptBizException(cause, 7993, "failed to Get Card content");
    }

    public static ExtRptBizException newCardDaoFailed2Execute(Throwable cause) {
        return new ExtRptBizException(cause, 7994, "failed to Execute");
    }

    public static ExtRptBizException newFailed2GetCardFilter(Throwable cause) {
        return new ExtRptBizException(cause, 7995, "failed to Get Card Filter");
    }

    public static ExtRptBizException newCardDaoFailed2GetCardList(Throwable cause) {
        return new ExtRptBizException(cause, 7996, "failed to Get Card List");
    }

    public static ExtRptBizException newCardDaoFailed2AddCard(Throwable cause) {
        return new ExtRptBizException(cause, 7997, "failed to Add Card");
    }

    public static ExtRptBizException newCardDaoFailed2DeleteCard(Throwable cause) {
        return new ExtRptBizException(cause, 7998, "failed to Delete Card");
    }

    public static ExtRptBizException newCardDaoFailed2GetCardId(Throwable cause) {
        return new ExtRptBizException(cause, 7999, "failed to Get Card Id");
    }

    public static ExtRptBizException newCardDaoFailed2OrderCard(Throwable cause) {
        return new ExtRptBizException(cause, 8000, "failed to Order Card");
    }

    private static ExtRptBizException translateCause(Throwable cause, int group, String tipMessage) {
        if (cause instanceof InvalidCouponException) {
            return new ExtRptBizException(cause, Integer.parseInt(group + "01"), tipMessage + " invalid rpt coupon");
        }
        if (cause instanceof NonExistRptException) {
            return new ExtRptBizException(cause, Integer.parseInt(group + "02"), tipMessage + " rpt is not exist");
        }
        if (cause instanceof NonModuleLisenceException) {
            return new ExtRptBizException(cause, Integer.parseInt(group + "03"), tipMessage + " no module lisence");
        }
        if (cause instanceof RptBinaryUnpackFailureException) {
            return new ExtRptBizException(cause, Integer.parseInt(group + "01"), tipMessage + " unpack rpt binary data failed");
        }
        if (cause instanceof RptLisenceCheckException) {
            return new ExtRptBizException(cause, Integer.parseInt(group + "04"), tipMessage + " no rpt lisence");
        }
        if (cause instanceof RptPermissionDeniedException) {
            return new ExtRptBizException(cause, Integer.parseInt(group + "05"), tipMessage + " permission denied");
        }
        if (cause instanceof UnDeployedRptVisitException) {
            return new ExtRptBizException(cause, Integer.parseInt(group + "06"), tipMessage + " rpt not deployed");
        }
        return new ExtRptBizException(cause, Integer.parseInt(group + "00"), tipMessage);
    }
}

