/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.server;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardVO;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CardDAO {
    private static Logger logger = CommonLogger.getLogger(CardDAO.class);
    private static final String TABLE_NAME = "T_EXT_MOBILECARD";
    private static final String COLUMN_FID = "FID";
    private static final String COLUMN_REPORTID = "FREPORTID";
    private static final String COLUMN_REPORTNAME = "FREPORTNAME";
    private static final String COLUMN_USERID = "FUSERID";
    private static final String COLUMN_CREATETIME = "FCREATEDATE";
    private static final String COLUMN_FILTER = "FFILTERCONTENT";
    private static final String COLUMN_DESCRIPTION = "FDESCRIPTION";
    private static final String COLUMN_ORDER = "FORDER";
    private static final String COLUMN_FILTERLEN = "FFILTERCONTENTLEN";
    private static final String COLUMN_CONTEXT = "FCONTEXT";

    public static ArrayList<CardVO> listCards(Context easCtx, String userId, int rowCount) throws ExtRptBizException {
        String sql = rowCount != -1 ? "select top " + rowCount + " " : "select ";
        sql = sql + "FID,FREPORTID,FREPORTNAME,FUSERID,FCREATEDATE from T_EXT_MOBILECARD where FUSERID =?  order by FORDER desc, FCREATEDATE desc";
        RptParams params = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        params.setObject("lstValue", queryValue);
        ArrayList<CardVO> ret = new ArrayList<CardVO>();
        try {
            ArrayList rowset = (ArrayList)CardDAO.executeQuery(params, sql, easCtx).getObject("object");
            for (HashMap item : rowset) {
                CardVO card = new CardVO();
                card.setFid((String)item.get(COLUMN_FID.toLowerCase()));
                card.setReportId((String)item.get(COLUMN_REPORTID.toLowerCase()));
                card.setReportName((String)item.get(COLUMN_REPORTNAME.toLowerCase()));
                card.setUserId((String)item.get(COLUMN_USERID.toLowerCase()));
                card.setCreateTime((Date)item.get(COLUMN_CREATETIME.toLowerCase()));
                ret.add(card);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2GetCardList(e);
        }
        return ret;
    }

    public static byte[] getCardFilterByReportId(Context easCtx, String reportId, String userId) throws ExtRptBizException {
        String sql = "select FFILTERCONTENTLEN from T_EXT_MOBILECARD where FREPORTID =? and FUSERID =? ";
        RptParams params = new RptParams();
        ArrayList<String> list = new ArrayList<String>();
        list.add(reportId);
        list.add(userId);
        params.setObject("lstValue", list);
        int filterLen = 0;
        ArrayList rowset = (ArrayList)CardDAO.executeQuery(params, sql, easCtx).getObject("object");
        for (HashMap item : rowset) {
            filterLen = Integer.parseInt(item.get(COLUMN_FILTERLEN.toLowerCase()).toString());
        }
        if (filterLen == 0) {
            return null;
        }
        byte[] filter = null;
        try {
            sql = "select FFILTERCONTENT from T_EXT_MOBILECARD where FREPORTID = '" + reportId + "' and " + COLUMN_USERID + " ='" + userId + "'";
            params.setObject("lstValue", null);
            params.setInt("length", filterLen);
            RptParams ps_r = CardDAO.executeBlobQuery(params, sql, easCtx);
            filter = (byte[])ps_r.getObject("content");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newFailed2GetCardFilter(e);
        }
        return filter;
    }

    public static byte[] getCardFilter(Context easCtx, String fid) throws ExtRptBizException {
        String sql = "select FFILTERCONTENT from T_EXT_MOBILECARD where FID = '" + fid + "'";
        byte[] filter = null;
        try {
            RptParams ps_r = CardDAO.executeBlobQuery(new RptParams(), sql, easCtx);
            filter = (byte[])ps_r.getObject("content");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newFailed2GetCardFilter(e);
        }
        return filter;
    }

    public static void addCard(Context easCtx, String reportId, String reportName, String userId, byte[] filter) throws ExtRptBizException {
        try {
            String sql = "insert into T_EXT_MOBILECARD(FID,FREPORTID,FREPORTNAME,FUSERID,FCREATEDATE,FFILTERCONTENT,FFILTERCONTENTLEN,FORDER,FDESCRIPTION,FCONTEXT) values(?,?,?,?,now(),?,?,?,?,?)";
            ArrayList<Object> list = new ArrayList<Object>();
            HashMap params = new HashMap();
            RunReportParam.putServerDefalutListParamsMap(easCtx, params);
            list.add(BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"01B5C2AE")).toString());
            list.add(reportId);
            list.add(reportName);
            list.add(userId);
            list.add(filter);
            list.add(filter == null ? 0 : filter.length);
            list.add(1);
            list.add("");
            list.add(JSONObject.toJSONString(params));
            CardDAO.execute(easCtx, sql, list);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2AddCard(e);
        }
    }

    public static void orderCard(Context easCtx, String userId, String[] idList) throws ExtRptBizException {
        try {
            for (int i = idList.length - 1; i >= 0; --i) {
                String reportId = idList[i];
                String sql = "update T_EXT_MOBILECARD set FORDER= ? where FREPORTID =? and FUSERID =?";
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(i);
                list.add(reportId);
                list.add(userId);
                CardDAO.execute(easCtx, sql, list);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2OrderCard(e);
        }
    }

    public static void deleteCard(Context easCtx, String fid) throws ExtRptBizException {
        try {
            String sql = "delete FROM T_EXT_MOBILECARD where FID=?";
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(fid);
            CardDAO.execute(easCtx, sql, list);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2DeleteCard(e);
        }
    }

    public static void deleteCardByReportId(Context easCtx, String reportId, String userId) throws ExtRptBizException {
        try {
            String sql = "delete FROM T_EXT_MOBILECARD where FREPORTID =? and FUSERID =? ";
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(reportId);
            list.add(userId);
            CardDAO.execute(easCtx, sql, list);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2DeleteCard(e);
        }
    }

    public static void deleteCardByReportId(Context easCtx, String reportId) throws ExtRptBizException {
        try {
            String sql = "delete FROM T_EXT_MOBILECARD where FREPORTID =? ";
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(reportId);
            CardDAO.execute(easCtx, sql, list);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2DeleteCard(e);
        }
    }

    public static void deleteCardContent(Context easCtx, String fcardid) throws ExtRptBizException {
        try {
            String sql = "delete FROM T_EXT_CARDCONTENT where fcardid = ? ";
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(fcardid);
            CardDAO.execute(easCtx, sql, list);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2DeleteCard(e);
        }
    }

    public static String getCardID(Context easCtx, String reportId, String userId) throws ExtRptBizException {
        String sql = "select FID from T_EXT_MOBILECARD where FREPORTID =? and FUSERID =?";
        RptParams params = new RptParams();
        ArrayList<String> list = new ArrayList<String>();
        list.add(reportId);
        list.add(userId);
        params.setObject("lstValue", list);
        String fid = "";
        try {
            ArrayList rowset = (ArrayList)CardDAO.executeQuery(params, sql, easCtx).getObject("object");
            for (HashMap item : rowset) {
                fid = (String)item.get(COLUMN_FID.toLowerCase());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2GetCardId(e);
        }
        return fid;
    }

    public static ArrayList<CardVO> getCardByReportId(Context easCtx, String reportId) throws ExtRptBizException {
        String sql = "select FID,FREPORTID,FREPORTNAME,FUSERID,FCREATEDATE,FCONTEXT FROM T_EXT_MOBILECARD where FREPORTID =? ";
        RptParams params = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportId);
        params.setObject("lstValue", queryValue);
        ArrayList<CardVO> ret = new ArrayList<CardVO>();
        try {
            ArrayList rowset = (ArrayList)CardDAO.executeQuery(params, sql, easCtx).getObject("object");
            for (HashMap item : rowset) {
                CardVO card = new CardVO();
                card.setFid((String)item.get(COLUMN_FID.toLowerCase()));
                card.setReportId((String)item.get(COLUMN_REPORTID.toLowerCase()));
                card.setReportName((String)item.get(COLUMN_REPORTNAME.toLowerCase()));
                card.setUserId((String)item.get(COLUMN_USERID.toLowerCase()));
                card.setCreateTime((Date)item.get(COLUMN_CREATETIME.toLowerCase()));
                card.setContext((String)item.get(COLUMN_CONTEXT.toLowerCase()));
                ret.add(card);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2GetCardList(e);
        }
        return ret;
    }

    public static ArrayList<CardVO> getCardByUserId(Context easCtx, String userId) throws ExtRptBizException {
        String sql = "select FID,FREPORTID,FREPORTNAME,FUSERID,FCREATEDATE FROM T_EXT_MOBILECARD where FUSERID =? ";
        RptParams params = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        params.setObject("lstValue", queryValue);
        ArrayList<CardVO> ret = new ArrayList<CardVO>();
        try {
            ArrayList rowset = (ArrayList)CardDAO.executeQuery(params, sql, easCtx).getObject("object");
            for (HashMap item : rowset) {
                CardVO card = new CardVO();
                card.setFid((String)item.get(COLUMN_FID.toLowerCase()));
                card.setReportId((String)item.get(COLUMN_REPORTID.toLowerCase()));
                card.setReportName((String)item.get(COLUMN_REPORTNAME.toLowerCase()));
                card.setUserId((String)item.get(COLUMN_USERID.toLowerCase()));
                card.setCreateTime((Date)item.get(COLUMN_CREATETIME.toLowerCase()));
                ret.add(card);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2GetCardList(e);
        }
        return ret;
    }

    public static ArrayList<CardVO> getCardByFid(Context easCtx, String fid) throws ExtRptBizException {
        String sql = "select FID,FREPORTID,FREPORTNAME,FUSERID,FCREATEDATE FROM T_EXT_MOBILECARD where FID =? ";
        RptParams params = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fid);
        params.setObject("lstValue", queryValue);
        ArrayList<CardVO> ret = new ArrayList<CardVO>();
        try {
            ArrayList rowset = (ArrayList)CardDAO.executeQuery(params, sql, easCtx).getObject("object");
            for (HashMap item : rowset) {
                CardVO card = new CardVO();
                card.setFid((String)item.get(COLUMN_FID.toLowerCase()));
                card.setReportId((String)item.get(COLUMN_REPORTID.toLowerCase()));
                card.setReportName((String)item.get(COLUMN_REPORTNAME.toLowerCase()));
                card.setUserId((String)item.get(COLUMN_USERID.toLowerCase()));
                card.setCreateTime((Date)item.get(COLUMN_CREATETIME.toLowerCase()));
                ret.add(card);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardDaoFailed2GetCardList(e);
        }
        return ret;
    }

    private static void execute(Context easCtx, String sql, ArrayList<Object> list) throws ExtRptBizException {
        try {
            logger.error((Object)("CardDao execute sql" + sql));
            RptParams params = new RptParams();
            params.setString("MethodName", "maintainRecord");
            params.setString("sql", sql);
            params.setObject("lstValue", list);
            params = easCtx == null ? ReportFacadeFactory.getRemoteInstance().commonExecute(params) : ReportFacadeFactory.getLocalInstance(easCtx).commonExecute(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getCause());
            throw ExtRptBizException.newCardDaoFailed2Execute(e);
        }
    }

    private static RptParams executeBlobQuery(RptParams params, String sql, Context easCtx) throws ExtRptBizException {
        try {
            logger.error((Object)("CardDao executeBlobQuery sql" + sql));
            params.setString("sql", sql);
            params.setString("MethodName", "getBlobBySQL");
            params = easCtx == null ? ReportFacadeFactory.getRemoteInstance().commonExecute(params) : ReportFacadeFactory.getLocalInstance(easCtx).commonExecute(params);
            return params;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getCause());
            throw ExtRptBizException.newCardDaoFailed2Execute(e);
        }
    }

    private static RptParams executeQuery(RptParams params, String sql, Context easCtx) throws ExtRptBizException {
        try {
            logger.error((Object)("CardDao executeQuery sql" + sql));
            params.setString("sql", sql);
            params.setString("MethodName", "getInfoListBySQL");
            params = easCtx == null ? ReportFacadeFactory.getRemoteInstance().commonExecute(params) : ReportFacadeFactory.getLocalInstance(easCtx).commonExecute(params);
            return params;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getCause());
            throw ExtRptBizException.newCardDaoFailed2Execute(e);
        }
    }
}

