/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.LocaleUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import java.awt.Component;
import java.awt.Window;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CtrlReportUtil {
    private static final Logger log = LogUtil.getLogger(CtrlReportUtil.class);
    private static final SimpleDateFormat sdf_yyyy_MM_dd_HH_mm_ss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    public static final SimpleDateFormat sdf_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat sdfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
    private static final String sstr_yyyy_MM_dd_HH_mm_ss_S = "yyyy-MM-dd HH:mm:ss.S";
    private static final String sstr_yyyy_MM_dd_HH_mm = "yyyy-MM-dd HH:mm";
    private static final String sstr_yyyy_MM_dd = "yyyy-MM-dd";
    public static final String strNull = "null";
    public static final String empty = "";
    public static final SimpleDateFormat sdfDateHHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static final String getObjectString(Object obj) {
        if (obj == null) {
            return empty;
        }
        String str = String.valueOf(obj).trim();
        if (str.equalsIgnoreCase(strNull) || str.length() == 0) {
            str = empty;
        }
        return str;
    }

    public static final String getToDay() {
        return sdf_yyyy_MM_dd_HH_mm_ss.format(new Date());
    }

    public static final String getDateFromTimestamp(Timestamp ts) {
        Date date = new Date(ts.getTime());
        return sdf_yyyy_MM_dd_HH_mm_ss.format(date);
    }

    public static final String formatDate(String in, String out, String date) {
        String strResult = empty;
        if (date != null && !date.replaceAll(strNull, empty).equals(empty)) {
            SimpleDateFormat sdfIn = new SimpleDateFormat(in);
            SimpleDateFormat sdfOut = new SimpleDateFormat(out);
            Date dat = null;
            try {
                dat = sdfIn.parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to parse date format:" + in);
            }
            strResult = sdfOut.format(dat);
        }
        return strResult;
    }

    public static final boolean isDate(String date) {
        boolean flag = false;
        if (!CtrlReportUtil.getObjectString(date).equals(empty)) {
            try {
                sdf_yyyy_MM_dd.parse(date);
                flag = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return flag;
    }

    private static String getFormatString(String date) {
        String formatString = sstr_yyyy_MM_dd_HH_mm_ss_S;
        if (date == null) {
            return formatString;
        }
        if ((date = date.trim()).replaceAll(strNull, empty).equals(empty)) {
            return formatString;
        }
        if (date.indexOf(":") < 0) {
            formatString = sstr_yyyy_MM_dd;
        } else {
            String[] str = date.split(":");
            if (str.length == 2) {
                formatString = sstr_yyyy_MM_dd_HH_mm;
            } else if (date.indexOf(".") < 0) {
                formatString = "yyyy-MM-dd HH:mm:ss";
            }
        }
        return formatString;
    }

    public static final String formatDateTime(String date) {
        String formatString = CtrlReportUtil.getFormatString(date);
        return CtrlReportUtil.formatDate(formatString, "yyyy-MM-dd HH:mm:ss", date);
    }

    public static final String formatDateTimeHHmm(String date) {
        String formatString = CtrlReportUtil.getFormatString(date);
        return CtrlReportUtil.formatDate(formatString, sstr_yyyy_MM_dd_HH_mm, date);
    }

    public static final String formatDateYMD(String date) {
        String formatString = CtrlReportUtil.getFormatString(date);
        return CtrlReportUtil.formatDate(formatString, sstr_yyyy_MM_dd, date);
    }

    public static final String formatDateTimeByStr(String date) {
        return CtrlReportUtil.formatDate(sstr_yyyy_MM_dd, sstr_yyyy_MM_dd, date);
    }

    public static final String formatDateTime(Date date) {
        return sdfDateTime.format(date);
    }

    public static final String formatTime(Date date) {
        return sdfTime.format(date);
    }

    public static final String formatDate(Date date) {
        return sdf_yyyy_MM_dd.format(date);
    }

    public static final String formatDateHHmm(Date date) {
        return sdfDateHHmm.format(date);
    }

    public static final long getDateLong(String str) throws ParseException {
        Date date = sdfDateTime.parse(str);
        return date.getTime();
    }

    public static final long getTimeLong(String str) throws ParseException {
        Date date = sdfTime.parse(str);
        return date.getTime();
    }

    public static final Date getStringDate(String str) throws ParseException {
        Date date = sdf_yyyy_MM_dd.parse(str);
        return date;
    }

    public static final Date getStringDateTime(String str) throws ParseException {
        Date date = sdfDateTime.parse(str);
        return date;
    }

    public static final String getOriginalLocaleString() {
        return CtrlReportUtil.getObjectString(LocaleUtil.getOriginalLocale((Locale)SysContext.getSysContext().getLocale()));
    }

    public static final HashMap getEaslocaleFromKDMultiLangBox(KDMultiLangBox mlb) {
        HashMap<String, String> ps = new HashMap<String, String>();
        int z = mlb.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)mlb.getItemAt(i);
            String key = LangUtil.makeLang((Locale)mli.getLang().getLocale());
            String val = (String)mli.getData();
            ps.put(key, val);
        }
        return ps;
    }

    public static final HashMap getMultiLangMap(String field, HashMap mapMultiLang) {
        field = field.toLowerCase();
        HashMap<String, String> map = new HashMap<String, String>();
        LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
        int z = lc.size();
        for (int i = 0; i < z; ++i) {
            LanguageInfo li = lc.get(i);
            String postfix = li.getLocale().toString().toLowerCase();
            map.put(field + "_" + postfix, CtrlReportUtil.getObjectString(mapMultiLang.get(postfix)));
        }
        return map;
    }

    public static final void setMultiLangSelectedVlaue(KDBizMultiLangBox kDBizMultiLangBoxName, String defaultValue) {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        int z = kDBizMultiLangBoxName.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)kDBizMultiLangBoxName.getItemAt(i);
            String ls = mli.getLang().getLocale().toString();
            if (!strLocal.equals(ls)) continue;
            kDBizMultiLangBoxName.setSelectedItem((Object)mli);
            kDBizMultiLangBoxName.setSelectedItemData((Object)defaultValue);
            break;
        }
    }

    public static final String bosToEasLang(String lstring) {
        String currentName = empty;
        if (lstring.equalsIgnoreCase("l1")) {
            currentName = "en_US";
        } else if (lstring.equalsIgnoreCase("l2")) {
            currentName = "zh_CN";
        } else if (lstring.equalsIgnoreCase("l3")) {
            currentName = "zh_TW";
        }
        return currentName;
    }

    public static final String easToBasLang(String estring) {
        String currentName = empty;
        if (estring.equalsIgnoreCase("en") || estring.equalsIgnoreCase("en_US")) {
            currentName = "l1";
        } else if (estring.equalsIgnoreCase("zh_CN")) {
            currentName = "l2";
        } else if (estring.equalsIgnoreCase("zh_TW")) {
            currentName = "l3";
        }
        return currentName;
    }

    public static final ArrayList getMultiLangInsertParams(HashMap mapMultiLang) {
        ArrayList<Object> lst = new ArrayList<Object>();
        ArrayList queryValue = new ArrayList();
        StringBuffer sb = new StringBuffer();
        StringBuffer sbsign = new StringBuffer();
        Iterator it = mapMultiLang.keySet().iterator();
        while (it.hasNext()) {
            String strNext = it.next().toString();
            sb.append(strNext).append(", ");
            sbsign.append("?, ");
            queryValue.add(mapMultiLang.get(strNext));
        }
        String insertSQL = sb.substring(0, sb.toString().length() - 2);
        String sign = sbsign.substring(0, sbsign.toString().length() - 2);
        lst.add(insertSQL);
        lst.add(sign);
        lst.add(queryValue);
        return lst;
    }

    public static final String getMultiLangUpdateSql(HashMap mapMultiLang) {
        StringBuffer sb = new StringBuffer();
        Iterator it = mapMultiLang.keySet().iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(" = ?, ");
        }
        return sb.substring(0, sb.toString().length() - 2);
    }

    public static final int javaType2DbType(String str) {
        int ret = 0;
        if ((str = str.toUpperCase(Locale.ENGLISH)).equals("NUMERIC") || str.equals("DECIMAL")) {
            return 2;
        }
        if (str.equals("DATE") || str.equals("TIME") || str.equals("DATETIME") || str.equals("TIMESTAMP")) {
            return 91;
        }
        if (str.equals("BOOLEAN")) {
            return 16;
        }
        if (str.equals("FLOAT") || str.equals("REAL") || str.equals("DOUBLE")) {
            return 8;
        }
        if (str.equals("INT") || str.equals("INTEGER") || str.equals("TINYINT") || str.equals("SMALLINT") || str.equals("NUMBER")) {
            return 4;
        }
        if (str.equals("BIGINT")) {
            return -5;
        }
        if (str.equals("STRING") || str.equals("CHAR")) {
            return 12;
        }
        return ret;
    }

    public static final int toExtColumnType(DataType datatype) {
        switch (datatype.intValue()) {
            case 0: {
                return 16;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 6: 
            case 7: {
                return 8;
            }
            case 8: {
                return 12;
            }
            case 9: {
                return 91;
            }
        }
        return 0;
    }

    public static final void addOtherCtrl(CoreUI ui, String name, String fid) {
        try {
            ui.setOprtState(name);
            ui.pubFireVOChangeListener(fid);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static final boolean isOtherCtrl(CoreUI ui, String name, String fid) {
        boolean isCtrl = false;
        try {
            ui.setOprtState(name);
            ui.pubFireVOChangeListener(fid);
        }
        catch (Throwable ex) {
            ui.handUIException(ex);
            isCtrl = true;
        }
        return isCtrl;
    }

    public static final void releaseCtrl(CoreUI ui, String fid) {
        try {
            ui.setOprtState("RELEASEALL");
            ui.pubFireVOChangeListener(fid);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static final long getSystemTime() {
        return System.currentTimeMillis();
    }

    public static final void closeWin(CoreUIObject ui) {
        Window parent = SwingUtilities.getWindowAncestor((Component)ui);
        parent.setVisible(false);
        parent.dispose();
    }

    public static final String trimStr(String str) {
        str = str.trim();
        while (str.indexOf("  ") != -1) {
            str = ExtStringUtil.replace(str, "  ", " ");
        }
        return str;
    }

    public static final String removeSpace(String str) {
        str = str.trim();
        while (str.indexOf(" ") != -1) {
            str = ExtStringUtil.replace(str, " ", empty);
        }
        return str;
    }

    public static final String strFilterSQL(String str) {
        if (str != null) {
            Pattern p = Pattern.compile("'");
            Matcher m = p.matcher(str);
            str = m.replaceAll("''");
        }
        return str;
    }

    public static final String artToExart(String str) {
        if (str != null && str.indexOf("@") != -1) {
            Pattern p = Pattern.compile("@");
            Matcher m = p.matcher(str);
            str = m.replaceAll("2xx3xx");
        }
        return str;
    }

    public static final String exartToArt(String str) {
        if (str != null && str.indexOf("2xx3xx") != -1) {
            Pattern p = Pattern.compile("2xx3xx");
            Matcher m = p.matcher(str);
            str = m.replaceAll("@");
        }
        return str;
    }

    public static final RptParams requestServiceMethod(String extrenalFullName, String extrenalMethod, List paramList) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("MethodName", (Object)"reflectMethod");
        pr.setObject("extrenalFullName", (Object)extrenalFullName);
        pr.setObject("extrenalMethod", (Object)extrenalMethod);
        if (null != paramList) {
            for (Map map : paramList) {
                String name = (String)map.keySet().iterator().next();
                pr.setObject(name, map.get(name));
            }
        }
        RptParams paramsReturn = FacadeFactory.commonExecuteNever(null, pr);
        return paramsReturn;
    }

    public static void main(String[] args) {
        CtrlReportUtil.formatDateTimeHHmm("2015/12/14 12:12:12.12");
        CtrlReportUtil.formatDateTimeByStr("2015-12-14");
        String str = "aaa";
        String[] arr = str.split(";");
        int len = arr.length;
        System.out.println(len);
    }
}

