/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.model;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.exec.ExtExecutor;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.io.BookIOController;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKds;
import com.kingdee.bos.ctrl.kds.io.kds.HighVersionException;
import com.kingdee.bos.ctrl.kds.io.kds.KDCompleteBookVersion;
import com.kingdee.bos.ctrl.kds.io.kds.KdsToBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.DataSetBaseFactory;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.ExtDataSetEnumFactory;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.ExtDataSetKSQLFactory;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.ExtDataSetTextFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ExtCompleteTempModel {
    private static Logger logger = LogUtil.getPackageLogger(ExtCompleteTempModel.class);
    private Book _exeBook;
    private Book _reslutBook;
    private String _version;
    private String _logs;
    private Book _tempBook;

    public ExtCompleteTempModel() {
    }

    public ExtCompleteTempModel(Book exeBook, Book reslutBook, String logs, String version) {
        this._tempBook = exeBook;
        this._reslutBook = reslutBook;
        this._version = version;
        this._logs = logs;
    }

    public void setTempBook(Book tempBook) {
        this._tempBook = tempBook;
    }

    public Book getTempBook() {
        return this._tempBook;
    }

    public void setExeBook(Book exeBook) {
        this._exeBook = exeBook;
    }

    public Book getExeBook() {
        return this._exeBook;
    }

    public void setReslutBook(Book reslutBook) {
        this._reslutBook = reslutBook;
    }

    public Book getReslutBook() {
        return this._reslutBook;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    public void setLog(String logs) {
        this._logs = logs;
    }

    public String getLogs() {
        return this._logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLog(File file) {
        if (StringUtils.isEmpty((String)this._logs)) {
            return;
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(this._logs.getBytes());
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{stream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{stream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportVersion(File file) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(KDCompleteBookVersion.getCurentVersion().getBytes());
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{stream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{stream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCompleteReport(File completeReport) throws Exception {
        String name = completeReport.getName().substring(0, completeReport.getName().length() - "complete-kds".length() - 1);
        FileOutputStream fout = null;
        ZipOutputStream zout = null;
        try {
            fout = new FileOutputStream(completeReport);
            zout = new ZipOutputStream(fout);
            BookIOController controller = new BookIOController();
            controller.appendIOMode(IBookFieldFlags.FLAG_BOOK_COMPLETEREPORT);
            ZipEntry entry = new ZipEntry(name + "." + "exe-kds");
            zout.putNextEntry(entry);
            zout.write(BookIOUtil.pack((Book)this._tempBook, (BookIOController)controller));
            if (!StringUtils.isEmpty((String)this._logs)) {
                entry = new ZipEntry(".log");
                zout.putNextEntry(entry);
                zout.write(this._logs.getBytes());
            }
            entry = new ZipEntry(".version");
            zout.putNextEntry(entry);
            zout.write((KDCompleteBookVersion.getCurentVersion() + "\n").getBytes());
            for (int i = 0; i < KDCompleteBookVersion.fileList.length; ++i) {
                zout.write((KDCompleteBookVersion.fileList[i] + "\n").getBytes());
            }
            if (this._reslutBook != null) {
                entry = new ZipEntry(name + "." + "kds");
                zout.putNextEntry(entry);
                BookToKds btk = new BookToKds();
                KDSDataOutputStream outPutStream = new KDSDataOutputStream((OutputStream)zout);
                btk.export(this._reslutBook, outPutStream);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{zout, fout});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{zout, fout});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCompleteReport(File completeReport) throws FileNotFoundException {
        ZipInputStream zis = null;
        FileInputStream fis = null;
        ZipEntry entry = null;
        fis = new FileInputStream(completeReport.getAbsolutePath());
        zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            while ((entry = zis.getNextEntry()) != null) {
                String temp = entry.getName();
                if (temp.endsWith(".version")) {
                    this._version = this.convertStreamToString(zis);
                    System.out.println(this._version);
                    continue;
                }
                if (temp.endsWith(".log")) {
                    this._logs = this.convertStreamToString(zis);
                    System.out.println(this._logs);
                    continue;
                }
                if (temp.endsWith("exe-kds")) {
                    try {
                        byte[] data = StreamUtil.readInputStream((InputStream)zis);
                        this._tempBook = BookIOUtil.unpack((byte[])data);
                        this._exeBook = BookIOUtil.unpack((byte[])data);
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                        continue;
                    }
                    catch (KDFException e) {
                        logger.error((Object)e);
                        continue;
                    }
                    catch (KDFSAXException e) {
                        logger.error((Object)e);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        continue;
                    }
                    ExtDataSetManager dataManager = this._exeBook.getDataSetManager();
                    HashMap<ExtDataSetType, DataSetBaseFactory> mapFactories = new HashMap<ExtDataSetType, DataSetBaseFactory>();
                    mapFactories.put(ExtDataSetType.TXT, new ExtDataSetTextFactory());
                    mapFactories.put(ExtDataSetType.SQL_KSQL, ExtDataSetKSQLFactory.getInstance());
                    mapFactories.put(ExtDataSetType.SQL_ENUM, ExtDataSetEnumFactory.getInstance());
                    ExtExecutor.exec((Book)this._exeBook, mapFactories, (Map)dataManager.getExecutionContext().getDataSetParameters(), null);
                    System.out.println("exe-kds");
                    continue;
                }
                if (!temp.endsWith("kds")) continue;
                KdsToBook ktb = new KdsToBook();
                try {
                    byte[] data = StreamUtil.readInputStream((InputStream)zis);
                    this._reslutBook = ktb.load(data);
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    continue;
                }
                catch (AuthorizationFailedException e) {
                    logger.error((Object)e);
                    continue;
                }
                catch (HighVersionException e) {
                    logger.error((Object)e);
                    continue;
                }
                System.out.println("kds");
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                fis.close();
                zis.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    private String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer sb = new StringBuffer();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return sb.toString().trim();
    }

    public boolean checkVersion() throws FileNotFoundException {
        if (this._version == null) {
            throw new FileNotFoundException();
        }
        String[] now = KDCompleteBookVersion.getCurentVersion().split("\\.");
        String[] versionInfo = this._version.split("\\n");
        String[] check = versionInfo[0].split("\\.");
        for (int i = 0; i < now.length; ++i) {
            if (check[i].compareTo(now[i]) <= 0) continue;
            return false;
        }
        return check.length - 1 <= now.length;
    }
}

