/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.bos.ctrl.kds.expans.model.data.FieldPermission;
import com.kingdee.bos.ctrl.kds.expans.model.data.FieldPermissionException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.util.ExtEASFusionUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class RptRuntimeCallbackImpl
implements IRptRuntimeCallback {
    private static Logger log = LogUtil.getPackageLogger(RptRuntimeCallbackImpl.class);
    private Context ctx;
    private String reportId;

    public RptRuntimeCallbackImpl(Context ctx, String reportId) {
        this.ctx = ctx;
        this.reportId = reportId;
    }

    public boolean hasPermission(FieldPermission fieldP) throws FieldPermissionException {
        RptParams params = new RptParams();
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.permission.FieldPermissionDAO");
        params.setString("MethodName", "queryFieldPermission");
        fieldP.setReportId(this.reportId);
        params.setObject("field_permission", (Object)fieldP);
        try {
            params = FacadeFactory.commonExecute(this.ctx, params);
        }
        catch (BOSException e) {
            String errInfo = "\u83b7\u53d6\u5b57\u6bb5(" + fieldP.getFieldName() + ")\u6743\u9650\u5931\u8d25\uff01";
            log.error((Object)errInfo, (Throwable)e);
            throw new FieldPermissionException(errInfo, (Throwable)e);
        }
        return ((FieldPermission)params.getObject("field_permission")).isHasPermission();
    }

    public String getReportId() {
        return this.reportId;
    }

    public Variant setRPTREF(List refList, Book book) {
        Variant variant = null;
        try {
            variant = ExtEASFusionUtil.clientCalc(this.ctx, new Date(), refList, book)[0];
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return variant;
    }
}

