/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.uiframe.IOutsideMenuEntrance;
import com.kingdee.eas.base.uiframe.OutsideMenuBizTypeEnum;
import com.kingdee.eas.base.uiframe.OutsideMenuEntranceInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionInfo;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ExtReportMenuEntrance
implements IOutsideMenuEntrance {
    public static final String[] EXTREPORTFORCUS = new String[]{"com.kingdee.eas.rpts.ctrlreport.client.ExtReportRunUI", "com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI"};
    public static final String[] EXTREPORT = new String[]{"com.kingdee.eas.rpts.sumreport.client.SumTaskListUI", "com.kingdee.eas.rpts.sumreport.client.UploadTaskListUI"};
    private static boolean _isApplyMenuPermission = true;
    private static boolean debug = false;

    public boolean isApplyMenuPermission() {
        return _isApplyMenuPermission;
    }

    public OutsideMenuEntranceInfo getOutsideMenuEntranceInfo(Context ctx) throws BOSException, EASBizException {
        if (debug) {
            System.out.println("==ExtReportMenuEntrance.getOutsideMenuEntranceInfo start");
        }
        MenuEntranceList lst = new MenuEntranceList();
        OutsideMenuEntranceInfo omei = new OutsideMenuEntranceInfo();
        omei.setType(OutsideMenuBizTypeEnum.REPORT_TYPE);
        if (ctx == null) {
            LicenseBo.LEAVE_COUNT = 0;
            PermissionBO.clearClientUserPermission();
        }
        HashMap resultMap = new HashMap();
        if (ExtReportMenuEntrance.isEmpty(ctx)) {
            if (null == ctx) {
                try {
                    CtrlReportUtil.requestServiceMethod("com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO", "importFromBos", null);
                }
                catch (Throwable throwable) {}
            } else {
                PermissionBO.importFromBos(ctx, null);
            }
        }
        String userId = null == ctx ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ctx.getCaller().toString();
        ArrayList listPermission = ExtReportMenuEntrance.getUserAllPermission(ctx, userId);
        ExtReportMenuEntrance.chgListToMap(listPermission, resultMap);
        List checkedList = ExtReportMenuEntrance.getItemListToBeChecked(resultMap);
        lst.addAll(checkedList);
        lst.addAll(ExtReportMenuEntrance.checkUploadAndSumPermission(ctx));
        omei.setList((List)lst);
        return omei;
    }

    private static final ArrayList getUserAllPermission(Context ctx, String userID) throws BOSException {
        String orgRangeSQL;
        String sqlPart1 = "select distinct p.FReportID, p.fpermission, r.FMenuID, r.FEasWebAppMenuId, r.FEasWebAppCenterId from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where p.FUserID = ? and p.FOrgID in (";
        String sqlPart2 = " )union all select distinct p.FReportID, p.fpermission, r.FMenuID, r.FEasWebAppMenuId, r.FEasWebAppCenterId from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where p.FUserID = ? and p.FOrgID is null union all select distinct p.FReportID, p.fpermission, r.FMenuID, r.FEasWebAppMenuId, r.FEasWebAppCenterId from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where p.froleid is not null and exists (select top 1 froleid from t_pm_userroleorg uro where uro.FUserID = ? and uro.froleid = p.froleid and exists (select top 1 forgid from t_pm_orgrange where fuserid = ? and ftype = ? and uro.FOrgID = forgid";
        String sqlPart3 = " )) union all select r.FID as FReportID,'0;0;0;0' fpermission, r.FMenuID, r.FEasWebAppMenuId,r.FEasWebAppCenterId from T_EXT_CloudReportDownloadList crdl left join (select * from T_BAS_DefineReport r where FCloudRptVersion is not null ) r on r.FCloudRptCenterId = crdl.FCloudRptId where  crdl.FUserId = ? and (r.fmenuid is not null or r.FEasWebAppCenterId is not null )";
        if (null == ctx) {
            if (userID == null) {
                userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            }
        } else if (userID == null) {
            userID = ctx.getCaller().toString();
        }
        ObjectUuidPK currentUserPK = new ObjectUuidPK(userID);
        try {
            orgRangeSQL = PermissionRangeHelper.getUserOrgIdRangeSQL((Context)ctx, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
        }
        catch (Exception ex) {
            throw new BOSException("can not get orgRangeSQL to find Permissions");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(sqlPart1).append(orgRangeSQL).append(sqlPart2).append(sqlPart3);
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(userID);
        queryValue.add(userID);
        queryValue.add(userID);
        queryValue.add(userID);
        queryValue.add(OrgRangeType.BIZ_ORG_TYPE.getValue());
        queryValue.add(userID);
        if (debug) {
            System.out.println("==getUserAllPermission sql:" + sqlBuffer.toString());
        }
        ArrayList listUserPermission = ExtDBUtil.getResultListBySql(ctx, sqlBuffer.toString(), queryValue);
        return listUserPermission;
    }

    private static final void chgListToMap(ArrayList listPermission, HashMap mapPermission) {
        if (listPermission != null) {
            if (mapPermission == null) {
                mapPermission = new HashMap<String, PermissionInfo>();
            }
            mapPermission.clear();
            for (HashMap map : listPermission) {
                String freportid = CtrlReportUtil.getObjectString(map.get("freportid"));
                String fmenuid = CtrlReportUtil.getObjectString(map.get("fmenuid"));
                String fpermission = CtrlReportUtil.getObjectString(map.get("fpermission"));
                String easWebAppMenuId = CtrlReportUtil.getObjectString(map.get("feaswebappmenuid"));
                String easWebAppCenterId = CtrlReportUtil.getObjectString(map.get("feaswebappcenterid"));
                if (debug) {
                    System.out.println("==freportid:" + freportid + " ==fmenuid:" + fmenuid + " ==fpermission:" + fpermission + " ==easWebAppMenuId:" + easWebAppMenuId + " ==easWebAppCenterId:" + easWebAppCenterId);
                }
                if (mapPermission.get(freportid) != null) {
                    StringBuffer joinPermission = new StringBuffer();
                    PermissionInfo info = (PermissionInfo)mapPermission.get(freportid);
                    String currentPermission = info.getPermission();
                    for (int i = 0; i < PermissionKind.PermissionKinds.length; ++i) {
                        joinPermission.append(ExtReportMenuEntrance.joioMaxPermission(PermissionKind.PermissionKinds[i], currentPermission, fpermission)).append(';');
                    }
                    joinPermission.deleteCharAt(joinPermission.length() - 1);
                    info.setPermission(joinPermission.toString());
                    continue;
                }
                PermissionInfo info = new PermissionInfo();
                info.setMenuID(fmenuid);
                info.setPermission(fpermission);
                info.setReportID(freportid);
                info.setEasWebAppMenuId(easWebAppMenuId);
                mapPermission.put(freportid, info);
            }
        }
    }

    private static final String joioMaxPermission(PermissionKind kind, String permission1, String permission2) {
        String flag2;
        String flag1 = PermissionKind.getPermissionString(permission1, kind);
        if (flag1.equals(flag2 = PermissionKind.getPermissionString(permission2, kind))) {
            return flag1;
        }
        int i1 = Integer.parseInt(flag1);
        int i2 = Integer.parseInt(flag2);
        i1 = Math.max(i1, i2);
        return String.valueOf(i1);
    }

    public static final boolean isEmpty(Context ctx) {
        try {
            ArrayList lst = ExtDBUtil.getResultListBySql(ctx, "select top 1 fuserid from T_EXT_Permission", null);
            return lst.isEmpty();
        }
        catch (BOSException e) {
            return false;
        }
    }

    private static List getCurrentUserBizOrgList(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        String userId = null == ctx ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ctx.getCaller().toString();
        ObjectUuidPK currentUserPK = new ObjectUuidPK(userId);
        OrgRangeCollection orgRange = PermissionRangeHelper.getUserOrgRange((Context)ctx, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
        Object[] orgArr = orgRange.toArray();
        for (int i = 0; i < orgArr.length; ++i) {
            Object obj = orgArr[i];
            if (!(obj instanceof OrgRangeInfo)) continue;
            OrgRangeInfo orgItem = (OrgRangeInfo)obj;
            resultList.add(orgItem.getOrg().getId().toString());
        }
        return resultList;
    }

    public static boolean checkFunctionPermission(Context ctx, String ui) throws BOSException, EASBizException {
        BOSUuid orgId;
        BOSUuid userId;
        IPermission permission;
        boolean result = false;
        if (ctx == null) {
            permission = PermissionFactory.getRemoteInstance();
            userId = SysContext.getSysContext().getCurrentUserInfo().getId();
            orgId = SysContext.getSysContext().getCurrentOrgUnit().getId();
        } else {
            permission = PermissionFactory.getLocalInstance((Context)ctx);
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)ctx.get((Object)"CurOU");
            orgId = orgUnit.getId();
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            userId = userInfo.getId();
        }
        ObjectUuidPK orgPk = new ObjectUuidPK(orgId);
        ObjectUuidPK userPk = new ObjectUuidPK(userId);
        if (EXTREPORT[0].equalsIgnoreCase(ui)) {
            result = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Make");
            if (!result) {
                boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Approve");
            }
            if (!result) {
                result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Upload");
            }
        } else if (EXTREPORT[1].equalsIgnoreCase(ui)) {
            result = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Make");
            if (!result) {
                boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Approve");
            }
            if (!result) {
                result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Upload");
            }
        } else {
            result = false;
        }
        return result;
    }

    private static List getItemListToBeChecked(HashMap itemMap) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String reportId : itemMap.keySet()) {
            String easAppCenterId;
            PermissionInfo info = (PermissionInfo)itemMap.get(reportId);
            String menuID = CtrlReportUtil.getObjectString(info.getMenuID());
            if (!resultList.contains(menuID)) {
                resultList.add(menuID);
            }
            if (resultList.contains(easAppCenterId = CtrlReportUtil.getObjectString(info.getEasWebAppMenuId()))) continue;
            resultList.add(easAppCenterId);
        }
        return resultList;
    }

    private static List getItemListToBeChecked(Context ctx, Set itemSet) throws BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT fid, FMenuID FROM T_BAS_DefineReport where FMenuID is not null");
        ArrayList dataList = ExtDBUtil.getResultListBySql(ctx, sb.toString(), null);
        for (HashMap map : dataList) {
            String menuID = CtrlReportUtil.getObjectString(map.get("fid"));
            BOSUuid bosUuid = BOSUuid.read((String)menuID);
            if (!itemSet.contains(bosUuid)) continue;
            String fmenuid = CtrlReportUtil.getObjectString(map.get("fmenuid"));
            resultList.add(fmenuid);
        }
        return resultList;
    }

    private static List checkUploadAndSumPermission(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        for (int index = 0; index < EXTREPORT.length; ++index) {
            if (!ExtReportMenuEntrance.checkFunctionPermission(ctx, EXTREPORT[index])) continue;
            idList.add(EXTREPORT[index]);
        }
        if (!idList.isEmpty()) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT fid,fuiclassname FROM T_PM_MainMenuItem WHERE fuiclassname IN ( ");
            for (int index = 0; index < idList.size(); ++index) {
                sqlBuffer.append("'");
                sqlBuffer.append(idList.get(index));
                sqlBuffer.append("',");
            }
            String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1) + ")";
            ArrayList menuIdList = ExtDBUtil.getResultListBySql(ctx, sql, null);
            for (HashMap map : menuIdList) {
                String menuId = CtrlReportUtil.getObjectString(map.get("fid"));
                resultList.add(menuId);
            }
        }
        return resultList;
    }

    private static class MenuEntranceList
    extends ArrayList {
        private static final long serialVersionUID = 2537380928073318532L;

        @Override
        public boolean contains(Object elem) {
            if (!_isApplyMenuPermission) {
                return true;
            }
            return super.contains(elem);
        }
    }
}

