/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.recycle.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.rpts.ctrlreport.client.MoveToNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ReportPathTreeDialog
extends SimpleDialog {
    private ReportPathTreeUI treeUI;

    ReportPathTreeDialog(KDDialog owner, boolean isMobile) {
        super((Dialog)owner);
        this.treeUI = new ReportPathTreeUI(isMobile);
        this.setTitle("\u62a5\u8868\u67e5\u627e");
        this.setComponent((Component)this.treeUI.getTreeView());
        this.setSize(800, 600);
        this.setResizable(false);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        TableLayout layout = (TableLayout)parent.getLayout();
        layout.rowStyle(0).setMargin(10);
        parent.add(this.getComponent(), thisCell);
    }

    protected boolean verify() {
        if (StringUtil.isEmptyString((String)this.getSystemID())) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u8fd8\u539f\u8def\u5f84\uff01");
            return false;
        }
        return super.verify();
    }

    boolean isOk() {
        return this.isOk;
    }

    String getSystemID() {
        return this.treeUI.getSystemID();
    }

    private class ReportPathTreeUI {
        private KDTree tree = new KDTree();
        private KDTreeView treeView = new KDTreeView(this.tree);
        private String reportType;

        private ReportPathTreeUI(boolean isMobile) {
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setAutoscrolls(true);
            this.reportType = isMobile ? "mobileReport" : "extReport";
            this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)MoveToNode.createTreeNode(this.reportType)));
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    Object object = ReportPathTreeUI.this.tree.getLastSelectedPathComponent();
                    if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
                        ReportPathTreeDialog.this.btnOk.setEnabled(true);
                    } else {
                        ReportPathTreeDialog.this.btnOk.setEnabled(false);
                    }
                }
            });
        }

        private String getSystemID() {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
            if (selectedNode == null) {
                return null;
            }
            return MoveToNode.getSystemID(selectedNode, this.reportType);
        }

        private KDTreeView getTreeView() {
            return this.treeView;
        }
    }
}

