/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.recycle.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.eas.rpts.ctrlreport.client.CellTreeNode2;
import com.kingdee.eas.rpts.ctrlreport.client.CellTreeRender3;
import com.kingdee.eas.rpts.ctrlreport.client.ExtMobileReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.recycle.DeletedReportInfo;
import com.kingdee.eas.rpts.ctrlreport.recycle.ReportRecycleBinException;
import com.kingdee.eas.rpts.ctrlreport.recycle.ReportRecycleBinFacade;
import com.kingdee.eas.rpts.ctrlreport.recycle.client.ReportPathTreeDialog;
import com.kingdee.eas.rpts.ctrlreport.recycle.server.IReportRecycleBinController;
import com.kingdee.eas.rpts.sumreport.enumtype.TempletType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;

public class ReportRecycleBinPanel
extends KDPanel {
    private static final int COL_ID = 0;
    private static final int COL_NAME = 1;
    private static final int COL_PATH = 2;
    private static final int COL_DELTIME = 3;
    private static final int COL_DELETER = 4;
    private static final int COL_ORG = 5;
    private static final int COL_CREATETIME = 6;
    private static final int COL_CREATOR = 7;
    private KDTable table;
    private IReportRecycleBinController rbController;

    public ReportRecycleBinPanel(boolean isMobile) {
        try {
            this.rbController = ReportRecycleBinFacade.getRemoteInst();
        }
        catch (ReportRecycleBinException e) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
            return;
        }
        this.setMobile(isMobile);
        this.initComponents();
        this.refreshTable();
    }

    private void initComponents() {
        this.table = new KDTable();
        this.table.setEditable(false);
        this.table.putDefaultRenderers(CellTreeNode2.class, (IBasicRender)new CellTreeRender3());
        this.table.getSelectManager().setSelectMode(10);
        this.table.addColumns(8);
        this.table.getColumn(0).getStyleAttributes().setHided(true);
        this.table.getColumn(1).setWidth(150);
        this.table.getColumn(2).setWidth(200);
        this.table.getColumn(5).setWidth(200);
        this.table.getColumn(3).setWidth(105);
        this.table.getColumn(4).setWidth(80);
        this.table.getColumn(6).setWidth(105);
        this.table.getColumn(7).setWidth(80);
        IRow rowHead = this.table.addHeadRow();
        rowHead.getCell(1).setValue((Object)"\u62a5\u8868\u540d\u79f0");
        rowHead.getCell(2).setValue((Object)"\u62a5\u8868\u8def\u5f84");
        rowHead.getCell(3).setValue((Object)"\u5220\u9664\u65f6\u95f4");
        rowHead.getCell(4).setValue((Object)"\u5220\u9664\u8005");
        rowHead.getCell(5).setValue((Object)"\u6240\u5c5e\u7ec4\u7ec7");
        rowHead.getCell(6).setValue((Object)"\u521b\u5efa\u65f6\u95f4");
        rowHead.getCell(7).setValue((Object)"\u521b\u5efa\u8005");
        this.setLayout(new BorderLayout());
        this.add((Component)this.table, "Center");
    }

    void setMobile(boolean isMobile) {
        this.rbController.setMobile(isMobile);
    }

    boolean isMobile() {
        return this.rbController.isMobile();
    }

    void refreshTable() {
        List<DeletedReportInfo> rptInfos = null;
        try {
            rptInfos = this.rbController.getAllDeletedReports();
        }
        catch (ReportRecycleBinException e) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
            return;
        }
        this.fillTableData(rptInfos);
    }

    private void fillTableData(List<DeletedReportInfo> deletedReportInfo) {
        this.table.removeRows();
        if (deletedReportInfo == null || deletedReportInfo.isEmpty()) {
            return;
        }
        String delTime = null;
        String createTime = null;
        DefaultKingdeeTreeNode rootNode = this.isMobile() ? CommonTreeModel.getMobileTreeModel() : CommonTreeModel.getPackageTreeModel(null);
        HashMap<String, String> mapPath = new HashMap<String, String>();
        for (DeletedReportInfo rptInfo : deletedReportInfo) {
            IRow row = this.table.addRow();
            row.setUserObject((Object)rptInfo);
            row.getCell(0).setValue((Object)rptInfo.getId());
            CellTreeNode2 cellNode = new CellTreeNode2(this.table, row.getCell(1));
            cellNode.setValue(CtrlReportUtil.getObjectString(rptInfo.getReportName()));
            cellNode.setTreeLevel(0);
            TempletType ftemplettype = TempletType.getTempletType(CtrlReportUtil.getObjectString(rptInfo.getTemplateType()));
            if (ftemplettype.equals(TempletType.SUM)) {
                cellNode.setIcon(ResourceManager.getIcon(ExtReportManageUI.class, (String)"report_type_sum.png"));
            } else if (ftemplettype.equals(TempletType.UPLOAD)) {
                cellNode.setIcon(ResourceManager.getIcon(ExtReportManageUI.class, (String)"report_type_upload.png"));
            } else if (ftemplettype.equals(TempletType.MOBILE)) {
                cellNode.setIcon(ResourceManager.getIcon(ExtMobileReportManageUI.class, (String)"report_type_mobile.png"));
            } else {
                cellNode.setIcon(ResourceManager.getIcon(ExtReportManageUI.class, (String)"report_type_normal.png"));
            }
            row.getCell(1).setValue((Object)cellNode);
            String systemId = rptInfo.getSystemId();
            String path = (String)mapPath.get(systemId);
            if (StringUtil.isEmptyString((String)path)) {
                path = this.convertToSystemPath(rootNode, systemId);
                mapPath.put(systemId, path);
            }
            row.getCell(2).setValue((Object)path);
            if (rptInfo.getDeleteTime() != null) {
                delTime = CtrlReportUtil.formatDateHHmm(rptInfo.getDeleteTime());
            }
            row.getCell(3).setValue((Object)delTime);
            row.getCell(4).setValue((Object)rptInfo.getDeleterName());
            row.getCell(5).setValue((Object)rptInfo.getOrgName());
            createTime = CtrlReportUtil.formatDateHHmm(rptInfo.getCreateTime());
            row.getCell(6).setValue((Object)createTime);
            row.getCell(7).setValue((Object)rptInfo.getCreatorName());
        }
    }

    private String convertToSystemPath(DefaultKingdeeTreeNode rootNode, String systemId) {
        String path = systemId;
        Enumeration enu = rootNode.children();
        while (enu.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enu.nextElement();
            if (this.isMobile()) {
                PubAcctsDAO.PubAcct pubAcctNode = (PubAcctsDAO.PubAcct)node.getUserObject();
                if (!pubAcctNode.fid.equals(systemId)) continue;
                return pubAcctNode.name;
            }
            BriefViewTreeNode briefNode = (BriefViewTreeNode)node.getUserObject();
            MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)briefNode.getUserObject();
            String packageName = briefInfo.getPackgeName();
            boolean isStart = systemId.startsWith(packageName);
            if (!isStart) continue;
            boolean isEnd = systemId.endsWith(packageName.substring(packageName.lastIndexOf("."), packageName.length()));
            if (StringUtils.isNotEmpty((String)systemId) && systemId.equals("com.kingdee.bos.workflow.metas.workflow")) {
                isEnd = true;
            }
            if (isEnd) {
                TreeNode[] nodes = node.getPath();
                path = "";
                for (TreeNode pathNode : nodes) {
                    path = path + ((DefaultKingdeeTreeNode)pathNode).getText() + "/";
                }
                if (!StringUtil.isEmptyString((String)path)) {
                    path = path.substring(path.indexOf("/") + 1, path.length() - 1);
                }
                return path;
            }
            if (node.getChildCount() <= 0 || (path = this.convertToSystemPath(node, systemId)).equals(systemId)) continue;
            return path;
        }
        return path;
    }

    void deleteSelectedReportInfos() {
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.table);
        if (rowIndexs == null || rowIndexs.length == 0) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u62a5\u8868\uff01");
            return;
        }
        if (!MessageUtil.msgboxOkCancel((Component)((Object)this), (String)"\u786e\u5b9a\u8981\u6c38\u4e45\u6027\u5730\u5220\u9664\u9009\u4e2d\u7684\u62a5\u8868\u5417\uff1f")) {
            return;
        }
        if (rowIndexs.length == this.table.getRowCount()) {
            try {
                this.rbController.deleteAllReportInfo();
            }
            catch (ReportRecycleBinException e) {
                MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
                return;
            }
            this.table.removeRows();
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int rowIndex : rowIndexs) {
            idList.add((String)this.table.getRow(rowIndex).getCell(0).getValue());
        }
        try {
            this.rbController.deleteReportInfoByIds(idList);
        }
        catch (ReportRecycleBinException e) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
            return;
        }
        for (int i = rowIndexs.length - 1; i >= 0; --i) {
            this.table.removeRow(rowIndexs[i]);
        }
    }

    void filterDeletedReportInfo(DeletedReportInfo reportInfo) {
        List<DeletedReportInfo> rptInfos;
        try {
            rptInfos = this.rbController.filterDeletedReportInfo(reportInfo);
        }
        catch (ReportRecycleBinException e) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
            return;
        }
        this.fillTableData(rptInfos);
    }

    void restoreSelectedReportInfos() {
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.table);
        if (rowIndexs == null || rowIndexs.length == 0) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fd8\u539f\u7684\u62a5\u8868\uff01");
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<DeletedReportInfo> rptListNoPath = new ArrayList<DeletedReportInfo>();
        for (int rowIndex : rowIndexs) {
            IRow row = this.table.getRow(rowIndex);
            DeletedReportInfo rptInfo = (DeletedReportInfo)row.getUserObject();
            if (rptInfo.getSystemId().equals(row.getCell(2).getValue())) {
                rptListNoPath.add((DeletedReportInfo)row.getUserObject());
                continue;
            }
            idList.add((String)this.table.getRow(rowIndex).getCell(0).getValue());
        }
        if (idList.size() == this.table.getRowCount()) {
            try {
                this.rbController.restoreAllReportInfo();
            }
            catch (ReportRecycleBinException e) {
                MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
                return;
            }
            this.table.removeRows();
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u5df2\u6210\u529f\u8fd8\u539f\u5168\u90e8\u62a5\u8868!");
            return;
        }
        if (!idList.isEmpty()) {
            try {
                this.rbController.restoreReportInfoByIds(idList);
            }
            catch (ReportRecycleBinException e) {
                MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
                return;
            }
            for (int i = rowIndexs.length - 1; i >= 0; --i) {
                this.table.removeRow(rowIndexs[i]);
            }
        }
        if (rptListNoPath.isEmpty() && !idList.isEmpty()) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)("\u6210\u529f\u8fd8\u539f[" + idList.size() + "]\u5f20\u62a5\u8868!"));
        } else if (!rptListNoPath.isEmpty()) {
            this.restoreNoPath(rptListNoPath, idList.size());
        }
    }

    private void restoreNoPath(List<DeletedReportInfo> rptListNoPath, int success) {
        ArrayList<String> idList = new ArrayList<String>();
        String detail = "";
        for (DeletedReportInfo rptInfo : rptListNoPath) {
            detail = detail + rptInfo.getReportName() + "\uff1a\u627e\u4e0d\u5230\u62a5\u8868\u8def\u5f84\n";
            idList.add(rptInfo.getId());
        }
        int returnValue = MessageDialog.show((Component)((Object)this), (Object)("\u6210\u529f\u8fd8\u539f" + success + "\u5f20\uff0c\u5931\u8d25" + rptListNoPath.size() + "\u5f20\u3002\u662f\u5426\u9009\u62e9\u5176\u4ed6\u4fdd\u5b58\u8def\u5f84\u7ee7\u7eed\u8fd8\u539f\u64cd\u4f5c\uff1f"), (String)"\u4fe1\u606f\u63d0\u793a", (int)0, (int)3, (String)detail);
        if (returnValue == 0) {
            ReportPathTreeDialog treeDialog = new ReportPathTreeDialog((KDDialog)SwingUtilities.getWindowAncestor((Component)((Object)this)), this.isMobile());
            treeDialog.showDialog();
            if (!treeDialog.isOk()) {
                return;
            }
            String systemId = treeDialog.getSystemID();
            try {
                this.rbController.restoreReportInfoBySystemId(idList, systemId);
                this.refreshTable();
            }
            catch (ReportRecycleBinException e) {
                MessageUtil.msgboxInfo((Component)((Object)this), (String)e.getMessage());
                return;
            }
        }
    }
}

