/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.subrpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportGuiExecutor;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.web.util.ReportBookHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubReportWebExecutor {
    private Context _ctx;
    private Book _book;

    public SubReportWebExecutor(Book mainBook, Context ctx) {
        this._ctx = ctx;
        this._book = mainBook;
    }

    public void exec() throws Exception {
        int sheetCount = this._book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = this._book.getSheet(i);
            List cells = sheet.getSubReportCells();
            if (cells == null || cells.isEmpty()) continue;
            for (Cell cell : cells) {
                SubReportInfo subReportInfo = cell.getSubReportInfo();
                if (subReportInfo == null) continue;
                ReportProperties rptProps = subReportInfo.getReportProps();
                String systemId = rptProps.getPath();
                String name = rptProps.getName();
                String orgId = rptProps.getDomain();
                String rptId = rptProps.getId();
                Map params = subReportInfo.getParams();
                WebParamAdapter adapter = null;
                byte[] bookData = subReportInfo.getBookData();
                if (bookData == null) {
                    adapter = new WebParamAdapter(this._ctx, name, systemId, orgId, rptId);
                    adapter.setLicenseChecked(true);
                    HashMap mapDesignParam = new HashMap();
                    if (params != null) {
                        ExtProps extProps = cell.getExtProps(false);
                        extProps.executeParams(params);
                        ReportBookHelper.executeParamsDefaultValue(this._ctx, params, null, rptProps);
                        mapDesignParam.putAll(params);
                    }
                    RunReportParam.putServerDefalutListParamsMap(this._ctx, mapDesignParam);
                    bookData = adapter.executeSubReport(mapDesignParam);
                }
                if (bookData == null) {
                    cell.setValue(new Variant((Object)"\u627e\u4e0d\u5230\u5b50\u62a5\u8868"));
                    continue;
                }
                subReportInfo.setBookData(bookData);
                SubReportGuiExecutor.addSubReportEmbed((Cell)cell, null);
                if (null == adapter) continue;
                Book subBook = adapter.getBook();
                subReportInfo.setBook(subBook);
                SubReportGuiExecutor.noMutilLevelSubReport((Book)subBook);
            }
        }
    }

    public void setMainBook(Book book) {
        this._book = book;
    }
}

