/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.util;

import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.monitor.LicenseClientUtil;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.client.EASResource;

public class LicenseControllerUtil {
    public static String constructLicenseMessage(String className) {
        String licenseMessage = null;
        try {
            LicenseController lc = FrameWorkClientUtils.getLicenseController();
            String moduleByPackage = lc.getModuleByPackage(className);
            if (moduleByPackage == null) {
                return null;
            }
            licenseMessage = LicenseControllerUtil.constructLicenseMessageByModuleName(moduleByPackage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return licenseMessage;
    }

    public static String constructLicenseMessageByModuleName(String moduleName) {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ModuleName"));
            if (moduleName == null || moduleName.trim().length() == 0) {
                return null;
            }
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)moduleName) + "[" + moduleName + "]");
            buffer.append("\n");
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_SubSystem"));
            String subSysName = LicenseClientUtil.getSubSystemNameByModularName((String)moduleName);
            if (subSysName == null || subSysName.trim().length() == 0) {
                return null;
            }
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)subSysName) + "[" + subSysName + "]");
            buffer.append("\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }
}

