/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.ui.editor.styled.SQLStyledEditor;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractCurrentSQLUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class CurrentSQLUI
extends AbstractCurrentSQLUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CurrentSQLUI.class);
    private boolean isinitLayout = false;
    private HashMap logMap;
    private SQLStyledEditor textKSQL;
    private SQLStyledEditor textDialectSQL;
    private KDRadioButton rbMySql;
    private KDRadioButton rbPostgreSQL;
    private KDRadioButton rbKingbase;

    public CurrentSQLUI() throws Exception {
        this.initLayout();
        this.labelUseTime.setHorizontalAlignment(4);
        this.kDButtonGroup1.add((AbstractButton)this.rbSqlServer);
        this.kDButtonGroup1.add((AbstractButton)this.rbOracle);
        this.kDButtonGroup1.add((AbstractButton)this.rbDB2);
        this.kDButtonGroup1.add((AbstractButton)this.rbMySql);
        this.kDButtonGroup1.add((AbstractButton)this.rbPostgreSQL);
        this.kDButtonGroup1.add((AbstractButton)this.rbKingbase);
        this.textKSQL = new SQLStyledEditor();
        this.kDScrollPane1.getViewport().add((Component)this.textKSQL, null);
        this.textDialectSQL = new SQLStyledEditor();
        this.kDScrollPane2.getViewport().add((Component)this.textDialectSQL, null);
    }

    @Override
    public void initUIContentLayout() {
        this.rbMySql = new KDRadioButton();
        this.rbMySql.setName("rbMySql");
        this.rbMySql.setText("MySql");
        this.rbPostgreSQL = new KDRadioButton();
        this.rbPostgreSQL.setName("rbPostgreSQL");
        this.rbPostgreSQL.setText("PostgreSQL");
        this.rbKingbase = new KDRadioButton();
        this.rbKingbase.setName("rbKingbase");
        this.rbKingbase.setText("Kingbase");
        this.setBounds(new Rectangle(10, 10, 800, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 800, 600));
        this.btnClose.setBounds(new Rectangle(719, 563, 73, 21));
        this.add((Component)this.btnClose, new KDLayout.Constraints(719, 563, 73, 21, 10));
        this.kDSeparator2.setBounds(new Rectangle(-4, 556, 809, 10));
        this.add((Component)this.kDSeparator2, new KDLayout.Constraints(-4, 556, 809, 10, 10));
        this.kDScrollPane1.setBounds(new Rectangle(8, 6, 781, 253));
        this.add((Component)this.kDScrollPane1, new KDLayout.Constraints(8, 6, 781, 253, 15));
        this.btnTraslate.setBounds(new Rectangle(498, 245, 77, 19));
        this.add((Component)this.btnTraslate, new KDLayout.Constraints(498, 245, 77, 19, 0));
        this.rbSqlServer.setBounds(new Rectangle(10, 245, 98, 19));
        this.add((Component)this.rbSqlServer, new KDLayout.Constraints(10, 245, 98, 19, 0));
        this.rbOracle.setBounds(new Rectangle(101, 245, 64, 19));
        this.add((Component)this.rbOracle, new KDLayout.Constraints(101, 245, 64, 19, 0));
        this.rbDB2.setBounds(new Rectangle(175, 245, 56, 19));
        this.add((Component)this.rbDB2, new KDLayout.Constraints(175, 245, 56, 19, 0));
        this.rbMySql.setBounds(new Rectangle(235, 245, 56, 19));
        this.add((Component)this.rbMySql, new KDLayout.Constraints(235, 245, 66, 19, 0));
        this.rbPostgreSQL.setBounds(new Rectangle(300, 245, 88, 19));
        this.add((Component)this.rbPostgreSQL, new KDLayout.Constraints(300, 245, 88, 19, 0));
        this.rbKingbase.setBounds(new Rectangle(400, 245, 88, 19));
        this.add((Component)this.rbKingbase, new KDLayout.Constraints(400, 245, 88, 19, 0));
        this.kDScrollPane2.setBounds(new Rectangle(7, 268, 781, 256));
        this.add((Component)this.kDScrollPane2, new KDLayout.Constraints(7, 268, 781, 256, 0));
        this.btnTestTime.setBounds(new Rectangle(625, 563, 87, 21));
        this.add((Component)this.btnTestTime, new KDLayout.Constraints(625, 563, 87, 21, 10));
        this.labelUseTime.setBounds(new Rectangle(457, 565, 163, 19));
        this.add((Component)this.labelUseTime, new KDLayout.Constraints(457, 565, 163, 19, 10));
    }

    public void onLoad() throws Exception {
        String dbTypeString;
        super.onLoad();
        String sql = CtrlReportUtil.getObjectString(this.logMap.get("sql"));
        if (!sql.equals("")) {
            String sqlFlag = sql.toLowerCase(Locale.ENGLISH);
            if (sqlFlag.startsWith("/*dialect*/")) {
                this.btnTraslate.setEnabled(false);
            }
            this.textKSQL.setText(sql);
            String useTime = CtrlReportUtil.getObjectString(this.logMap.get("useTime"));
            this.labelUseTime.setText(useTime);
        }
        if (!(dbTypeString = CtrlReportUtil.getObjectString(this.logMap.get("dbType"))).equals("")) {
            int dbType = Integer.parseInt(dbTypeString);
            if (dbType == 3) {
                this.rbSqlServer.setSelected(true);
            } else if (dbType == 2) {
                this.rbOracle.setSelected(true);
            } else if (dbType == 1) {
                this.rbDB2.setSelected(true);
            } else if (dbType == 6) {
                this.rbMySql.setSelected(true);
            } else if (dbType == 5) {
                this.rbPostgreSQL.setSelected(true);
            } else if (dbType == 12) {
                this.rbKingbase.setSelected(true);
            }
        }
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    @Override
    protected void btnTraslate_actionPerformed(ActionEvent e) throws Exception {
        int dbType = -1;
        if (this.rbSqlServer.isSelected()) {
            dbType = 3;
        } else if (this.rbOracle.isSelected()) {
            dbType = 2;
        } else if (this.rbDB2.isSelected()) {
            dbType = 1;
        } else if (this.rbMySql.isSelected()) {
            dbType = 6;
        } else if (this.rbPostgreSQL.isSelected()) {
            dbType = 5;
        } else if (this.rbKingbase.isSelected()) {
            dbType = 12;
        } else {
            return;
        }
        String dialectSQL = TransUtil.Translate((String)this.textKSQL.getText(), (int)dbType);
        this.textDialectSQL.setText(dialectSQL);
    }

    @Override
    protected void btnTestTime_actionPerformed(ActionEvent e) throws Exception {
        String sql = CtrlReportUtil.getObjectString(this.logMap.get("sql"));
        if (!sql.equals("")) {
            try {
                IRowSet rs = CtrlDesignDataExecutor.execute("", sql, this.logMap, 0, -1);
                if (rs != null) {
                    rs.close();
                }
                String useTime = CtrlReportUtil.getObjectString(this.logMap.get("useTime"));
                this.labelUseTime.setText(useTime);
            }
            catch (Exception e1) {
                logger.debug((Object)e1);
            }
        }
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    public void setLogMap(HashMap logMap) {
        this.logMap = logMap;
    }
}

