/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.dlg.FormulaMiniWizardDialog;
import com.kingdee.bos.ctrl.ext.util.CalExprUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractDefaultDateTimeValueUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DefaultDateValueUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DefaultDateTimeValueUI
extends AbstractDefaultDateTimeValueUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DefaultDateTimeValueUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = false;
    private int dataType = 4;
    protected KDSeparator kDSeparator1;
    protected KDButton btnFunc;
    protected KDRadioButton rbFormula;
    protected KDTextField rbFormulaField;

    public DefaultDateTimeValueUI() throws Exception {
        this.init();
        this.initLayout();
        this.kDButtonGroup1.add((AbstractButton)this.rbSystem);
        this.kDButtonGroup1.add((AbstractButton)this.rbFix);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateAdd);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateSub);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthBegin);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthEnd);
        this.kDButtonGroup1.add((AbstractButton)this.rbFormula);
        this.kDButtonGroup2.add((AbstractButton)this.rbFixTime);
        this.kDButtonGroup2.add((AbstractButton)this.rbSystemTime);
        this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
        this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
    }

    private void init() throws ClassNotFoundException, IOException {
        this.resHelper = new ResourceBundleHelper(DefaultDateValueUI.class.getName());
        this.kDSeparator1 = new KDSeparator();
        this.btnFunc = new KDButton();
        this.rbFormula = new KDRadioButton();
        this.rbFormulaField = new KDTextField();
        this.kDSeparator1.setName("kDSeparator1");
        this.btnFunc.setName("btnFunc");
        this.rbFormula.setName("rbFormula");
        this.rbFormulaField.setName("rbFormulaField");
        this.rbFormula.setText(this.resHelper.getString("rbFormula.text"));
        this.btnFunc.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_formulaguide.gif"));
        this.btnFunc.setLimitedSize(false);
        this.btnFunc.setOpaque(false);
        this.btnFunc.setBorder(null);
        this.btnFunc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultDateTimeValueUI.this.beforeActionPerformed(e);
                try {
                    DefaultDateTimeValueUI.this.btnFunc_actionPerformed(e);
                }
                catch (Exception exc) {
                    DefaultDateTimeValueUI.this.handUIException(exc);
                }
                finally {
                    DefaultDateTimeValueUI.this.afterActionPerformed(e);
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setBounds(new Rectangle(10, 10, 400, 292));
        this.kDSeparator2.setBounds(new Rectangle(0, 195, 392, 8));
        this.btnConfirm.setBounds(new Rectangle(166, 235, 73, 21));
        this.btnCancel.setBounds(new Rectangle(316, 235, 73, 21));
        this.btnClear.setBounds(new Rectangle(241, 235, 73, 21));
        this.rbFormula.setBounds(13, 202, 80, 19);
        this.add((Component)this.rbFormula, null);
        this.rbFormulaField.setBounds(100, 202, 150, 19);
        this.add((Component)this.rbFormulaField, null);
        this.btnFunc.setBounds(255, 202, 20, 19);
        this.add((Component)this.btnFunc);
        this.kDSeparator1.setBounds(new Rectangle(0, 227, 401, 8));
        this.add((Component)this.kDSeparator1, null);
    }

    public DefaultDateTimeValueUI(String value, int dataType) throws Exception {
        this();
        SimpleDateFormat sdf;
        String formatString;
        String unit;
        this.dataType = dataType;
        this.initDateFormat();
        String dateValue = value;
        String timeValue = "";
        if (value.indexOf("|") != -1) {
            String[] arr = value.split("\\|");
            dateValue = arr[0];
            timeValue = arr[1];
        }
        if (dateValue.startsWith("getSystemDate()")) {
            this.rbSystem.setSelected(true);
        } else if (dateValue.startsWith("dayBegin")) {
            this.rbMonthBegin.setSelected(true);
        } else if (dateValue.startsWith("dayEnd")) {
            this.rbMonthEnd.setSelected(true);
        } else if (dateValue.startsWith("dateAdd + ")) {
            this.rbDateAdd.setSelected(true);
            dateValue = ExtStringUtil.replace(dateValue, "dateAdd + ", "");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            unit = dateValue.substring(lenth - 1);
            this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (dateValue.startsWith("dateSub - ")) {
            this.rbDateSub.setSelected(true);
            dateValue = ExtStringUtil.replace(dateValue, "dateSub - ", "");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            unit = dateValue.substring(lenth - 1);
            this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (value.startsWith("=")) {
            this.rbFormula.setSelected(true);
            this.rbFormulaField.setText(value);
        } else {
            this.rbFix.setSelected(true);
            formatString = "yyyy-MM-dd";
            if (dataType == 4) {
                formatString = "yyyy-MM-dd HH:mm:ss";
            }
            Date date = null;
            if (dateValue != null && !dateValue.equals("")) {
                try {
                    sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(dateValue);
                }
                catch (ParseException sdf2) {}
            } else {
                date = RunReportParam.getServerDate(null);
            }
            this.kDDatePicker1.setValue((Object)date);
        }
        if (timeValue.startsWith("getSystemTime()")) {
            this.rbSystemTime.setSelected(true);
        } else {
            this.rbFixTime.setSelected(true);
            formatString = "HH:mm:ss";
            Date date = null;
            if (timeValue != null && !timeValue.equals("")) {
                try {
                    sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(timeValue);
                }
                catch (ParseException parseException) {}
            } else {
                date = RunReportParam.getServerDate(null);
            }
            this.kDTimePicker1.setValue((Object)date);
        }
    }

    public DefaultDateTimeValueUI(String value, int dataType, boolean isProcedure) throws Exception {
        this(value, dataType);
        if (isProcedure) {
            this.rbSystem.setEnabled(false);
            this.rbDateAdd.setEnabled(false);
            this.rbDateSub.setEnabled(false);
            this.rbMonthBegin.setEnabled(false);
            this.rbMonthEnd.setEnabled(false);
            this.spAdd.setEnabled(false);
            this.spSub.setEnabled(false);
            this.btnClear.setEnabled(false);
            this.rbFormula.setEnabled(false);
            this.rbFormulaField.setEnabled(false);
        }
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void initDateFormat() {
        if (this.dataType == 4) {
            String datePatternOld = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setTimeEnabled(true);
            String datePatternNew = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setDatePattern(ExtStringUtil.replace(datePatternNew, datePatternOld, datePatternOld + " "));
            Date date = RunReportParam.getServerDate(null);
            this.kDDatePicker1.setValue((Object)date);
        }
    }

    protected void initListener() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultDateTimeValueUI.this.isCancel = true;
            }
        });
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    private boolean checkFormula(String formula) {
        if (this.rbFormula.isSelected()) {
            if (StringUtil.isEmptyString((String)formula) || "=".equals(formula)) {
                this.rbFormulaField.requestFocusInWindow();
                return false;
            }
            short isValid = CalExprUtil.isDateFormula((String)formula);
            String warn = null;
            switch (isValid) {
                case 1: {
                    return true;
                }
                case -1: {
                    warn = this.resHelper.getString("msgWarning.invalid");
                    break;
                }
                case 2: {
                    warn = this.resHelper.getString("msgWarning.notDate");
                }
            }
            MessageUtil.msgboxWarning((Component)((Object)this), warn);
            this.rbFormulaField.requestFocusInWindow();
            this.rbFormulaField.selectAll();
            return false;
        }
        return true;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkFormula(this.rbFormulaField.getText().trim())) {
            return;
        }
        this.isCancel = false;
        this.closeWin();
    }

    protected void btnFunc_actionPerformed(ActionEvent e) throws Exception {
        FormulaMiniWizardDialog dialog = FormulaMiniWizardDialog.getMiniDialog();
        String editingData = this.rbFormulaField.getText();
        if (editingData.startsWith("=")) {
            editingData = editingData.replaceFirst("=", "");
        }
        dialog.getMiniWizard().setEditingData(editingData);
        dialog.showDialog();
        if (dialog.isOk()) {
            this.rbFormulaField.setText("=" + dialog.getMiniWizard().getEditor().getRealText());
        }
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
        this.kDDatePicker1.setValue(null);
        this.rbFix.setSelected(true);
        this.rbFormulaField.setText(null);
    }

    @Override
    protected void rbFix_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
    }

    @Override
    protected void rbSystem_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(false);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getDateSelected() {
        String ret = null;
        if (this.rbSystem.isSelected()) {
            ret = "getSystemDate()";
        } else if (this.rbMonthBegin.isSelected()) {
            ret = "dayBegin";
            ret = this.joinDateTime(ret);
        } else if (this.rbMonthEnd.isSelected()) {
            ret = "dayEnd";
            ret = this.joinDateTime(ret);
        } else if (this.rbDateAdd.isSelected()) {
            ret = "dateAdd + " + this.spAdd.getIntegerVlaue() + "D";
            ret = this.joinDateTime(ret);
        } else if (this.rbDateSub.isSelected()) {
            ret = "dateSub - " + this.spSub.getIntegerVlaue() + "D";
            ret = this.joinDateTime(ret);
        } else if (this.rbFormula.isSelected()) {
            String formula = this.rbFormulaField.getText().trim();
            ret = formula.startsWith("=") ? formula : "=" + formula;
        } else {
            ret = CtrlReportUtil.getObjectString(this.kDDatePicker1.getText());
            if (!ret.equals("")) {
                String formatString = "yyyy-MM-dd";
                if (this.dataType == 4) {
                    formatString = "yyyy-MM-dd HH:mm:ss";
                }
                String pattern = this.kDDatePicker1.getDatePattern();
                ret = CtrlReportUtil.formatDate(pattern, formatString, ret);
            }
        }
        return ret;
    }

    private String joinDateTime(String value) {
        return value + "|" + this.getTimeSelected();
    }

    private String getTimeSelected() {
        String ret = null;
        if (this.rbSystemTime.isSelected()) {
            ret = "getSystemTime()";
        } else {
            ret = CtrlReportUtil.getObjectString(this.kDTimePicker1.getText());
            if (!ret.equals("")) {
                String formatString = "HH:mm:ss";
                String pattern = this.kDTimePicker1.getTimePattern();
                ret = CtrlReportUtil.formatDate(pattern, formatString, ret);
            }
        }
        return ret;
    }
}

