/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.dlg.FormulaMiniWizardDialog;
import com.kingdee.bos.ctrl.ext.util.CalExprUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractDefaultDateValueUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class DefaultDateValueUI
extends AbstractDefaultDateValueUI {
    private static final long serialVersionUID = 1L;
    private boolean isinitLayout = false;
    private boolean isCancel = false;
    private int dataType = 2;
    protected KDButton btnFunc;
    protected KDRadioButton rbFormula;
    protected KDTextField rbFormulaField;

    public DefaultDateValueUI() throws Exception {
        this.init();
        this.initLayout();
        this.kDButtonGroup1.add((AbstractButton)this.rbSystem);
        this.kDButtonGroup1.add((AbstractButton)this.rbFix);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateAdd);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateSub);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthBegin);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthEnd);
        this.kDButtonGroup1.add((AbstractButton)this.rbFormula);
        this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
        this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
    }

    private void init() throws ClassNotFoundException, IOException {
        this.resHelper = new ResourceBundleHelper(DefaultDateValueUI.class.getName());
        this.btnFunc = new KDButton();
        this.rbFormula = new KDRadioButton();
        this.rbFormulaField = new KDTextField();
        this.btnFunc.setName("btnFunc");
        this.rbFormula.setName("rbFormula");
        this.rbFormulaField.setName("rbFormulaField");
        this.rbFormula.setText(this.resHelper.getString("rbFormula.text"));
        this.btnFunc.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_formulaguide.gif"));
        this.btnFunc.setLimitedSize(false);
        this.btnFunc.setOpaque(false);
        this.btnFunc.setBorder(null);
        this.btnFunc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultDateValueUI.this.beforeActionPerformed(e);
                try {
                    DefaultDateValueUI.this.btnFunc_actionPerformed(e);
                }
                catch (Exception exc) {
                    DefaultDateValueUI.this.handUIException(exc);
                }
                finally {
                    DefaultDateValueUI.this.afterActionPerformed(e);
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setBounds(new Rectangle(10, 10, 300, 275));
        this.kDSeparator2.setBounds(new Rectangle(0, 207, 298, 10));
        this.btnConfirm.setBounds(new Rectangle(65, 217, 73, 21));
        this.btnCancel.setBounds(new Rectangle(215, 217, 73, 21));
        this.btnClear.setBounds(new Rectangle(140, 217, 73, 21));
        this.rbFormula.setBounds(new Rectangle(30, 173, 80, 19));
        this.add((Component)this.rbFormula, null);
        this.rbFormulaField.setBounds(new Rectangle(118, 173, 120, 19));
        this.add((Component)this.rbFormulaField, null);
        this.btnFunc.setBounds(245, 173, 20, 19);
        this.add((Component)this.btnFunc);
    }

    public DefaultDateValueUI(String value, int dataType) throws Exception {
        this();
        this.dataType = dataType;
        this.initDateFormat();
        if (value.startsWith("getSystemDate()")) {
            this.rbSystem.setSelected(true);
        } else if (value.startsWith("dayBegin")) {
            this.rbMonthBegin.setSelected(true);
        } else if (value.startsWith("dayEnd")) {
            this.rbMonthEnd.setSelected(true);
        } else if (value.startsWith("dateAdd + ")) {
            this.rbDateAdd.setSelected(true);
            value = ExtStringUtil.replace(value, "dateAdd + ", "");
            int lenth = value.length();
            int addNumber = Integer.parseInt(value.substring(0, lenth - 1));
            this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (value.startsWith("dateSub - ")) {
            this.rbDateSub.setSelected(true);
            value = ExtStringUtil.replace(value, "dateSub - ", "");
            int lenth = value.length();
            int addNumber = Integer.parseInt(value.substring(0, lenth - 1));
            this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (value.startsWith("=")) {
            this.rbFormula.setSelected(true);
            this.rbFormulaField.setText(value);
        } else {
            this.rbFix.setSelected(true);
            String formatString = "yyyy-MM-dd";
            if (dataType == 4) {
                formatString = "yyyy-MM-dd HH:mm:ss";
            }
            Date date = null;
            if (value != null && !value.equals("")) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(value);
                }
                catch (ParseException parseException) {}
            } else {
                date = RunReportParam.getServerDate(null);
            }
            this.kDDatePicker1.setValue((Object)date);
        }
    }

    public DefaultDateValueUI(String value, int dataType, boolean isProcedure) throws Exception {
        this(value, dataType);
        if (isProcedure) {
            this.rbSystem.setEnabled(false);
            this.rbDateAdd.setEnabled(false);
            this.rbDateSub.setEnabled(false);
            this.rbMonthBegin.setEnabled(false);
            this.rbMonthEnd.setEnabled(false);
            this.spAdd.setEnabled(false);
            this.spSub.setEnabled(false);
            this.btnClear.setEnabled(false);
            this.rbFormula.setEnabled(false);
            this.rbFormulaField.setEnabled(false);
        }
    }

    private void initDateFormat() {
        if (this.dataType == 4) {
            String datePatternOld = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setTimeEnabled(true);
            String datePatternNew = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setDatePattern(StringUtil.replace((String)datePatternNew, (String)datePatternOld, (String)(datePatternOld + " ")));
            Rectangle rt = this.kDDatePicker1.getBounds();
            this.kDDatePicker1.setBounds(new Rectangle(rt.x, rt.y, rt.width + 55, rt.height));
            Date date = RunReportParam.getServerDate(null);
            this.kDDatePicker1.setValue((Object)date);
        }
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    protected void initListener() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultDateValueUI.this.isCancel = true;
            }
        });
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    private boolean checkFormula(String formula) {
        if (this.rbFormula.isSelected()) {
            if (StringUtil.isEmptyString((String)formula) || "=".equals(formula)) {
                this.rbFormulaField.requestFocusInWindow();
                return false;
            }
            short isValid = CalExprUtil.isDateFormula((String)formula);
            String warn = null;
            switch (isValid) {
                case 1: {
                    return true;
                }
                case -1: {
                    warn = this.resHelper.getString("msgWarning.invalid");
                    break;
                }
                case 2: {
                    warn = this.resHelper.getString("msgWarning.notDate");
                }
            }
            MessageUtil.msgboxWarning((Component)((Object)this), warn);
            this.rbFormulaField.requestFocusInWindow();
            this.rbFormulaField.selectAll();
            return false;
        }
        return true;
    }

    protected void btnFunc_actionPerformed(ActionEvent e) throws Exception {
        FormulaMiniWizardDialog dialog = FormulaMiniWizardDialog.getMiniDialog();
        String editingData = this.rbFormulaField.getText();
        if (editingData.startsWith("=")) {
            editingData = editingData.replaceFirst("=", "");
        }
        dialog.getMiniWizard().setEditingData(editingData);
        dialog.showDialog();
        if (dialog.isOk()) {
            this.rbFormulaField.setText("=" + dialog.getMiniWizard().getEditor().getRealText());
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkFormula(this.rbFormulaField.getText().trim())) {
            return;
        }
        this.isCancel = false;
        this.closeWin();
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
        this.kDDatePicker1.setValue(null);
        this.rbFix.setSelected(true);
        this.rbFormulaField.setText(null);
    }

    @Override
    protected void rbFix_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
    }

    @Override
    protected void rbSystem_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(false);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getDateSelected() {
        String ret = null;
        if (this.rbSystem.isSelected()) {
            ret = "getSystemDate()";
        } else if (this.rbMonthBegin.isSelected()) {
            ret = "dayBegin";
        } else if (this.rbMonthEnd.isSelected()) {
            ret = "dayEnd";
        } else if (this.rbDateAdd.isSelected()) {
            ret = "dateAdd + " + this.spAdd.getIntegerVlaue() + "D";
        } else if (this.rbDateSub.isSelected()) {
            ret = "dateSub - " + this.spSub.getIntegerVlaue() + "D";
        } else if (this.rbFormula.isSelected()) {
            String formula = this.rbFormulaField.getText().trim();
            ret = formula.startsWith("=") ? formula : "=" + formula;
        } else {
            ret = CtrlReportUtil.getObjectString(this.kDDatePicker1.getText());
            if (!ret.equals("")) {
                String formatString = "yyyy-MM-dd";
                if (this.dataType == 4) {
                    formatString = "yyyy-MM-dd HH:mm:ss";
                }
                String pattern = this.kDDatePicker1.getDatePattern();
                ret = CtrlReportUtil.formatDate(pattern, formatString, ret);
            }
        }
        return ret;
    }
}

