/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractDefaultRadioValueUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.ParamUIObj;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.param.ArgInputComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class DefaultRadioValueUI
extends AbstractDefaultRadioValueUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DefaultRadioValueUI.class);
    private boolean isCancel = false;
    DesignParameter p;
    ArrayList lstBox = new ArrayList();
    ParamUIObj defSelected;
    String[] selected_values;

    public DefaultRadioValueUI() throws Exception {
    }

    public DefaultRadioValueUI(DesignParameter p, Object objSelected) throws Exception {
        this();
        this.p = p;
        if (objSelected instanceof ParamUIObj) {
            this.defSelected = (ParamUIObj)objSelected;
            this.selected_values = this.defSelected.getValueArr();
        }
        this.getBoxList();
    }

    private void getBoxList() {
        int xCheckBox = 28;
        int yCheckBox = 20;
        int panelCheckBoxHeight = 0;
        KDPanel kDPanelCB = new KDPanel();
        kDPanelCB.setLayout(null);
        kDPanelCB.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(103, 101, 98)), this.p.getAlias()));
        this.kDPanel1.add((Component)kDPanelCB);
        IInputCtrl inputCtrl = this.p.getInputCtrl();
        if (null == inputCtrl) {
            return;
        }
        int bind = inputCtrl.getDataBind();
        if (bind == 0) {
            String displayKey = "alias";
            String valueKey = "value";
            String tableFlag = inputCtrl.getDataSetType();
            boolean isKSQL = tableFlag.equals("6");
            if (isKSQL) {
                displayKey = inputCtrl.getDefDisplay().getName();
                valueKey = inputCtrl.getDefValue().getName();
            }
            DefObj def = inputCtrl.getDefDbsource();
            String fid = def.getName();
            if (isKSQL) {
                String dbsourcename = def.getAlias();
                String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
                if (!systemid.equals("")) {
                    fid = fid + "\\" + systemid + "\\" + dbsourcename;
                }
            }
            ArrayList lst = new ArrayList();
            try {
                String orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                String orgName = SysContext.getSysContext().getCurrentOrgUnit().getName().toString();
                lst = RunReportParam.getBizDataList(null, isKSQL, fid, orgID, orgName, ArgInputComponentFactory.fetchSuppliers(this.p));
            }
            catch (Exception e) {
                logger.error((Object)"\u8bbe\u7f6eRadioButton", (Throwable)e);
                return;
            }
            for (HashMap mapitem : lst) {
                KDRadioButton cb = new KDRadioButton();
                cb.setText(CtrlReportUtil.getObjectString(mapitem.get(displayKey.toLowerCase())));
                DefObj defItem = new DefObj();
                defItem.setName(CtrlReportUtil.getObjectString(mapitem.get(valueKey.toLowerCase())));
                defItem.setAlias(CtrlReportUtil.getObjectString(mapitem.get(displayKey.toLowerCase())));
                cb.setUserObject((Object)defItem);
                this.setCBChecked(cb, defItem.getName());
                cb.setBounds(new Rectangle(xCheckBox, yCheckBox, 200, 19));
                kDPanelCB.add((Component)cb);
                this.kDButtonGroup1.add((AbstractButton)cb);
                this.lstBox.add(cb);
                panelCheckBoxHeight = yCheckBox += 20;
            }
        } else if (bind == 1) {
            ArrayList selfList = inputCtrl.getSelfList();
            for (DefObj defItem : selfList) {
                KDRadioButton cb = new KDRadioButton();
                cb.setText(defItem.getAlias());
                cb.setUserObject((Object)defItem);
                this.setCBChecked(cb, defItem.getName());
                cb.setBounds(new Rectangle(xCheckBox, yCheckBox, 200, 19));
                kDPanelCB.add((Component)cb);
                this.kDButtonGroup1.add((AbstractButton)cb);
                this.lstBox.add(cb);
                panelCheckBoxHeight = yCheckBox += 20;
            }
        }
        kDPanelCB.setBounds(new Rectangle(0, 0, 277, panelCheckBoxHeight += 3));
        this.kDPanel1.setPreferredSize(new Dimension(0, panelCheckBoxHeight));
    }

    void setCBChecked(KDRadioButton cb, String value) {
        if (null != this.selected_values) {
            for (int i = 0; i < this.selected_values.length; ++i) {
                if (!value.equals(this.selected_values[i])) continue;
                cb.setSelected(true);
                break;
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.closeWin();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public ParamUIObj getDateSelected() {
        ArrayList<DefObj> lstSelected = new ArrayList<DefObj>();
        ParamUIObj pu = new ParamUIObj();
        int size = this.lstBox.size();
        for (int i = 0; i < size; ++i) {
            KDRadioButton cb = (KDRadioButton)this.lstBox.get(i);
            if (!cb.isSelected()) continue;
            lstSelected.add((DefObj)cb.getUserObject());
            break;
        }
        size = lstSelected.size();
        DefObj[] defs = new DefObj[size];
        for (int i = 0; i < size; ++i) {
            DefObj defItem;
            defs[i] = defItem = (DefObj)lstSelected.get(i);
        }
        pu.setDefs(defs);
        return pu;
    }
}

