/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.semantic.use.SemanticUsetimeModel;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.client.ExtMobileReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.client.IReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.client.ReportStudioUI;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.SQLCustomType;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractDesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ExecuteAllSqlUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.FieldUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.FilterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ITabUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.JavaTabUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.JoinUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.KSQLNameUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OrderUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutDBTabUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ParamUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.PreviewKSQLPanelUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ProcedureTabUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.SemanticUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.SqlUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.TableUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.JavaModel;
import com.kingdee.eas.rpts.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.NoFoundQueryException;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.TabUIFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignInputStream;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignOutputStream;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.Semantic2Model;
import com.kingdee.eas.rpts.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.rpts.ctrlsqldesign.model.StaticSQLModel;
import com.kingdee.eas.rpts.snapshot.ds.model.DynamicSnapshotModel;
import com.kingdee.eas.rpts.snapshot.ds.model.StaticSnapshotModel;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class DesignUI
extends AbstractDesignUI {
    private static final long serialVersionUID = -5782922810898448416L;
    private static final Logger logger = CoreUIObject.getLogger(DesignUI.class);
    protected static ITabUI tabUI = null;
    private static DesignUI designUI = null;
    private CtrlDesignQueryModel model;
    private IReportManageUI reportUI = null;
    private HashMap mapData = null;
    private boolean isOnLoadStart = false;
    private boolean isinitLayout = false;
    private boolean isNoFoundQuery = false;
    private SQLCustomType customType;
    private ExtDataSet dataset;
    boolean isNew = true;
    boolean isCanceld = true;
    private KDButton btnMaxMin = new KDButton();

    private DesignUI() throws Exception {
    }

    public static final DesignUI getInstance() {
        if (designUI == null) {
            try {
                designUI = new DesignUI();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return designUI;
    }

    public void onLoad() throws Exception {
        designUI.setMinimumSize(new Dimension(600, 400));
        this.isOnLoadStart = true;
        InputMap inputmap = this.getInputMap(1);
        inputmap.put(KeyStroke.getKeyStroke(120, 576), "New");
        ActionMap actionmapNew = this.getActionMap();
        actionmapNew.put("New", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String xmlstr = DesignUI.this.getModelXml();
                try {
                    ExecuteAllSqlUI ui = new ExecuteAllSqlUI();
                    ui.kDTextArea1.setText(xmlstr);
                    ReportDialog.showDialog((CoreUIObject)ui, "xml", true, false);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDTabbedPane1.removeAll();
        this.btnMaxMin.setText(MessageUtil.getMsgInfo("label452"));
        this.btnMaxMin.addMouseListener((MouseListener)new MouseAdapter(){
            private boolean _isFullScreen;
            private int _x;
            private int _y;
            private int _w;
            private int _h;

            @Override
            public void mouseClicked(MouseEvent e) {
                AbstractButton btn = (AbstractButton)e.getSource();
                btn.setText(this._isFullScreen ? MessageUtil.getMsgInfo("label452") : MessageUtil.getMsgInfo("label453"));
                Window win = SwingUtilities.getWindowAncestor(btn);
                if (win instanceof KDDialog) {
                    KDDialog dlg = (KDDialog)win;
                    if (this._isFullScreen) {
                        dlg.setLocation(this._x, this._y);
                        dlg.setSize(this._w, this._h);
                        dlg.validate();
                        dlg.repaint();
                    } else {
                        this._x = dlg.getX();
                        this._y = dlg.getY();
                        this._w = dlg.getWidth();
                        this._h = dlg.getHeight();
                        WindowUtil.makeDialogFullScreen((KDDialog)dlg);
                    }
                }
                this._isFullScreen = !this._isFullScreen;
            }
        });
        this.btnMaxMin.setBounds(new Rectangle(5, 568, 100, 21));
        this.add((Component)this.btnMaxMin, new KDLayout.Constraints(5, 568, 100, 21, 6));
    }

    private String getModelXml() {
        RunReportParam.setSQLVersion(this.model);
        Element xml = CtrlDesignUtil.toXml(this.model.getCommonQuery(), this.model.getQuery());
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        String xmlstr = outter.outputString(xml);
        return xmlstr;
    }

    public void refresh() {
        this.initLayout();
        this.initModel();
        this.initFirstTab();
        this.syncModel2Ui();
    }

    private void initModel() {
        if (this.getModel() != null) {
            this.btnSaveAs.setEnabled(false);
        } else {
            String fid = CtrlReportUtil.getObjectString(this.mapData.get("fid"));
            if (this.customType.equals(SQLCustomType.SNAP) && fid.length() == 0) {
                this.model = StaticSQLModel.getSnapSQLModel();
                return;
            }
            if (this.customType.equals(SQLCustomType.DYNAMIC_SNAPSHOT) && fid.length() == 0) {
                this.model = DynamicSnapshotModel.getModel();
                return;
            }
            if (this.customType.equals(SQLCustomType.STATIC_SNAPSHOT) && fid.length() == 0) {
                this.model = StaticSnapshotModel.getModel();
                return;
            }
            this.model = new CtrlDesignQueryModel();
            this.model.setObjectSelector(new KsqlObjectSelector());
            if (fid.length() == 0) {
                this.model.setQuery((IQuery)new CtrlDesignKsqlQuery(true));
            } else {
                CtrlDesignInputStream in = new CtrlDesignInputStream(fid);
                in.getInputObject(this.model);
                if (this.customType.equals(SQLCustomType.SQL)) {
                    KsqlObjectSelector selector = this.model.getObjectSelector();
                    try {
                        selector.cacheTable2MetaClass(this.model.getQuery());
                    }
                    catch (NoFoundQueryException e) {
                        MessageUtil.showInfo(e.getMessage() + "\r\n" + e.getCustomMessage(), false);
                        this.noFoundQuerySetup();
                    }
                }
                this.isNew = false;
            }
        }
        CtrlDesignCommonQuery commonQuery = this.model.getCommonQuery();
        commonQuery.getProperties().put(CtrlDesignUtil.CustomType, String.valueOf(this.customType.intValue()));
        Map pmDsMap = (Map)commonQuery.getProperty("ExtReportInnerParamMap");
        List paramList = commonQuery.getParameters();
        if (paramList != null && pmDsMap != null) {
            for (int i = 0; i < paramList.size(); ++i) {
                String kySysId;
                String kyName;
                String key;
                Object dsCnt;
                DefObj ds;
                DesignParameter param = (DesignParameter)((Object)paramList.get(i));
                IInputCtrl inputCtrl = param.getInputCtrl();
                if (inputCtrl == null || null == (ds = inputCtrl.getDefDbsource()) || null == (dsCnt = pmDsMap.get(key = SqlDSModelDrill.getKey(kyName = ds.getAliasName(), kySysId = ds.getStrProperty("systemID"))))) continue;
                ds.setProperty("ExtReportInnerDSContent", dsCnt);
            }
        }
    }

    public void noFoundQuerySetup() {
        this.isNoFoundQuery = true;
        this.btnOK.setEnabled(false);
        this.btnSaveAs.setEnabled(false);
        this.btnApply.setEnabled(false);
    }

    private void initFirstTab() {
        tabUI = null;
        if (this.customType.equals(SQLCustomType.SQL)) {
            tabUI = TableUI.getInstance();
            this.addTabContentOwner("table", "kDPanel_table.constraints");
            this.addTabContentOwner("join", "kDPanel_link.constraints");
            this.addTabContentOwner("field", "kDPanel_field.constraints");
            this.addTabContentOwner("filter", "kDPanel_filter.constraints");
            this.addTabContentOwner("order", "kDPanel_order.constraints");
            this.addTabContentOwner("sql", "kDPanel_select.constraints");
            this.addTabContentOwner("param", "kDPanel_para.constraints");
            this.addTabContentOwner("outputField", "kDPanel_output.constraints");
            this.addTabContentOwner("outDb", "kDPanel_outDB.constraints");
        } else if (this.customType == SQLCustomType.SEMANTIC_SQL) {
            tabUI = SemanticUI.getInstance();
            this.addTabContentOwner("semantic", "\u8bed\u4e49\u5c42");
            this.addTabContentOwner("filter", "kDPanel_filter.constraints");
            this.addTabContentOwner("order", "kDPanel_order.constraints");
            this.addTabContentOwner("sql", "kDPanel_select.constraints");
            this.addTabContentOwner("param", "kDPanel_para.constraints");
            this.addTabContentOwner("outputField", "kDPanel_output.constraints");
            this.addTabContentOwner("outDb", "kDPanel_outDB.constraints");
        } else if (this.customType.equals(SQLCustomType.SNAP)) {
            tabUI = ParamUI.getInstance(this.isMobile());
            this.addTabContentOwner("param", "kDPanel_para.constraints");
            this.addTabContentOwner("outputField", "kDPanel_output.constraints");
            this.addTabContentOwner("outDb", "kDPanel_outDB.constraints");
        } else if (this.customType.equals(SQLCustomType.DYNAMIC_SNAPSHOT) || this.customType.equals(SQLCustomType.STATIC_SNAPSHOT)) {
            tabUI = ParamUI.getInstance(this.isMobile());
            this.addTabContentOwner("param", "kDPanel_para.constraints");
            ParamUI.getInstance(this.isMobile()).setTipLabelText("");
            this.addTabContentOwner("outDb", "kDPanel_outDB.constraints");
        } else {
            if (this.customType.equals(SQLCustomType.PROCEDURE)) {
                tabUI = ProcedureTabUI.getInstance(this.isMobile());
                ParamUI.getInstance(this.isMobile()).setTipLabelText(MessageUtil.getMsgInfo("label313"));
                this.addTabContentOwner("procedure", "kDPanel_proce.constraints");
            } else {
                tabUI = JavaTabUI.getInstance();
                ParamUI.getInstance(this.isMobile()).setTipLabelText("");
                this.addTabContentOwner("java", "kDPanel_java.constraints");
            }
            this.addTabContentOwner("param", "kDPanel_para.constraints");
            this.addTabContentOwner("outputField", "kDPanel_output.constraints");
            this.addTabContentOwner("outDb", "kDPanel_outDB.constraints");
        }
    }

    private void addTabContentOwner(String tag, String titleResKey) {
        String title;
        KDPanel pan = new KDPanel((LayoutManager)new BorderLayout());
        pan.setCustomInsets(new Insets(8, 8, 8, 8));
        pan.setUserObject((Object)tag);
        try {
            title = this.resHelper.getString(titleResKey);
        }
        catch (MissingResourceException ex) {
            title = titleResKey;
        }
        this.kDTabbedPane1.add((Component)pan, (Object)title);
    }

    @Override
    protected void kDTabbedPane1_stateChanged(ChangeEvent e) throws Exception {
        if (this.isOnLoadStart) {
            if (this.checkParamInvalid()) {
                return;
            }
            this.syncUi2Model();
            KDTabbedPane kdtab = (KDTabbedPane)e.getSource();
            KDPanel panelTemp = (KDPanel)kdtab.getSelectedComponent();
            tabUI = TabUIFactory.createTabUI(panelTemp.getUserObject(), this.isMobile());
            if (tabUI instanceof ParamUI) {
                boolean visible = this.reportUI instanceof ReportStudioUI;
                ((ParamUI)tabUI).getParamPanel().setSpecialFunctionsVisible(visible);
            }
            this.syncModel2Ui();
        }
    }

    public boolean isMobile() {
        return this.reportUI instanceof ExtMobileReportManageUI;
    }

    private void syncModel2Ui() {
        if (tabUI.isInitUI()) {
            ((KDPanel)this.kDTabbedPane1.getSelectedComponent()).add((Component)tabUI.getPanel(), (Object)"Center");
            tabUI.setInitUI(false);
        }
        if (this.isNoFoundQuery && tabUI instanceof FilterUI) {
            return;
        }
        if (tabUI.isRefreshFromModel()) {
            tabUI.syncModel2Ui();
            if (tabUI instanceof OutputFieldsUI) {
                return;
            }
            tabUI.setRefreshFromModel(false);
        }
    }

    private void syncUi2Model() {
        SemanticUsetimeModel semanticModel;
        if (this.isNoFoundQuery && tabUI instanceof FilterUI) {
            return;
        }
        if (tabUI != null) {
            BaseTabUIImp pu;
            if (tabUI instanceof SqlUI) {
                SqlUI sqlUI = (SqlUI)tabUI;
                if (sqlUI.isSqlCustom()) {
                    tabUI.syncUi2Model();
                    return;
                }
            } else if (tabUI instanceof ParamUI) {
                pu = (ParamUI)tabUI;
                ((ParamUI)pu).getParamPanel().commitTableData();
            } else if (tabUI instanceof ProcedureTabUI) {
                pu = (ProcedureTabUI)tabUI;
                ((ProcedureTabUI)pu).getProcedurePanel().commitTableData();
            }
            tabUI.syncUi2Model();
        }
        if (this.customType.equals(SQLCustomType.SEMANTIC_SQL) && (semanticModel = this.getModel().getCommonQuery().getSemanticModel()) != null && !semanticModel.isInvalid()) {
            String sql = Semantic2Model.SemanticSqlMaker.makeQuery(this.getModel().getQuery(), semanticModel);
            this.getModel().getQuery().setContent(sql);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
        CtrlReportUtil.closeWin(this);
    }

    @Override
    protected void btnPreview_actionPerformed(ActionEvent e) throws Exception {
        this.syncUi2Model();
        if (this.customType.equals(SQLCustomType.PROCEDURE)) {
            ProcedureModel pm = this.model.getCommonQuery().getProcedureModel();
            if (pm == null || pm.getName().equals("")) {
                MessageUtil.showInfo("label306", true);
                return;
            }
            if (pm.getDbType() == 2 && pm.getResultCursor().equals("")) {
                MessageUtil.showInfo("label307", true);
                return;
            }
        }
        if (this.customType.equals(SQLCustomType.JAVA)) {
            JavaModel jm = this.model.getCommonQuery().getJavaModel();
            if (jm == null || jm.getExecuteType() == 0 && jm.getFullname().equals("")) {
                MessageUtil.showInfo("\u8bf7\u586b\u5199\u53cd\u5c04\u7c7b\u5168\u8def\u5f84", false);
                return;
            }
            if (jm.getExecuteType() == 1 && jm.getJavaCode().equals("")) {
                MessageUtil.showInfo("\u8bf7\u586b\u5199\u52a8\u6001\u7f16\u8bd1\u7684\u4ee3\u7801", false);
                return;
            }
        }
        PreviewKSQLPanelUI previewPanel = new PreviewKSQLPanelUI();
        previewPanel.preview(false, true);
        if (previewPanel.isShowPreviewUI()) {
            String message = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label31");
            ReportDialog.showDialog((CoreUIObject)previewPanel, message, true, false);
        }
        if (tabUI instanceof OutputFieldsUI) {
            tabUI.syncModel2Ui();
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceld = false;
        this.save(true, this.mapData);
    }

    private boolean friendlyRemind() {
        List paramLst = this.model.getCommonQuery().getParameters();
        if (paramLst != null) {
            StringBuffer infoBuf = new StringBuffer();
            int size = paramLst.size();
            for (int i = 0; i < size; ++i) {
                DesignParameter p = (DesignParameter)((Object)paramLst.get(i));
                if ((p.isAllowNull() || p.getInputState() != InputState.READONLY) && (p.isAllowNull() || p.getInputState() != InputState.HIDDEN) || !StringUtil.isEmptyString((String)p.getDefaultValue())) continue;
                infoBuf.append(p.getAlias()).append('\uff0c');
            }
            if (infoBuf.length() != 0) {
                infoBuf.setCharAt(infoBuf.length() - 1, ' ');
                infoBuf.append("\u4e3a\u5fc5\u586b\u53c2\u6570\uff0c\u7ee7\u7eed\u8bbe\u7f6e\u5b83\u4eec\u7684\u9ed8\u8ba4\u503c\uff1f");
                if (MessageUtil.showConfirm(infoBuf.toString(), false)) {
                    Component[] cs = this.kDTabbedPane1.getComponents();
                    for (int i = 0; i < cs.length; ++i) {
                        if (!(cs[i] instanceof KDPanel) || ((KDPanel)cs[i]).getUserObject() != "param") continue;
                        this.kDTabbedPane1.setSelectedComponent(cs[i]);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void btnSaveAs_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceld = false;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("systemID", this.mapData.get("systemID").toString());
        map.put("leafParentTreePath", this.mapData.get("leafParentTreePath").toString());
        this.save(true, map);
    }

    @Override
    protected void btnApply_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceld = false;
        this.save(false, this.mapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(boolean isClose, HashMap mapData) throws Exception {
        if (this.friendlyRemind()) {
            return;
        }
        if (this.checkSemanticInvalid()) {
            return;
        }
        if (this.checkParamInvalid()) {
            return;
        }
        boolean bool = true;
        boolean isInsert = false;
        HashMap mapName = new HashMap();
        String fid = CtrlReportUtil.getObjectString(mapData.get("fid"));
        String fname = CtrlReportUtil.getObjectString(mapData.get("fname"));
        String systemID = CtrlReportUtil.getObjectString(mapData.get("systemID"));
        String leafParentTreePath = CtrlReportUtil.getObjectString(mapData.get("leafParentTreePath"));
        boolean isSQL = false;
        boolean isNoName = false;
        if (fname.equals("")) {
            String strLocal = SysContext.getSysContext().getLocale().toString();
            KSQLNameUI nameUI = new KSQLNameUI(leafParentTreePath, this.reportUI instanceof ExtMobileReportManageUI);
            while (true) {
                nameUI.clear();
                ReportDialog.showDialog(nameUI, EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label13"), true);
                if (!nameUI.isOk()) {
                    return;
                }
                isSQL = nameUI.isSQL();
                mapName = nameUI.getMapData();
                fname = CtrlReportUtil.getObjectString(mapName.get(strLocal));
                boolean flag = CtrlDesignUtil.isexist(fid, systemID, fname, strLocal);
                if (!flag) break;
                MessageUtil.showInfo(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"report_name_repeat"), false);
            }
            mapData.put("fname", fname);
            isNoName = true;
        }
        if (fid == null || fid.length() == 0) {
            isInsert = true;
        } else {
            String fisdynamicsql = CtrlReportUtil.getObjectString(mapData.get("fisdynamicsql"));
            if (fisdynamicsql.equals("1")) {
                isSQL = true;
            }
        }
        this.syncUi2Model();
        CtrlReportException outputCE = null;
        if (this.customType.equals(SQLCustomType.SQL) || this.customType == SQLCustomType.SEMANTIC_SQL) {
            try {
                OutputFieldsUI.setOutputColumns(this.model, true);
            }
            catch (CtrlReportException e) {
                outputCE = e;
            }
        }
        if (this.dataset != null) {
            StringBuffer metaStr = new StringBuffer();
            ArrayList<String> paramDataSourceList = new ArrayList<String>();
            metaStr.append(this.getModelXml());
            CtrlDesignCommonQuery commonQuery = this.model.getCommonQuery();
            if (null != commonQuery) {
                List paramList = commonQuery.getParameters();
                Map commonQueryInnerQuery = (Map)commonQuery.getProperty("ExtReportInnerParamMap");
                if (commonQueryInnerQuery != null && paramList != null && paramList.size() > 0) {
                    for (int i = 0; i < paramList.size(); ++i) {
                        String key;
                        String value;
                        DesignParameter p = (DesignParameter)((Object)paramList.get(i));
                        IInputCtrl inputCtrl = p.getInputCtrl();
                        if (inputCtrl == null) continue;
                        boolean isParameterDataSourceModified = false;
                        DefObj dbsource = inputCtrl.getDefDbsource();
                        if (dbsource == null) continue;
                        Object modifiedFlag = dbsource.getProperties().get("isModified");
                        if (modifiedFlag != null) {
                            isParameterDataSourceModified = (Boolean)modifiedFlag;
                        }
                        if (isParameterDataSourceModified || (value = (String)commonQueryInnerQuery.get(key = SqlDSModelDrill.getKey(dbsource.getAliasName(), dbsource.getStrProperty("systemID")))) == null) continue;
                        paramDataSourceList.add(key);
                        paramDataSourceList.add(value);
                    }
                }
            }
            if (paramDataSourceList.isEmpty()) {
                this.dataset.setMeta(metaStr.toString());
            } else {
                this.dataset.setMeta(SqlDSModelDrill.mergeMeta(metaStr.toString(), paramDataSourceList));
            }
        } else {
            block36: {
                CtrlDesignOutputStream out = new CtrlDesignOutputStream(mapName, fid, systemID, isSQL, this.customType.intValue());
                try {
                    CtrlDesignCommonQuery commonQuery = this.model.getCommonQuery();
                    Map map = commonQuery.getProperties();
                    if (!mapName.isEmpty()) {
                        map.putAll(mapName);
                    }
                    RunReportParam.setSQLVersion(this.model);
                    IQuery query = this.model.getQuery();
                    Element xml = CtrlDesignUtil.toXml(commonQuery, query);
                    XmlUtil.saveXmlStream((OutputStream)((Object)out), (Element)xml);
                    mapData.put("fid", out.getFid());
                    if (!isNoName) break block36;
                    Container obj = this.getParent();
                    while (true) {
                        if (obj instanceof JDialog) {
                            String message = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label32");
                            ((JDialog)obj).setTitle(message + " - " + fname);
                            break;
                        }
                        obj = ((Component)obj).getParent();
                    }
                }
                catch (Exception ex) {
                    bool = false;
                    MessageUtil.showDetailAndOK(null, ex.getMessage(), ex);
                }
                finally {
                    StreamUtil.closeStream((OutputStream)((Object)out));
                }
            }
            if (bool) {
                CtrlReportUtil.addOtherCtrl(this.reportUI.getCoreUI(), "EDIT", fid);
                if (systemID.equals(this.reportUI.getSystemID()) && this.reportUI.getTableFlag().equals("2")) {
                    try {
                        this.reportUI.getDataList();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.add("0");
                    this.reportUI.setTableSelected(lst);
                }
            } else if (isInsert) {
                mapData.put("fid", "");
                mapData.put("fname", "");
            }
        }
        if (outputCE != null) {
            MessageUtil.showDetailAndOK(null, outputCE.getMessage(), outputCE);
        }
        if (isClose) {
            this.btnCancel_actionPerformed(null);
        }
    }

    public boolean destroyWindow() {
        TableUI.destroy();
        JoinUI.destroy();
        FieldUI.destroy();
        FilterUI.destroy();
        OrderUI.destroy();
        SqlUI.destroy();
        ParamUI.destroy();
        OutputFieldsUI.destroy();
        OutDBTabUI.destroy();
        ProcedureTabUI.destroy();
        JavaTabUI.destroy();
        SemanticUI.destroy();
        tabUI = null;
        designUI = null;
        CtrlReportUtil.releaseCtrl(this.reportUI.getCoreUI(), this.getEditID());
        return true;
    }

    public void handUIException(Throwable throwable) {
        this.destroyWindow();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        super.handUIException(throwable);
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
            this.kDTabbedPane1.setForcedHide(true);
        }
    }

    public CtrlDesignQueryModel getModel() {
        return this.model;
    }

    public void setModel(CtrlDesignQueryModel model) {
        this.model = model;
    }

    public HashMap getMapData() {
        return this.mapData;
    }

    public void setMapData(HashMap mapData) {
        this.mapData = mapData;
        this.customType = (SQLCustomType)mapData.get("customType");
    }

    public IReportManageUI getReportUI() {
        return this.reportUI;
    }

    public void setReportUI(IReportManageUI reportUI) {
        this.reportUI = reportUI;
    }

    public String getEditID() {
        return CtrlReportUtil.getObjectString(this.mapData.get("fid"));
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isNoFoundQuery() {
        return this.isNoFoundQuery;
    }

    public SQLCustomType getCustomType() {
        return this.customType;
    }

    public void setDataset(ExtDataSet dataset) {
        this.dataset = dataset;
    }

    public ExtDataSet getDataset() {
        return this.dataset;
    }

    public boolean isCanceld() {
        return this.isCanceld;
    }

    private boolean checkSemanticInvalid() {
        SemanticUsetimeModel semanticModel = this.model.getCommonQuery().getSemanticModel();
        if (semanticModel != null && semanticModel.isInvalid()) {
            MessageUtil.showWarning((Component)((Object)this), "\u539f\u5f15\u7528\u5bf9\u8c61\u627e\u4e0d\u5230\uff0c\u60a8\u5fc5\u987b\u91cd\u65b0\u4f7f\u7528\u8bed\u4e49\u5c42\u6784\u9020SQL\uff0c\u624d\u53ef\u4ee5\u4fdd\u5b58\u3002");
            return true;
        }
        return false;
    }

    private boolean checkParamInvalid() {
        if (tabUI instanceof ParamUI && ((ParamUI)tabUI).getParamPanel().checkInvalidParam()) {
            Component sc = this.kDTabbedPane1.getSelectedComponent();
            if (((KDPanel)sc).getUserObject() == "param") {
                MessageUtil.showInfo("\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", false);
            }
            Component[] cs = this.kDTabbedPane1.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                if (!(cs[i] instanceof KDPanel) || ((KDPanel)cs[i]).getUserObject() != "param") continue;
                this.kDTabbedPane1.setSelectedComponent(cs[i]);
                break;
            }
            return true;
        }
        return false;
    }
}

