/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelHelper;
import com.kingdee.eas.rpts.ctrlreport.bo.BlobBO;
import com.kingdee.eas.rpts.ctrlreport.bo.CtrlQuerySolutionBO;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtDatasetFilterImpl;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractExecuteKSQLUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ExecuteKSQLVirtualMode;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ReportCommonFilterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExecuteKSQLUI
extends AbstractExecuteKSQLUI {
    private static final long serialVersionUID = -4714144927525782133L;
    private static final Logger logger = CoreUIObject.getLogger(ExecuteKSQLUI.class);
    private String solutionID;
    private String parameterXmlString;
    private int shareType;
    boolean isInitToolBar = true;
    private transient ExecuteKSQLVirtualMode virtualMode;

    public ExecuteKSQLUI() throws Exception {
        this.tblContent.getDataRequestManager().setDataRequestMode(1);
        this.tblContent.getDataRequestManager().setMemoryCallback(true);
        this.tblContent.getDataRequestManager().setExportMemoryCallback(true);
        this.tblContent.getDataRequestManager().setPageRowCount(500);
        this.tblContent.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                ExecuteKSQLUI.this.doDataRequest(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(CtrlReportUtil.getObjectString(this.getUIContext().get("MainMenuName")));
        this.openGetDataThread(false);
    }

    private void initVirtualModel() throws CtrlReportException {
        String type;
        CtrlDesignCommonQuery commonQuery;
        int pageRowCount = this.tblContent.getDataRequestManager().getPageRowCount();
        this.virtualMode = new ExecuteKSQLVirtualMode(this.tblContent, this, pageRowCount);
        CtrlDesignQueryModel model = KSQLReportBO.initModel(CtrlReportUtil.getObjectString(this.getUIContext().get("UIClassParam")));
        CtrlDesignCommonQuery ctrlDesignCommonQuery = commonQuery = model == null ? null : model.getCommonQuery();
        if (null != commonQuery && (type = CtrlReportUtil.getObjectString(commonQuery.getProperties().get(CtrlDesignUtil.CustomType))).equals(String.valueOf(1)) && commonQuery.getQuery() != null && ExtStringUtil.isInvalidSql(commonQuery.getQuery().getContent())) {
            MessageUtil.showInfo("\u5efa\u8bae\u81ea\u5b9a\u4e49Sql\u67e5\u8be2\u91c7\u7528\u5185\u5916\u8fde\u63a5\u67e5\u8be2\u65b9\u5f0f\uff01", false);
        }
        this.virtualMode.setQueryModel(model);
    }

    private void openGetDataThread(boolean isRefresh) throws CtrlReportException, SQLException {
        if (this.virtualMode == null) {
            this.initVirtualModel();
        }
        this.virtualMode.hideBizData();
        int start = 0;
        try {
            if (!this.buildParams(isRefresh)) {
                this.destroyWindow();
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u6784\u9020\u53c2\u6570\uff1a", (Throwable)e);
            this.virtualMode.handException(e);
        }
        if (this.virtualMode.getPageRowCount() != this.tblContent.getDataRequestManager().getPageRowCount()) {
            this.virtualMode.setPageRowCount(this.tblContent.getDataRequestManager().getPageRowCount());
        }
        this.virtualMode.setParameterXml(this.parameterXmlString);
        ResultSet rs = this.virtualMode.getOnePageData(start);
        if (null != rs) {
            this.setTableHeader(this.tblContent, rs, -1);
            ExecuteKSQLUI.bindResultSet(this.tblContent, rs, start);
            this.virtualMode.showBizData();
        }
        this.showToolBar();
    }

    private void showToolBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExecuteKSQLUI.this.initToolBar();
            }
        });
    }

    protected void initToolBar() {
        if (this.isInitToolBar) {
            KDToolBar toolBar = this.getUIToolBar();
            if (toolBar.getToolBarComponentCount() < 2) {
                return;
            }
            KDWorkButton btnSearch = new KDWorkButton();
            btnSearch.setName("btnSearch");
            String message = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label33");
            btnSearch.setText(message);
            btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
            btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecuteKSQLUI.this.btnSearch_actionPerformed();
                }
            });
            KDWorkButton btnRefresh = new KDWorkButton();
            btnRefresh.setName("btnRefresh");
            message = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label34");
            btnRefresh.setText(message);
            btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
            btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecuteKSQLUI.this.btnRefresh_actionPerformed();
                }
            });
            KDWorkButton btnExport = new KDWorkButton();
            btnExport.setName("btnExportSnapshot");
            message = "\u5bfc\u51fa\u5230Excel";
            btnExport.setText(message);
            ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("com/kingdee/eas/rpts/ctrlsqldesign/client/bos_export.png"));
            btnExport.setIcon((Icon)icon);
            btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportExcelHelper helper = new ExportExcelHelper((CoreUI)ExecuteKSQLUI.this, ExecuteKSQLUI.this.tblContent);
                    try {
                        helper.createExportConfigUI();
                    }
                    catch (IOException exc) {
                        logger.error((Object)exc.getMessage());
                    }
                }
            });
            toolBar.add((Component)btnSearch, 1);
            toolBar.add((Component)new JToolBar.Separator(), 2);
            toolBar.add((Component)btnRefresh, 3);
            toolBar.add((Component)new JToolBar.Separator(), 4);
            toolBar.add((Component)btnExport, 5);
            toolBar.add((Component)new JToolBar.Separator(), 6);
            Container c = toolBar.getParent();
            if (c != null) {
                c.validate();
                c.repaint();
            }
            this.isInitToolBar = false;
        }
    }

    public boolean destroyWindow() {
        boolean destroyWindow = super.destroyWindow();
        if (destroyWindow) {
            this.virtualMode.destroyThread();
        }
        return destroyWindow;
    }

    public void doDataRequest(RequestRowSetEvent e) {
        if (this.virtualMode.getPageRowCount() != this.tblContent.getDataRequestManager().getPageRowCount()) {
            this.virtualMode.setPageRowCount(this.tblContent.getDataRequestManager().getPageRowCount());
        }
        ResultSet rs = this.virtualMode.doDataRequest(e);
        try {
            ExecuteKSQLUI.bindResultSet(this.tblContent, rs, (Integer)e.getParam1());
        }
        catch (SQLException e1) {
            logger.error((Object)"\u6253\u5f00\u53d6\u6570\u7ebf\u7a0b\u5931\u8d25", e1.getCause());
            this.virtualMode.handException(e1);
        }
    }

    protected void btnSearch_actionPerformed() {
        try {
            this.openGetDataThread(false);
        }
        catch (CtrlReportException e) {
            logger.error((Object)"\u6253\u5f00\u53d6\u6570\u7ebf\u7a0b\u5931\u8d25", e.getCause());
            this.virtualMode.handException(e);
        }
        catch (SQLException e) {
            logger.error((Object)"\u6253\u5f00\u53d6\u6570\u7ebf\u7a0b\u5931\u8d25", e.getCause());
            this.virtualMode.handException(e);
        }
    }

    protected void btnRefresh_actionPerformed() {
        try {
            this.openGetDataThread(true);
        }
        catch (CtrlReportException e) {
            logger.error((Object)"\u6253\u5f00\u53d6\u6570\u7ebf\u7a0b\u5931\u8d25", e.getCause());
            this.virtualMode.handException(e);
        }
        catch (SQLException e) {
            logger.error((Object)"\u6253\u5f00\u53d6\u6570\u7ebf\u7a0b\u5931\u8d25", e.getCause());
            this.virtualMode.handException(e);
        }
    }

    protected KDTable getTableForCommon() {
        return this.tblContent;
    }

    public static boolean isAllParamsHidden(List lstParam) {
        if (null == lstParam || lstParam.isEmpty()) {
            return true;
        }
        for (DesignParameter dp : lstParam) {
            InputState inputState = dp.getInputState();
            if (inputState == InputState.HIDDEN) continue;
            return false;
        }
        return true;
    }

    private boolean buildParams(boolean isRefresh) throws Exception {
        HashMap defalutSolution;
        CtrlDesignQueryModel model = KSQLReportBO.initModel(CtrlReportUtil.getObjectString(this.getUIContext().get("UIClassParam")));
        boolean isDialogDefalut = false;
        String fid = (String)this.getUIContext().get("UIClassParam");
        List lstParam = model.getCommonQuery().getParameters();
        if (this.isInitToolBar && !(defalutSolution = CtrlQuerySolutionBO.getDefaultSolutionInfo(fid)).isEmpty()) {
            this.solutionID = CtrlReportUtil.getObjectString(defalutSolution.get("fid"));
            this.parameterXmlString = CtrlReportUtil.getObjectString(defalutSolution.get("fwherevalue"));
            if (!ExtDatasetFilterImpl.hasNullRequired(lstParam, this.parameterXmlString)) {
                isDialogDefalut = true;
            }
        }
        if (ExecuteKSQLUI.isAllParamsHidden(lstParam)) {
            if (StringUtil.isEmptyString((String)this.parameterXmlString)) {
                this.parameterXmlString = CtrlDesignUtil.toFilterSolutionXmlByDesignParameter((ArrayList)lstParam);
            }
        } else if (!isDialogDefalut && !isRefresh) {
            String paramRelationFullName = CtrlReportUtil.getObjectString(model.getCommonQuery().getProperty(CtrlDesignUtil.ParamRelationFullName));
            String sourceReportOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            DefaultArgInput argUI = new DefaultArgInput(paramRelationFullName, sourceReportOrgID);
            argUI.createParametersUI(lstParam);
            ReportCommonFilterUI commonFilterUI = new ReportCommonFilterUI((JPanel)((Object)argUI), fid, this.solutionID, this.parameterXmlString, this.shareType);
            ReportDialog.showDialog((CoreUIObject)commonFilterUI, EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label35"), true, false, (Window)this.getUIContext().get("Owner"));
            if (!commonFilterUI.isOk()) {
                if (this.isInitToolBar) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExecuteKSQLUI.this.getUIWindow().close();
                        }
                    });
                    return false;
                }
            } else {
                this.solutionID = commonFilterUI.getSolutionID();
                this.parameterXmlString = commonFilterUI.getParameterXmlString();
                this.shareType = commonFilterUI.getShareType();
            }
        }
        return true;
    }

    public static final int bindResultSet(KDTable table, ResultSet rs, int start) throws SQLException {
        int bindRow = 0;
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int row = start;
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            IRow irow = table.setRow(start++);
            for (int col = 0; col < cols; ++col) {
                Object value = rs.getObject(col + 1);
                int type = rsmd.getColumnType(col + 1);
                if (type == 2004) {
                    value = BlobBO.readBlob(rs, col + 1);
                }
                value = RunReportParam.getOracleDateValue(value);
                table.getCell(row, col).setValue(value);
                map.put(rsmd.getColumnName(col + 1).toLowerCase(), value);
            }
            irow.setUserObject(map);
            ++row;
            ++bindRow;
        }
        rs.close();
        return bindRow;
    }

    public void setTableHeader(KDTable table, ResultSet rs, int rowCount) throws SQLException, CtrlReportException {
        int cols = rs.getMetaData().getColumnCount();
        ArrayList<StyleAttributes> colums = new ArrayList<StyleAttributes>();
        ArrayList<Integer> columsWidth = new ArrayList<Integer>();
        for (int i = 0; i < cols; ++i) {
            if (table.getColumn(i) != null) {
                colums.add(table.getColumn(i).getStyleAttributes());
                columsWidth.add(table.getColumn(i).getWidth());
                continue;
            }
            colums.add(null);
            columsWidth.add(null);
        }
        table.removeColumns();
        table.addColumns(cols);
        table.getDataRequestManager().setExportPageRowCount(500);
        CtrlDesignQueryModel model = KSQLReportBO.initModel(CtrlReportUtil.getObjectString(this.getUIContext().get("UIClassParam")));
        HashMap oldNameAlisaMap = OutputFieldsUI.getNameAlisaMapFromModel(model);
        String[] colFields = new String[cols];
        IRow headRow = table.addHeadRow();
        int headRowHeight = table.getHead().getHeight();
        headRow.setHeight(headRowHeight);
        for (int i = 0; i < cols; ++i) {
            String rowHeader = rs.getMetaData().getColumnName(i + 1);
            if (oldNameAlisaMap.containsKey(rowHeader.toUpperCase())) {
                Column oc = (Column)oldNameAlisaMap.get(rowHeader.toUpperCase());
                rowHeader = oc.getAlias();
            }
            headRow.getCell(i).setValue((Object)rowHeader);
            colFields[i] = rowHeader;
            table.getColumn(i).setKey(rowHeader);
            if (colums.get(i) != null) {
                table.getColumn(i).setStyleAttributes((StyleAttributes)colums.get(i));
            }
            if (columsWidth.get(i) == null) continue;
            table.getColumn(i).setWidth((Integer)columsWidth.get(i) == 0 ? 1 : (Integer)columsWidth.get(i));
        }
        table.putBindContents("member", colFields);
        table.checkParsed(true);
        table.setRowCount(rowCount);
    }
}

