/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractExecuteKSQLUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.PreviewKSQLPanelUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ProcessingBoxPanel;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class ExecuteKSQLVirtualMode {
    private static final Logger logger = CoreUIObject.getLogger(ExecuteKSQLVirtualMode.class);
    private CtrlDesignQueryModel model = null;
    private String parameterXmlString;
    ProcessingBoxPanel processingBoxPanel;
    boolean isInitToolBar = true;
    String fid;
    private KDTable table;
    private AbstractExecuteKSQLUI owner;
    private volatile int pageRowCount;
    private ExecutorService executor;
    private int lastStart = 0;
    private int lastRowCount = 0;
    private Future<ResultSet> lastFuture = null;

    public ExecuteKSQLVirtualMode(KDTable table, AbstractExecuteKSQLUI owner, int pageRowCount) {
        this.table = table;
        this.owner = owner;
        this.pageRowCount = pageRowCount;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "rpt virtual model thread");
            }
        });
    }

    public void setParameterXml(String parameterXmlString) {
        this.parameterXmlString = parameterXmlString;
    }

    public void setQueryModel(CtrlDesignQueryModel model) {
        this.model = model;
    }

    public synchronized void setPageRowCount(int pageRowCount) {
        this.pageRowCount = pageRowCount;
    }

    public synchronized int getPageRowCount() {
        return this.pageRowCount;
    }

    public ResultSet doDataRequest(RequestRowSetEvent e) {
        return this.getOnePageData((Integer)e.getParam1());
    }

    public ResultSet getOnePageData(int start) {
        Future<ResultSet> retFuture = null;
        retFuture = start == this.lastStart && this.pageRowCount == this.lastRowCount && null != this.lastFuture ? this.lastFuture : this.executor.submit(new GetDataJob(start, this.pageRowCount));
        ResultSet set = null;
        try {
            set = retFuture.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (null != set) {
            this.lastStart = start + this.pageRowCount;
            this.lastRowCount = this.pageRowCount;
            this.lastFuture = this.executor.submit(new GetDataJob(this.lastStart, this.lastRowCount));
        }
        return set;
    }

    public void destroyThread() {
        this.executor.shutdownNow();
    }

    public void handException(final Exception e) {
        String temp = CtrlReportUtil.getObjectString(e.getMessage());
        int ic = temp.indexOf("Caused exception message is:");
        final StringBuilder builder = new StringBuilder();
        if (ic != -1) {
            builder.append(MessageUtil.getMsgInfo("label151") + "\r\n" + temp.substring(ic + 29));
        } else {
            builder.append(temp);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageUtil.showDetailAndOK(null, builder.toString(), e);
                ExecuteKSQLVirtualMode.this.owner.getUIWindow().close();
            }
        });
    }

    public void hideBizData() {
        if (this.processingBoxPanel == null) {
            this.processingBoxPanel = new ProcessingBoxPanel();
        }
        this.owner.add((Component)((Object)this.processingBoxPanel), "Center");
        this.owner.remove((Component)this.table);
        this.owner.repaint();
    }

    public void showBizData() {
        this.owner.add((Component)this.table);
        this.owner.remove((Component)((Object)this.processingBoxPanel));
        this.owner.validate();
    }

    class GetDataJob
    implements Callable<ResultSet> {
        private int start;
        private int length;
        private long startTime;

        private GetDataJob(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public ResultSet call() throws Exception {
            return this.getOnePage(this.start, this.length);
        }

        private ResultSet getOnePage(int start, int length) {
            try {
                if (logger.isDebugEnabled()) {
                    this.startTime = System.currentTimeMillis();
                    logger.debug((Object)String.format("start fetch data rowStart:%d pageCount: %d", start, ExecuteKSQLVirtualMode.this.pageRowCount));
                }
                ResultSet set = this.execute(start, length);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("fetch data end cost: %d ms", System.currentTimeMillis() - this.startTime));
                }
                return set;
            }
            catch (Exception e) {
                logger.error((Object)("\u6267\u884c\u53d6\u6570\u5931\u8d25\uff0c\u5f00\u59cb\u884c\uff1a" + start + ",\u5f02\u5e38\u4fe1\u606f\uff1a"), e.getCause());
                ExecuteKSQLVirtualMode.this.handException(e);
                return null;
            }
        }

        private ResultSet execute(int start, int length) throws JDOMException, IOException, CtrlReportException {
            HashMap mapDesignParameter = PreviewKSQLPanelUI.getExecuteParam(ExecuteKSQLVirtualMode.this.model, ExecuteKSQLVirtualMode.this.parameterXmlString);
            HashMap mapResult = CtrlDesignDataExecutor.execute(null, ExecuteKSQLVirtualMode.this.model, mapDesignParameter, null, start, length, true, null);
            return (IRowSet)mapResult.get("6xx8xxRowset");
        }
    }
}

