/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.immit.IExtCallback;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.kds.KDCompleteBookVersion;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.workbench.logic.TrimWidgetManager;
import com.kingdee.bos.ctrl.workbench.persist.TrimDatabase;
import com.kingdee.bos.ctrl.workbench.ui.ITrimView;
import com.kingdee.bos.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.bos.ctrl.workbench.ui.Perspective;
import com.kingdee.bos.ctrl.workbench.ui.TrimWidgetViewport;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCompleteTempModel;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ShowExcuteDataAction;
import com.kingdee.eas.rpts.ctrlsqldesign.client.TrimViewPane;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExtCompleteTempUI
extends KDFrame {
    private static Logger logger = LogUtil.getPackageLogger(ExtCompleteTempUI.class);
    private static String _version = "1.0.0";
    private KDWorkButton _btnImport;
    private KDWorkButton _btnData;
    private ShowExcuteDataAction showDataAction;
    private KDWorkButton _btnImportCompare2;
    private KDWorkButton _btnResultDiff;
    private KDWorkButton _btnImportCompare;
    private KDWorkButton _btnDataDiff;
    private KDWorkButton _btnViewManager;
    private KDWorkButton _btnTempView;
    private KDWorkButton _btnResultView;
    private KDWorkButton _btnDataView;
    private Perspective _tempPerspective;
    private Perspective _resultPerspective;
    private Perspective _dataPerspective;
    Perspective nowSpective;
    private KDToolBar _tempToolBar;
    private KDToolBar _resultToolBar;
    private KDToolBar _dataToolBar;
    private ExtCallbackImpl _extCallbackImpl;
    private ExtCompleteTempModel _tempModel;
    private ExtCompleteTempModel _compareTempModel;
    private KDExt ext;
    private ParamView paramUI;
    private KDTextArea _listField;
    private SpreadContext _reslutContext;
    private SpreadContext _compareContext;
    private DataView _resultData;
    private DataView _compareData;
    private KDTextArea _logField;
    private KDPanel panel;

    public ExtCompleteTempUI(ExtCallbackImpl extCallbackImpl) {
        this.setSize(800, 600);
        this.setTitle("\u5168\u4fe1\u606f\u62a5\u8868\u6a21\u677f\u5206\u6790\u5668   \u7248\u672c\uff1a" + KDCompleteBookVersion.getCurentVersion());
        this.setExtendedState(6);
        CtrlSwingUtilities.makeAlignBounds((boolean)true, (boolean)true, (Component)((Object)this));
        this.panel = new KDPanel();
        this.panel.setLayout((LayoutManager)new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ExtCompleteTempUI.this._tempPerspective != null) {
                    ExtCompleteTempUI.this._tempPerspective.persist();
                }
                if (ExtCompleteTempUI.this._resultPerspective != null) {
                    ExtCompleteTempUI.this._resultPerspective.persist();
                }
                if (ExtCompleteTempUI.this._dataPerspective != null) {
                    ExtCompleteTempUI.this._dataPerspective.persist();
                }
                TrimDatabase.persist();
            }
        });
        this._extCallbackImpl = extCallbackImpl;
        this.initUI();
    }

    protected void initUI() {
        this._logField = new KDTextArea();
        this._logField.setEditable(false);
        this._listField = new KDTextArea();
        this._listField.setEditable(false);
        this.paramUI = new ParamView();
        this._btnViewManager = new KDWorkButton("\u89c6\u56fe\u7ba1\u7406");
        this._btnViewManager.setToolTipText("\u89c6\u56fe\u7ba1\u7406");
        this._btnViewManager.setIcon(EASResource.getIcon((String)"imgTbtn_choosein"));
        this._btnViewManager.setEnabled(false);
        this._btnViewManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrimDatabase.showTrimList((Perspective)ExtCompleteTempUI.this.nowSpective);
            }
        });
        this._btnTempView = new KDWorkButton("\u62a5\u8868\u6a21\u677f");
        this._btnTempView.setToolTipText("\u62a5\u8868\u6a21\u677f");
        this._btnTempView.setIcon(EASResource.getIcon((String)"imgTbtn_list"));
        this._btnTempView.setEnabled(false);
        this._btnTempView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtCompleteTempUI.this.panel.removeAll();
                ExtCompleteTempUI.this.panel.add((Component)ExtCompleteTempUI.this.getTempPerspective(), (Object)"Center");
                ExtCompleteTempUI.this.panel.repaint();
                ExtCompleteTempUI.this.nowSpective = ExtCompleteTempUI.this._tempPerspective;
                ExtCompleteTempUI.this._btnTempView.setEnabled(false);
                ExtCompleteTempUI.this._btnResultView.setEnabled(true);
                ExtCompleteTempUI.this._btnDataView.setEnabled(true);
            }
        });
        this._btnResultView = new KDWorkButton("\u7ed3\u679c\u5206\u6790");
        this._btnResultView.setToolTipText("\u7ed3\u679c\u5206\u6790");
        this._btnResultView.setIcon(EASResource.getIcon((String)"imgTbtn_list"));
        this._btnResultView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtCompleteTempUI.this.panel.removeAll();
                ExtCompleteTempUI.this.panel.add((Component)ExtCompleteTempUI.this.getResultPerspective(), (Object)"Center");
                ExtCompleteTempUI.this.panel.repaint();
                ExtCompleteTempUI.this.nowSpective = ExtCompleteTempUI.this._resultPerspective;
                ExtCompleteTempUI.this._btnTempView.setEnabled(true);
                ExtCompleteTempUI.this._btnResultView.setEnabled(false);
                ExtCompleteTempUI.this._btnDataView.setEnabled(true);
            }
        });
        this._btnDataView = new KDWorkButton("\u6570\u636e\u5206\u6790");
        this._btnDataView.setToolTipText("\u6570\u636e\u5206\u6790");
        this._btnDataView.setIcon(EASResource.getIcon((String)"imgTbtn_list"));
        this._btnDataView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtCompleteTempUI.this.panel.removeAll();
                ExtCompleteTempUI.this.panel.add((Component)ExtCompleteTempUI.this.getDataPerspective(), (Object)"Center");
                ExtCompleteTempUI.this.panel.repaint();
                ExtCompleteTempUI.this.nowSpective = ExtCompleteTempUI.this._dataPerspective;
                ExtCompleteTempUI.this._btnTempView.setEnabled(true);
                ExtCompleteTempUI.this._btnResultView.setEnabled(true);
                ExtCompleteTempUI.this._btnDataView.setEnabled(false);
            }
        });
        this.initTempView();
        this.initResultView();
        this.initDataView();
        this.getTempPerspective();
        this.getResultPerspective();
        this.getDataPerspective();
        this.panel.add((Component)this.getTempPerspective(), (Object)"Center");
        this.getContentPane().add((Component)this.panel);
    }

    private void initTempView() {
        this._btnImport = new KDWorkButton("\u5bfc\u5165\u6a21\u677f");
        this._btnImport.setToolTipText("\u5bfc\u5165\u6a21\u677f");
        this._btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this._btnImport.setEnabled(false);
        this._btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDFileChooser chooser = new KDFileChooser();
                chooser.setDialogType(0);
                chooser.setDialogTitle("\u5bfc\u5165\u6a21\u677f");
                FileFilter[] ff = chooser.getChoosableFileFilters();
                for (int i = 0; i < ff.length; ++i) {
                    chooser.removeChoosableFileFilter(ff[i]);
                }
                chooser.setApproveButtonText("\u5bfc\u5165\u6a21\u677f");
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return "complete-kds".equals(CtrlUtil.File.getExtension((File)f)) || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return ".complete-kds";
                    }
                });
                int r = chooser.showOpenDialog((Component)ExtCompleteTempUI.this.getContentPane());
                if (r == 0) {
                    try {
                        ExtCompleteTempUI.this._tempModel = new ExtCompleteTempModel();
                        ExtCompleteTempUI.this._tempModel.importCompleteReport(chooser.getSelectedFile());
                        ExtCompleteTempUI.this.updataTempView(ExtCompleteTempUI.this._tempModel);
                    }
                    catch (FileNotFoundException e1) {
                        MessageUtil.msgboxWarning((Component)ExtCompleteTempUI.this._btnImport, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
                        logger.error((Object)e1);
                    }
                }
            }
        });
        this._btnData = new KDWorkButton("\u67e5\u770b\u6570\u636e");
        this._btnData.setToolTipText("\u67e5\u770b\u6570\u636e");
        this.showDataAction = new ShowExcuteDataAction((Component)((Object)this));
        this._btnData.setAction((Action)this.showDataAction);
        this._btnData.setEnabled(false);
        this._btnData.setIcon((Icon)ResourceManager.getImageIcon((String)"dataset.gif"));
        this._tempToolBar = new KDToolBar();
        this._tempToolBar.add((Component)this._btnImport);
        this._tempToolBar.add((Component)this._btnData);
    }

    private void initResultView() {
        this._btnImportCompare2 = new KDWorkButton("\u5bfc\u5165\u6bd4\u8f83\u6a21\u677f");
        this._btnImportCompare2.setToolTipText("\u5bfc\u5165\u6bd4\u8f83\u6a21\u677f");
        this._btnImportCompare2.setEnabled(false);
        this._btnImportCompare2.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this._btnImportCompare2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtCompleteTempUI.this.comparePerformed();
            }
        });
        this._btnResultDiff = new KDWorkButton("\u4e0b\u4e00\u5904\u5dee\u5f02");
        this._btnResultDiff.setToolTipText("\u4e0b\u4e00\u5904\u5dee\u5f02");
        this._btnResultDiff.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this._btnResultDiff.setEnabled(false);
        this._btnResultDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtCompleteTempUI.this.compareSpread(ExtCompleteTempUI.this._reslutContext, ExtCompleteTempUI.this._compareContext);
            }
        });
        this._resultToolBar = new KDToolBar();
        this._resultToolBar.add((Component)this._btnImportCompare2);
        this._resultToolBar.add((Component)this._btnResultDiff);
    }

    private void initDataView() {
        this._btnImportCompare = new KDWorkButton("\u5bfc\u5165\u6bd4\u8f83\u6a21\u677f");
        this._btnImportCompare.setToolTipText("\u5bfc\u5165\u6bd4\u8f83\u6a21\u677f");
        this._btnImportCompare.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this._btnImportCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtCompleteTempUI.this.comparePerformed();
            }
        });
        this._btnImportCompare.setEnabled(false);
        this._btnDataDiff = new KDWorkButton("\u4e0b\u4e00\u5904\u5dee\u5f02");
        this._btnDataDiff.setToolTipText("\u4e0b\u4e00\u5904\u5dee\u5f02");
        this._btnDataDiff.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this._btnDataDiff.setEnabled(false);
        this._btnDataDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtCompleteTempUI.this.nextDifferent();
            }
        });
        this._dataToolBar = new KDToolBar();
        this._dataToolBar.add((Component)this._btnImportCompare);
        this._dataToolBar.add((Component)this._btnDataDiff);
    }

    private void addSpecToolBar(KDToolBar toolBar) {
        toolBar.addSeparator();
        toolBar.add((Component)this._btnViewManager);
        toolBar.add((Component)this._btnTempView);
        toolBar.add((Component)this._btnResultView);
        toolBar.add((Component)this._btnDataView);
        this.removeAllToolBar();
        this.addToolBar((JToolBar)toolBar);
    }

    private Perspective getTempPerspective() {
        TrimViewPane listPane;
        TrimViewPane paramPane;
        TrimViewPane exePane;
        this.addSpecToolBar(this._tempToolBar);
        if (this._tempPerspective != null) {
            return this._tempPerspective;
        }
        this._tempPerspective = new Perspective("tempView", _version);
        if (!this._tempPerspective.isAutoInstantiated()) {
            exePane = new TrimViewPane();
            paramPane = new TrimViewPane();
            listPane = new TrimViewPane();
        } else {
            exePane = (TrimViewPane)((TrimWidgetViewport)this._tempPerspective.getTrimWidget("exeTemp")).getView();
            paramPane = (TrimViewPane)((TrimWidgetViewport)this._tempPerspective.getTrimWidget("param")).getView();
            listPane = (TrimViewPane)((TrimWidgetViewport)this._tempPerspective.getTrimWidget("list")).getView();
        }
        exePane.setCustomInsets(new Insets(0, 0, 0, 0));
        new Thread(new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                ExtCompleteTempUI.this.ext = new KDExt((IExtCallback)ExtCompleteTempUI.this._extCallbackImpl);
                ExtCompleteTempUI.this._extCallbackImpl.setExt(ExtCompleteTempUI.this.ext);
                time = System.currentTimeMillis() - time;
                System.out.println("ext: " + time);
                try {
                    ExtCompleteTempUI.this.ext.refresh();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                exePane.add(ExtCompleteTempUI.this.ext.getRootPane(), "Center");
                exePane.validate();
                ExtCompleteTempUI.this._btnImport.setEnabled(true);
                ExtCompleteTempUI.this._btnViewManager.setEnabled(true);
            }
        }).start();
        paramPane.add((Component)((Object)this.paramUI), "Center");
        KDScrollPane listScroll = new KDScrollPane((Component)this._listField);
        listPane.setLayout(new BorderLayout());
        listPane.add((Component)listScroll, "Center");
        if (!this._tempPerspective.isAutoInstantiated()) {
            TrimWidgetManager manager = this._tempPerspective.getTrimWidgetManager();
            TrimWidgetViewport exeTrim = new TrimWidgetViewport("exeTemp", (ITrimView)exePane);
            exeTrim.setTitle("\u62a5\u8868\u6a21\u677f");
            TrimWidgetViewport paramTrim = new TrimWidgetViewport("param", (ITrimView)paramPane);
            paramTrim.setTitle("\u53c2\u6570");
            TrimWidgetViewport listTrim = new TrimWidgetViewport("list", (ITrimView)listPane);
            listTrim.setTitle("\u6e05\u5355");
            exeTrim.setCategory("\u6a21\u677f\u89c6\u56fe");
            paramTrim.setCategory("\u6a21\u677f\u89c6\u56fe");
            listTrim.setCategory("\u6a21\u677f\u89c6\u56fe");
            this._tempPerspective.registerTrimWidget("exeTemp", (ITrimWidget)exeTrim);
            this._tempPerspective.registerTrimWidget("param", (ITrimWidget)paramTrim);
            this._tempPerspective.registerTrimWidget("list", (ITrimWidget)listTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)exeTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)paramTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)listTrim);
            manager.addTrim(2, (ITrimWidget)exeTrim, null);
            manager.addTrim(2, (ITrimWidget)paramTrim, (ITrimWidget)exeTrim);
            manager.addTrim(4, (ITrimWidget)listTrim, (ITrimWidget)paramTrim);
            this._tempPerspective.persistToCache();
        }
        this.nowSpective = this._tempPerspective;
        return this._tempPerspective;
    }

    private Perspective getResultPerspective() {
        TrimViewPane extPane;
        TrimViewPane reslutPane;
        this.addSpecToolBar(this._resultToolBar);
        if (this._resultPerspective != null) {
            return this._resultPerspective;
        }
        this._resultPerspective = new Perspective("resultView", _version);
        if (!this._resultPerspective.isAutoInstantiated()) {
            reslutPane = new TrimViewPane();
            extPane = new TrimViewPane();
        } else {
            reslutPane = (TrimViewPane)((TrimWidgetViewport)this._resultPerspective.getTrimWidget("reslutReport")).getView();
            extPane = (TrimViewPane)((TrimWidgetViewport)this._resultPerspective.getTrimWidget("exeReport")).getView();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                ExtCompleteTempUI.this._reslutContext = new SpreadContext();
                time = System.currentTimeMillis() - time;
                System.out.println("context: " + time);
                reslutPane.add((Component)ExtCompleteTempUI.this._reslutContext, "Center");
                ExtCompleteTempUI.this._compareContext = new SpreadContext();
                time = System.currentTimeMillis() - time;
                System.out.println("context: " + time);
                extPane.add((Component)ExtCompleteTempUI.this._compareContext, "Center");
                ExtCompleteTempUI.this.syncSpread(ExtCompleteTempUI.this._reslutContext, ExtCompleteTempUI.this._compareContext);
            }
        }).start();
        if (!this._resultPerspective.isAutoInstantiated()) {
            TrimWidgetManager manager = this._resultPerspective.getTrimWidgetManager();
            TrimWidgetViewport reslutTrim = new TrimWidgetViewport("reslutReport", (ITrimView)reslutPane);
            reslutTrim.setTitle("\u5ba2\u6237\u6267\u884c\u7ed3\u679c");
            TrimWidgetViewport exeTrim = new TrimWidgetViewport("exeReport", (ITrimView)extPane);
            exeTrim.setTitle("\u672c\u5730\u6267\u884c\u7ed3\u679c");
            reslutTrim.setCategory("\u7ed3\u679c\u5206\u6790");
            exeTrim.setCategory("\u7ed3\u679c\u5206\u6790");
            this._resultPerspective.registerTrimWidget("reslutReport", (ITrimWidget)reslutTrim);
            this._resultPerspective.registerTrimWidget("exeReport", (ITrimWidget)exeTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)reslutTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)exeTrim);
            manager.addTrim(2, (ITrimWidget)reslutTrim, null);
            manager.addTrim(4, (ITrimWidget)exeTrim, (ITrimWidget)reslutTrim, 0.5);
            this._resultPerspective.persistToCache();
        }
        return this._resultPerspective;
    }

    private Perspective getDataPerspective() {
        TrimViewPane logPane;
        TrimViewPane comparePane;
        TrimViewPane reslutPane;
        this.addSpecToolBar(this._dataToolBar);
        if (this._dataPerspective != null) {
            return this._dataPerspective;
        }
        this._dataPerspective = new Perspective("dataView", _version);
        if (!this._dataPerspective.isAutoInstantiated()) {
            reslutPane = new TrimViewPane();
            comparePane = new TrimViewPane();
            logPane = new TrimViewPane();
        } else {
            reslutPane = (TrimViewPane)((TrimWidgetViewport)this._dataPerspective.getTrimWidget("reslutData")).getView();
            comparePane = (TrimViewPane)((TrimWidgetViewport)this._dataPerspective.getTrimWidget("compareData")).getView();
            logPane = (TrimViewPane)((TrimWidgetViewport)this._dataPerspective.getTrimWidget("log")).getView();
        }
        this._resultData = new DataView();
        reslutPane.add((Component)((Object)this._resultData), "Center");
        this._compareData = new DataView();
        comparePane.add((Component)((Object)this._compareData), "Center");
        KDScrollPane logScroll = new KDScrollPane((Component)this._logField);
        logPane.add((Component)logScroll, "Center");
        if (!this._dataPerspective.isAutoInstantiated()) {
            TrimWidgetManager manager = this._dataPerspective.getTrimWidgetManager();
            TrimWidgetViewport reslutTrim = new TrimWidgetViewport("reslutData", (ITrimView)reslutPane);
            reslutTrim.setTitle("\u62a5\u8868\u6570\u636e");
            TrimWidgetViewport compareTrim = new TrimWidgetViewport("compareData", (ITrimView)comparePane);
            compareTrim.setTitle("\u6bd4\u8f83\u6570\u636e");
            TrimWidgetViewport logTrim = new TrimWidgetViewport("log", (ITrimView)logPane);
            logTrim.setTitle("\u65e5\u5fd7");
            reslutTrim.setCategory("\u6570\u636e\u5206\u6790");
            compareTrim.setCategory("\u6570\u636e\u5206\u6790");
            logTrim.setCategory("\u6570\u636e\u5206\u6790");
            this._dataPerspective.registerTrimWidget("reslutData", (ITrimWidget)reslutTrim);
            this._dataPerspective.registerTrimWidget("compareData", (ITrimWidget)compareTrim);
            this._dataPerspective.registerTrimWidget("log", (ITrimWidget)logTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)reslutTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)compareTrim);
            TrimDatabase.registerTrimWidget((ITrimWidget)logTrim);
            manager.addTrim(2, (ITrimWidget)reslutTrim, null);
            manager.addTrim(2, (ITrimWidget)logTrim, (ITrimWidget)reslutTrim);
            manager.addTrim(4, (ITrimWidget)compareTrim, (ITrimWidget)reslutTrim, 0.5);
            this._dataPerspective.persistToCache();
        }
        return this._dataPerspective;
    }

    private void updataTempView(ExtCompleteTempModel tempModel) {
        try {
            if (!tempModel.checkVersion()) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u5206\u6790\u5668\u7248\u672c\u8fc7\u4f4e\uff0c\u5efa\u8bae\u5347\u7ea7\u5206\u6790\u5668\uff01");
            }
        }
        catch (FileNotFoundException e) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u4e0d\u5b58\u5728\u7248\u672c\u4fe1\u606f\u6587\u4ef6\uff0c\u6587\u4ef6\u88ab\u4fee\u6539\u8fc7\uff01");
        }
        this.ext.setBook(tempModel.getTempBook());
        if (tempModel.getReslutBook() != null) {
            this._reslutContext.setBook(tempModel.getReslutBook());
        } else {
            this._reslutContext.setBook(Book.Manager.getNewBook(null, (int)3));
        }
        if (tempModel.getExeBook() != null) {
            this._compareContext.setBook(tempModel.getExeBook());
        } else {
            this._compareContext.setBook(Book.Manager.getNewBook(null, (int)3));
        }
        this._logField.setText(tempModel.getLogs());
        this._listField.setText(tempModel.getVersion());
        this.showDataAction.setBook(this._tempModel.getTempBook());
        this._resultData.setDataManager(this._tempModel.getTempBook().getDataSetManager());
        this._btnData.setEnabled(true);
        this._btnImportCompare.setEnabled(true);
        this._btnImportCompare2.setEnabled(true);
        this.paramUI.setDataManager(tempModel.getTempBook());
        this._compareData.removeAll();
        this._btnResultDiff.setEnabled(true);
        this._btnDataDiff.setEnabled(false);
    }

    private void comparePerformed() {
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogType(0);
        chooser.setDialogTitle("\u5bfc\u5165\u6a21\u677f");
        FileFilter[] ff = chooser.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            chooser.removeChoosableFileFilter(ff[i]);
        }
        chooser.setApproveButtonText("\u5bfc\u5165\u6a21\u677f");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return "complete-kds".equals(CtrlUtil.File.getExtension((File)f)) || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return ".complete-kds";
            }
        });
        int r = chooser.showOpenDialog((Component)this.getContentPane());
        if (r == 0) {
            try {
                this._compareTempModel = new ExtCompleteTempModel();
                this._compareTempModel.importCompleteReport(chooser.getSelectedFile());
                this.updataCompareTempView(this._compareTempModel);
            }
            catch (FileNotFoundException e1) {
                MessageUtil.msgboxWarning((Component)this._btnImport, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
                logger.error((Object)e1);
            }
        }
    }

    private void updataCompareTempView(ExtCompleteTempModel model) {
        try {
            if (!model.checkVersion()) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u5206\u6790\u5668\u7248\u672c\u8fc7\u4f4e\uff0c\u5efa\u8bae\u5347\u7ea7\u5206\u6790\u5668\uff01");
            }
        }
        catch (FileNotFoundException e1) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u4e0d\u5b58\u5728\u7248\u672c\u4fe1\u606f\u6587\u4ef6\uff0c\u6587\u4ef6\u88ab\u4fee\u6539\u8fc7\uff01");
        }
        this._compareData.setDataManager(model.getTempBook().getDataSetManager());
        if (model.getReslutBook() != null) {
            this._compareContext.setBook(model.getReslutBook());
        } else {
            this._compareContext.setBook(Book.Manager.getNewBook(null, (int)3));
        }
        this._btnDataDiff.setEnabled(true);
        int size = Math.min(this._compareData.getTabCount(), this._resultData.getTabCount());
        for (int i = 0; i < size; ++i) {
            this.syncTable((KDTable)this._resultData.getComponentAt(i), (KDTable)this._compareData.getComponentAt(i));
        }
        this._compareData.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size;
                DataView tabbedPane = (DataView)((Object)e.getSource());
                int selectedIndex = tabbedPane.getSelectedIndex();
                if (selectedIndex < (size = Math.min(ExtCompleteTempUI.this._compareData.getTabCount(), ExtCompleteTempUI.this._resultData.getTabCount())) && selectedIndex > -1) {
                    if (ExtCompleteTempUI.this._resultData.getSelectedIndex() != selectedIndex) {
                        ExtCompleteTempUI.this._resultData.setSelectedIndex(selectedIndex);
                    }
                    ExtCompleteTempUI.this._btnDataDiff.setEnabled(true);
                } else {
                    ExtCompleteTempUI.this._btnDataDiff.setEnabled(false);
                }
            }
        });
        this._resultData.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size;
                DataView tabbedPane = (DataView)((Object)e.getSource());
                int selectedIndex = tabbedPane.getSelectedIndex();
                if (selectedIndex < (size = Math.min(ExtCompleteTempUI.this._compareData.getTabCount(), ExtCompleteTempUI.this._resultData.getTabCount())) && selectedIndex > -1) {
                    if (ExtCompleteTempUI.this._compareData.getSelectedIndex() != selectedIndex) {
                        ExtCompleteTempUI.this._compareData.setSelectedIndex(selectedIndex);
                    }
                    ExtCompleteTempUI.this._btnDataDiff.setEnabled(true);
                } else {
                    ExtCompleteTempUI.this._btnDataDiff.setEnabled(false);
                }
            }
        });
    }

    private void syncSpread(SpreadContext reslutContext, SpreadContext extContext) {
        JScrollBar reslutHSb = reslutContext.getSpread().getScrollBarManager().getHScrollBar(2);
        JScrollBar exeHSb = extContext.getSpread().getScrollBarManager().getHScrollBar(2);
        this.syncScrollBar(reslutHSb, exeHSb);
        final JScrollBar reslutVSb = reslutContext.getSpread().getScrollBarManager().getVScrollBar(2);
        final JScrollBar exeVSb = extContext.getSpread().getScrollBarManager().getVScrollBar(2);
        this.syncScrollBar(reslutVSb, exeVSb);
        reslutContext.getSpread().getActiveView().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ExtCompleteTempUI.this.changeValue(reslutVSb.getValue(), exeVSb);
            }
        });
        extContext.getSpread().getActiveView().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ExtCompleteTempUI.this.changeValue(exeVSb.getValue(), reslutVSb);
            }
        });
    }

    private void syncTable(KDTable resultTable, KDTable compareTable) {
        final JScrollBar reslutVSb = resultTable.getLayoutManager().getVertical(1).getScrollBar();
        final JScrollBar compareVSb = compareTable.getLayoutManager().getVertical(1).getScrollBar();
        if (reslutVSb != null && compareVSb != null) {
            this.syncScrollBar(reslutVSb, compareVSb);
            KDTViewManager manager = resultTable.getViewManager();
            KDTView view = (KDTView)manager.getView(5);
            view.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    ExtCompleteTempUI.this.changeValue(reslutVSb.getValue(), compareVSb);
                }
            });
            manager = compareTable.getViewManager();
            view = (KDTView)manager.getView(5);
            view.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    ExtCompleteTempUI.this.changeValue(compareVSb.getValue(), reslutVSb);
                }
            });
        }
        JScrollBar reslutHSb = resultTable.getLayoutManager().getHorizon(2).getScrollBar();
        JScrollBar compareHSb = compareTable.getLayoutManager().getHorizon(2).getScrollBar();
        if (reslutHSb != null && compareHSb != null) {
            this.syncScrollBar(reslutHSb, compareHSb);
        }
    }

    private void syncScrollBar(final JScrollBar sb1, final JScrollBar sb2) {
        sb1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ExtCompleteTempUI.this.changeValue(sb1.getValue(), sb2);
            }
        });
        sb2.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ExtCompleteTempUI.this.changeValue(sb2.getValue(), sb1);
            }
        });
    }

    private void changeValue(int value, JScrollBar sb) {
        if (sb.getValue() != value && value <= sb.getModel().getMaximum() && value >= sb.getModel().getMinimum()) {
            sb.setValue(value);
        }
    }

    private void nextDifferent() {
        KDTable result = this._resultData.getSelectTable();
        KDTable compare = this._compareData.getSelectTable();
        if (result.getRowCount() == 0) {
            this.selectNextCell(compare);
            return;
        }
        if (compare.getRowCount() == 0) {
            this.selectNextCell(result);
            return;
        }
        int minRow = Math.min(result.getRowCount(), compare.getRowCount());
        int minCol = Math.min(result.getColumnCount(), compare.getColumnCount());
        int maxRow = Math.max(result.getRowCount(), compare.getRowCount());
        int maxCol = Math.max(result.getColumnCount(), compare.getColumnCount());
        int row = 0;
        int col = 0;
        KDTSelectBlock selectBlock = result.getSelectManager().get();
        if (selectBlock != null) {
            row = selectBlock.getEndRow();
            col = selectBlock.getEndCol();
        }
        int compareRow = 0;
        int compareCol = 0;
        KDTSelectBlock cSelectBlock = compare.getSelectManager().get();
        if (cSelectBlock != null) {
            compareRow = cSelectBlock.getEndRow();
            compareCol = cSelectBlock.getEndCol();
        }
        if (col == result.getColumnCount() - 1) {
            if (row == compareRow) {
                col = Math.max(col, compareCol);
            } else if (row > compareRow) {
                col = maxCol;
            } else if (row == result.getRowCount() - 1 && row < compareRow) {
                this.selectNextCell(compare);
                return;
            }
        }
        ++col;
        while (row < maxRow) {
            while (col < maxCol) {
                if (row < minRow && col < minCol) {
                    Object compareValue;
                    Object resultValue = result.getCell(row, col).getValue();
                    if (!resultValue.equals(compareValue = compare.getCell(row, col).getValue())) {
                        this.selectBlock(result, row, col);
                        this.selectBlock(compare, row, col);
                        return;
                    }
                } else {
                    this.selectBlock(result, row, col);
                    this.selectBlock(compare, row, col);
                    return;
                }
                ++col;
            }
            if (col > maxCol - 1) {
                col = 0;
            }
            ++row;
        }
        MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u6ca1\u6709\u66f4\u591a\u5dee\u5f02\uff01");
    }

    private void selectNextCell(KDTable table) {
        int row = -1;
        int col = -1;
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (selectBlock != null) {
            row = selectBlock.getEndRow();
            col = selectBlock.getEndCol();
        }
        if (col == table.getColumnCount() - 1) {
            if (row == table.getRowCount() - 1) {
                MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u6ca1\u6709\u66f4\u591a\u5dee\u5f02\uff01");
                row = 0;
                col = 0;
            } else {
                ++row;
                col = 0;
            }
        } else {
            ++col;
        }
        this.selectBlock(table, row, col);
    }

    private void selectBlock(KDTable table, int row, int col) {
        if (row > table.getRowCount() - 1) {
            row = table.getRowCount() - 1;
            col = table.getColumnCount() - 1;
        } else {
            col = Math.min(col, table.getColumnCount() - 1);
        }
        KDTSelectBlock selectBlock = new KDTSelectBlock(row, col, row, col);
        table.getSelectManager().select(selectBlock);
        table.scrollToVisible(row, col);
    }

    private void compareSpread(SpreadContext reslutContext, SpreadContext compareContext) {
        Sheet reslutSheet = reslutContext.getBook().getSheet(0);
        Sheet compareSheet = compareContext.getBook().getSheet(0);
        SortedRowArray reslutRows = reslutSheet.getRows();
        SortedColumnArray reslutCols = reslutSheet.getCols();
        SortedRowArray compareRows = compareSheet.getRows();
        SortedColumnArray compareCols = compareSheet.getCols();
        int maxRow = Math.max(reslutRows.size(), compareRows.size());
        int maxCol = Math.max(reslutCols.size(), compareCols.size());
        int col = reslutSheet.getSheetOption().getSelection().getActiveCol();
        ++col;
        for (int row = reslutSheet.getSheetOption().getSelection().getActiveRow(); row < maxRow; ++row) {
            while (col < maxCol) {
                Cell cCell;
                Cell rCell = reslutSheet.getCell(row, col, true);
                if (!this.compareCell(rCell, cCell = compareSheet.getCell(row, col, true))) {
                    CellBlock cellBlock = CellBlock.getCellBlock((int)row, (int)col, (int)row, (int)col);
                    reslutSheet.getSheetOption().getSelection().setActiveCell(row, col);
                    compareSheet.getSheetOption().getSelection().setActiveCell(row, col);
                    reslutSheet.getSheetOption().getSelection().changeSelection(cellBlock, 2);
                    compareSheet.getSheetOption().getSelection().changeSelection(cellBlock, 2);
                    reslutContext.getSpread().scrollActiveCellVisible();
                    compareContext.getSpread().scrollActiveCellVisible();
                    return;
                }
                ++col;
            }
            if (col <= maxCol - 1) continue;
            col = 0;
        }
        MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u6ca1\u6709\u66f4\u591a\u5dee\u5f02\uff01");
    }

    private boolean compareCell(Cell cell, Cell compareCell) {
        if (!cell.getFormula().equals(compareCell.getFormula())) {
            return false;
        }
        if (!cell.getValue2().equals(compareCell.getValue2())) {
            return false;
        }
        if (!cell.getText().equals(compareCell.getText())) {
            return false;
        }
        return cell.getDisplayStyle().equals((Object)compareCell.getDisplayStyle());
    }

    private String pareDateTime(Variant value, int dataType) {
        String vtTemp = "";
        if (dataType == 2) {
            Date date = null;
            try {
                date = value.toDate();
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)e);
            }
            vtTemp = CtrlReportUtil.sdf_yyyy_MM_dd.format(date);
        } else if (dataType == 4) {
            Date date = null;
            try {
                date = value.toDate();
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)e);
            }
            vtTemp = CtrlReportUtil.sdfDateTime.format(date);
        } else if (dataType == 5) {
            Date date = null;
            try {
                date = value.toDate();
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)e);
            }
            vtTemp = CtrlReportUtil.sdfTime.format(date);
        } else {
            vtTemp = CtrlReportUtil.getObjectString(value.toString());
        }
        return vtTemp;
    }

    private class ParamView
    extends KDTable {
        private static final long serialVersionUID = -1849913333737838349L;
        private static final int NAME = 0;
        private static final int ALIAS = 1;
        private static final int INPUTTYPE = 2;
        private static final int DATATYPE = 3;
        private static final int DEFAULTVALUE = 4;
        private static final int VALUE = 5;
        private static final int NULLABLE = 6;
        private static final int INPUTSTATE = 7;
        private static final int DESCRIPTION = 8;

        public ParamView() {
            this.setEnabled(false);
            this.initTaleHeader();
        }

        public ParamView(Book book) {
            this.setEnabled(false);
            this.initTaleHeader();
            this.setDataManager(book);
        }

        private void initTaleHeader() {
            this.addColumns(9);
            IRow headRow = this.addHeadRow();
            headRow.getCell(0).setValue((Object)"\u53c2\u6570\u540d");
            headRow.getCell(1).setValue((Object)"\u663e\u793a\u540d\u79f0");
            headRow.getCell(2).setValue((Object)"\u63a7\u4ef6\u7c7b\u578b");
            headRow.getCell(3).setValue((Object)"\u6570\u636e\u7c7b\u578b");
            headRow.getCell(4).setValue((Object)"\u7f3a\u7701\u503c");
            headRow.getCell(5).setValue((Object)"\u53c2\u6570\u503c");
            headRow.getCell(6).setValue((Object)"\u5141\u8bb8\u7a7a\u503c");
            headRow.getCell(7).setValue((Object)"\u72b6\u6001");
            headRow.getCell(8).setValue((Object)"\u8bf4\u660e");
            this.getColumn(8).setWidth(180);
        }

        public void setDataManager(Book book) {
            this.removeRows();
            ExtDataSetManager manager = book.getDataSetManager();
            Map parameters = manager.getExecutionContext().getDataSetParameters();
            if (parameters == null || parameters.size() < 1) {
                return;
            }
            ArrayList allUnionParam = new ArrayList();
            try {
                RunReportParam.cacheDbSourceModel(null, MiscUtil.collectExtDataSets((Book)book), allUnionParam, null);
            }
            catch (CtrlReportException e) {
                logger.error((Object)e);
            }
            for (int i = 0; i < allUnionParam.size(); ++i) {
                DesignParameter parameter = (DesignParameter)((Object)allUnionParam.get(i));
                IParameter value = (IParameter)parameters.get(parameter.getName());
                this.addRow();
                this.getCell(i, 0).setValue((Object)parameter.getName());
                this.getCell(i, 1).setValue((Object)parameter.getAlias());
                if (parameter.getInputType() != null) {
                    this.getCell(i, 2).setValue((Object)parameter.getInputType().getName());
                } else {
                    this.getCell(i, 2).setValue((Object)"\u7a7a\u63a7\u4ef6");
                }
                this.getCell(i, 3).setValue((Object)parameter.getDesignDataType().getName());
                if (parameter.getDefaultValue() != null) {
                    this.getCell(i, 4).setValue((Object)parameter.getDefaultValue().replaceAll("0xx1xx", ";"));
                }
                if (value != null) {
                    Variant[] vts;
                    Variant valueObject = value.getValue();
                    int dataType = value.getDataType();
                    String valueString = CtrlReportUtil.getObjectString(ExtCompleteTempUI.this.pareDateTime(valueObject, dataType));
                    if (valueObject instanceof Variant && valueObject.isArray() && null != (vts = (Variant[])valueObject.getValue())) {
                        valueString = "";
                        int length = vts.length;
                        for (int i1 = 0; i1 < length; ++i1) {
                            Variant vt = vts[i1];
                            String vtTemp = ExtCompleteTempUI.this.pareDateTime(vt, dataType);
                            valueString = valueString + vtTemp + ";";
                        }
                        if (!valueString.equals("")) {
                            valueString = valueString.substring(0, valueString.length() - 1);
                        }
                    }
                    this.getCell(i, 5).setValue((Object)valueString);
                    this.getCell(i, 8).setValue((Object)value.getDescription());
                }
                this.getCell(i, 6).setValue((Object)new Boolean(parameter.isAllowNull()));
                this.getCell(i, 7).setValue((Object)parameter.getInputState());
            }
        }
    }

    private class DataView
    extends KDTabbedPane {
        private static final long serialVersionUID = 3285312419962013066L;
        private ExtDataSetManager _manager;

        public DataView() {
        }

        public DataView(ExtDataSetManager manager) {
            this.setDataManager(manager);
        }

        public void setDataManager(ExtDataSetManager manager) {
            this._manager = manager;
            this.mode2ui();
        }

        private void mode2ui() {
            this.removeAll();
            int size = this._manager.size();
            for (int i = 0; i < size; ++i) {
                ExtDataSet dataset = this._manager.getAt(i);
                SortedObjectArray _columns = dataset.getColumns();
                ExtColumn[] columns = new ExtColumn[_columns.size()];
                ArrayList<ExtColumn> files = new ArrayList<ExtColumn>();
                for (int j = 0; j < columns.length; ++j) {
                    ExtColumn col = (ExtColumn)_columns.get(j);
                    int index = (Integer)col.getIndex().getValue();
                    if (index >= columns.length) {
                        files.add(col);
                        continue;
                    }
                    columns[index] = col;
                }
                int fileSize = files.size();
                if (fileSize > 0) {
                    String detail = "\u6570\u636e\u6e90\uff1a" + dataset.getAlias() + "\n\u4e0d\u4e00\u81f4\u5b57\u6bb5\uff1a[" + ((ExtColumn)files.get(0)).getAlias() + "]";
                    String errorInfo = "\u5b9e\u9645\u8fd4\u56de\u7684\u6570\u636e\u96c6\u5217\u6570\u4e0e\u62a5\u8868\u5f15\u5165\u7684\u6570\u636e\u96c6\u5b9a\u4e49\u5217\u6570\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u5728\u62a5\u8868\u4e2d\u5f15\u5165\u6570\u636e\u96c6\u540e\u4fee\u6539\u4e86\u6570\u636e\u96c6\u7684\u5b9a\u4e49\u3002";
                    for (int j = 1; j < fileSize; ++j) {
                        detail = detail + ", [" + ((ExtColumn)files.get(j)).getAlias() + "]";
                    }
                    detail = detail + "\u3002";
                    AdvMsgBox msgBox = AdvMsgBox.createAdvMsgBox((Component)((Object)this), (String)"\u9519\u8bef\u4fe1\u606f", (String)errorInfo, (String)detail, (int)0, (int)8188);
                    msgBox.show();
                    return;
                }
                if (columns.length <= 0) {
                    return;
                }
                KDTable table = new KDTable();
                this.setTaleHeader(table, columns);
                this.bindDataSet(table, dataset);
                this.addTab(dataset.getName(), null, (Component)table, true);
            }
        }

        private void setTaleHeader(KDTable table, ExtColumn[] columns) {
            int length = columns.length;
            table.addColumns(length);
            IRow headRow = table.addHeadRow();
            for (int i = 0; i < length; ++i) {
                String rowHeader = columns[i].getName();
                headRow.getCell(i).setValue((Object)rowHeader.toUpperCase());
            }
        }

        private void bindDataSet(KDTable table, ExtDataSet dataset) {
            Variant[][] data = dataset.getData();
            if (data == null || data.length <= 0) {
                return;
            }
            int rows = data.length;
            int cols = data[0].length;
            for (int r = 0; r < rows; ++r) {
                table.addRow();
                for (int c = 0; c < cols; ++c) {
                    Variant value = data[r][c];
                    table.getCell(r, c).setValue((Object)value);
                }
            }
        }

        public KDTable getSelectTable() {
            return (KDTable)this.getSelectedComponent();
        }
    }
}

