/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.data.wizard.common.FieldEditorDialog;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.BaseTabUISelectorImp;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.FilterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OrderUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.SqlUI;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FieldUI
extends BaseTabUISelectorImp {
    private static final long serialVersionUID = 6837073713414197501L;
    private static FieldUI fieldUI = null;
    private static CtrlDesignQueryModel model = null;
    private KDTreeView kDTreeView1;
    private KDTree kDTree1;
    private FieldEditorDialog fieldEditor;
    private FormulaWizardEditor formulaWizard;
    private TableChangedHandler tableChangedHandler;
    private boolean isFirst = true;

    private FieldUI() {
        this.initCtrl();
        this.installListener();
        this.initTree();
    }

    public static final FieldUI getInstance() {
        if (fieldUI == null) {
            model = DesignUI.getInstance().getModel();
            fieldUI = new FieldUI();
        }
        return fieldUI;
    }

    public static final void destroy() {
        fieldUI = null;
    }

    @Override
    public KDPanel getPanel() {
        KDPanel panTemp = new KDPanel((LayoutManager)new BorderLayout());
        panTemp.setOpaque(false);
        panTemp.add((Component)((Object)fieldUI));
        return panTemp;
    }

    private void initCtrl() {
        this.getSelected().addButton((Action)new ActionEdit(), "edit");
        this.getSelected().syncBtn();
        this.kDTreeView1 = new KDTreeView();
        this.kDTreeView1.setMinimumSize(new Dimension(10, 10));
        this.kDTreeView1.setName("kDTreeView1");
        this.kDTree1 = new KDTree();
        this.kDTree1.setName("kDTree1");
        this.kDTreeView1.setTree(this.kDTree1);
        this.setSupplyTitle(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label36"));
        this.setSelectedTitle(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label37"));
        this.setSupplyCtrlNoScroll((JComponent)this.kDTreeView1);
    }

    private void installListener() {
        this.kDTree1.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(FieldUI.this.kDTree1.getModel().getRoot())) {
                    FieldUI.this.kDTree1.expandPath(new TreePath(FieldUI.this.kDTree1.getModel().getRoot()));
                }
            }
        });
        this.kDTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FieldUI.this.syncSelectButton();
            }
        });
        this.getSelectedList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FieldUI.this.editField();
                    return;
                }
                Object obj = ((KDList)e.getSource()).getSelectedValue();
                if (obj instanceof Column) {
                    String expr = ((Column)obj).getExpr();
                    expr = ExtStringUtil.replace(expr, "[", "");
                    expr = ExtStringUtil.replace(expr, "]", "");
                    DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)FieldUI.this.kDTree1.getModel().getRoot();
                    FieldUI.this.expandSelected(root, expr, "");
                }
            }
        });
        this.kDTree1.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FieldUI.this.kDTree1_mouseClicked(e);
            }
        });
        if (this.tableChangedHandler == null) {
            this.tableChangedHandler = new TableChangedHandler();
        }
        model.removePropertyChangedListener(this.tableChangedHandler);
        model.addPropertyChangedListener(this.tableChangedHandler);
    }

    protected void syncSelectButton() {
        boolean isSelectEnabled = false;
        boolean isSelectAllEnabled = false;
        TreePath path = this.kDTree1.getSelectionPath();
        if (path != null) {
            Object userObj = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
            isSelectEnabled = userObj instanceof MetaField;
            isSelectAllEnabled = userObj instanceof MetaClass;
        }
        this.btnSelect.setEnabled(isSelectEnabled);
        this.btnSelectAll.setEnabled(isSelectAllEnabled);
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree1.setShowsRootHandles(true);
        this.kDTree1.setRootVisible(false);
    }

    private boolean expandSelected(DefaultKingdeeTreeNode nodeRoot, String selectedPath, String tableName) {
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            Object obj = repNode.getUserObject();
            if (obj instanceof MetaClass) {
                tableName = ((MetaClass)obj).getName();
            } else if (obj instanceof MetaField) {
                MetaField bvNode = (MetaField)obj;
                String expr = tableName + "." + bvNode.getName();
                if (expr.equals(selectedPath)) {
                    Object[] pathtoRoot = repNode.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    this.kDTree1.expandPath(path);
                    this.kDTree1.setSelectionPath(path);
                    this.kDTree1.scrollPathToVisible(path);
                    flag = false;
                    break;
                }
            }
            if (flag = this.expandSelected(repNode, selectedPath, tableName)) continue;
            break;
        }
        return flag;
    }

    @Override
    public void syncModel2Ui() {
        DefaultKingdeeTreeNode oldRoot = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        DefaultKingdeeTreeNode newRoot = new DefaultKingdeeTreeNode();
        KsqlObjectSelector selector = model.getObjectSelector();
        ITableList queryTables = model.getQuery().getTables();
        boolean isExist = false;
        for (int i = 0; i < queryTables.size(); ++i) {
            ITable queryTable = (ITable)queryTables.get(i);
            DefaultKingdeeTreeNode nodeTable = null;
            isExist = false;
            int tableNodeCount = oldRoot.getChildCount();
            for (int j = 0; j < tableNodeCount; ++j) {
                DefaultKingdeeTreeNode nodeTableTemp = (DefaultKingdeeTreeNode)oldRoot.getChildAt(j);
                MetaClass existTable = (MetaClass)nodeTableTemp.getUserObject();
                if (!StringUtil.equals((String)queryTable.getName(), (String)existTable.getName()) || !StringUtil.equals((String)queryTable.getAlias(), (String)existTable.getAlias())) continue;
                nodeTable = nodeTableTemp;
                isExist = true;
                break;
            }
            if (!isExist) {
                MetaClass mc = selector.getMetaClassFromCache(queryTable.getName());
                if (mc == null) continue;
                MetaClass mcTable = new MetaClass();
                mcTable.copy((IDefObj)queryTable);
                mcTable.setFields(mc.getFields());
                nodeTable = new DefaultKingdeeTreeNode((Object)mcTable);
                for (MetaField mf : mcTable.getFields()) {
                    nodeTable.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)mf));
                }
            }
            newRoot.add(nodeTable);
        }
        TreePath path = this.kDTree1.getSelectionPath();
        DefaultKingdeeTreeNode nodeOriSelected = null;
        if (path != null) {
            nodeOriSelected = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        ((DefaultTreeModel)this.kDTree1.getModel()).setRoot((TreeNode)newRoot);
        this.kDTree1.expandAllNodes(true, (TreeNode)newRoot);
        if (newRoot.isNodeDescendant((DefaultMutableTreeNode)nodeOriSelected)) {
            this.kDTree1.setSelectionNode(nodeOriSelected);
        } else {
            this.kDTree1.setSelectionPath(null);
        }
        IColumnList queryColumns = model.getQuery().getColumns();
        this.getSelectedList().removeAllElements();
        for (int i = 0; i < queryColumns.size(); ++i) {
            this.getSelectedList().addElement(queryColumns.get(i));
        }
        this.syncSelectButton();
    }

    private void kDTree1_mouseClicked(MouseEvent e) {
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            this.addNodeToList();
        }
    }

    private void addNodeToList() {
        StringBuffer errPrompt = new StringBuffer();
        int errCount = 0;
        TreePath[] paths = this.kDTree1.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            Object firstUserObject = null;
            for (int i = 0; i < paths.length; ++i) {
                MetaClass metaClass;
                String err;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                Object userObject = node.getUserObject();
                if (firstUserObject == null) {
                    firstUserObject = userObject;
                }
                if (i > 0 && userObject.getClass() != firstUserObject.getClass()) {
                    return;
                }
                if (userObject instanceof MetaClass) {
                    for (int j = 0; j < node.getChildCount(); ++j) {
                        MetaField mf = (MetaField)((DefaultKingdeeTreeNode)node.getChildAt(j)).getUserObject();
                        String err2 = this.addField(mf, (MetaClass)userObject);
                        if (err2 == null) continue;
                        ++errCount;
                        if (errPrompt.length() != 0) continue;
                        errPrompt.append("\"");
                        errPrompt.append(err2);
                        errPrompt.append("\"");
                    }
                    continue;
                }
                if (!(userObject instanceof MetaField) || (err = this.addField((MetaField)userObject, metaClass = (MetaClass)((DefaultKingdeeTreeNode)node.getParent()).getUserObject())) == null) continue;
                ++errCount;
                if (errPrompt.length() != 0) continue;
                errPrompt.append("\"");
                errPrompt.append(err);
                errPrompt.append("\"");
            }
        }
        if (errCount > 0) {
            errPrompt.append(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label38"));
            errPrompt.append(errCount);
            errPrompt.append(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label39"));
            errPrompt.append(Wizard2Resource.getString((String)"res_30"));
            MessageUtil.showWarning((Component)((Object)this), errPrompt.toString());
        }
    }

    private String addField(MetaField metaField, MetaClass metaClass) {
        Column col = this.createObjectToSelect(metaField, metaClass);
        if (col == null) {
            return metaField.getAliasName();
        }
        int n = 1;
        while (FieldUI.isUserTable(col.getName())) {
            String name = col.getName() + "_" + n;
            col.setName(name);
        }
        WizardUtil.makeSureDefObjUnique((KDList)this.getSelectedList(), (IDefObj)col);
        this.getSelectedList().addElement((Object)col);
        this.getSelectedList().setSelectedValue((Object)col, true);
        this.setRefreshTab();
        return null;
    }

    private Column createObjectToSelect(MetaField metaField, MetaClass metaClass) {
        Column col = new Column();
        col.copy((IDefObj)metaField);
        col.setDataType(metaField.getType());
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(metaClass.getName());
        sb.append("].[");
        sb.append(metaField.getName());
        sb.append("]");
        col.setExpr(sb.toString());
        return col;
    }

    private void setRefreshTab() {
        FilterUI.refreshFromModel(true);
        OrderUI.refreshFromModel(true);
        SqlUI.refreshFromModel(true);
    }

    public static void refreshFromModel(boolean isRefreshFromModel) {
        if (fieldUI != null) {
            fieldUI.setRefreshFromModel(isRefreshFromModel);
        }
    }

    private void treeMoveNextNode() {
        if (this.kDTree1.getSelectionCount() > 1) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTree1.getSelectionPath().getLastPathComponent();
        DefaultKingdeeTreeNode next = (DefaultKingdeeTreeNode)node.getNextSibling();
        if (next != null) {
            this.kDTree1.setSelectionNode(next);
        } else {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
            int iAllCount = root.getChildCount();
            int iCurrentIndex = root.getIndex(node.getParent());
            if (iCurrentIndex < iAllCount - 1) {
                next = (DefaultKingdeeTreeNode)root.getChildAt(iCurrentIndex + 1).getChildAt(0);
                this.kDTree1.setSelectionNode(next);
            }
        }
    }

    @Override
    public void syncUi2Model() {
        KDList fieldList = this.getSelectedList();
        IColumnList list = model.getQuery().getColumns();
        list.clear();
        for (int i = 0; i < fieldList.getElementCount(); ++i) {
            Column column = (Column)fieldList.getElement(i);
            list.add(i, (Object)column);
        }
    }

    protected boolean onDelete() {
        int[] idxs = this.lvSelected.getList().getSelectedIndices();
        if (idxs.length == 0) {
            return false;
        }
        boolean confirm = MessageUtil.showConfirm(null, MessageUtil.getMsgInfo("label269"));
        if (!confirm) {
            return false;
        }
        for (int i = idxs.length - 1; i >= 0; --i) {
            Column col = (Column)this.lvSelected.getList().getElement(idxs[i]);
            String currentName = col.getName();
            this.lvSelected.getList().removeElementAt(idxs[i]);
            this.setRefreshTab();
            this.syncUi2Model();
            FilterUI.reWriteFilterConditionForDelete(model.getQuery(), currentName);
        }
        if (idxs[0] < this.lvSelected.getList().getElementCount()) {
            this.lvSelected.getList().setSelectedIndex(idxs[0]);
        } else {
            this.lvSelected.getList().setSelectedIndex(this.lvSelected.getList().getElementCount() - 1);
        }
        return true;
    }

    protected boolean onDeleteAll() {
        int[] idxs = this.lvSelected.getList().getSelectedIndices();
        if (idxs.length == 0) {
            return false;
        }
        boolean confirm = MessageUtil.showConfirm(null, MessageUtil.getMsgInfo("label269"));
        if (!confirm) {
            return false;
        }
        this.lvSelected.getList().removeAllElements();
        this.setRefreshTab();
        this.syncUi2Model();
        FilterUI.removeAllFilter(model.getQuery());
        return true;
    }

    protected void onSelectAll() {
        this.addNodeToList();
        this.syncUi2Model();
        try {
            OutputFieldsUI.setOutputColumns(model, false);
        }
        catch (CtrlReportException e) {
            MessageUtil.showDetailAndOK(null, e.getMessage(), e);
        }
    }

    @Override
    protected void onSelect() {
        this.addNodeToList();
        this.treeMoveNextNode();
        this.syncUi2Model();
        try {
            OutputFieldsUI.setOutputColumns(model, false);
        }
        catch (CtrlReportException e) {
            MessageUtil.showDetailAndOK(null, e.getMessage(), e);
        }
    }

    protected static boolean isUserTable(String name) {
        ITableList queryTables = model.getQuery().getTables();
        if (null != queryTables) {
            for (int i = 0; i < queryTables.size(); ++i) {
                ITable table = (ITable)queryTables.get(i);
                String tableName = table.getName();
                if (!tableName.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected void editField() {
        FieldEditorDialog editor = this.getFieldEditor();
        editor.setNewMode(false);
        Column col = (Column)this.getSelectedList().getSelectedValue();
        if (col == null) {
            return;
        }
        editor.setID(col.getName());
        editor.setAlias(col.getAlias());
        editor.setDesc(col.getDesc());
        editor.setExpr(col.getExpr());
        editor.setType(col.getDataType());
        if (editor.showDialog()) {
            if (FieldUI.isUserTable(editor.getID())) {
                MessageUtil.showInfo("label255", true);
                return;
            }
            this.setChanged(true);
            this.fireNameChanged(col, editor);
            if (!editor.getID().equalsIgnoreCase(col.getName())) {
                FilterUI.reWriteFilterCondition(model.getQuery(), col.getName(), editor.getID());
            }
            col.setAlias(editor.getAlias());
            col.setName(editor.getID());
            col.setDesc(editor.getDesc());
            col.setDataType(editor.getDataType());
            col.setExpr(editor.getExpr());
            this.getSelectedList().repaint();
            this.setRefreshTab();
            this.syncUi2Model();
        }
    }

    protected void fireNameChanged(Column col, FieldEditorDialog editor) {
        if (!editor.getAlias().equalsIgnoreCase(col.getAlias())) {
            model.firePropertyChanged(col, "field alias", col.getAlias(), editor.getAlias());
        }
        if (!editor.getID().equalsIgnoreCase(col.getName())) {
            model.firePropertyChanged(col, "field name", col.getName(), editor.getID());
        }
    }

    protected FieldEditorDialog getFieldEditor() {
        if (this.fieldEditor == null) {
            this.fieldEditor = this.createFieldEditor();
            this.fieldEditor.setFormula(this.getFormulaWizard());
            this.updateFormulaWizard(this.getFormulaWizard());
            this.fieldEditor.addVerifyListener(new FieldEditorDialog.VerifyListener(){

                public boolean isOK(FieldEditorDialog.VerifyEvent e) {
                    return FieldUI.this.verify(e);
                }
            });
        }
        return this.fieldEditor;
    }

    protected FieldEditorDialog createFieldEditor() {
        FieldEditorDialog fieldEditor = (FieldEditorDialog)WindowUtil.createWindow(FieldEditorDialog.class, (Component)((Object)this));
        fieldEditor.setTitle(Wizard2Resource.getString((String)"res_18"));
        fieldEditor.setBosQueryMode(false, false);
        return fieldEditor;
    }

    protected FormulaWizardEditor getFormulaWizard() {
        if (this.formulaWizard == null) {
            this.formulaWizard = this.createFormulaWizard();
            if (this.formulaWizard != null) {
                this.formulaWizard.setTitle(Wizard2Resource.getString((String)"res_16"));
                this.formulaWizard.setExampleShow(true);
            }
        }
        return this.formulaWizard;
    }

    protected FormulaWizardEditor createFormulaWizard() {
        FormulaWizardEditor formulaWizard = new FormulaWizardEditor();
        formulaWizard.addFieldSupplyGroup();
        formulaWizard.getFieldSupplyGroup().addNodeCurrentFields();
        formulaWizard.getFieldSupplyGroup().addNodeMetaFields();
        if (model instanceof CtrlDesignQueryModel) {
            formulaWizard.getFieldSupplyGroup().addNodeParamFields();
        }
        return formulaWizard;
    }

    protected void updateFormulaWizard(FormulaWizardEditor formulaWizard) {
        formulaWizard.getFieldSupplyGroup().updateFieldSupplyGroup(this.getSelectedList(), false);
        IQuery query = model.getQuery();
        ITable[] tables = (ITable[])query.getTables().toArray((Object[])new ITable[0]);
        KsqlObjectSelector selector = model.getObjectSelector();
        ArrayList<MetaClass> listMcs = new ArrayList<MetaClass>();
        ITableList queryTables = query.getTables();
        for (int i = 0; i < queryTables.size(); ++i) {
            ITable queryTable = (ITable)queryTables.get(i);
            MetaClass mc = selector.getMetaClassFromCache(queryTable.getName());
            listMcs.add(mc);
        }
        MetaClass[] mcs = listMcs.toArray(new MetaClass[0]);
        formulaWizard.getFieldSupplyGroup().updateTableSupplyGroup(tables, mcs, false);
        if (model instanceof CtrlDesignQueryModel) {
            List listParam = model.getCommonQuery().getParameters();
            this.getFormulaWizard().getFieldSupplyGroup().updateParamGroup(listParam);
        }
    }

    private boolean verify(FieldEditorDialog.VerifyEvent evt) {
        Column col = null;
        if (!evt.getNewMode()) {
            col = (Column)this.getSelectedList().getSelectedValue();
        }
        if (StringUtil.isEmptyString((String)evt.getId())) {
            MessageUtil.showWarning((Component)((Object)this), Wizard2Resource.getString((String)"res_17"));
            return false;
        }
        if (!WizardUtil.isValidString((String)evt.getId())) {
            MessageUtil.showWarning((Component)((Object)this), Wizard2Resource.getString((String)"res_19"));
            return false;
        }
        if (!WizardUtil.isIDUnique((KDList)this.getSelectedList(), (IDefObj)col, (String)evt.getId())) {
            MessageUtil.showWarning((Component)((Object)this), Wizard2Resource.getString((String)"res_20"));
            return false;
        }
        if (!WizardUtil.isValidString((String)evt.getAlias())) {
            MessageUtil.showWarning((Component)((Object)this), Wizard2Resource.getString((String)"res_21"));
            return false;
        }
        return true;
    }

    private class TableChangedHandler
    implements PropertyChangeListener {
        private TableChangedHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (fieldUI == null) {
                return;
            }
            if (evt.getPropertyName() == "table name") {
                this.changeTableName((String)evt.getOldValue(), (String)evt.getNewValue());
            }
        }

        private void changeTableName(String oldName, String newName) {
            int length = oldName.length();
            IColumnList queryColumns = model.getQuery().getColumns();
            for (Column column : queryColumns) {
                String expr = column.getExpr();
                expr = ExtStringUtil.replace(expr, "[" + oldName + "]", "[" + newName + "]");
                column.setExpr(expr);
            }
        }
    }

    private class ActionEdit
    extends AbstractAction {
        private static final long serialVersionUID = -5992175684183075848L;

        public ActionEdit() {
            this.putValue("ShortDescription", Wizard2Resource.getString((String)"res_15"));
            this.putValue("SmallIcon", Resource.ICON_EDIT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldUI.this.editField();
        }
    }
}

