/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.ui.editor.styled.JavaStyledEditor;
import com.kingdee.bos.ctrl.data.wizard.common.CommonResource;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractJavaUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignParamUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.JavaModel;
import com.kingdee.eas.rpts.ctrlsqldesign.data.ProcedureDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.ProcedureParamData;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.param.IJavaDataSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class JavaUI
extends AbstractJavaUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(JavaUI.class);
    private static final int COL_NAME = 0;
    private static final int COL_ALIAS = 1;
    private static final int COL_DATA_TYPE = 2;
    private KDComboBox cmbDataType;
    private JavaStyledEditor editor;
    protected KDBizMultiLangBox mlbAlias;
    TablePropertyChangeHandler tablePropertyChangeHandler;

    public JavaUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.initLayout();
        this.table.checkParsed();
        this.setOpaque(false);
        this.kDButtonGroup1.add((AbstractButton)this.interfaceRowSet);
        this.kDButtonGroup1.add((AbstractButton)this.interfaceSQL);
        this.kDButtonGroup2.add((AbstractButton)this.executeReflect);
        this.kDButtonGroup2.add((AbstractButton)this.executeTranslat);
        this.executeTranslat.setEnabled(false);
        this.editor = new JavaStyledEditor();
        this.editor.setEnabled(false);
        this.kDScrollPane1.getViewport().add((Component)this.editor, null);
        this.initTable();
        this.installListener();
    }

    private void initTable() {
        this.table.getSelectManager().setSelectMode(15);
        KDTableHelper.updateEnterWithTab((KDTable)this.table, (boolean)false);
        this.mlbAlias = new KDBizMultiLangBox();
        this.table.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.mlbAlias));
        this.mlbAlias.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
        this.cmbDataType = new KDComboBox();
        this.cmbDataType.addItems((Object[])ProcedureDataType.JavaDataTypes);
        this.cmbDataType.putClientProperty((Object)"jump", (Object)"false");
        KDTDefaultCellEditor ceDataType = new KDTDefaultCellEditor((JComboBox)this.cmbDataType);
        this.table.getColumn(2).setEditor((ICellEditor)ceDataType);
    }

    private void installListener() {
        this.btnAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JavaUI.this.doBtnAuto();
                }
                catch (Exception e1) {
                    String msgTip = MessageUtil.getMsgInfo("label352");
                    MessageUtil.showDetailAndOK(null, msgTip + e1.getMessage(), e1);
                }
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaUI.this.doBtnInsert();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaUI.this.doBtnDelete();
            }
        });
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopping(KDTEditEvent e) {
                boolean flag;
                if (e.getColIndex() == 0 && e.getValue() != null && (flag = DesignParamUI.isNameRepeat(JavaUI.this.table, 0, e.getRowIndex(), e.getValue().toString(), null))) {
                    e.setCancel(true);
                    return;
                }
                for (int i = 0; i < JavaUI.this.table.getRowCount(); ++i) {
                    IRow row = JavaUI.this.table.getRow(i);
                    JavaUI.this.setParameterFromRow(row);
                }
            }
        });
    }

    private void doBtnInsert() {
        this.removeTablePropertyChangeHandler();
        try {
            IRow newRow = this.table.addRow();
            int idx = this.table.getRowCount() - 1;
            newRow.setUserObject((Object)new ProcedureParamData());
            newRow.getCell(2).setValue((Object)ProcedureDataType.STRING);
            this.table.getEditManager().editCellAt(idx, 0);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            this.addTablePropertyChangeHandler();
        }
    }

    private void doBtnDelete() {
        int selEnd;
        KDTSelectBlock sel = this.table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (!MessageUtil.showConfirm((Component)((Object)this), CommonResource.getString((String)"res_39"))) {
            return;
        }
        int selBegin = sel.getBeginRow();
        for (int i = selEnd = sel.getEndRow(); i >= selBegin; --i) {
            this.table.removeRow(i);
        }
        this.table.getSelectManager().setActiveRowIndex(selBegin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBtnAuto() throws Exception {
        boolean confirm;
        if (!JavaUI.validate(this)) {
            return;
        }
        if (this.table.getRowCount() > 0 && !(confirm = MessageUtil.showConfirm(null, MessageUtil.getMsgInfo("label353")))) {
            return;
        }
        IJavaDataSet iJavaDataSet = this.getIJavaDataSet();
        Map outputMap = iJavaDataSet.getOutputParam();
        if (outputMap.isEmpty()) {
            MessageUtil.showInfo("label354", true);
            return;
        }
        this.removeTablePropertyChangeHandler();
        try {
            this.table.removeRows();
            for (String name : outputMap.keySet()) {
                ProcedureParamData ppd = new ProcedureParamData();
                ppd.setName(name);
                ppd.setAlias(name);
                ppd.setDataType(ProcedureDataType.STRING);
                IRow newRow = this.table.addRow();
                this.setParam2Row(ppd, newRow);
            }
            MessageUtil.showInfo("label355", true);
        }
        finally {
            this.addTablePropertyChangeHandler();
        }
    }

    private IJavaDataSet getIJavaDataSet() throws CtrlReportException {
        IJavaDataSet iJavaDataSet = null;
        if (this.executeReflect.isSelected()) {
            String strFullName = this.fullname.getText().trim();
            try {
                iJavaDataSet = (IJavaDataSet)Class.forName(strFullName).newInstance();
                iJavaDataSet.setFilterParam(new HashMap());
            }
            catch (Throwable t) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label350") + t.getMessage(), t);
            }
        }
        return iJavaDataSet;
    }

    @Override
    protected void executeReflect_itemStateChanged(ItemEvent e) throws Exception {
        if (null == e || e.getStateChange() == 1) {
            this.fullname.setEnabled(true);
            this.editor.setEnabled(false);
        }
    }

    @Override
    protected void executeTranslat_itemStateChanged(ItemEvent e) throws Exception {
        if (null == e || e.getStateChange() == 1) {
            this.fullname.setEnabled(false);
            this.editor.setEnabled(true);
        }
    }

    protected void btnLook_actionPerformed(ActionEvent e) throws Exception {
        if (!JavaUI.validate(this)) {
            return;
        }
    }

    public static final boolean validate(JavaUI javaUI) {
        if (javaUI.executeReflect.isSelected() && javaUI.fullname.getText().trim().equals("")) {
            MessageUtil.showInfo("label356", true);
            javaUI.fullname.requestFocus();
            return false;
        }
        if (javaUI.executeTranslat.isSelected() && javaUI.editor.getText().trim().equals("")) {
            MessageUtil.showInfo("label357", false);
            javaUI.editor.requestFocus();
            return false;
        }
        return true;
    }

    public JavaModel getJavaModel() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            paramList.add(this.table.getRow(i).getUserObject());
        }
        JavaModel jm = new JavaModel();
        int interfaceType = 0;
        if (this.interfaceRowSet.isSelected()) {
            interfaceType = 1;
        }
        int executeType = 0;
        if (this.executeTranslat.isSelected()) {
            executeType = 1;
        }
        jm.setInterfaceType(interfaceType);
        jm.setExecuteType(executeType);
        jm.setFullname(this.fullname.getText().trim());
        jm.setJavaCode(this.editor.getText());
        jm.setParamList(paramList);
        return jm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(JavaModel jm) {
        if (jm == null) {
            return;
        }
        this.removeTablePropertyChangeHandler();
        try {
            int interfaceType = jm.getInterfaceType();
            if (interfaceType == 0) {
                this.interfaceSQL.setSelected(true);
            } else {
                this.interfaceRowSet.setSelected(true);
            }
            int executeType = jm.getExecuteType();
            if (executeType == 0) {
                this.executeReflect.setSelected(true);
                this.fullname.setEnabled(true);
                this.editor.setEnabled(false);
            } else {
                this.executeTranslat.setSelected(true);
                this.fullname.setEnabled(false);
                this.editor.setEnabled(true);
            }
            this.fullname.setText(jm.getFullname());
            this.editor.setText(jm.getJavaCode());
            ArrayList paramList = jm.getParamList();
            if (paramList != null && !paramList.isEmpty()) {
                int size = paramList.size();
                this.table.removeRows();
                this.table.addRows(size);
                for (int i = 0; i < size; ++i) {
                    IRow row = this.table.getRow(i);
                    ProcedureParamData pmd = (ProcedureParamData)((Object)paramList.get(i));
                    this.setParam2Row(pmd, row);
                }
            }
        }
        finally {
            this.addTablePropertyChangeHandler();
        }
    }

    private void setParam2Row(ProcedureParamData ppd, IRow row) {
        row.getCell(0).setValue((Object)ppd.getName());
        OutputFieldsUI.setMultiLangItemListToCell(row.getCell(1), ppd, this.mlbAlias, "alias");
        row.getCell(2).setValue((Object)ppd.getDataType());
        row.setUserObject((Object)ppd);
    }

    private ProcedureParamData setParameterFromRow(IRow row) {
        ProcedureParamData p = (ProcedureParamData)((Object)row.getUserObject());
        if (row.getCell(0).getValue() != null) {
            p.setName(row.getCell(0).getValue().toString());
        } else {
            p.setName(null);
        }
        if (row.getCell(1).getValue() != null) {
            OutputFieldsUI.getMultiLangItemListFromCell(row.getCell(1), p, "alias");
        } else {
            p.setAlias(null);
        }
        if (row.getCell(2).getValue() != null) {
            p.setDataType((ProcedureDataType)row.getCell(2).getValue());
        }
        return p;
    }

    private void removeTablePropertyChangeHandler() {
        if (this.tablePropertyChangeHandler == null) {
            this.tablePropertyChangeHandler = new TablePropertyChangeHandler();
        }
        this.table.removeKDTPropertyChangeListener((KDTPropertyChangeListener)this.tablePropertyChangeHandler);
    }

    private void addTablePropertyChangeHandler() {
        if (this.tablePropertyChangeHandler == null) {
            this.tablePropertyChangeHandler = new TablePropertyChangeHandler();
        }
        this.table.addKDTPropertyChangeListener((KDTPropertyChangeListener)this.tablePropertyChangeHandler);
    }

    private class TablePropertyChangeHandler
    implements KDTPropertyChangeListener {
        private TablePropertyChangeHandler() {
        }

        public void propertyChange(KDTPropertyChangeEvent e) {
            if (e.getColIndex() == 0) {
                if (e.getNewValue() != null) {
                    boolean flag = DesignParamUI.isNameRepeat(JavaUI.this.table, 0, e.getRowIndex(), e.getNewValue().toString(), CtrlReportUtil.getObjectString(e.getOldValue()));
                    if (flag) {
                        return;
                    }
                } else {
                    MessageUtil.showInfo("label358", true);
                    return;
                }
            }
            for (int i = 0; i < JavaUI.this.table.getRowCount(); ++i) {
                IRow row = JavaUI.this.table.getRow(i);
                JavaUI.this.setParameterFromRow(row);
            }
        }
    }
}

