/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.ui.joineditor.JoinPanel;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelField;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelLine;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelTable;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IJoinList;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Join;
import com.kingdee.bos.ctrl.data.modal.query.JoinType;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedJoin;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.rpts.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class JoinUI
extends BaseTabUIImp {
    private static CtrlDesignQueryModel model = null;
    private static JoinUI joinUI = null;
    private JoinPanel joinPanel;
    private KDScrollPane scrollPane;
    private TableChangedHandler tableChangedHandler;

    private JoinUI() {
        this.initJoinModel();
        this.addPropertyChangedListener();
    }

    public static final JoinUI getInstance() {
        if (joinUI == null) {
            model = DesignUI.getInstance().getModel();
            joinUI = new JoinUI();
        }
        return joinUI;
    }

    public static final void destroy() {
        joinUI = null;
    }

    @Override
    public KDPanel getPanel() {
        KDPanel panTemp = new KDPanel((LayoutManager)new BorderLayout());
        panTemp.setOpaque(false);
        panTemp.add((Component)this.scrollPane, (Object)"Center");
        return panTemp;
    }

    public static void refreshFromModel(boolean isRefreshFromModel) {
        if (joinUI != null) {
            joinUI.setRefreshFromModel(isRefreshFromModel);
        }
    }

    private void initJoinModel() {
        int i;
        this.joinPanel = new JoinPanel();
        this.joinPanel.setOpaque(false);
        this.scrollPane = new KDScrollPane((Component)this.joinPanel);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setBorder(null);
        this.joinPanel.removeAllTable();
        ITableList tables = model.getQuery().getTables();
        if (tables != null) {
            KsqlObjectSelector selector = model.getObjectSelector();
            for (i = 0; i < tables.size(); ++i) {
                ModelTable joinTable;
                ITable queryTable = (ITable)tables.get(i);
                if (!selector.buildModelTable(queryTable, joinTable = new ModelTable())) continue;
                if (queryTable.getExtObj() != null) {
                    DesignedTable dt = (DesignedTable)queryTable.getExtObj();
                    Rectangle rec = new Rectangle();
                    rec.x = dt.getX();
                    rec.y = dt.getY();
                    rec.width = dt.getWidth();
                    rec.height = dt.getHeight();
                    this.joinPanel.addTable(joinTable, rec);
                    continue;
                }
                this.joinPanel.addTable(joinTable);
            }
        }
        this.joinPanel.updatePreferredSize();
        IJoinList joins = model.getQuery().getJoins();
        for (i = 0; i < joins.size(); ++i) {
            ModelLine line = new ModelLine();
            Join join = (Join)joins.get(i);
            for (int j = 0; j < this.joinPanel.getTableSet().size(); ++j) {
                ModelTable joinTable = (ModelTable)this.joinPanel.getTableSet().get(j);
                if (StringUtil.equals((String)joinTable.getId(), (String)join.getLeftTable())) {
                    line.setFromTable(joinTable);
                    continue;
                }
                if (!StringUtil.equals((String)joinTable.getId(), (String)join.getRightTable())) continue;
                line.setToTable(joinTable);
            }
            if (line.getFromTable() == null || line.getToTable() == null) continue;
            if (join.getJoinType() == JoinType.INNER) {
                line.setType(1);
            } else if (join.getJoinType() == JoinType.LEFT) {
                line.setType(2);
            } else if (join.getJoinType() == JoinType.RIGHT) {
                line.setType(3);
            } else if (join.getJoinType() == JoinType.FULL) {
                line.setType(4);
            }
            if (join.getCondition().getExtObj() != null) {
                ModelField joinField;
                int j;
                DesignedJoin dj = (DesignedJoin)join.getCondition().getExtObj();
                for (j = 0; j < line.getFromTable().getFields().size(); ++j) {
                    joinField = (ModelField)line.getFromTable().getFields().get(j);
                    if (!StringUtil.equals((String)joinField.getId(), (String)dj.getFromField())) continue;
                    line.setFromField(joinField);
                }
                for (j = 0; j < line.getToTable().getFields().size(); ++j) {
                    joinField = (ModelField)line.getToTable().getFields().get(j);
                    if (!StringUtil.equals((String)joinField.getId(), (String)dj.getToField())) continue;
                    line.setToField(joinField);
                }
                line.setRelation(dj.getRelation());
                line.setIndex(dj.getIndex());
            }
            this.joinPanel.addLine(line);
        }
    }

    private void addPropertyChangedListener() {
        if (this.tableChangedHandler == null) {
            this.tableChangedHandler = new TableChangedHandler();
        }
        model.removePropertyChangedListener(this.tableChangedHandler);
        model.addPropertyChangedListener(this.tableChangedHandler);
    }

    @Override
    public void syncModel2Ui() {
        ITableList queryTables = model.getQuery().getTables();
        ArrayList joinTables = this.joinPanel.getTableSet();
        for (int i = joinTables.size() - 1; i >= 0; --i) {
            ModelTable joinTable = (ModelTable)joinTables.get(i);
            boolean isExist = false;
            for (int j = 0; j < queryTables.size(); ++j) {
                ITable queryTable = (ITable)queryTables.get(j);
                if (!StringUtil.equals((String)queryTable.getName(), (String)joinTable.getId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.joinPanel.removeTable(joinTable);
        }
        ModelTable joinTable = null;
        KsqlObjectSelector selector = model.getObjectSelector();
        for (int i = 0; i < queryTables.size(); ++i) {
            ITable queryTable = (ITable)queryTables.get(i);
            boolean isExist = false;
            for (int j = 0; j < joinTables.size(); ++j) {
                joinTable = (ModelTable)joinTables.get(j);
                if (!StringUtil.equals((String)queryTable.getName(), (String)joinTable.getId())) continue;
                isExist = true;
                break;
            }
            if (isExist && !(queryTable instanceof IQuery)) continue;
            if (!isExist) {
                joinTable = new ModelTable();
            }
            if (!selector.buildModelTable(queryTable, joinTable)) continue;
            if (!isExist) {
                this.joinPanel.addTable(joinTable);
                continue;
            }
            joinTable.getUi().refreshField();
        }
        this.joinPanel.updatePreferredSize();
    }

    @Override
    public void syncUi2Model() {
        this.updateJoinList();
        this.updateTableExtObj();
    }

    private void updateJoinList() {
        IJoinList joins = model.getQuery().getJoins();
        joins.clear();
        ArrayList joinLines = this.joinPanel.getLineSet();
        for (int i = 0; i < joinLines.size(); ++i) {
            ModelLine joinLine = (ModelLine)joinLines.get(i);
            if (joinLine == null) continue;
            Join join = new Join();
            join.setLeftTable(joinLine.getFromTable().getId());
            join.setRightTable(joinLine.getToTable().getId());
            switch (joinLine.getType()) {
                case 1: {
                    join.setJoinType(JoinType.INNER);
                    break;
                }
                case 2: {
                    join.setJoinType(JoinType.LEFT);
                    break;
                }
                case 3: {
                    join.setJoinType(JoinType.RIGHT);
                    break;
                }
                default: {
                    join.setJoinType(JoinType.FULL);
                }
            }
            Condition cond = new Condition();
            cond.setExpr(ModelLine.builtFieldRelation((ModelLine)joinLine));
            join.setCondition(cond);
            DesignedJoin extObj = new DesignedJoin();
            extObj.setRelation(joinLine.getRelation());
            extObj.setIndex(joinLine.getIndex());
            extObj.setFromField(joinLine.getFromField().getId());
            extObj.setToField(joinLine.getToField().getId());
            cond.setExtObj((Object)extObj);
            joins.add((Object)join);
        }
    }

    private void updateTableExtObj() {
        ITableList queryTables = model.getQuery().getTables();
        ArrayList joinTables = this.joinPanel.getTableSet();
        block0: for (int i = 0; i < queryTables.size(); ++i) {
            ITable queryTable = (ITable)queryTables.get(i);
            for (int j = 0; j < joinTables.size(); ++j) {
                ModelTable joinTable = (ModelTable)joinTables.get(j);
                if (!StringUtil.equals((String)joinTable.getId(), (String)queryTable.getName())) continue;
                DesignedTable dt = new DesignedTable();
                Rectangle rect = joinTable.getUi().getBounds();
                dt.setX(rect.x);
                dt.setY(rect.y);
                dt.setWidth(rect.width);
                dt.setHeight(rect.height);
                queryTable.setExtObj((Object)dt);
                continue block0;
            }
        }
    }

    private class TableChangedHandler
    implements PropertyChangeListener {
        private TableChangedHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (JoinUI.this.joinPanel == null) {
                return;
            }
            if (evt.getPropertyName() == "table name") {
                this.changeTableName((String)evt.getOldValue(), (String)evt.getNewValue());
            } else if (evt.getPropertyName() == "table alias") {
                String id = ((ITable)evt.getSource()).getName();
                this.changeTableAlias(id, (String)evt.getOldValue(), (String)evt.getNewValue());
            }
        }

        private void changeTableName(String oldName, String newName) {
            ArrayList joinTables = JoinUI.this.joinPanel.getTableSet();
            for (int i = 0; i < joinTables.size(); ++i) {
                ModelTable joinTable = (ModelTable)joinTables.get(i);
                if (!StringUtil.equals((String)joinTable.getId(), (String)oldName)) continue;
                joinTable.setId(newName);
                joinTable.getUi().refreshTable();
            }
        }

        private void changeTableAlias(String id, String oldAlias, String newAlias) {
            ArrayList joinTables = JoinUI.this.joinPanel.getTableSet();
            for (int i = 0; i < joinTables.size(); ++i) {
                ModelTable joinTable = (ModelTable)joinTables.get(i);
                if (!StringUtil.equals((String)joinTable.getId(), (String)id) || !StringUtil.equals((String)joinTable.getAlias(), (String)oldAlias)) continue;
                joinTable.setAlias(newAlias);
                joinTable.getUi().refreshTable();
            }
        }
    }
}

